// third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BrowsingTopicsDocumentServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BrowsingTopicsDocumentService', scope);
  }
}

/** @interface */
export class BrowsingTopicsDocumentServiceInterface {
  
  /**
   * @param { !boolean } observe
   * @return {!Promise<{
        result: !BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result,
   *  }>}
   */

  getBrowsingTopics(observe) {}
}

/**
 * @implements { BrowsingTopicsDocumentServiceInterface }
 */
export class BrowsingTopicsDocumentServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BrowsingTopicsDocumentServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BrowsingTopicsDocumentServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BrowsingTopicsDocumentServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } observe
   * @return {!Promise<{
        result: !BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result,
   *  }>}
   */

  getBrowsingTopics(
      observe) {
    return this.proxy.sendMessage(
        0,
        BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
        BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
        [
          observe
        ],
        true);
  }
}

/**
 * An object which receives request messages for the BrowsingTopicsDocumentService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BrowsingTopicsDocumentServiceReceiver {
  /**
   * @param {!BrowsingTopicsDocumentServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BrowsingTopicsDocumentServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BrowsingTopicsDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BrowsingTopicsDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
        BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
        impl.getBrowsingTopics.bind(impl),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BrowsingTopicsDocumentService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BrowsingTopicsDocumentService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BrowsingTopicsDocumentServiceRemote}
   */
  static getRemote() {
    let remote = new BrowsingTopicsDocumentServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BrowsingTopicsDocumentService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BrowsingTopicsDocumentServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BrowsingTopicsDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BrowsingTopicsDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBrowsingTopics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
        BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
        this.getBrowsingTopics.createReceiverHandler(true /* expectsResponse */),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EpochTopicSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    EpochTopicSpec.$,
    'EpochTopic',
    [
      mojo.internal.StructField(
        'topic', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'configVersion', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modelVersion', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'taxonomyVersion', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class EpochTopic {
  constructor() {
    /** @type { !number } */
    this.topic;
    /** @type { !string } */
    this.version;
    /** @type { !string } */
    this.configVersion;
    /** @type { !string } */
    this.modelVersion;
    /** @type { !string } */
    this.taxonomyVersion;
  }
}



mojo.internal.Struct(
    BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsSpec.$,
    'BrowsingTopicsDocumentService_GetBrowsingTopics_Params',
    [
      mojo.internal.StructField(
        'observe', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BrowsingTopicsDocumentService_GetBrowsingTopics_Params {
  constructor() {
    /** @type { !boolean } */
    this.observe;
  }
}



mojo.internal.Struct(
    BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsSpec.$,
    'BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams {
  constructor() {
    /** @type { !BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result } */
    this.result;
  }
}

mojo.internal.Union(
    BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultSpec.$, 'BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(EpochTopicSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!EpochTopic>|undefined),
 *   failure: (!string|undefined),
 * } }
 */
export const BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result = {};
