// third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function EpochTopic(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EpochTopic.prototype.initDefaults_ = function() {
    this.topic = 0;
    this.version = null;
    this.configVersion = null;
    this.modelVersion = null;
    this.taxonomyVersion = null;
  };
  EpochTopic.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EpochTopic.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EpochTopic.version
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EpochTopic.configVersion
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EpochTopic.modelVersion
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EpochTopic.taxonomyVersion
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EpochTopic.encodedSize = codec.kStructHeaderSize + 40;

  EpochTopic.decode = function(decoder) {
    var packed;
    var val = new EpochTopic();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.topic =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.version =
        decoder.decodeStruct(codec.String);
    val.configVersion =
        decoder.decodeStruct(codec.String);
    val.modelVersion =
        decoder.decodeStruct(codec.String);
    val.taxonomyVersion =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EpochTopic.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EpochTopic.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.topic);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.version);
    encoder.encodeStruct(codec.String, val.configVersion);
    encoder.encodeStruct(codec.String, val.modelVersion);
    encoder.encodeStruct(codec.String, val.taxonomyVersion);
  };
  function BrowsingTopicsDocumentService_GetBrowsingTopics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BrowsingTopicsDocumentService_GetBrowsingTopics_Params.prototype.initDefaults_ = function() {
    this.observe = false;
  };
  BrowsingTopicsDocumentService_GetBrowsingTopics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_Params.encodedSize = codec.kStructHeaderSize + 8;

  BrowsingTopicsDocumentService_GetBrowsingTopics_Params.decode = function(decoder) {
    var packed;
    var val = new BrowsingTopicsDocumentService_GetBrowsingTopics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.observe = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BrowsingTopicsDocumentService_GetBrowsingTopics_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.observe & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result);
    return val;
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result, val.result);
  };

  function BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.success:
          encoder.encodeArrayPointer(new codec.PointerTo(EpochTopic), val.success);
          break;
        case BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.String, val.failure);
          break;
      }
      encoder.align();
    };


    BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeArrayPointer(new codec.PointerTo(EpochTopic));
          break;
        case BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.success:
          

    // validate BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.success
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(EpochTopic), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.Tags.failure:
          

    // validate BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.failure
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result.encodedSize = 16;
  var kBrowsingTopicsDocumentService_GetBrowsingTopics_Name = 0;

  function BrowsingTopicsDocumentServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(BrowsingTopicsDocumentService,
                                                   handleOrPtrInfo);
  }

  function BrowsingTopicsDocumentServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        BrowsingTopicsDocumentService, associatedInterfacePtrInfo);
  }

  BrowsingTopicsDocumentServiceAssociatedPtr.prototype =
      Object.create(BrowsingTopicsDocumentServicePtr.prototype);
  BrowsingTopicsDocumentServiceAssociatedPtr.prototype.constructor =
      BrowsingTopicsDocumentServiceAssociatedPtr;

  function BrowsingTopicsDocumentServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  BrowsingTopicsDocumentServicePtr.prototype.getBrowsingTopics = function() {
    return BrowsingTopicsDocumentServiceProxy.prototype.getBrowsingTopics
        .apply(this.ptr.getProxy(), arguments);
  };

  BrowsingTopicsDocumentServiceProxy.prototype.getBrowsingTopics = function(observe) {
    var params_ = new BrowsingTopicsDocumentService_GetBrowsingTopics_Params();
    params_.observe = observe;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBrowsingTopicsDocumentService_GetBrowsingTopics_Name,
          codec.align(BrowsingTopicsDocumentService_GetBrowsingTopics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BrowsingTopicsDocumentService_GetBrowsingTopics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function BrowsingTopicsDocumentServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  BrowsingTopicsDocumentServiceStub.prototype.getBrowsingTopics = function(observe) {
    return this.delegate_ && this.delegate_.getBrowsingTopics && this.delegate_.getBrowsingTopics(observe);
  }

  BrowsingTopicsDocumentServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  BrowsingTopicsDocumentServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBrowsingTopicsDocumentService_GetBrowsingTopics_Name:
      var params = reader.decodeStruct(BrowsingTopicsDocumentService_GetBrowsingTopics_Params);
      this.getBrowsingTopics(params.observe).then(function(response) {
        var responseParams =
            new BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kBrowsingTopicsDocumentService_GetBrowsingTopics_Name,
            codec.align(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateBrowsingTopicsDocumentServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBrowsingTopicsDocumentService_GetBrowsingTopics_Name:
        if (message.expectsResponse())
          paramsClass = BrowsingTopicsDocumentService_GetBrowsingTopics_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBrowsingTopicsDocumentServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kBrowsingTopicsDocumentService_GetBrowsingTopics_Name:
        if (message.isResponse())
          paramsClass = BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var BrowsingTopicsDocumentService = {
    name: 'blink.mojom.BrowsingTopicsDocumentService',
    kVersion: 0,
    ptrClass: BrowsingTopicsDocumentServicePtr,
    proxyClass: BrowsingTopicsDocumentServiceProxy,
    stubClass: BrowsingTopicsDocumentServiceStub,
    validateRequest: validateBrowsingTopicsDocumentServiceRequest,
    validateResponse: validateBrowsingTopicsDocumentServiceResponse,
  };
  BrowsingTopicsDocumentServiceStub.prototype.validator = validateBrowsingTopicsDocumentServiceRequest;
  BrowsingTopicsDocumentServiceProxy.prototype.validator = validateBrowsingTopicsDocumentServiceResponse;
  exports.EpochTopic = EpochTopic;
  exports.BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result = BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result;
  exports.BrowsingTopicsDocumentService = BrowsingTopicsDocumentService;
  exports.BrowsingTopicsDocumentServicePtr = BrowsingTopicsDocumentServicePtr;
  exports.BrowsingTopicsDocumentServiceAssociatedPtr = BrowsingTopicsDocumentServiceAssociatedPtr;
})();