// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-params-data.h"
#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-import-headers.h"
#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-test-utils.h"


namespace blink::mojom {
WebBluetoothLeScanFilter::WebBluetoothLeScanFilter()
    : services(),
      name(),
      name_prefix(),
      manufacturer_data() {}

WebBluetoothLeScanFilter::WebBluetoothLeScanFilter(
    std::optional<std::vector<::device::BluetoothUUID>> services_in,
    const std::optional<std::string>& name_in,
    const std::optional<std::string>& name_prefix_in,
    std::optional<base::flat_map<WebBluetoothCompanyPtr, std::vector<WebBluetoothDataFilterPtr>>> manufacturer_data_in)
    : services(std::move(services_in)),
      name(std::move(name_in)),
      name_prefix(std::move(name_prefix_in)),
      manufacturer_data(std::move(manufacturer_data_in)) {}

WebBluetoothLeScanFilter::~WebBluetoothLeScanFilter() = default;

void WebBluetoothLeScanFilter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "services"), this->services,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::device::BluetoothUUID>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_prefix"), this->name_prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manufacturer_data"), this->manufacturer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<base::flat_map<WebBluetoothCompanyPtr, std::vector<WebBluetoothDataFilterPtr>>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothLeScanFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothCompany::WebBluetoothCompany()
    : id() {}

WebBluetoothCompany::WebBluetoothCompany(
    uint16_t id_in)
    : id(std::move(id_in)) {}

WebBluetoothCompany::~WebBluetoothCompany() = default;
size_t WebBluetoothCompany::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  return seed;
}

void WebBluetoothCompany::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothCompany::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothDataFilter::WebBluetoothDataFilter()
    : data(),
      mask() {}

WebBluetoothDataFilter::WebBluetoothDataFilter(
    uint8_t data_in,
    uint8_t mask_in)
    : data(std::move(data_in)),
      mask(std::move(mask_in)) {}

WebBluetoothDataFilter::~WebBluetoothDataFilter() = default;
size_t WebBluetoothDataFilter::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->data);
  seed = mojo::internal::Hash(seed, this->mask);
  return seed;
}

void WebBluetoothDataFilter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask"), this->mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothDataFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothRequestDeviceOptions::WebBluetoothRequestDeviceOptions()
    : filters(),
      exclusion_filters(),
      optional_services(),
      optional_manufacturer_data(),
      accept_all_devices() {}

WebBluetoothRequestDeviceOptions::WebBluetoothRequestDeviceOptions(
    std::optional<std::vector<WebBluetoothLeScanFilterPtr>> filters_in,
    std::optional<std::vector<WebBluetoothLeScanFilterPtr>> exclusion_filters_in,
    std::vector<::device::BluetoothUUID> optional_services_in,
    std::vector<uint16_t> optional_manufacturer_data_in,
    bool accept_all_devices_in)
    : filters(std::move(filters_in)),
      exclusion_filters(std::move(exclusion_filters_in)),
      optional_services(std::move(optional_services_in)),
      optional_manufacturer_data(std::move(optional_manufacturer_data_in)),
      accept_all_devices(std::move(accept_all_devices_in)) {}

WebBluetoothRequestDeviceOptions::~WebBluetoothRequestDeviceOptions() = default;

void WebBluetoothRequestDeviceOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<WebBluetoothLeScanFilterPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusion_filters"), this->exclusion_filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<WebBluetoothLeScanFilterPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optional_services"), this->optional_services,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::device::BluetoothUUID>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optional_manufacturer_data"), this->optional_manufacturer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_all_devices"), this->accept_all_devices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothRequestDeviceOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothRequestLEScanOptions::WebBluetoothRequestLEScanOptions()
    : filters(),
      keep_repeated_devices(),
      accept_all_advertisements() {}

WebBluetoothRequestLEScanOptions::WebBluetoothRequestLEScanOptions(
    std::optional<std::vector<WebBluetoothLeScanFilterPtr>> filters_in,
    bool keep_repeated_devices_in,
    bool accept_all_advertisements_in)
    : filters(std::move(filters_in)),
      keep_repeated_devices(std::move(keep_repeated_devices_in)),
      accept_all_advertisements(std::move(accept_all_advertisements_in)) {}

WebBluetoothRequestLEScanOptions::~WebBluetoothRequestLEScanOptions() = default;

void WebBluetoothRequestLEScanOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<WebBluetoothLeScanFilterPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keep_repeated_devices"), this->keep_repeated_devices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_all_advertisements"), this->accept_all_advertisements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothRequestLEScanOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothDeviceId::WebBluetoothDeviceId()
    : device_id() {}

WebBluetoothDeviceId::WebBluetoothDeviceId(
    std::vector<uint8_t> device_id_in)
    : device_id(std::move(device_id_in)) {}

WebBluetoothDeviceId::~WebBluetoothDeviceId() = default;

void WebBluetoothDeviceId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothDeviceId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothDevice::WebBluetoothDevice()
    : id(),
      name() {}

WebBluetoothDevice::WebBluetoothDevice(
    const ::blink::WebBluetoothDeviceId& id_in,
    const std::optional<std::string>& name_in)
    : id(std::move(id_in)),
      name(std::move(name_in)) {}

WebBluetoothDevice::~WebBluetoothDevice() = default;

void WebBluetoothDevice::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::WebBluetoothDeviceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothDevice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothRemoteGATTService::WebBluetoothRemoteGATTService()
    : instance_id(),
      uuid() {}

WebBluetoothRemoteGATTService::WebBluetoothRemoteGATTService(
    const std::string& instance_id_in,
    const ::device::BluetoothUUID& uuid_in)
    : instance_id(std::move(instance_id_in)),
      uuid(std::move(uuid_in)) {}

WebBluetoothRemoteGATTService::~WebBluetoothRemoteGATTService() = default;

void WebBluetoothRemoteGATTService::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_id"), this->instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::BluetoothUUID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothRemoteGATTService::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothRemoteGATTCharacteristic::WebBluetoothRemoteGATTCharacteristic()
    : instance_id(),
      uuid(),
      properties() {}

WebBluetoothRemoteGATTCharacteristic::WebBluetoothRemoteGATTCharacteristic(
    const std::string& instance_id_in,
    const ::device::BluetoothUUID& uuid_in,
    uint32_t properties_in)
    : instance_id(std::move(instance_id_in)),
      uuid(std::move(uuid_in)),
      properties(std::move(properties_in)) {}

WebBluetoothRemoteGATTCharacteristic::~WebBluetoothRemoteGATTCharacteristic() = default;

void WebBluetoothRemoteGATTCharacteristic::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_id"), this->instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::BluetoothUUID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "properties"), this->properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothRemoteGATTCharacteristic::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothAdvertisingEvent::WebBluetoothAdvertisingEvent()
    : device(),
      name(),
      uuids(),
      appearance_is_set(),
      appearance(),
      tx_power_is_set(),
      tx_power(),
      rssi_is_set(),
      rssi(),
      manufacturer_data(),
      service_data() {}

WebBluetoothAdvertisingEvent::WebBluetoothAdvertisingEvent(
    WebBluetoothDevicePtr device_in,
    const std::optional<std::string>& name_in,
    std::vector<::device::BluetoothUUID> uuids_in,
    bool appearance_is_set_in,
    uint16_t appearance_in,
    bool tx_power_is_set_in,
    uint8_t tx_power_in,
    bool rssi_is_set_in,
    uint8_t rssi_in,
    base::flat_map<WebBluetoothCompanyPtr, std::vector<uint8_t>> manufacturer_data_in,
    const base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>>& service_data_in)
    : device(std::move(device_in)),
      name(std::move(name_in)),
      uuids(std::move(uuids_in)),
      appearance_is_set(std::move(appearance_is_set_in)),
      appearance(std::move(appearance_in)),
      tx_power_is_set(std::move(tx_power_is_set_in)),
      tx_power(std::move(tx_power_in)),
      rssi_is_set(std::move(rssi_is_set_in)),
      rssi(std::move(rssi_in)),
      manufacturer_data(std::move(manufacturer_data_in)),
      service_data(std::move(service_data_in)) {}

WebBluetoothAdvertisingEvent::~WebBluetoothAdvertisingEvent() = default;

void WebBluetoothAdvertisingEvent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device"), this->device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebBluetoothDevicePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuids"), this->uuids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::device::BluetoothUUID>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appearance_is_set"), this->appearance_is_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appearance"), this->appearance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tx_power_is_set"), this->tx_power_is_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tx_power"), this->tx_power,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rssi_is_set"), this->rssi_is_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rssi"), this->rssi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manufacturer_data"), this->manufacturer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<WebBluetoothCompanyPtr, std::vector<uint8_t>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_data"), this->service_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothAdvertisingEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebBluetoothRemoteGATTDescriptor::WebBluetoothRemoteGATTDescriptor()
    : instance_id(),
      uuid() {}

WebBluetoothRemoteGATTDescriptor::WebBluetoothRemoteGATTDescriptor(
    const std::string& instance_id_in,
    const ::device::BluetoothUUID& uuid_in)
    : instance_id(std::move(instance_id_in)),
      uuid(std::move(uuid_in)) {}

WebBluetoothRemoteGATTDescriptor::~WebBluetoothRemoteGATTDescriptor() = default;

void WebBluetoothRemoteGATTDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_id"), this->instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::BluetoothUUID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebBluetoothRemoteGATTDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebBluetoothService::IPCStableHashFunction WebBluetoothService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebBluetoothService>(message.name())) {
    case messages::WebBluetoothService::kGetAvailability: {
      return &WebBluetoothService::GetAvailability_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRequestDevice: {
      return &WebBluetoothService::RequestDevice_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kGetDevices: {
      return &WebBluetoothService::GetDevices_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kForgetDevice: {
      return &WebBluetoothService::ForgetDevice_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteServerConnect: {
      return &WebBluetoothService::RemoteServerConnect_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteServerDisconnect: {
      return &WebBluetoothService::RemoteServerDisconnect_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteServerGetPrimaryServices: {
      return &WebBluetoothService::RemoteServerGetPrimaryServices_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteServiceGetCharacteristics: {
      return &WebBluetoothService::RemoteServiceGetCharacteristics_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicReadValue: {
      return &WebBluetoothService::RemoteCharacteristicReadValue_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicWriteValue: {
      return &WebBluetoothService::RemoteCharacteristicWriteValue_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicStartNotifications: {
      return &WebBluetoothService::RemoteCharacteristicStartNotifications_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicStopNotifications: {
      return &WebBluetoothService::RemoteCharacteristicStopNotifications_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicGetDescriptors: {
      return &WebBluetoothService::RemoteCharacteristicGetDescriptors_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteDescriptorReadValue: {
      return &WebBluetoothService::RemoteDescriptorReadValue_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRemoteDescriptorWriteValue: {
      return &WebBluetoothService::RemoteDescriptorWriteValue_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kRequestScanningStart: {
      return &WebBluetoothService::RequestScanningStart_Sym::IPCStableHash;
    }
    case messages::WebBluetoothService::kWatchAdvertisementsForDevice: {
      return &WebBluetoothService::WatchAdvertisementsForDevice_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebBluetoothService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebBluetoothService>(message.name())) {
      case messages::WebBluetoothService::kGetAvailability:
            return "Receive blink::mojom::WebBluetoothService::GetAvailability";
      case messages::WebBluetoothService::kRequestDevice:
            return "Receive blink::mojom::WebBluetoothService::RequestDevice";
      case messages::WebBluetoothService::kGetDevices:
            return "Receive blink::mojom::WebBluetoothService::GetDevices";
      case messages::WebBluetoothService::kForgetDevice:
            return "Receive blink::mojom::WebBluetoothService::ForgetDevice";
      case messages::WebBluetoothService::kRemoteServerConnect:
            return "Receive blink::mojom::WebBluetoothService::RemoteServerConnect";
      case messages::WebBluetoothService::kRemoteServerDisconnect:
            return "Receive blink::mojom::WebBluetoothService::RemoteServerDisconnect";
      case messages::WebBluetoothService::kRemoteServerGetPrimaryServices:
            return "Receive blink::mojom::WebBluetoothService::RemoteServerGetPrimaryServices";
      case messages::WebBluetoothService::kRemoteServiceGetCharacteristics:
            return "Receive blink::mojom::WebBluetoothService::RemoteServiceGetCharacteristics";
      case messages::WebBluetoothService::kRemoteCharacteristicReadValue:
            return "Receive blink::mojom::WebBluetoothService::RemoteCharacteristicReadValue";
      case messages::WebBluetoothService::kRemoteCharacteristicWriteValue:
            return "Receive blink::mojom::WebBluetoothService::RemoteCharacteristicWriteValue";
      case messages::WebBluetoothService::kRemoteCharacteristicStartNotifications:
            return "Receive blink::mojom::WebBluetoothService::RemoteCharacteristicStartNotifications";
      case messages::WebBluetoothService::kRemoteCharacteristicStopNotifications:
            return "Receive blink::mojom::WebBluetoothService::RemoteCharacteristicStopNotifications";
      case messages::WebBluetoothService::kRemoteCharacteristicGetDescriptors:
            return "Receive blink::mojom::WebBluetoothService::RemoteCharacteristicGetDescriptors";
      case messages::WebBluetoothService::kRemoteDescriptorReadValue:
            return "Receive blink::mojom::WebBluetoothService::RemoteDescriptorReadValue";
      case messages::WebBluetoothService::kRemoteDescriptorWriteValue:
            return "Receive blink::mojom::WebBluetoothService::RemoteDescriptorWriteValue";
      case messages::WebBluetoothService::kRequestScanningStart:
            return "Receive blink::mojom::WebBluetoothService::RequestScanningStart";
      case messages::WebBluetoothService::kWatchAdvertisementsForDevice:
            return "Receive blink::mojom::WebBluetoothService::WatchAdvertisementsForDevice";
    }
  } else {
    switch (static_cast<messages::WebBluetoothService>(message.name())) {
      case messages::WebBluetoothService::kGetAvailability:
            return "Receive reply blink::mojom::WebBluetoothService::GetAvailability";
      case messages::WebBluetoothService::kRequestDevice:
            return "Receive reply blink::mojom::WebBluetoothService::RequestDevice";
      case messages::WebBluetoothService::kGetDevices:
            return "Receive reply blink::mojom::WebBluetoothService::GetDevices";
      case messages::WebBluetoothService::kForgetDevice:
            return "Receive reply blink::mojom::WebBluetoothService::ForgetDevice";
      case messages::WebBluetoothService::kRemoteServerConnect:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteServerConnect";
      case messages::WebBluetoothService::kRemoteServerDisconnect:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteServerDisconnect";
      case messages::WebBluetoothService::kRemoteServerGetPrimaryServices:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteServerGetPrimaryServices";
      case messages::WebBluetoothService::kRemoteServiceGetCharacteristics:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteServiceGetCharacteristics";
      case messages::WebBluetoothService::kRemoteCharacteristicReadValue:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteCharacteristicReadValue";
      case messages::WebBluetoothService::kRemoteCharacteristicWriteValue:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteCharacteristicWriteValue";
      case messages::WebBluetoothService::kRemoteCharacteristicStartNotifications:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteCharacteristicStartNotifications";
      case messages::WebBluetoothService::kRemoteCharacteristicStopNotifications:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteCharacteristicStopNotifications";
      case messages::WebBluetoothService::kRemoteCharacteristicGetDescriptors:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteCharacteristicGetDescriptors";
      case messages::WebBluetoothService::kRemoteDescriptorReadValue:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteDescriptorReadValue";
      case messages::WebBluetoothService::kRemoteDescriptorWriteValue:
            return "Receive reply blink::mojom::WebBluetoothService::RemoteDescriptorWriteValue";
      case messages::WebBluetoothService::kRequestScanningStart:
            return "Receive reply blink::mojom::WebBluetoothService::RequestScanningStart";
      case messages::WebBluetoothService::kWatchAdvertisementsForDevice:
            return "Receive reply blink::mojom::WebBluetoothService::WatchAdvertisementsForDevice";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebBluetoothService::GetAvailability_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe9e8dd9;  // IPCStableHash for blink::mojom::WebBluetoothService::GetAvailability
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RequestDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cf056d2;  // IPCStableHash for blink::mojom::WebBluetoothService::RequestDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::GetDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01213d9a;  // IPCStableHash for blink::mojom::WebBluetoothService::GetDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::ForgetDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2241a12b;  // IPCStableHash for blink::mojom::WebBluetoothService::ForgetDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteServerConnect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8fa75cb;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteServerConnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteServerDisconnect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25f19dc4;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteServerDisconnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteServerGetPrimaryServices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a82a977;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteServerGetPrimaryServices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteServiceGetCharacteristics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x942aadb7;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteServiceGetCharacteristics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteCharacteristicReadValue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08065f6e;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteCharacteristicReadValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteCharacteristicWriteValue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b76b5f2;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteCharacteristicWriteValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteCharacteristicStartNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51a7d568;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteCharacteristicStartNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteCharacteristicStopNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf240f06;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteCharacteristicStopNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteCharacteristicGetDescriptors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd553aa38;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteCharacteristicGetDescriptors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteDescriptorReadValue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1df4602e;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteDescriptorReadValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RemoteDescriptorWriteValue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7cc5e471;  // IPCStableHash for blink::mojom::WebBluetoothService::RemoteDescriptorWriteValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::RequestScanningStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20331afd;  // IPCStableHash for blink::mojom::WebBluetoothService::RequestScanningStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebBluetoothService::WatchAdvertisementsForDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd57a3ca0;  // IPCStableHash for blink::mojom::WebBluetoothService::WatchAdvertisementsForDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebBluetoothService_GetAvailability_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_GetAvailability_ForwardToCallback(
      WebBluetoothService::GetAvailabilityCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_GetAvailability_ForwardToCallback(const WebBluetoothService_GetAvailability_ForwardToCallback&) = delete;
  WebBluetoothService_GetAvailability_ForwardToCallback& operator=(const WebBluetoothService_GetAvailability_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::GetAvailabilityCallback callback_;
};

class WebBluetoothService_RequestDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RequestDevice_ForwardToCallback(
      WebBluetoothService::RequestDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RequestDevice_ForwardToCallback(const WebBluetoothService_RequestDevice_ForwardToCallback&) = delete;
  WebBluetoothService_RequestDevice_ForwardToCallback& operator=(const WebBluetoothService_RequestDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RequestDeviceCallback callback_;
};

class WebBluetoothService_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_GetDevices_ForwardToCallback(
      WebBluetoothService::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_GetDevices_ForwardToCallback(const WebBluetoothService_GetDevices_ForwardToCallback&) = delete;
  WebBluetoothService_GetDevices_ForwardToCallback& operator=(const WebBluetoothService_GetDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::GetDevicesCallback callback_;
};

class WebBluetoothService_ForgetDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_ForgetDevice_ForwardToCallback(
      WebBluetoothService::ForgetDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_ForgetDevice_ForwardToCallback(const WebBluetoothService_ForgetDevice_ForwardToCallback&) = delete;
  WebBluetoothService_ForgetDevice_ForwardToCallback& operator=(const WebBluetoothService_ForgetDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::ForgetDeviceCallback callback_;
};

class WebBluetoothService_RemoteServerConnect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteServerConnect_ForwardToCallback(
      WebBluetoothService::RemoteServerConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteServerConnect_ForwardToCallback(const WebBluetoothService_RemoteServerConnect_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteServerConnect_ForwardToCallback& operator=(const WebBluetoothService_RemoteServerConnect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteServerConnectCallback callback_;
};

class WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback(
      WebBluetoothService::RemoteServerGetPrimaryServicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback(const WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback& operator=(const WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteServerGetPrimaryServicesCallback callback_;
};

class WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback(
      WebBluetoothService::RemoteServiceGetCharacteristicsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback(const WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback& operator=(const WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteServiceGetCharacteristicsCallback callback_;
};

class WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback(
      WebBluetoothService::RemoteCharacteristicReadValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback(const WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback& operator=(const WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteCharacteristicReadValueCallback callback_;
};

class WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback(
      WebBluetoothService::RemoteCharacteristicWriteValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback(const WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback& operator=(const WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteCharacteristicWriteValueCallback callback_;
};

class WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback(
      WebBluetoothService::RemoteCharacteristicStartNotificationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback(const WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback& operator=(const WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteCharacteristicStartNotificationsCallback callback_;
};

class WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback(
      WebBluetoothService::RemoteCharacteristicStopNotificationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback(const WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback& operator=(const WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteCharacteristicStopNotificationsCallback callback_;
};

class WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback(
      WebBluetoothService::RemoteCharacteristicGetDescriptorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback(const WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback& operator=(const WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteCharacteristicGetDescriptorsCallback callback_;
};

class WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback(
      WebBluetoothService::RemoteDescriptorReadValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback(const WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback& operator=(const WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteDescriptorReadValueCallback callback_;
};

class WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback(
      WebBluetoothService::RemoteDescriptorWriteValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback(const WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback&) = delete;
  WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback& operator=(const WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RemoteDescriptorWriteValueCallback callback_;
};

class WebBluetoothService_RequestScanningStart_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_RequestScanningStart_ForwardToCallback(
      WebBluetoothService::RequestScanningStartCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_RequestScanningStart_ForwardToCallback(const WebBluetoothService_RequestScanningStart_ForwardToCallback&) = delete;
  WebBluetoothService_RequestScanningStart_ForwardToCallback& operator=(const WebBluetoothService_RequestScanningStart_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::RequestScanningStartCallback callback_;
};

class WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback(
      WebBluetoothService::WatchAdvertisementsForDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback(const WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback&) = delete;
  WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback& operator=(const WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebBluetoothService::WatchAdvertisementsForDeviceCallback callback_;
};

WebBluetoothServiceProxy::WebBluetoothServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBluetoothServiceProxy::GetAvailability(
    GetAvailabilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebBluetoothService::GetAvailability");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kGetAvailability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_GetAvailability_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("GetAvailability");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_GetAvailability_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RequestDevice(
    WebBluetoothRequestDeviceOptionsPtr in_options, RequestDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RequestDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type WebBluetoothRequestDeviceOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRequestDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RequestDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothRequestDeviceOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebBluetoothService.RequestDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RequestDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RequestDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebBluetoothService::GetDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_GetDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::ForgetDevice(
    const ::blink::WebBluetoothDeviceId& in_device_id, ForgetDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::ForgetDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::WebBluetoothDeviceId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kForgetDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_ForgetDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in WebBluetoothService.ForgetDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("ForgetDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_ForgetDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteServerConnect(
    const ::blink::WebBluetoothDeviceId& in_device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> in_client, RemoteServerConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteServerConnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::WebBluetoothDeviceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<WebBluetoothServerClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteServerConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteServerConnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in WebBluetoothService.RemoteServerConnect request");

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothServerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebBluetoothService.RemoteServerConnect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteServerConnect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteServerConnect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteServerDisconnect(
    const ::blink::WebBluetoothDeviceId& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteServerDisconnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::WebBluetoothDeviceId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteServerDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteServerDisconnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in WebBluetoothService.RemoteServerDisconnect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteServerDisconnect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebBluetoothServiceProxy::RemoteServerGetPrimaryServices(
    const ::blink::WebBluetoothDeviceId& in_device_id, WebBluetoothGATTQueryQuantity in_quantity, const std::optional<::device::BluetoothUUID>& in_services_uuid, RemoteServerGetPrimaryServicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteServerGetPrimaryServices", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::WebBluetoothDeviceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quantity"), in_quantity,
                        "<value of type WebBluetoothGATTQueryQuantity>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("services_uuid"), in_services_uuid,
                        "<value of type const std::optional<::device::BluetoothUUID>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteServerGetPrimaryServices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in WebBluetoothService.RemoteServerGetPrimaryServices request");

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothGATTQueryQuantity>(
    in_quantity,
    &params->quantity);
  mojo::internal::MessageFragment<
      typename decltype(params->services_uuid)::BaseType> services_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_services_uuid,
    services_uuid_fragment);

  params->services_uuid.Set(
      services_uuid_fragment.is_null() ? nullptr : services_uuid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteServerGetPrimaryServices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteServiceGetCharacteristics(
    const std::string& in_service_instance_id, WebBluetoothGATTQueryQuantity in_quantity, const std::optional<::device::BluetoothUUID>& in_characteristics_uuid, RemoteServiceGetCharacteristicsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteServiceGetCharacteristics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_instance_id"), in_service_instance_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quantity"), in_quantity,
                        "<value of type WebBluetoothGATTQueryQuantity>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristics_uuid"), in_characteristics_uuid,
                        "<value of type const std::optional<::device::BluetoothUUID>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteServiceGetCharacteristics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_instance_id)::BaseType> service_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_instance_id,
    service_instance_id_fragment);

  params->service_instance_id.Set(
      service_instance_id_fragment.is_null() ? nullptr : service_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_instance_id in WebBluetoothService.RemoteServiceGetCharacteristics request");

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothGATTQueryQuantity>(
    in_quantity,
    &params->quantity);
  mojo::internal::MessageFragment<
      typename decltype(params->characteristics_uuid)::BaseType> characteristics_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_characteristics_uuid,
    characteristics_uuid_fragment);

  params->characteristics_uuid.Set(
      characteristics_uuid_fragment.is_null() ? nullptr : characteristics_uuid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteServiceGetCharacteristics");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteCharacteristicReadValue(
    const std::string& in_characteristic_instance_id, RemoteCharacteristicReadValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteCharacteristicReadValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_instance_id"), in_characteristic_instance_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicReadValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicReadValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_instance_id)::BaseType> characteristic_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_instance_id,
    characteristic_instance_id_fragment);

  params->characteristic_instance_id.Set(
      characteristic_instance_id_fragment.is_null() ? nullptr : characteristic_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_instance_id in WebBluetoothService.RemoteCharacteristicReadValue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicReadValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteCharacteristicWriteValue(
    const std::string& in_characteristic_instance_id, ::base::span<const ::uint8_t> in_value, WebBluetoothWriteType in_write_type, RemoteCharacteristicWriteValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteCharacteristicWriteValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_instance_id"), in_characteristic_instance_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ::base::span<const ::uint8_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_type"), in_write_type,
                        "<value of type WebBluetoothWriteType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicWriteValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_instance_id)::BaseType> characteristic_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_instance_id,
    characteristic_instance_id_fragment);

  params->characteristic_instance_id.Set(
      characteristic_instance_id_fragment.is_null() ? nullptr : characteristic_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_instance_id in WebBluetoothService.RemoteCharacteristicWriteValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in WebBluetoothService.RemoteCharacteristicWriteValue request");

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothWriteType>(
    in_write_type,
    &params->write_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicWriteValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteCharacteristicStartNotifications(
    const std::string& in_characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> in_client, RemoteCharacteristicStartNotificationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteCharacteristicStartNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_instance_id"), in_characteristic_instance_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicStartNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_instance_id)::BaseType> characteristic_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_instance_id,
    characteristic_instance_id_fragment);

  params->characteristic_instance_id.Set(
      characteristic_instance_id_fragment.is_null() ? nullptr : characteristic_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_instance_id in WebBluetoothService.RemoteCharacteristicStartNotifications request");

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothCharacteristicClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebBluetoothService.RemoteCharacteristicStartNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicStartNotifications");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteCharacteristicStopNotifications(
    const std::string& in_characteristic_instance_id, RemoteCharacteristicStopNotificationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteCharacteristicStopNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_instance_id"), in_characteristic_instance_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicStopNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_instance_id)::BaseType> characteristic_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_instance_id,
    characteristic_instance_id_fragment);

  params->characteristic_instance_id.Set(
      characteristic_instance_id_fragment.is_null() ? nullptr : characteristic_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_instance_id in WebBluetoothService.RemoteCharacteristicStopNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicStopNotifications");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteCharacteristicGetDescriptors(
    const std::string& in_characteristics_instance_id, WebBluetoothGATTQueryQuantity in_quantity, const std::optional<::device::BluetoothUUID>& in_descriptor_uuid, RemoteCharacteristicGetDescriptorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteCharacteristicGetDescriptors", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristics_instance_id"), in_characteristics_instance_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quantity"), in_quantity,
                        "<value of type WebBluetoothGATTQueryQuantity>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_uuid"), in_descriptor_uuid,
                        "<value of type const std::optional<::device::BluetoothUUID>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicGetDescriptors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristics_instance_id)::BaseType> characteristics_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristics_instance_id,
    characteristics_instance_id_fragment);

  params->characteristics_instance_id.Set(
      characteristics_instance_id_fragment.is_null() ? nullptr : characteristics_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristics_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristics_instance_id in WebBluetoothService.RemoteCharacteristicGetDescriptors request");

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothGATTQueryQuantity>(
    in_quantity,
    &params->quantity);
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_uuid)::BaseType> descriptor_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_descriptor_uuid,
    descriptor_uuid_fragment);

  params->descriptor_uuid.Set(
      descriptor_uuid_fragment.is_null() ? nullptr : descriptor_uuid_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicGetDescriptors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteDescriptorReadValue(
    const std::string& in_descriptor_instance_id, RemoteDescriptorReadValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteDescriptorReadValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_instance_id"), in_descriptor_instance_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteDescriptorReadValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteDescriptorReadValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_instance_id)::BaseType> descriptor_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_instance_id,
    descriptor_instance_id_fragment);

  params->descriptor_instance_id.Set(
      descriptor_instance_id_fragment.is_null() ? nullptr : descriptor_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_instance_id in WebBluetoothService.RemoteDescriptorReadValue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteDescriptorReadValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RemoteDescriptorWriteValue(
    const std::string& in_descriptor_instance_id, ::base::span<const ::uint8_t> in_value, RemoteDescriptorWriteValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RemoteDescriptorWriteValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_instance_id"), in_descriptor_instance_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteDescriptorWriteValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteDescriptorWriteValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_instance_id)::BaseType> descriptor_instance_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_instance_id,
    descriptor_instance_id_fragment);

  params->descriptor_instance_id.Set(
      descriptor_instance_id_fragment.is_null() ? nullptr : descriptor_instance_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_instance_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_instance_id in WebBluetoothService.RemoteDescriptorWriteValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in WebBluetoothService.RemoteDescriptorWriteValue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteDescriptorWriteValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::RequestScanningStart(
    ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> in_client, WebBluetoothRequestLEScanOptionsPtr in_options, RequestScanningStartCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::RequestScanningStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type WebBluetoothRequestLEScanOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRequestScanningStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RequestScanningStart_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothAdvertisementClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebBluetoothService.RequestScanningStart request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothRequestLEScanOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebBluetoothService.RequestScanningStart request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RequestScanningStart");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_RequestScanningStart_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebBluetoothServiceProxy::WatchAdvertisementsForDevice(
    const ::blink::WebBluetoothDeviceId& in_device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> in_client, WatchAdvertisementsForDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothService::WatchAdvertisementsForDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::WebBluetoothDeviceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kWatchAdvertisementsForDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_WatchAdvertisementsForDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in WebBluetoothService.WatchAdvertisementsForDevice request");

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothAdvertisementClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebBluetoothService.WatchAdvertisementsForDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("WatchAdvertisementsForDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebBluetoothService_GetAvailability_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::GetAvailabilityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_GetAvailability_ProxyToResponder> proxy(
        new WebBluetoothService_GetAvailability_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_GetAvailability_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_GetAvailability_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_GetAvailability_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::GetAvailabilityCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_available);
};

bool WebBluetoothService_GetAvailability_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_GetAvailability_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_GetAvailability_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.0
  bool success = true;
  bool p_is_available{};
  WebBluetoothService_GetAvailability_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_available = input_data_view.is_available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_available));
  }
  return true;
}

void WebBluetoothService_GetAvailability_ProxyToResponder::Run(
    bool in_is_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::GetAvailability", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_available"), in_is_available,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kGetAvailability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_GetAvailability_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_available = in_is_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("GetAvailability");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RequestDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RequestDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RequestDevice_ProxyToResponder> proxy(
        new WebBluetoothService_RequestDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RequestDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RequestDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RequestDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RequestDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result, WebBluetoothDevicePtr in_device);
};

bool WebBluetoothService_RequestDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RequestDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RequestDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.1
  bool success = true;
  WebBluetoothResult p_result{};
  WebBluetoothDevicePtr p_device{};
  WebBluetoothService_RequestDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadDevice(&p_device))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_device));
  }
  return true;
}

void WebBluetoothService_RequestDevice_ProxyToResponder::Run(
    WebBluetoothResult in_result, WebBluetoothDevicePtr in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RequestDevice", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type WebBluetoothDevicePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRequestDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RequestDevice_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RequestDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_GetDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::GetDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_GetDevices_ProxyToResponder> proxy(
        new WebBluetoothService_GetDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_GetDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::GetDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<WebBluetoothDevicePtr> in_devices);
};

bool WebBluetoothService_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.2
  bool success = true;
  std::vector<WebBluetoothDevicePtr> p_devices{};
  WebBluetoothService_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_devices));
  }
  return true;
}

void WebBluetoothService_GetDevices_ProxyToResponder::Run(
    std::vector<WebBluetoothDevicePtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::GetDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<WebBluetoothDevicePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothDeviceDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_ForgetDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::ForgetDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_ForgetDevice_ProxyToResponder> proxy(
        new WebBluetoothService_ForgetDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_ForgetDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_ForgetDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_ForgetDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::ForgetDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebBluetoothService_ForgetDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_ForgetDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_ForgetDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.3
  bool success = true;
  WebBluetoothService_ForgetDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebBluetoothService_ForgetDevice_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::WebBluetoothService::ForgetDevice");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kForgetDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_ForgetDevice_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("ForgetDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteServerConnect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteServerConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteServerConnect_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteServerConnect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteServerConnect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteServerConnect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteServerConnect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteServerConnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result);
};

bool WebBluetoothService_RemoteServerConnect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteServerConnect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteServerConnect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.4
  bool success = true;
  WebBluetoothResult p_result{};
  WebBluetoothService_RemoteServerConnect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebBluetoothService_RemoteServerConnect_ProxyToResponder::Run(
    WebBluetoothResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteServerConnect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteServerConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteServerConnect_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteServerConnect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteServerGetPrimaryServicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteServerGetPrimaryServicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result, std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>> in_services);
};

bool WebBluetoothService_RemoteServerGetPrimaryServices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.6
  bool success = true;
  WebBluetoothResult p_result{};
  std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>> p_services{};
  WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadServices(&p_services))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_services));
  }
  return true;
}

void WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder::Run(
    WebBluetoothResult in_result, std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>> in_services) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteServerGetPrimaryServices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("services"), in_services,
                        "<value of type std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteServerGetPrimaryServices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->services)::BaseType>
      services_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& services_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothRemoteGATTServiceDataView>>(
    in_services,
    services_fragment,
    &services_validate_params);

  params->services.Set(
      services_fragment.is_null() ? nullptr : services_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteServerGetPrimaryServices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteServiceGetCharacteristicsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteServiceGetCharacteristicsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result, std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>> in_characteristics);
};

bool WebBluetoothService_RemoteServiceGetCharacteristics_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.7
  bool success = true;
  WebBluetoothResult p_result{};
  std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>> p_characteristics{};
  WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCharacteristics(&p_characteristics))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_characteristics));
  }
  return true;
}

void WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder::Run(
    WebBluetoothResult in_result, std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>> in_characteristics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteServiceGetCharacteristics", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristics"), in_characteristics,
                        "<value of type std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteServiceGetCharacteristics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->characteristics)::BaseType>
      characteristics_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& characteristics_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView>>(
    in_characteristics,
    characteristics_fragment,
    &characteristics_validate_params);

  params->characteristics.Set(
      characteristics_fragment.is_null() ? nullptr : characteristics_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteServiceGetCharacteristics");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteCharacteristicReadValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteCharacteristicReadValueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result, ::base::span<const ::uint8_t> in_value);
};

bool WebBluetoothService_RemoteCharacteristicReadValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.8
  bool success = true;
  WebBluetoothResult p_result{};
  ::base::span<const ::uint8_t> p_value{};
  WebBluetoothService_RemoteCharacteristicReadValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_value));
  }
  return true;
}

void WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder::Run(
    WebBluetoothResult in_result, ::base::span<const ::uint8_t> in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteCharacteristicReadValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicReadValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicReadValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteCharacteristicWriteValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteCharacteristicWriteValueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result);
};

bool WebBluetoothService_RemoteCharacteristicWriteValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.9
  bool success = true;
  WebBluetoothResult p_result{};
  WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder::Run(
    WebBluetoothResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteCharacteristicWriteValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicWriteValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicWriteValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteCharacteristicStartNotificationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteCharacteristicStartNotificationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result);
};

bool WebBluetoothService_RemoteCharacteristicStartNotifications_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.10
  bool success = true;
  WebBluetoothResult p_result{};
  WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder::Run(
    WebBluetoothResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteCharacteristicStartNotifications", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicStartNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicStartNotifications");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteCharacteristicStopNotificationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteCharacteristicStopNotificationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebBluetoothService_RemoteCharacteristicStopNotifications_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.11
  bool success = true;
  WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::WebBluetoothService::RemoteCharacteristicStopNotifications");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicStopNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicStopNotifications");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteCharacteristicGetDescriptorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteCharacteristicGetDescriptorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result, std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>> in_descriptors);
};

bool WebBluetoothService_RemoteCharacteristicGetDescriptors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.12
  bool success = true;
  WebBluetoothResult p_result{};
  std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>> p_descriptors{};
  WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadDescriptors(&p_descriptors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_descriptors));
  }
  return true;
}

void WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder::Run(
    WebBluetoothResult in_result, std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>> in_descriptors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteCharacteristicGetDescriptors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptors"), in_descriptors,
                        "<value of type std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteCharacteristicGetDescriptors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->descriptors)::BaseType>
      descriptors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& descriptors_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView>>(
    in_descriptors,
    descriptors_fragment,
    &descriptors_validate_params);

  params->descriptors.Set(
      descriptors_fragment.is_null() ? nullptr : descriptors_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteCharacteristicGetDescriptors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteDescriptorReadValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteDescriptorReadValueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result, ::base::span<const ::uint8_t> in_value);
};

bool WebBluetoothService_RemoteDescriptorReadValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.13
  bool success = true;
  WebBluetoothResult p_result{};
  ::base::span<const ::uint8_t> p_value{};
  WebBluetoothService_RemoteDescriptorReadValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_value));
  }
  return true;
}

void WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder::Run(
    WebBluetoothResult in_result, ::base::span<const ::uint8_t> in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteDescriptorReadValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteDescriptorReadValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteDescriptorReadValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RemoteDescriptorWriteValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder> proxy(
        new WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RemoteDescriptorWriteValueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result);
};

bool WebBluetoothService_RemoteDescriptorWriteValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.14
  bool success = true;
  WebBluetoothResult p_result{};
  WebBluetoothService_RemoteDescriptorWriteValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder::Run(
    WebBluetoothResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RemoteDescriptorWriteValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRemoteDescriptorWriteValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RemoteDescriptorWriteValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_RequestScanningStart_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::RequestScanningStartCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_RequestScanningStart_ProxyToResponder> proxy(
        new WebBluetoothService_RequestScanningStart_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_RequestScanningStart_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_RequestScanningStart_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_RequestScanningStart_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::RequestScanningStartCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result);
};

bool WebBluetoothService_RequestScanningStart_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_RequestScanningStart_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_RequestScanningStart_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.15
  bool success = true;
  WebBluetoothResult p_result{};
  WebBluetoothService_RequestScanningStart_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebBluetoothService_RequestScanningStart_ProxyToResponder::Run(
    WebBluetoothResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::RequestScanningStart", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kRequestScanningStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_RequestScanningStart_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("RequestScanningStart");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebBluetoothService::WatchAdvertisementsForDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder> proxy(
        new WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebBluetoothService::WatchAdvertisementsForDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebBluetoothResult in_result);
};

bool WebBluetoothService_WatchAdvertisementsForDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebBluetoothService.16
  bool success = true;
  WebBluetoothResult p_result{};
  WebBluetoothService_WatchAdvertisementsForDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebBluetoothService::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder::Run(
    WebBluetoothResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebBluetoothService::WatchAdvertisementsForDevice", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothService::kWatchAdvertisementsForDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothService::Name_);
  message.set_method_name("WatchAdvertisementsForDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebBluetoothServiceStubDispatch::Accept(
    WebBluetoothService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebBluetoothService>(message->header()->name)) {
    case messages::WebBluetoothService::kGetAvailability: {
      break;
    }
    case messages::WebBluetoothService::kRequestDevice: {
      break;
    }
    case messages::WebBluetoothService::kGetDevices: {
      break;
    }
    case messages::WebBluetoothService::kForgetDevice: {
      break;
    }
    case messages::WebBluetoothService::kRemoteServerConnect: {
      break;
    }
    case messages::WebBluetoothService::kRemoteServerDisconnect: {
      DCHECK(message->is_serialized());
      internal::WebBluetoothService_RemoteServerDisconnect_Params_Data* params =
          reinterpret_cast<internal::WebBluetoothService_RemoteServerDisconnect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBluetoothService.5
      bool success = true;
      ::blink::WebBluetoothDeviceId p_device_id{};
      WebBluetoothService_RemoteServerDisconnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteServerDisconnect(        
        std::move(p_device_id));
      return true;
    }
    case messages::WebBluetoothService::kRemoteServerGetPrimaryServices: {
      break;
    }
    case messages::WebBluetoothService::kRemoteServiceGetCharacteristics: {
      break;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicReadValue: {
      break;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicWriteValue: {
      break;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicStartNotifications: {
      break;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicStopNotifications: {
      break;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicGetDescriptors: {
      break;
    }
    case messages::WebBluetoothService::kRemoteDescriptorReadValue: {
      break;
    }
    case messages::WebBluetoothService::kRemoteDescriptorWriteValue: {
      break;
    }
    case messages::WebBluetoothService::kRequestScanningStart: {
      break;
    }
    case messages::WebBluetoothService::kWatchAdvertisementsForDevice: {
      break;
    }
  }
  return false;
}

// static
bool WebBluetoothServiceStubDispatch::AcceptWithResponder(
    WebBluetoothService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebBluetoothService>(message->header()->name)) {
    case messages::WebBluetoothService::kGetAvailability: {
      internal::WebBluetoothService_GetAvailability_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_GetAvailability_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.0
      bool success = true;
      WebBluetoothService_GetAvailability_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 0, false);
        return false;
      }
      auto callback =
          WebBluetoothService_GetAvailability_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAvailability(std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRequestDevice: {
      internal::WebBluetoothService_RequestDevice_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RequestDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.1
      bool success = true;
      WebBluetoothRequestDeviceOptionsPtr p_options{};
      WebBluetoothService_RequestDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 1, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RequestDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDevice(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kGetDevices: {
      internal::WebBluetoothService_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_GetDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.2
      bool success = true;
      WebBluetoothService_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 2, false);
        return false;
      }
      auto callback =
          WebBluetoothService_GetDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kForgetDevice: {
      internal::WebBluetoothService_ForgetDevice_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_ForgetDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.3
      bool success = true;
      ::blink::WebBluetoothDeviceId p_device_id{};
      WebBluetoothService_ForgetDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 3, false);
        return false;
      }
      auto callback =
          WebBluetoothService_ForgetDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForgetDevice(        
        std::move(p_device_id), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteServerConnect: {
      internal::WebBluetoothService_RemoteServerConnect_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteServerConnect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.4
      bool success = true;
      ::blink::WebBluetoothDeviceId p_device_id{};
      ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> p_client{};
      WebBluetoothService_RemoteServerConnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 4, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteServerConnect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteServerConnect(        
        std::move(p_device_id), 
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteServerDisconnect: {
      break;
    }
    case messages::WebBluetoothService::kRemoteServerGetPrimaryServices: {
      internal::WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.6
      bool success = true;
      ::blink::WebBluetoothDeviceId p_device_id{};
      WebBluetoothGATTQueryQuantity p_quantity{};
      std::optional<::device::BluetoothUUID> p_services_uuid{};
      WebBluetoothService_RemoteServerGetPrimaryServices_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadQuantity(&p_quantity))
        success = false;
      if (success && !input_data_view.ReadServicesUuid(&p_services_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 6, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteServerGetPrimaryServices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteServerGetPrimaryServices(        
        std::move(p_device_id), 
        std::move(p_quantity), 
        std::move(p_services_uuid), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteServiceGetCharacteristics: {
      internal::WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.7
      bool success = true;
      std::string p_service_instance_id{};
      WebBluetoothGATTQueryQuantity p_quantity{};
      std::optional<::device::BluetoothUUID> p_characteristics_uuid{};
      WebBluetoothService_RemoteServiceGetCharacteristics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceInstanceId(&p_service_instance_id))
        success = false;
      if (success && !input_data_view.ReadQuantity(&p_quantity))
        success = false;
      if (success && !input_data_view.ReadCharacteristicsUuid(&p_characteristics_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 7, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteServiceGetCharacteristics_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteServiceGetCharacteristics(        
        std::move(p_service_instance_id), 
        std::move(p_quantity), 
        std::move(p_characteristics_uuid), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicReadValue: {
      internal::WebBluetoothService_RemoteCharacteristicReadValue_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteCharacteristicReadValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.8
      bool success = true;
      std::string p_characteristic_instance_id{};
      WebBluetoothService_RemoteCharacteristicReadValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicInstanceId(&p_characteristic_instance_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 8, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteCharacteristicReadValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteCharacteristicReadValue(        
        std::move(p_characteristic_instance_id), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicWriteValue: {
      internal::WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.9
      bool success = true;
      std::string p_characteristic_instance_id{};
      ::base::span<const ::uint8_t> p_value{};
      WebBluetoothWriteType p_write_type{};
      WebBluetoothService_RemoteCharacteristicWriteValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicInstanceId(&p_characteristic_instance_id))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadWriteType(&p_write_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 9, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteCharacteristicWriteValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteCharacteristicWriteValue(        
        std::move(p_characteristic_instance_id), 
        std::move(p_value), 
        std::move(p_write_type), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicStartNotifications: {
      internal::WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.10
      bool success = true;
      std::string p_characteristic_instance_id{};
      ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> p_client{};
      WebBluetoothService_RemoteCharacteristicStartNotifications_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicInstanceId(&p_characteristic_instance_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 10, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteCharacteristicStartNotifications_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteCharacteristicStartNotifications(        
        std::move(p_characteristic_instance_id), 
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicStopNotifications: {
      internal::WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.11
      bool success = true;
      std::string p_characteristic_instance_id{};
      WebBluetoothService_RemoteCharacteristicStopNotifications_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicInstanceId(&p_characteristic_instance_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 11, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteCharacteristicStopNotifications_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteCharacteristicStopNotifications(        
        std::move(p_characteristic_instance_id), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteCharacteristicGetDescriptors: {
      internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.12
      bool success = true;
      std::string p_characteristics_instance_id{};
      WebBluetoothGATTQueryQuantity p_quantity{};
      std::optional<::device::BluetoothUUID> p_descriptor_uuid{};
      WebBluetoothService_RemoteCharacteristicGetDescriptors_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicsInstanceId(&p_characteristics_instance_id))
        success = false;
      if (success && !input_data_view.ReadQuantity(&p_quantity))
        success = false;
      if (success && !input_data_view.ReadDescriptorUuid(&p_descriptor_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 12, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteCharacteristicGetDescriptors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteCharacteristicGetDescriptors(        
        std::move(p_characteristics_instance_id), 
        std::move(p_quantity), 
        std::move(p_descriptor_uuid), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteDescriptorReadValue: {
      internal::WebBluetoothService_RemoteDescriptorReadValue_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteDescriptorReadValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.13
      bool success = true;
      std::string p_descriptor_instance_id{};
      WebBluetoothService_RemoteDescriptorReadValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescriptorInstanceId(&p_descriptor_instance_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 13, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteDescriptorReadValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteDescriptorReadValue(        
        std::move(p_descriptor_instance_id), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRemoteDescriptorWriteValue: {
      internal::WebBluetoothService_RemoteDescriptorWriteValue_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RemoteDescriptorWriteValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.14
      bool success = true;
      std::string p_descriptor_instance_id{};
      ::base::span<const ::uint8_t> p_value{};
      WebBluetoothService_RemoteDescriptorWriteValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescriptorInstanceId(&p_descriptor_instance_id))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 14, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RemoteDescriptorWriteValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteDescriptorWriteValue(        
        std::move(p_descriptor_instance_id), 
        std::move(p_value), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kRequestScanningStart: {
      internal::WebBluetoothService_RequestScanningStart_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_RequestScanningStart_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.15
      bool success = true;
      ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> p_client{};
      WebBluetoothRequestLEScanOptionsPtr p_options{};
      WebBluetoothService_RequestScanningStart_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 15, false);
        return false;
      }
      auto callback =
          WebBluetoothService_RequestScanningStart_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestScanningStart(        
        std::move(p_client), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebBluetoothService::kWatchAdvertisementsForDevice: {
      internal::WebBluetoothService_WatchAdvertisementsForDevice_Params_Data* params =
          reinterpret_cast<
              internal::WebBluetoothService_WatchAdvertisementsForDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebBluetoothService.16
      bool success = true;
      ::blink::WebBluetoothDeviceId p_device_id{};
      ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> p_client{};
      WebBluetoothService_WatchAdvertisementsForDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothService::Name_, 16, false);
        return false;
      }
      auto callback =
          WebBluetoothService_WatchAdvertisementsForDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WatchAdvertisementsForDevice(        
        std::move(p_device_id), 
        std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebBluetoothServiceValidationInfo[] = {
    { &internal::WebBluetoothService_GetAvailability_Params_Data::Validate,
     &internal::WebBluetoothService_GetAvailability_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RequestDevice_Params_Data::Validate,
     &internal::WebBluetoothService_RequestDevice_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_GetDevices_Params_Data::Validate,
     &internal::WebBluetoothService_GetDevices_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_ForgetDevice_Params_Data::Validate,
     &internal::WebBluetoothService_ForgetDevice_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteServerConnect_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteServerConnect_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteServerDisconnect_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteCharacteristicReadValue_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteDescriptorReadValue_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RemoteDescriptorWriteValue_Params_Data::Validate,
     &internal::WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_RequestScanningStart_Params_Data::Validate,
     &internal::WebBluetoothService_RequestScanningStart_ResponseParams_Data::Validate},
    { &internal::WebBluetoothService_WatchAdvertisementsForDevice_Params_Data::Validate,
     &internal::WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data::Validate},
};

bool WebBluetoothServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::WebBluetoothService::Name_,
    kWebBluetoothServiceValidationInfo);
}

bool WebBluetoothServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::WebBluetoothService::Name_,
    kWebBluetoothServiceValidationInfo);
}
// The declaration includes the definition on other builds.

WebBluetoothServerClient::IPCStableHashFunction WebBluetoothServerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebBluetoothServerClient>(message.name())) {
    case messages::WebBluetoothServerClient::kGATTServerDisconnected: {
      return &WebBluetoothServerClient::GATTServerDisconnected_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebBluetoothServerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebBluetoothServerClient>(message.name())) {
      case messages::WebBluetoothServerClient::kGATTServerDisconnected:
            return "Receive blink::mojom::WebBluetoothServerClient::GATTServerDisconnected";
    }
  } else {
    switch (static_cast<messages::WebBluetoothServerClient>(message.name())) {
      case messages::WebBluetoothServerClient::kGATTServerDisconnected:
            return "Receive reply blink::mojom::WebBluetoothServerClient::GATTServerDisconnected";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebBluetoothServerClient::GATTServerDisconnected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa03d8af8;  // IPCStableHash for blink::mojom::WebBluetoothServerClient::GATTServerDisconnected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebBluetoothServerClientProxy::WebBluetoothServerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBluetoothServerClientProxy::GATTServerDisconnected(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebBluetoothServerClient::GATTServerDisconnected");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothServerClient::kGATTServerDisconnected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothServerClient_GATTServerDisconnected_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothServerClient::Name_);
  message.set_method_name("GATTServerDisconnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebBluetoothServerClientStubDispatch::Accept(
    WebBluetoothServerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebBluetoothServerClient>(message->header()->name)) {
    case messages::WebBluetoothServerClient::kGATTServerDisconnected: {
      DCHECK(message->is_serialized());
      internal::WebBluetoothServerClient_GATTServerDisconnected_Params_Data* params =
          reinterpret_cast<internal::WebBluetoothServerClient_GATTServerDisconnected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBluetoothServerClient.0
      bool success = true;
      WebBluetoothServerClient_GATTServerDisconnected_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothServerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GATTServerDisconnected(        );
      return true;
    }
  }
  return false;
}

// static
bool WebBluetoothServerClientStubDispatch::AcceptWithResponder(
    WebBluetoothServerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebBluetoothServerClient>(message->header()->name)) {
    case messages::WebBluetoothServerClient::kGATTServerDisconnected: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebBluetoothServerClientValidationInfo[] = {
    { &internal::WebBluetoothServerClient_GATTServerDisconnected_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebBluetoothServerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::WebBluetoothServerClient::Name_,
    kWebBluetoothServerClientValidationInfo);
}

// The declaration includes the definition on other builds.

WebBluetoothCharacteristicClient::IPCStableHashFunction WebBluetoothCharacteristicClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebBluetoothCharacteristicClient>(message.name())) {
    case messages::WebBluetoothCharacteristicClient::kRemoteCharacteristicValueChanged: {
      return &WebBluetoothCharacteristicClient::RemoteCharacteristicValueChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebBluetoothCharacteristicClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebBluetoothCharacteristicClient>(message.name())) {
      case messages::WebBluetoothCharacteristicClient::kRemoteCharacteristicValueChanged:
            return "Receive blink::mojom::WebBluetoothCharacteristicClient::RemoteCharacteristicValueChanged";
    }
  } else {
    switch (static_cast<messages::WebBluetoothCharacteristicClient>(message.name())) {
      case messages::WebBluetoothCharacteristicClient::kRemoteCharacteristicValueChanged:
            return "Receive reply blink::mojom::WebBluetoothCharacteristicClient::RemoteCharacteristicValueChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebBluetoothCharacteristicClient::RemoteCharacteristicValueChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x45a304ff;  // IPCStableHash for blink::mojom::WebBluetoothCharacteristicClient::RemoteCharacteristicValueChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebBluetoothCharacteristicClientProxy::WebBluetoothCharacteristicClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBluetoothCharacteristicClientProxy::RemoteCharacteristicValueChanged(
    ::base::span<const ::uint8_t> in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothCharacteristicClient::RemoteCharacteristicValueChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothCharacteristicClient::kRemoteCharacteristicValueChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in WebBluetoothCharacteristicClient.RemoteCharacteristicValueChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothCharacteristicClient::Name_);
  message.set_method_name("RemoteCharacteristicValueChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebBluetoothCharacteristicClientStubDispatch::Accept(
    WebBluetoothCharacteristicClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebBluetoothCharacteristicClient>(message->header()->name)) {
    case messages::WebBluetoothCharacteristicClient::kRemoteCharacteristicValueChanged: {
      DCHECK(message->is_serialized());
      internal::WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data* params =
          reinterpret_cast<internal::WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBluetoothCharacteristicClient.0
      bool success = true;
      ::base::span<const ::uint8_t> p_value{};
      WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothCharacteristicClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoteCharacteristicValueChanged(        
        std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool WebBluetoothCharacteristicClientStubDispatch::AcceptWithResponder(
    WebBluetoothCharacteristicClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebBluetoothCharacteristicClient>(message->header()->name)) {
    case messages::WebBluetoothCharacteristicClient::kRemoteCharacteristicValueChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebBluetoothCharacteristicClientValidationInfo[] = {
    { &internal::WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebBluetoothCharacteristicClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::WebBluetoothCharacteristicClient::Name_,
    kWebBluetoothCharacteristicClientValidationInfo);
}

// The declaration includes the definition on other builds.

WebBluetoothAdvertisementClient::IPCStableHashFunction WebBluetoothAdvertisementClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebBluetoothAdvertisementClient>(message.name())) {
    case messages::WebBluetoothAdvertisementClient::kAdvertisingEvent: {
      return &WebBluetoothAdvertisementClient::AdvertisingEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebBluetoothAdvertisementClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebBluetoothAdvertisementClient>(message.name())) {
      case messages::WebBluetoothAdvertisementClient::kAdvertisingEvent:
            return "Receive blink::mojom::WebBluetoothAdvertisementClient::AdvertisingEvent";
    }
  } else {
    switch (static_cast<messages::WebBluetoothAdvertisementClient>(message.name())) {
      case messages::WebBluetoothAdvertisementClient::kAdvertisingEvent:
            return "Receive reply blink::mojom::WebBluetoothAdvertisementClient::AdvertisingEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebBluetoothAdvertisementClient::AdvertisingEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12d7eeac;  // IPCStableHash for blink::mojom::WebBluetoothAdvertisementClient::AdvertisingEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebBluetoothAdvertisementClientProxy::WebBluetoothAdvertisementClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBluetoothAdvertisementClientProxy::AdvertisingEvent(
    WebBluetoothAdvertisingEventPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebBluetoothAdvertisementClient::AdvertisingEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebBluetoothAdvertisingEventPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebBluetoothAdvertisementClient::kAdvertisingEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebBluetoothAdvertisingEventDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in WebBluetoothAdvertisementClient.AdvertisingEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBluetoothAdvertisementClient::Name_);
  message.set_method_name("AdvertisingEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebBluetoothAdvertisementClientStubDispatch::Accept(
    WebBluetoothAdvertisementClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebBluetoothAdvertisementClient>(message->header()->name)) {
    case messages::WebBluetoothAdvertisementClient::kAdvertisingEvent: {
      DCHECK(message->is_serialized());
      internal::WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data* params =
          reinterpret_cast<internal::WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebBluetoothAdvertisementClient.0
      bool success = true;
      WebBluetoothAdvertisingEventPtr p_result{};
      WebBluetoothAdvertisementClient_AdvertisingEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBluetoothAdvertisementClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvertisingEvent(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool WebBluetoothAdvertisementClientStubDispatch::AcceptWithResponder(
    WebBluetoothAdvertisementClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebBluetoothAdvertisementClient>(message->header()->name)) {
    case messages::WebBluetoothAdvertisementClient::kAdvertisingEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebBluetoothAdvertisementClientValidationInfo[] = {
    { &internal::WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebBluetoothAdvertisementClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::WebBluetoothAdvertisementClient::Name_,
    kWebBluetoothAdvertisementClientValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::WebBluetoothLeScanFilter::DataView, ::blink::mojom::WebBluetoothLeScanFilterPtr>::Read(
    ::blink::mojom::WebBluetoothLeScanFilter::DataView input,
    ::blink::mojom::WebBluetoothLeScanFilterPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothLeScanFilterPtr result(::blink::mojom::WebBluetoothLeScanFilter::New());
  
      if (success && !input.ReadServices(&result->services))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadNamePrefix(&result->name_prefix))
        success = false;
      if (success && !input.ReadManufacturerData(&result->manufacturer_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothCompany::DataView, ::blink::mojom::WebBluetoothCompanyPtr>::Read(
    ::blink::mojom::WebBluetoothCompany::DataView input,
    ::blink::mojom::WebBluetoothCompanyPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothCompanyPtr result(::blink::mojom::WebBluetoothCompany::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothDataFilter::DataView, ::blink::mojom::WebBluetoothDataFilterPtr>::Read(
    ::blink::mojom::WebBluetoothDataFilter::DataView input,
    ::blink::mojom::WebBluetoothDataFilterPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothDataFilterPtr result(::blink::mojom::WebBluetoothDataFilter::New());
  
      if (success)
        result->data = input.data();
      if (success)
        result->mask = input.mask();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothRequestDeviceOptions::DataView, ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr>::Read(
    ::blink::mojom::WebBluetoothRequestDeviceOptions::DataView input,
    ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr result(::blink::mojom::WebBluetoothRequestDeviceOptions::New());
  
      if (success && !input.ReadFilters(&result->filters))
        success = false;
      if (success && !input.ReadExclusionFilters(&result->exclusion_filters))
        success = false;
      if (success && !input.ReadOptionalServices(&result->optional_services))
        success = false;
      if (success && !input.ReadOptionalManufacturerData(&result->optional_manufacturer_data))
        success = false;
      if (success)
        result->accept_all_devices = input.accept_all_devices();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothRequestLEScanOptions::DataView, ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr>::Read(
    ::blink::mojom::WebBluetoothRequestLEScanOptions::DataView input,
    ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr result(::blink::mojom::WebBluetoothRequestLEScanOptions::New());
  
      if (success && !input.ReadFilters(&result->filters))
        success = false;
      if (success)
        result->keep_repeated_devices = input.keep_repeated_devices();
      if (success)
        result->accept_all_advertisements = input.accept_all_advertisements();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothDeviceId::DataView, ::blink::mojom::WebBluetoothDeviceIdPtr>::Read(
    ::blink::mojom::WebBluetoothDeviceId::DataView input,
    ::blink::mojom::WebBluetoothDeviceIdPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothDeviceIdPtr result(::blink::mojom::WebBluetoothDeviceId::New());
  
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothDevice::DataView, ::blink::mojom::WebBluetoothDevicePtr>::Read(
    ::blink::mojom::WebBluetoothDevice::DataView input,
    ::blink::mojom::WebBluetoothDevicePtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothDevicePtr result(::blink::mojom::WebBluetoothDevice::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothRemoteGATTService::DataView, ::blink::mojom::WebBluetoothRemoteGATTServicePtr>::Read(
    ::blink::mojom::WebBluetoothRemoteGATTService::DataView input,
    ::blink::mojom::WebBluetoothRemoteGATTServicePtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothRemoteGATTServicePtr result(::blink::mojom::WebBluetoothRemoteGATTService::New());
  
      if (success && !input.ReadInstanceId(&result->instance_id))
        success = false;
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothRemoteGATTCharacteristic::DataView, ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr>::Read(
    ::blink::mojom::WebBluetoothRemoteGATTCharacteristic::DataView input,
    ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr result(::blink::mojom::WebBluetoothRemoteGATTCharacteristic::New());
  
      if (success && !input.ReadInstanceId(&result->instance_id))
        success = false;
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success)
        result->properties = input.properties();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothAdvertisingEvent::DataView, ::blink::mojom::WebBluetoothAdvertisingEventPtr>::Read(
    ::blink::mojom::WebBluetoothAdvertisingEvent::DataView input,
    ::blink::mojom::WebBluetoothAdvertisingEventPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothAdvertisingEventPtr result(::blink::mojom::WebBluetoothAdvertisingEvent::New());
  
      if (success && !input.ReadDevice(&result->device))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUuids(&result->uuids))
        success = false;
      if (success)
        result->appearance_is_set = input.appearance_is_set();
      if (success)
        result->appearance = input.appearance();
      if (success)
        result->tx_power_is_set = input.tx_power_is_set();
      if (success)
        result->tx_power = input.tx_power();
      if (success)
        result->rssi_is_set = input.rssi_is_set();
      if (success)
        result->rssi = input.rssi();
      if (success && !input.ReadManufacturerData(&result->manufacturer_data))
        success = false;
      if (success && !input.ReadServiceData(&result->service_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WebBluetoothRemoteGATTDescriptor::DataView, ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr>::Read(
    ::blink::mojom::WebBluetoothRemoteGATTDescriptor::DataView input,
    ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr result(::blink::mojom::WebBluetoothRemoteGATTDescriptor::New());
  
      if (success && !input.ReadInstanceId(&result->instance_id))
        success = false;
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void WebBluetoothServiceInterceptorForTesting::GetAvailability(GetAvailabilityCallback callback) {
  GetForwardingInterface()->GetAvailability(std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RequestDevice(WebBluetoothRequestDeviceOptionsPtr options, RequestDeviceCallback callback) {
  GetForwardingInterface()->RequestDevice(
    std::move(options)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::GetDevices(GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::ForgetDevice(const ::blink::WebBluetoothDeviceId& device_id, ForgetDeviceCallback callback) {
  GetForwardingInterface()->ForgetDevice(
    std::move(device_id)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteServerConnect(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, RemoteServerConnectCallback callback) {
  GetForwardingInterface()->RemoteServerConnect(
    std::move(device_id)
    , 
    std::move(client)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteServerDisconnect(const ::blink::WebBluetoothDeviceId& device_id) {
  GetForwardingInterface()->RemoteServerDisconnect(
    std::move(device_id)
    );
}
void WebBluetoothServiceInterceptorForTesting::RemoteServerGetPrimaryServices(const ::blink::WebBluetoothDeviceId& device_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& services_uuid, RemoteServerGetPrimaryServicesCallback callback) {
  GetForwardingInterface()->RemoteServerGetPrimaryServices(
    std::move(device_id)
    , 
    std::move(quantity)
    , 
    std::move(services_uuid)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteServiceGetCharacteristics(const std::string& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& characteristics_uuid, RemoteServiceGetCharacteristicsCallback callback) {
  GetForwardingInterface()->RemoteServiceGetCharacteristics(
    std::move(service_instance_id)
    , 
    std::move(quantity)
    , 
    std::move(characteristics_uuid)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteCharacteristicReadValue(const std::string& characteristic_instance_id, RemoteCharacteristicReadValueCallback callback) {
  GetForwardingInterface()->RemoteCharacteristicReadValue(
    std::move(characteristic_instance_id)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteCharacteristicWriteValue(const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type, RemoteCharacteristicWriteValueCallback callback) {
  GetForwardingInterface()->RemoteCharacteristicWriteValue(
    std::move(characteristic_instance_id)
    , 
    std::move(value)
    , 
    std::move(write_type)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteCharacteristicStartNotifications(const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, RemoteCharacteristicStartNotificationsCallback callback) {
  GetForwardingInterface()->RemoteCharacteristicStartNotifications(
    std::move(characteristic_instance_id)
    , 
    std::move(client)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteCharacteristicStopNotifications(const std::string& characteristic_instance_id, RemoteCharacteristicStopNotificationsCallback callback) {
  GetForwardingInterface()->RemoteCharacteristicStopNotifications(
    std::move(characteristic_instance_id)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteCharacteristicGetDescriptors(const std::string& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& descriptor_uuid, RemoteCharacteristicGetDescriptorsCallback callback) {
  GetForwardingInterface()->RemoteCharacteristicGetDescriptors(
    std::move(characteristics_instance_id)
    , 
    std::move(quantity)
    , 
    std::move(descriptor_uuid)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteDescriptorReadValue(const std::string& descriptor_instance_id, RemoteDescriptorReadValueCallback callback) {
  GetForwardingInterface()->RemoteDescriptorReadValue(
    std::move(descriptor_instance_id)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RemoteDescriptorWriteValue(const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value, RemoteDescriptorWriteValueCallback callback) {
  GetForwardingInterface()->RemoteDescriptorWriteValue(
    std::move(descriptor_instance_id)
    , 
    std::move(value)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::RequestScanningStart(::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, RequestScanningStartCallback callback) {
  GetForwardingInterface()->RequestScanningStart(
    std::move(client)
    , 
    std::move(options)
    , std::move(callback));
}
void WebBluetoothServiceInterceptorForTesting::WatchAdvertisementsForDevice(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WatchAdvertisementsForDeviceCallback callback) {
  GetForwardingInterface()->WatchAdvertisementsForDevice(
    std::move(device_id)
    , 
    std::move(client)
    , std::move(callback));
}
WebBluetoothServiceAsyncWaiter::WebBluetoothServiceAsyncWaiter(
    WebBluetoothService* proxy) : proxy_(proxy) {}

WebBluetoothServiceAsyncWaiter::~WebBluetoothServiceAsyncWaiter() = default;


void WebBluetoothServiceAsyncWaiter::GetAvailability(
    bool* out_is_available) {
  base::RunLoop loop;
  proxy_->GetAvailability(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_available
,
             bool is_available) {*out_is_available = std::move(is_available);
            loop->Quit();
          },
          &loop,
          out_is_available));
  loop.Run();
}

bool WebBluetoothServiceAsyncWaiter::GetAvailability(
    ) {
  bool async_wait_result;
  GetAvailability(&async_wait_result);
  return async_wait_result;
}

void WebBluetoothServiceAsyncWaiter::RequestDevice(
    WebBluetoothRequestDeviceOptionsPtr options, WebBluetoothResult* out_result, WebBluetoothDevicePtr* out_device) {
  base::RunLoop loop;
  proxy_->RequestDevice(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             WebBluetoothDevicePtr* out_device
,
             WebBluetoothResult result,
             WebBluetoothDevicePtr device) {*out_result = std::move(result);*out_device = std::move(device);
            loop->Quit();
          },
          &loop,
          out_result,
          out_device));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::GetDevices(
    std::vector<WebBluetoothDevicePtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<WebBluetoothDevicePtr>* out_devices
,
             std::vector<WebBluetoothDevicePtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

std::vector<WebBluetoothDevicePtr> WebBluetoothServiceAsyncWaiter::GetDevices(
    ) {
  std::vector<WebBluetoothDevicePtr> async_wait_result;
  GetDevices(&async_wait_result);
  return async_wait_result;
}

void WebBluetoothServiceAsyncWaiter::ForgetDevice(
    const ::blink::WebBluetoothDeviceId& device_id) {
  base::RunLoop loop;
  proxy_->ForgetDevice(
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::RemoteServerConnect(
    const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, WebBluetoothResult* out_result) {
  base::RunLoop loop;
  proxy_->RemoteServerConnect(
      std::move(device_id),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             WebBluetoothResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebBluetoothResult WebBluetoothServiceAsyncWaiter::RemoteServerConnect(
    const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client) {
  WebBluetoothResult async_wait_result;
  RemoteServerConnect(std::move(device_id),std::move(client),&async_wait_result);
  return async_wait_result;
}

void WebBluetoothServiceAsyncWaiter::RemoteServerGetPrimaryServices(
    const ::blink::WebBluetoothDeviceId& device_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& services_uuid, WebBluetoothResult* out_result, std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>>* out_services) {
  base::RunLoop loop;
  proxy_->RemoteServerGetPrimaryServices(
      std::move(device_id),
      std::move(quantity),
      std::move(services_uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>>* out_services
,
             WebBluetoothResult result,
             std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>> services) {*out_result = std::move(result);*out_services = std::move(services);
            loop->Quit();
          },
          &loop,
          out_result,
          out_services));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::RemoteServiceGetCharacteristics(
    const std::string& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& characteristics_uuid, WebBluetoothResult* out_result, std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>>* out_characteristics) {
  base::RunLoop loop;
  proxy_->RemoteServiceGetCharacteristics(
      std::move(service_instance_id),
      std::move(quantity),
      std::move(characteristics_uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>>* out_characteristics
,
             WebBluetoothResult result,
             std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>> characteristics) {*out_result = std::move(result);*out_characteristics = std::move(characteristics);
            loop->Quit();
          },
          &loop,
          out_result,
          out_characteristics));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::RemoteCharacteristicReadValue(
    const std::string& characteristic_instance_id, WebBluetoothResult* out_result, ::base::span<const ::uint8_t>* out_value) {
  base::RunLoop loop;
  proxy_->RemoteCharacteristicReadValue(
      std::move(characteristic_instance_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             ::base::span<const ::uint8_t>* out_value
,
             WebBluetoothResult result,
             ::base::span<const ::uint8_t> value) {*out_result = std::move(result);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_result,
          out_value));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::RemoteCharacteristicWriteValue(
    const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type, WebBluetoothResult* out_result) {
  base::RunLoop loop;
  proxy_->RemoteCharacteristicWriteValue(
      std::move(characteristic_instance_id),
      std::move(value),
      std::move(write_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             WebBluetoothResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebBluetoothResult WebBluetoothServiceAsyncWaiter::RemoteCharacteristicWriteValue(
    const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type) {
  WebBluetoothResult async_wait_result;
  RemoteCharacteristicWriteValue(std::move(characteristic_instance_id),std::move(value),std::move(write_type),&async_wait_result);
  return async_wait_result;
}

void WebBluetoothServiceAsyncWaiter::RemoteCharacteristicStartNotifications(
    const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, WebBluetoothResult* out_result) {
  base::RunLoop loop;
  proxy_->RemoteCharacteristicStartNotifications(
      std::move(characteristic_instance_id),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             WebBluetoothResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebBluetoothResult WebBluetoothServiceAsyncWaiter::RemoteCharacteristicStartNotifications(
    const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client) {
  WebBluetoothResult async_wait_result;
  RemoteCharacteristicStartNotifications(std::move(characteristic_instance_id),std::move(client),&async_wait_result);
  return async_wait_result;
}

void WebBluetoothServiceAsyncWaiter::RemoteCharacteristicStopNotifications(
    const std::string& characteristic_instance_id) {
  base::RunLoop loop;
  proxy_->RemoteCharacteristicStopNotifications(
      std::move(characteristic_instance_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::RemoteCharacteristicGetDescriptors(
    const std::string& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& descriptor_uuid, WebBluetoothResult* out_result, std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>>* out_descriptors) {
  base::RunLoop loop;
  proxy_->RemoteCharacteristicGetDescriptors(
      std::move(characteristics_instance_id),
      std::move(quantity),
      std::move(descriptor_uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>>* out_descriptors
,
             WebBluetoothResult result,
             std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>> descriptors) {*out_result = std::move(result);*out_descriptors = std::move(descriptors);
            loop->Quit();
          },
          &loop,
          out_result,
          out_descriptors));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::RemoteDescriptorReadValue(
    const std::string& descriptor_instance_id, WebBluetoothResult* out_result, ::base::span<const ::uint8_t>* out_value) {
  base::RunLoop loop;
  proxy_->RemoteDescriptorReadValue(
      std::move(descriptor_instance_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             ::base::span<const ::uint8_t>* out_value
,
             WebBluetoothResult result,
             ::base::span<const ::uint8_t> value) {*out_result = std::move(result);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_result,
          out_value));
  loop.Run();
}



void WebBluetoothServiceAsyncWaiter::RemoteDescriptorWriteValue(
    const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothResult* out_result) {
  base::RunLoop loop;
  proxy_->RemoteDescriptorWriteValue(
      std::move(descriptor_instance_id),
      std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             WebBluetoothResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebBluetoothResult WebBluetoothServiceAsyncWaiter::RemoteDescriptorWriteValue(
    const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value) {
  WebBluetoothResult async_wait_result;
  RemoteDescriptorWriteValue(std::move(descriptor_instance_id),std::move(value),&async_wait_result);
  return async_wait_result;
}

void WebBluetoothServiceAsyncWaiter::RequestScanningStart(
    ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, WebBluetoothResult* out_result) {
  base::RunLoop loop;
  proxy_->RequestScanningStart(
      std::move(client),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             WebBluetoothResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebBluetoothResult WebBluetoothServiceAsyncWaiter::RequestScanningStart(
    ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options) {
  WebBluetoothResult async_wait_result;
  RequestScanningStart(std::move(client),std::move(options),&async_wait_result);
  return async_wait_result;
}

void WebBluetoothServiceAsyncWaiter::WatchAdvertisementsForDevice(
    const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothResult* out_result) {
  base::RunLoop loop;
  proxy_->WatchAdvertisementsForDevice(
      std::move(device_id),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebBluetoothResult* out_result
,
             WebBluetoothResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebBluetoothResult WebBluetoothServiceAsyncWaiter::WatchAdvertisementsForDevice(
    const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client) {
  WebBluetoothResult async_wait_result;
  WatchAdvertisementsForDevice(std::move(device_id),std::move(client),&async_wait_result);
  return async_wait_result;
}




void WebBluetoothServerClientInterceptorForTesting::GATTServerDisconnected() {
  GetForwardingInterface()->GATTServerDisconnected();
}
WebBluetoothServerClientAsyncWaiter::WebBluetoothServerClientAsyncWaiter(
    WebBluetoothServerClient* proxy) : proxy_(proxy) {}

WebBluetoothServerClientAsyncWaiter::~WebBluetoothServerClientAsyncWaiter() = default;





void WebBluetoothCharacteristicClientInterceptorForTesting::RemoteCharacteristicValueChanged(::base::span<const ::uint8_t> value) {
  GetForwardingInterface()->RemoteCharacteristicValueChanged(
    std::move(value)
    );
}
WebBluetoothCharacteristicClientAsyncWaiter::WebBluetoothCharacteristicClientAsyncWaiter(
    WebBluetoothCharacteristicClient* proxy) : proxy_(proxy) {}

WebBluetoothCharacteristicClientAsyncWaiter::~WebBluetoothCharacteristicClientAsyncWaiter() = default;





void WebBluetoothAdvertisementClientInterceptorForTesting::AdvertisingEvent(WebBluetoothAdvertisingEventPtr result) {
  GetForwardingInterface()->AdvertisingEvent(
    std::move(result)
    );
}
WebBluetoothAdvertisementClientAsyncWaiter::WebBluetoothAdvertisementClientAsyncWaiter(
    WebBluetoothAdvertisementClient* proxy) : proxy_(proxy) {}

WebBluetoothAdvertisementClientAsyncWaiter::~WebBluetoothAdvertisementClientAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif