// third_party/blink/public/mojom/blob/data_element.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/blob/data_element.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"

#include "third_party/blink/public/mojom/blob/data_element.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DataElementBytesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DataElementBytesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DataElementBytes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->length = Traits::length(input);

      decltype(Traits::embedded_data(input)) in_embedded_data = Traits::embedded_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->embedded_data)::BaseType>
          embedded_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& embedded_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_embedded_data,
        embedded_data_fragment,
        &embedded_data_validate_params);

      fragment->embedded_data.Set(
          embedded_data_fragment.is_null() ? nullptr : embedded_data_fragment.data());

      decltype(Traits::data(input)) in_data = Traits::data(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BytesProviderInterfaceBase>>(
        in_data,
        &fragment->data,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid data in DataElementBytes struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DataElementFileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DataElementFileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DataElementFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in DataElementFile struct");

      fragment->offset = Traits::offset(input);

      fragment->length = Traits::length(input);

      decltype(Traits::expected_modification_time(input)) in_expected_modification_time = Traits::expected_modification_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expected_modification_time)::BaseType> expected_modification_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_expected_modification_time,
        expected_modification_time_fragment);

      fragment->expected_modification_time.Set(
          expected_modification_time_fragment.is_null() ? nullptr : expected_modification_time_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DataElementBlobDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DataElementBlobDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DataElementBlob_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::blob(input)) in_blob = Traits::blob(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
        in_blob,
        &fragment->blob,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->blob)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid blob in DataElementBlob struct");

      fragment->offset = Traits::offset(input);

      fragment->length = Traits::length(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DataElementDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DataElementDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::DataElement_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::DataElementDataView::Tag::kBytes: {
    decltype(Traits::bytes(input))
    in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bytes)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataElementBytesDataView, send_validation>(
  in_bytes,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bytes in DataElement union");
    fragment->data.f_bytes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DataElementDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataElementFileDataView, send_validation>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in DataElement union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DataElementDataView::Tag::kBlob: {
    decltype(Traits::blob(input))
    in_blob = Traits::blob(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_blob)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataElementBlobDataView, send_validation>(
  in_blob,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null blob in DataElement union");
    fragment->data.f_blob.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_SEND_VALIDATION_H_