// third_party/blink/public/mojom/background_sync/background_sync.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-params-data.h"
#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-import-headers.h"
#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-test-utils.h"


namespace blink::mojom {
SyncRegistrationOptions::SyncRegistrationOptions()
    : tag(""),
      min_interval(-1) {}

SyncRegistrationOptions::SyncRegistrationOptions(
    const std::string& tag_in,
    int64_t min_interval_in)
    : tag(std::move(tag_in)),
      min_interval(std::move(min_interval_in)) {}

SyncRegistrationOptions::~SyncRegistrationOptions() = default;
size_t SyncRegistrationOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->tag);
  seed = mojo::internal::Hash(seed, this->min_interval);
  return seed;
}

void SyncRegistrationOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tag"), this->tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_interval"), this->min_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyncRegistrationOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundSyncRegistrationInfo::BackgroundSyncRegistrationInfo()
    : service_worker_registration_id(-1),
      tag(),
      sync_type() {}

BackgroundSyncRegistrationInfo::BackgroundSyncRegistrationInfo(
    int64_t service_worker_registration_id_in,
    const std::string& tag_in,
    BackgroundSyncType sync_type_in)
    : service_worker_registration_id(std::move(service_worker_registration_id_in)),
      tag(std::move(tag_in)),
      sync_type(std::move(sync_type_in)) {}

BackgroundSyncRegistrationInfo::~BackgroundSyncRegistrationInfo() = default;
size_t BackgroundSyncRegistrationInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->service_worker_registration_id);
  seed = mojo::internal::Hash(seed, this->tag);
  seed = mojo::internal::Hash(seed, this->sync_type);
  return seed;
}

void BackgroundSyncRegistrationInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_registration_id"), this->service_worker_registration_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tag"), this->tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_type"), this->sync_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BackgroundSyncType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackgroundSyncRegistrationInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

OneShotBackgroundSyncService::IPCStableHashFunction OneShotBackgroundSyncService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OneShotBackgroundSyncService>(message.name())) {
    case messages::OneShotBackgroundSyncService::kRegister: {
      return &OneShotBackgroundSyncService::Register_Sym::IPCStableHash;
    }
    case messages::OneShotBackgroundSyncService::kDidResolveRegistration: {
      return &OneShotBackgroundSyncService::DidResolveRegistration_Sym::IPCStableHash;
    }
    case messages::OneShotBackgroundSyncService::kGetRegistrations: {
      return &OneShotBackgroundSyncService::GetRegistrations_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OneShotBackgroundSyncService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OneShotBackgroundSyncService>(message.name())) {
      case messages::OneShotBackgroundSyncService::kRegister:
            return "Receive blink::mojom::OneShotBackgroundSyncService::Register";
      case messages::OneShotBackgroundSyncService::kDidResolveRegistration:
            return "Receive blink::mojom::OneShotBackgroundSyncService::DidResolveRegistration";
      case messages::OneShotBackgroundSyncService::kGetRegistrations:
            return "Receive blink::mojom::OneShotBackgroundSyncService::GetRegistrations";
    }
  } else {
    switch (static_cast<messages::OneShotBackgroundSyncService>(message.name())) {
      case messages::OneShotBackgroundSyncService::kRegister:
            return "Receive reply blink::mojom::OneShotBackgroundSyncService::Register";
      case messages::OneShotBackgroundSyncService::kDidResolveRegistration:
            return "Receive reply blink::mojom::OneShotBackgroundSyncService::DidResolveRegistration";
      case messages::OneShotBackgroundSyncService::kGetRegistrations:
            return "Receive reply blink::mojom::OneShotBackgroundSyncService::GetRegistrations";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OneShotBackgroundSyncService::Register_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3ef3470;  // IPCStableHash for blink::mojom::OneShotBackgroundSyncService::Register
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OneShotBackgroundSyncService::DidResolveRegistration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10c01f2f;  // IPCStableHash for blink::mojom::OneShotBackgroundSyncService::DidResolveRegistration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OneShotBackgroundSyncService::GetRegistrations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b31e736;  // IPCStableHash for blink::mojom::OneShotBackgroundSyncService::GetRegistrations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OneShotBackgroundSyncService_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OneShotBackgroundSyncService_Register_ForwardToCallback(
      OneShotBackgroundSyncService::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  OneShotBackgroundSyncService_Register_ForwardToCallback(const OneShotBackgroundSyncService_Register_ForwardToCallback&) = delete;
  OneShotBackgroundSyncService_Register_ForwardToCallback& operator=(const OneShotBackgroundSyncService_Register_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OneShotBackgroundSyncService::RegisterCallback callback_;
};

class OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback(
      OneShotBackgroundSyncService::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback(const OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback&) = delete;
  OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback& operator=(const OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OneShotBackgroundSyncService::GetRegistrationsCallback callback_;
};

OneShotBackgroundSyncServiceProxy::OneShotBackgroundSyncServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OneShotBackgroundSyncServiceProxy::Register(
    SyncRegistrationOptionsPtr in_options, int64_t in_service_worker_registration_id, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::OneShotBackgroundSyncService::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SyncRegistrationOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OneShotBackgroundSyncService::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in OneShotBackgroundSyncService.Register request");

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OneShotBackgroundSyncService_Register_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OneShotBackgroundSyncServiceProxy::DidResolveRegistration(
    BackgroundSyncRegistrationInfoPtr in_registration_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::OneShotBackgroundSyncService::DidResolveRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_info"), in_registration_info,
                        "<value of type BackgroundSyncRegistrationInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OneShotBackgroundSyncService::kDidResolveRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration_info)::BaseType> registration_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncRegistrationInfoDataView>(
    in_registration_info,
    registration_info_fragment);

  params->registration_info.Set(
      registration_info_fragment.is_null() ? nullptr : registration_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration_info in OneShotBackgroundSyncService.DidResolveRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("DidResolveRegistration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OneShotBackgroundSyncServiceProxy::GetRegistrations(
    int64_t in_service_worker_registration_id, GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::OneShotBackgroundSyncService::GetRegistrations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OneShotBackgroundSyncService::kGetRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OneShotBackgroundSyncService_Register_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OneShotBackgroundSyncService::RegisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OneShotBackgroundSyncService_Register_ProxyToResponder> proxy(
        new OneShotBackgroundSyncService_Register_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OneShotBackgroundSyncService_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OneShotBackgroundSyncService_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OneShotBackgroundSyncService_Register_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OneShotBackgroundSyncService::RegisterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options);
};

bool OneShotBackgroundSyncService_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OneShotBackgroundSyncService_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OneShotBackgroundSyncService_Register_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OneShotBackgroundSyncService.0
  bool success = true;
  BackgroundSyncError p_err{};
  SyncRegistrationOptionsPtr p_options{};
  OneShotBackgroundSyncService_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadOptions(&p_options))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OneShotBackgroundSyncService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_options));
  }
  return true;
}

void OneShotBackgroundSyncService_Register_ProxyToResponder::Run(
    BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::OneShotBackgroundSyncService::Register", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err,
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SyncRegistrationOptionsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OneShotBackgroundSyncService::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_Register_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
    in_err,
    &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OneShotBackgroundSyncService::GetRegistrationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder> proxy(
        new OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OneShotBackgroundSyncService::GetRegistrationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, std::vector<SyncRegistrationOptionsPtr> in_registrations);
};

bool OneShotBackgroundSyncService_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OneShotBackgroundSyncService.2
  bool success = true;
  BackgroundSyncError p_err{};
  std::vector<SyncRegistrationOptionsPtr> p_registrations{};
  OneShotBackgroundSyncService_GetRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OneShotBackgroundSyncService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_registrations));
  }
  return true;
}

void OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder::Run(
    BackgroundSyncError in_err, std::vector<SyncRegistrationOptionsPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::OneShotBackgroundSyncService::GetRegistrations", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err,
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations,
                        "<value of type std::vector<SyncRegistrationOptionsPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OneShotBackgroundSyncService::kGetRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
    in_err,
    &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& registrations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SyncRegistrationOptionsDataView>>(
    in_registrations,
    registrations_fragment,
    &registrations_validate_params);

  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registrations.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registrations in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OneShotBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OneShotBackgroundSyncServiceStubDispatch::Accept(
    OneShotBackgroundSyncService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OneShotBackgroundSyncService>(message->header()->name)) {
    case messages::OneShotBackgroundSyncService::kRegister: {
      break;
    }
    case messages::OneShotBackgroundSyncService::kDidResolveRegistration: {
      DCHECK(message->is_serialized());
      internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data* params =
          reinterpret_cast<internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OneShotBackgroundSyncService.1
      bool success = true;
      BackgroundSyncRegistrationInfoPtr p_registration_info{};
      OneShotBackgroundSyncService_DidResolveRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistrationInfo(&p_registration_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OneShotBackgroundSyncService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidResolveRegistration(        
        std::move(p_registration_info));
      return true;
    }
    case messages::OneShotBackgroundSyncService::kGetRegistrations: {
      break;
    }
  }
  return false;
}

// static
bool OneShotBackgroundSyncServiceStubDispatch::AcceptWithResponder(
    OneShotBackgroundSyncService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OneShotBackgroundSyncService>(message->header()->name)) {
    case messages::OneShotBackgroundSyncService::kRegister: {
      internal::OneShotBackgroundSyncService_Register_Params_Data* params =
          reinterpret_cast<
              internal::OneShotBackgroundSyncService_Register_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OneShotBackgroundSyncService.0
      bool success = true;
      SyncRegistrationOptionsPtr p_options{};
      int64_t p_service_worker_registration_id{};
      OneShotBackgroundSyncService_Register_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OneShotBackgroundSyncService::Name_, 0, false);
        return false;
      }
      auto callback =
          OneShotBackgroundSyncService_Register_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(        
        std::move(p_options), 
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
    case messages::OneShotBackgroundSyncService::kDidResolveRegistration: {
      break;
    }
    case messages::OneShotBackgroundSyncService::kGetRegistrations: {
      internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OneShotBackgroundSyncService.2
      bool success = true;
      int64_t p_service_worker_registration_id{};
      OneShotBackgroundSyncService_GetRegistrations_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OneShotBackgroundSyncService::Name_, 2, false);
        return false;
      }
      auto callback =
          OneShotBackgroundSyncService_GetRegistrations_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(        
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOneShotBackgroundSyncServiceValidationInfo[] = {
    { &internal::OneShotBackgroundSyncService_Register_Params_Data::Validate,
     &internal::OneShotBackgroundSyncService_Register_ResponseParams_Data::Validate},
    { &internal::OneShotBackgroundSyncService_DidResolveRegistration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OneShotBackgroundSyncService_GetRegistrations_Params_Data::Validate,
     &internal::OneShotBackgroundSyncService_GetRegistrations_ResponseParams_Data::Validate},
};

bool OneShotBackgroundSyncServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::OneShotBackgroundSyncService::Name_,
    kOneShotBackgroundSyncServiceValidationInfo);
}

bool OneShotBackgroundSyncServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::OneShotBackgroundSyncService::Name_,
    kOneShotBackgroundSyncServiceValidationInfo);
}
// The declaration includes the definition on other builds.

PeriodicBackgroundSyncService::IPCStableHashFunction PeriodicBackgroundSyncService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PeriodicBackgroundSyncService>(message.name())) {
    case messages::PeriodicBackgroundSyncService::kRegister: {
      return &PeriodicBackgroundSyncService::Register_Sym::IPCStableHash;
    }
    case messages::PeriodicBackgroundSyncService::kUnregister: {
      return &PeriodicBackgroundSyncService::Unregister_Sym::IPCStableHash;
    }
    case messages::PeriodicBackgroundSyncService::kGetRegistrations: {
      return &PeriodicBackgroundSyncService::GetRegistrations_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PeriodicBackgroundSyncService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PeriodicBackgroundSyncService>(message.name())) {
      case messages::PeriodicBackgroundSyncService::kRegister:
            return "Receive blink::mojom::PeriodicBackgroundSyncService::Register";
      case messages::PeriodicBackgroundSyncService::kUnregister:
            return "Receive blink::mojom::PeriodicBackgroundSyncService::Unregister";
      case messages::PeriodicBackgroundSyncService::kGetRegistrations:
            return "Receive blink::mojom::PeriodicBackgroundSyncService::GetRegistrations";
    }
  } else {
    switch (static_cast<messages::PeriodicBackgroundSyncService>(message.name())) {
      case messages::PeriodicBackgroundSyncService::kRegister:
            return "Receive reply blink::mojom::PeriodicBackgroundSyncService::Register";
      case messages::PeriodicBackgroundSyncService::kUnregister:
            return "Receive reply blink::mojom::PeriodicBackgroundSyncService::Unregister";
      case messages::PeriodicBackgroundSyncService::kGetRegistrations:
            return "Receive reply blink::mojom::PeriodicBackgroundSyncService::GetRegistrations";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PeriodicBackgroundSyncService::Register_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2f6fd068;  // IPCStableHash for blink::mojom::PeriodicBackgroundSyncService::Register
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeriodicBackgroundSyncService::Unregister_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba2ef997;  // IPCStableHash for blink::mojom::PeriodicBackgroundSyncService::Unregister
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeriodicBackgroundSyncService::GetRegistrations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x63495e00;  // IPCStableHash for blink::mojom::PeriodicBackgroundSyncService::GetRegistrations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PeriodicBackgroundSyncService_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PeriodicBackgroundSyncService_Register_ForwardToCallback(
      PeriodicBackgroundSyncService::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  PeriodicBackgroundSyncService_Register_ForwardToCallback(const PeriodicBackgroundSyncService_Register_ForwardToCallback&) = delete;
  PeriodicBackgroundSyncService_Register_ForwardToCallback& operator=(const PeriodicBackgroundSyncService_Register_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PeriodicBackgroundSyncService::RegisterCallback callback_;
};

class PeriodicBackgroundSyncService_Unregister_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PeriodicBackgroundSyncService_Unregister_ForwardToCallback(
      PeriodicBackgroundSyncService::UnregisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  PeriodicBackgroundSyncService_Unregister_ForwardToCallback(const PeriodicBackgroundSyncService_Unregister_ForwardToCallback&) = delete;
  PeriodicBackgroundSyncService_Unregister_ForwardToCallback& operator=(const PeriodicBackgroundSyncService_Unregister_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PeriodicBackgroundSyncService::UnregisterCallback callback_;
};

class PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback(
      PeriodicBackgroundSyncService::GetRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback(const PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback&) = delete;
  PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback& operator=(const PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PeriodicBackgroundSyncService::GetRegistrationsCallback callback_;
};

PeriodicBackgroundSyncServiceProxy::PeriodicBackgroundSyncServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PeriodicBackgroundSyncServiceProxy::Register(
    SyncRegistrationOptionsPtr in_options, int64_t in_service_worker_registration_id, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeriodicBackgroundSyncService::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SyncRegistrationOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeriodicBackgroundSyncService::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in PeriodicBackgroundSyncService.Register request");

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PeriodicBackgroundSyncService_Register_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PeriodicBackgroundSyncServiceProxy::Unregister(
    int64_t in_service_worker_registration_id, const std::string& in_tag, UnregisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeriodicBackgroundSyncService::Unregister", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tag"), in_tag,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeriodicBackgroundSyncService::kUnregister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Unregister_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->tag)::BaseType> tag_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tag,
    tag_fragment);

  params->tag.Set(
      tag_fragment.is_null() ? nullptr : tag_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tag.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tag in PeriodicBackgroundSyncService.Unregister request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Unregister");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PeriodicBackgroundSyncService_Unregister_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PeriodicBackgroundSyncServiceProxy::GetRegistrations(
    int64_t in_service_worker_registration_id, GetRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeriodicBackgroundSyncService::GetRegistrations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeriodicBackgroundSyncService::kGetRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PeriodicBackgroundSyncService_Register_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PeriodicBackgroundSyncService::RegisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PeriodicBackgroundSyncService_Register_ProxyToResponder> proxy(
        new PeriodicBackgroundSyncService_Register_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PeriodicBackgroundSyncService_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PeriodicBackgroundSyncService_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PeriodicBackgroundSyncService_Register_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PeriodicBackgroundSyncService::RegisterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options);
};

bool PeriodicBackgroundSyncService_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PeriodicBackgroundSyncService.0
  bool success = true;
  BackgroundSyncError p_err{};
  SyncRegistrationOptionsPtr p_options{};
  PeriodicBackgroundSyncService_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadOptions(&p_options))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PeriodicBackgroundSyncService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_options));
  }
  return true;
}

void PeriodicBackgroundSyncService_Register_ProxyToResponder::Run(
    BackgroundSyncError in_err, SyncRegistrationOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PeriodicBackgroundSyncService::Register", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err,
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SyncRegistrationOptionsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeriodicBackgroundSyncService::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
    in_err,
    &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SyncRegistrationOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PeriodicBackgroundSyncService_Unregister_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PeriodicBackgroundSyncService::UnregisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PeriodicBackgroundSyncService_Unregister_ProxyToResponder> proxy(
        new PeriodicBackgroundSyncService_Unregister_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PeriodicBackgroundSyncService_Unregister_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PeriodicBackgroundSyncService_Unregister_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PeriodicBackgroundSyncService_Unregister_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PeriodicBackgroundSyncService::UnregisterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err);
};

bool PeriodicBackgroundSyncService_Unregister_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PeriodicBackgroundSyncService.1
  bool success = true;
  BackgroundSyncError p_err{};
  PeriodicBackgroundSyncService_Unregister_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PeriodicBackgroundSyncService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_err));
  }
  return true;
}

void PeriodicBackgroundSyncService_Unregister_ProxyToResponder::Run(
    BackgroundSyncError in_err) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PeriodicBackgroundSyncService::Unregister", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err,
                        "<value of type BackgroundSyncError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeriodicBackgroundSyncService::kUnregister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
    in_err,
    &params->err);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("Unregister");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PeriodicBackgroundSyncService::GetRegistrationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder> proxy(
        new PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PeriodicBackgroundSyncService::GetRegistrationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BackgroundSyncError in_err, std::vector<SyncRegistrationOptionsPtr> in_registrations);
};

bool PeriodicBackgroundSyncService_GetRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PeriodicBackgroundSyncService.2
  bool success = true;
  BackgroundSyncError p_err{};
  std::vector<SyncRegistrationOptionsPtr> p_registrations{};
  PeriodicBackgroundSyncService_GetRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErr(&p_err))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PeriodicBackgroundSyncService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_err), 
std::move(p_registrations));
  }
  return true;
}

void PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder::Run(
    BackgroundSyncError in_err, std::vector<SyncRegistrationOptionsPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PeriodicBackgroundSyncService::GetRegistrations", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("err"), in_err,
                        "<value of type BackgroundSyncError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations,
                        "<value of type std::vector<SyncRegistrationOptionsPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeriodicBackgroundSyncService::kGetRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BackgroundSyncError>(
    in_err,
    &params->err);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& registrations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SyncRegistrationOptionsDataView>>(
    in_registrations,
    registrations_fragment,
    &registrations_validate_params);

  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registrations.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registrations in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeriodicBackgroundSyncService::Name_);
  message.set_method_name("GetRegistrations");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PeriodicBackgroundSyncServiceStubDispatch::Accept(
    PeriodicBackgroundSyncService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PeriodicBackgroundSyncService>(message->header()->name)) {
    case messages::PeriodicBackgroundSyncService::kRegister: {
      break;
    }
    case messages::PeriodicBackgroundSyncService::kUnregister: {
      break;
    }
    case messages::PeriodicBackgroundSyncService::kGetRegistrations: {
      break;
    }
  }
  return false;
}

// static
bool PeriodicBackgroundSyncServiceStubDispatch::AcceptWithResponder(
    PeriodicBackgroundSyncService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PeriodicBackgroundSyncService>(message->header()->name)) {
    case messages::PeriodicBackgroundSyncService::kRegister: {
      internal::PeriodicBackgroundSyncService_Register_Params_Data* params =
          reinterpret_cast<
              internal::PeriodicBackgroundSyncService_Register_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PeriodicBackgroundSyncService.0
      bool success = true;
      SyncRegistrationOptionsPtr p_options{};
      int64_t p_service_worker_registration_id{};
      PeriodicBackgroundSyncService_Register_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeriodicBackgroundSyncService::Name_, 0, false);
        return false;
      }
      auto callback =
          PeriodicBackgroundSyncService_Register_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(        
        std::move(p_options), 
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
    case messages::PeriodicBackgroundSyncService::kUnregister: {
      internal::PeriodicBackgroundSyncService_Unregister_Params_Data* params =
          reinterpret_cast<
              internal::PeriodicBackgroundSyncService_Unregister_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PeriodicBackgroundSyncService.1
      bool success = true;
      int64_t p_service_worker_registration_id{};
      std::string p_tag{};
      PeriodicBackgroundSyncService_Unregister_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadTag(&p_tag))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeriodicBackgroundSyncService::Name_, 1, false);
        return false;
      }
      auto callback =
          PeriodicBackgroundSyncService_Unregister_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unregister(        
        std::move(p_service_worker_registration_id), 
        std::move(p_tag), std::move(callback));
      return true;
    }
    case messages::PeriodicBackgroundSyncService::kGetRegistrations: {
      internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PeriodicBackgroundSyncService.2
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PeriodicBackgroundSyncService_GetRegistrations_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeriodicBackgroundSyncService::Name_, 2, false);
        return false;
      }
      auto callback =
          PeriodicBackgroundSyncService_GetRegistrations_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrations(        
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPeriodicBackgroundSyncServiceValidationInfo[] = {
    { &internal::PeriodicBackgroundSyncService_Register_Params_Data::Validate,
     &internal::PeriodicBackgroundSyncService_Register_ResponseParams_Data::Validate},
    { &internal::PeriodicBackgroundSyncService_Unregister_Params_Data::Validate,
     &internal::PeriodicBackgroundSyncService_Unregister_ResponseParams_Data::Validate},
    { &internal::PeriodicBackgroundSyncService_GetRegistrations_Params_Data::Validate,
     &internal::PeriodicBackgroundSyncService_GetRegistrations_ResponseParams_Data::Validate},
};

bool PeriodicBackgroundSyncServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PeriodicBackgroundSyncService::Name_,
    kPeriodicBackgroundSyncServiceValidationInfo);
}

bool PeriodicBackgroundSyncServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::PeriodicBackgroundSyncService::Name_,
    kPeriodicBackgroundSyncServiceValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::SyncRegistrationOptions::DataView, ::blink::mojom::SyncRegistrationOptionsPtr>::Read(
    ::blink::mojom::SyncRegistrationOptions::DataView input,
    ::blink::mojom::SyncRegistrationOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::SyncRegistrationOptionsPtr result(::blink::mojom::SyncRegistrationOptions::New());
  
      if (success && !input.ReadTag(&result->tag))
        success = false;
      if (success)
        result->min_interval = input.min_interval();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::BackgroundSyncRegistrationInfo::DataView, ::blink::mojom::BackgroundSyncRegistrationInfoPtr>::Read(
    ::blink::mojom::BackgroundSyncRegistrationInfo::DataView input,
    ::blink::mojom::BackgroundSyncRegistrationInfoPtr* output) {
  bool success = true;
  ::blink::mojom::BackgroundSyncRegistrationInfoPtr result(::blink::mojom::BackgroundSyncRegistrationInfo::New());
  
      if (success)
        result->service_worker_registration_id = input.service_worker_registration_id();
      if (success && !input.ReadTag(&result->tag))
        success = false;
      if (success && !input.ReadSyncType(&result->sync_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void OneShotBackgroundSyncServiceInterceptorForTesting::Register(SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, RegisterCallback callback) {
  GetForwardingInterface()->Register(
    std::move(options)
    , 
    std::move(service_worker_registration_id)
    , std::move(callback));
}
void OneShotBackgroundSyncServiceInterceptorForTesting::DidResolveRegistration(BackgroundSyncRegistrationInfoPtr registration_info) {
  GetForwardingInterface()->DidResolveRegistration(
    std::move(registration_info)
    );
}
void OneShotBackgroundSyncServiceInterceptorForTesting::GetRegistrations(int64_t service_worker_registration_id, GetRegistrationsCallback callback) {
  GetForwardingInterface()->GetRegistrations(
    std::move(service_worker_registration_id)
    , std::move(callback));
}
OneShotBackgroundSyncServiceAsyncWaiter::OneShotBackgroundSyncServiceAsyncWaiter(
    OneShotBackgroundSyncService* proxy) : proxy_(proxy) {}

OneShotBackgroundSyncServiceAsyncWaiter::~OneShotBackgroundSyncServiceAsyncWaiter() = default;


void OneShotBackgroundSyncServiceAsyncWaiter::Register(
    SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, BackgroundSyncError* out_err, SyncRegistrationOptionsPtr* out_options) {
  base::RunLoop loop;
  proxy_->Register(
      std::move(options),
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             BackgroundSyncError* out_err
,
             SyncRegistrationOptionsPtr* out_options
,
             BackgroundSyncError err,
             SyncRegistrationOptionsPtr options) {*out_err = std::move(err);*out_options = std::move(options);
            loop->Quit();
          },
          &loop,
          out_err,
          out_options));
  loop.Run();
}



void OneShotBackgroundSyncServiceAsyncWaiter::GetRegistrations(
    int64_t service_worker_registration_id, BackgroundSyncError* out_err, std::vector<SyncRegistrationOptionsPtr>* out_registrations) {
  base::RunLoop loop;
  proxy_->GetRegistrations(
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             BackgroundSyncError* out_err
,
             std::vector<SyncRegistrationOptionsPtr>* out_registrations
,
             BackgroundSyncError err,
             std::vector<SyncRegistrationOptionsPtr> registrations) {*out_err = std::move(err);*out_registrations = std::move(registrations);
            loop->Quit();
          },
          &loop,
          out_err,
          out_registrations));
  loop.Run();
}






void PeriodicBackgroundSyncServiceInterceptorForTesting::Register(SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, RegisterCallback callback) {
  GetForwardingInterface()->Register(
    std::move(options)
    , 
    std::move(service_worker_registration_id)
    , std::move(callback));
}
void PeriodicBackgroundSyncServiceInterceptorForTesting::Unregister(int64_t service_worker_registration_id, const std::string& tag, UnregisterCallback callback) {
  GetForwardingInterface()->Unregister(
    std::move(service_worker_registration_id)
    , 
    std::move(tag)
    , std::move(callback));
}
void PeriodicBackgroundSyncServiceInterceptorForTesting::GetRegistrations(int64_t service_worker_registration_id, GetRegistrationsCallback callback) {
  GetForwardingInterface()->GetRegistrations(
    std::move(service_worker_registration_id)
    , std::move(callback));
}
PeriodicBackgroundSyncServiceAsyncWaiter::PeriodicBackgroundSyncServiceAsyncWaiter(
    PeriodicBackgroundSyncService* proxy) : proxy_(proxy) {}

PeriodicBackgroundSyncServiceAsyncWaiter::~PeriodicBackgroundSyncServiceAsyncWaiter() = default;


void PeriodicBackgroundSyncServiceAsyncWaiter::Register(
    SyncRegistrationOptionsPtr options, int64_t service_worker_registration_id, BackgroundSyncError* out_err, SyncRegistrationOptionsPtr* out_options) {
  base::RunLoop loop;
  proxy_->Register(
      std::move(options),
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             BackgroundSyncError* out_err
,
             SyncRegistrationOptionsPtr* out_options
,
             BackgroundSyncError err,
             SyncRegistrationOptionsPtr options) {*out_err = std::move(err);*out_options = std::move(options);
            loop->Quit();
          },
          &loop,
          out_err,
          out_options));
  loop.Run();
}



void PeriodicBackgroundSyncServiceAsyncWaiter::Unregister(
    int64_t service_worker_registration_id, const std::string& tag, BackgroundSyncError* out_err) {
  base::RunLoop loop;
  proxy_->Unregister(
      std::move(service_worker_registration_id),
      std::move(tag),
      base::BindOnce(
          [](base::RunLoop* loop,
             BackgroundSyncError* out_err
,
             BackgroundSyncError err) {*out_err = std::move(err);
            loop->Quit();
          },
          &loop,
          out_err));
  loop.Run();
}

BackgroundSyncError PeriodicBackgroundSyncServiceAsyncWaiter::Unregister(
    int64_t service_worker_registration_id, const std::string& tag) {
  BackgroundSyncError async_wait_result;
  Unregister(std::move(service_worker_registration_id),std::move(tag),&async_wait_result);
  return async_wait_result;
}

void PeriodicBackgroundSyncServiceAsyncWaiter::GetRegistrations(
    int64_t service_worker_registration_id, BackgroundSyncError* out_err, std::vector<SyncRegistrationOptionsPtr>* out_registrations) {
  base::RunLoop loop;
  proxy_->GetRegistrations(
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             BackgroundSyncError* out_err
,
             std::vector<SyncRegistrationOptionsPtr>* out_registrations
,
             BackgroundSyncError err,
             std::vector<SyncRegistrationOptionsPtr> registrations) {*out_err = std::move(err);*out_registrations = std::move(registrations);
            loop->Quit();
          },
          &loop,
          out_err,
          out_registrations));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif