// third_party/blink/public/mojom/autoplay/autoplay.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('url.mojom.Origin');



goog.provide('blink.mojom.AUTOPLAY_FLAG_NONE');
/**
 * @const { !number }
 * @export
 */
blink.mojom.AUTOPLAY_FLAG_NONE = 0x00000;
goog.provide('blink.mojom.AUTOPLAY_FLAG_HIGH_MEDIA_ENGAGEMENT');
/**
 * @const { !number }
 * @export
 */
blink.mojom.AUTOPLAY_FLAG_HIGH_MEDIA_ENGAGEMENT = 0x00001;
goog.provide('blink.mojom.AUTOPLAY_FLAG_FORCE_ALLOW');
/**
 * @const { !number }
 * @export
 */
blink.mojom.AUTOPLAY_FLAG_FORCE_ALLOW = 0x00002;
goog.provide('blink.mojom.AUTOPLAY_FLAG_USER_EXCEPTION');
/**
 * @const { !number }
 * @export
 */
blink.mojom.AUTOPLAY_FLAG_USER_EXCEPTION = 0x00004;



goog.provide('blink.mojom.AutoplayConfigurationClient');
goog.provide('blink.mojom.AutoplayConfigurationClientReceiver');
goog.provide('blink.mojom.AutoplayConfigurationClientCallbackRouter');
goog.provide('blink.mojom.AutoplayConfigurationClientInterface');
goog.provide('blink.mojom.AutoplayConfigurationClientRemote');
goog.provide('blink.mojom.AutoplayConfigurationClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AutoplayConfigurationClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AutoplayConfigurationClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AutoplayConfigurationClientInterface = class {
  
  /**
   * @param { !url.mojom.Origin } origin
   * @param { !number } flags
   */

  addAutoplayFlags(origin, flags) {}
};

/**
 * @export
 * @implements { blink.mojom.AutoplayConfigurationClientInterface }
 */
blink.mojom.AutoplayConfigurationClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AutoplayConfigurationClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AutoplayConfigurationClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AutoplayConfigurationClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Origin } origin
   * @param { !number } flags
   */

  addAutoplayFlags(
      origin,
      flags) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
        null,
        [
          origin,
          flags
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AutoplayConfigurationClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AutoplayConfigurationClientReceiver = class {
  /**
   * @param {!blink.mojom.AutoplayConfigurationClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AutoplayConfigurationClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AutoplayConfigurationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AutoplayConfigurationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
        null,
        impl.addAutoplayFlags.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AutoplayConfigurationClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AutoplayConfigurationClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AutoplayConfigurationClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AutoplayConfigurationClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AutoplayConfigurationClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AutoplayConfigurationClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AutoplayConfigurationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AutoplayConfigurationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAutoplayFlags =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
        null,
        this.addAutoplayFlags.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
    'AutoplayConfigurationClient_AddAutoplayFlags_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'flags', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_Params');

/** @record */
blink.mojom.AutoplayConfigurationClient_AddAutoplayFlags_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !number } */
    this.flags;
  }
};

