// third_party/blink/public/mojom/ai/ai_writer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/ai/ai_writer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_writer.mojom-params-data.h"
#include "third_party/blink/public/mojom/ai/ai_writer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/ai/ai_writer.mojom-import-headers.h"
#include "third_party/blink/public/mojom/ai/ai_writer.mojom-test-utils.h"


namespace blink::mojom {
AIWriterCreateOptions::AIWriterCreateOptions()
    : shared_context(),
      tone(),
      format(),
      length(),
      expected_input_languages(),
      expected_context_languages(),
      output_language() {}

AIWriterCreateOptions::AIWriterCreateOptions(
    const std::optional<std::string>& shared_context_in,
    AIWriterTone tone_in,
    AIWriterFormat format_in,
    AIWriterLength length_in,
    std::vector<::blink::mojom::AILanguageCodePtr> expected_input_languages_in,
    std::vector<::blink::mojom::AILanguageCodePtr> expected_context_languages_in,
    ::blink::mojom::AILanguageCodePtr output_language_in)
    : shared_context(std::move(shared_context_in)),
      tone(std::move(tone_in)),
      format(std::move(format_in)),
      length(std::move(length_in)),
      expected_input_languages(std::move(expected_input_languages_in)),
      expected_context_languages(std::move(expected_context_languages_in)),
      output_language(std::move(output_language_in)) {}

AIWriterCreateOptions::~AIWriterCreateOptions() = default;

void AIWriterCreateOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_context"), this->shared_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tone"), this->tone,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIWriterTone>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIWriterFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIWriterLength>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_input_languages"), this->expected_input_languages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::blink::mojom::AILanguageCodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_context_languages"), this->expected_context_languages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::blink::mojom::AILanguageCodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_language"), this->output_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::AILanguageCodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIWriterCreateOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AIWriter::IPCStableHashFunction AIWriter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIWriter>(message.name())) {
    case messages::AIWriter::kWrite: {
      return &AIWriter::Write_Sym::IPCStableHash;
    }
    case messages::AIWriter::kMeasureUsage: {
      return &AIWriter::MeasureUsage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIWriter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIWriter>(message.name())) {
      case messages::AIWriter::kWrite:
            return "Receive blink::mojom::AIWriter::Write";
      case messages::AIWriter::kMeasureUsage:
            return "Receive blink::mojom::AIWriter::MeasureUsage";
    }
  } else {
    switch (static_cast<messages::AIWriter>(message.name())) {
      case messages::AIWriter::kWrite:
            return "Receive reply blink::mojom::AIWriter::Write";
      case messages::AIWriter::kMeasureUsage:
            return "Receive reply blink::mojom::AIWriter::MeasureUsage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIWriter::Write_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e2a1a7b;  // IPCStableHash for blink::mojom::AIWriter::Write
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIWriter::MeasureUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08f54588;  // IPCStableHash for blink::mojom::AIWriter::MeasureUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AIWriter_MeasureUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIWriter_MeasureUsage_ForwardToCallback(
      AIWriter::MeasureUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIWriter_MeasureUsage_ForwardToCallback(const AIWriter_MeasureUsage_ForwardToCallback&) = delete;
  AIWriter_MeasureUsage_ForwardToCallback& operator=(const AIWriter_MeasureUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIWriter::MeasureUsageCallback callback_;
};

AIWriterProxy::AIWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIWriterProxy::Write(
    const std::string& in_input, const std::optional<std::string>& in_context, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> in_pending_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIWriter::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_responder"), in_pending_responder,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIWriter::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIWriter_Write_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in AIWriter.Write request");
  mojo::internal::MessageFragment<
      typename decltype(params->context)::BaseType> context_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_context,
    context_fragment);

  params->context.Set(
      context_fragment.is_null() ? nullptr : context_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelStreamingResponderInterfaceBase>>(
    in_pending_responder,
    &params->pending_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pending_responder in AIWriter.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIWriter::Name_);
  message.set_method_name("Write");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIWriterProxy::MeasureUsage(
    const std::string& in_input, const std::string& in_context, MeasureUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIWriter::MeasureUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIWriter::kMeasureUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIWriter_MeasureUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in AIWriter.MeasureUsage request");
  mojo::internal::MessageFragment<
      typename decltype(params->context)::BaseType> context_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_context,
    context_fragment);

  params->context.Set(
      context_fragment.is_null() ? nullptr : context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context in AIWriter.MeasureUsage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIWriter::Name_);
  message.set_method_name("MeasureUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIWriter_MeasureUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AIWriter_MeasureUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIWriter::MeasureUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIWriter_MeasureUsage_ProxyToResponder> proxy(
        new AIWriter_MeasureUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIWriter_MeasureUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIWriter_MeasureUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIWriter_MeasureUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIWriter::MeasureUsageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<uint32_t> in_number_of_tokens);
};

bool AIWriter_MeasureUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIWriter_MeasureUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIWriter_MeasureUsage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIWriter.1
  bool success = true;
  std::optional<uint32_t> p_number_of_tokens{};
  AIWriter_MeasureUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_number_of_tokens = input_data_view.number_of_tokens();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIWriter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_number_of_tokens));
  }
  return true;
}

void AIWriter_MeasureUsage_ProxyToResponder::Run(
    std::optional<uint32_t> in_number_of_tokens) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIWriter::MeasureUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("number_of_tokens"), in_number_of_tokens,
                        "<value of type std::optional<uint32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIWriter::kMeasureUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIWriter_MeasureUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->number_of_tokens_$flag = in_number_of_tokens.has_value();
  if (in_number_of_tokens.has_value()) {
    params->number_of_tokens_$value = in_number_of_tokens.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIWriter::Name_);
  message.set_method_name("MeasureUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AIWriterStubDispatch::Accept(
    AIWriter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIWriter>(message->header()->name)) {
    case messages::AIWriter::kWrite: {
      DCHECK(message->is_serialized());
      internal::AIWriter_Write_Params_Data* params =
          reinterpret_cast<internal::AIWriter_Write_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIWriter.0
      bool success = true;
      std::string p_input{};
      std::optional<std::string> p_context{};
      ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> p_pending_responder{};
      AIWriter_Write_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success && !input_data_view.ReadContext(&p_context))
        success = false;
      if (success) {
        p_pending_responder =
            input_data_view.TakePendingResponder<decltype(p_pending_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIWriter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(        
        std::move(p_input), 
        std::move(p_context), 
        std::move(p_pending_responder));
      return true;
    }
    case messages::AIWriter::kMeasureUsage: {
      break;
    }
  }
  return false;
}

// static
bool AIWriterStubDispatch::AcceptWithResponder(
    AIWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIWriter>(message->header()->name)) {
    case messages::AIWriter::kWrite: {
      break;
    }
    case messages::AIWriter::kMeasureUsage: {
      internal::AIWriter_MeasureUsage_Params_Data* params =
          reinterpret_cast<
              internal::AIWriter_MeasureUsage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIWriter.1
      bool success = true;
      std::string p_input{};
      std::string p_context{};
      AIWriter_MeasureUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success && !input_data_view.ReadContext(&p_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIWriter::Name_, 1, false);
        return false;
      }
      auto callback =
          AIWriter_MeasureUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MeasureUsage(        
        std::move(p_input), 
        std::move(p_context), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIWriterValidationInfo[] = {
    { &internal::AIWriter_Write_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIWriter_MeasureUsage_Params_Data::Validate,
     &internal::AIWriter_MeasureUsage_ResponseParams_Data::Validate},
};

bool AIWriterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AIWriter::Name_,
    kAIWriterValidationInfo);
}

bool AIWriterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::AIWriter::Name_,
    kAIWriterValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::AIWriterCreateOptions::DataView, ::blink::mojom::AIWriterCreateOptionsPtr>::Read(
    ::blink::mojom::AIWriterCreateOptions::DataView input,
    ::blink::mojom::AIWriterCreateOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::AIWriterCreateOptionsPtr result(::blink::mojom::AIWriterCreateOptions::New());
  
      if (success && !input.ReadSharedContext(&result->shared_context))
        success = false;
      if (success && !input.ReadTone(&result->tone))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadLength(&result->length))
        success = false;
      if (success && !input.ReadExpectedInputLanguages(&result->expected_input_languages))
        success = false;
      if (success && !input.ReadExpectedContextLanguages(&result->expected_context_languages))
        success = false;
      if (success && !input.ReadOutputLanguage(&result->output_language))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void AIWriterInterceptorForTesting::Write(const std::string& input, const std::optional<std::string>& context, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) {
  GetForwardingInterface()->Write(
    std::move(input)
    , 
    std::move(context)
    , 
    std::move(pending_responder)
    );
}
void AIWriterInterceptorForTesting::MeasureUsage(const std::string& input, const std::string& context, MeasureUsageCallback callback) {
  GetForwardingInterface()->MeasureUsage(
    std::move(input)
    , 
    std::move(context)
    , std::move(callback));
}
AIWriterAsyncWaiter::AIWriterAsyncWaiter(
    AIWriter* proxy) : proxy_(proxy) {}

AIWriterAsyncWaiter::~AIWriterAsyncWaiter() = default;


void AIWriterAsyncWaiter::MeasureUsage(
    const std::string& input, const std::string& context, std::optional<uint32_t>* out_number_of_tokens) {
  base::RunLoop loop;
  proxy_->MeasureUsage(
      std::move(input),
      std::move(context),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<uint32_t>* out_number_of_tokens
,
             std::optional<uint32_t> number_of_tokens) {*out_number_of_tokens = std::move(number_of_tokens);
            loop->Quit();
          },
          &loop,
          out_number_of_tokens));
  loop.Run();
}

std::optional<uint32_t> AIWriterAsyncWaiter::MeasureUsage(
    const std::string& input, const std::string& context) {
  std::optional<uint32_t> async_wait_result;
  MeasureUsage(std::move(input),std::move(context),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif