// third_party/blink/public/mojom/ai/ai_summarizer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AILanguageCode as blink_mojom_AILanguageCode,
  AILanguageCodeSpec as blink_mojom_AILanguageCodeSpec
} from './ai_common.mojom.m.js';

import {
  ModelStreamingResponderRemote as blink_mojom_ModelStreamingResponderRemote,
  ModelStreamingResponderPendingReceiver as blink_mojom_ModelStreamingResponderPendingReceiver
} from './model_streaming_responder.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AISummarizerTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AISummarizerType = {
  
  kTLDR: 0,
  kKeyPoints: 1,
  kTeaser: 2,
  kHeadline: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AISummarizerFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AISummarizerFormat = {
  
  kPlainText: 0,
  kMarkDown: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AISummarizerLengthSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AISummarizerLength = {
  
  kShort: 0,
  kMedium: 1,
  kLong: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AISummarizerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AISummarizer', scope);
  }
}

/** @interface */
export class AISummarizerInterface {
  
  /**
   * @param { !string } input
   * @param { !string } context
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  summarize(input, context, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(input, context) {}
}

/**
 * @implements { AISummarizerInterface }
 */
export class AISummarizerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AISummarizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AISummarizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AISummarizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { !string } context
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  summarize(
      input,
      context,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        AISummarizer_Summarize_ParamsSpec.$,
        null,
        [
          input,
          context,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(
      input,
      context) {
    return this.proxy.sendMessage(
        1,
        AISummarizer_MeasureUsage_ParamsSpec.$,
        AISummarizer_MeasureUsage_ResponseParamsSpec.$,
        [
          input,
          context
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AISummarizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AISummarizerReceiver {
  /**
   * @param {!AISummarizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AISummarizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AISummarizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AISummarizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AISummarizer_Summarize_ParamsSpec.$,
        null,
        impl.summarize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AISummarizer_MeasureUsage_ParamsSpec.$,
        AISummarizer_MeasureUsage_ResponseParamsSpec.$,
        impl.measureUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AISummarizer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AISummarizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AISummarizerRemote}
   */
  static getRemote() {
    let remote = new AISummarizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AISummarizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AISummarizerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AISummarizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AISummarizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.summarize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AISummarizer_Summarize_ParamsSpec.$,
        null,
        this.summarize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.measureUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AISummarizer_MeasureUsage_ParamsSpec.$,
        AISummarizer_MeasureUsage_ResponseParamsSpec.$,
        this.measureUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AISummarizerCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AISummarizer_Summarize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AISummarizer_MeasureUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AISummarizer_MeasureUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AISummarizerCreateOptionsSpec.$,
    'AISummarizerCreateOptions',
    [
      mojo.internal.StructField(
        'sharedContext', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        AISummarizerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'format', 12,
        0,
        AISummarizerFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 16,
        0,
        AISummarizerLengthSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedInputLanguages', 24,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedContextLanguages', 32,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputLanguage', 40,
        0,
        blink_mojom_AILanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AISummarizerCreateOptions {
  constructor() {
    /** @type { (string|undefined) } */
    this.sharedContext;
    /** @type { !AISummarizerType } */
    this.type;
    /** @type { !AISummarizerFormat } */
    this.format;
    /** @type { !AISummarizerLength } */
    this.length;
    /** @type { !Array<!blink_mojom_AILanguageCode> } */
    this.expectedInputLanguages;
    /** @type { !Array<!blink_mojom_AILanguageCode> } */
    this.expectedContextLanguages;
    /** @type { !blink_mojom_AILanguageCode } */
    this.outputLanguage;
  }
}



mojo.internal.Struct(
    AISummarizer_Summarize_ParamsSpec.$,
    'AISummarizer_Summarize_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 16,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AISummarizer_Summarize_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !string } */
    this.context;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}



mojo.internal.Struct(
    AISummarizer_MeasureUsage_ParamsSpec.$,
    'AISummarizer_MeasureUsage_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AISummarizer_MeasureUsage_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !string } */
    this.context;
  }
}



mojo.internal.Struct(
    AISummarizer_MeasureUsage_ResponseParamsSpec.$,
    'AISummarizer_MeasureUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'number_of_tokens_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "number_of_tokens_$value",
          originalFieldName: "numberOfTokens",
        }
      ),
      mojo.internal.StructField(
        'number_of_tokens_$value', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numberOfTokens",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AISummarizer_MeasureUsage_ResponseParams {
  constructor() {
    /** @type { (number|undefined) } */
    this.numberOfTokens;
  }
}

