// third_party/blink/public/mojom/ai/ai_rewriter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_REWRITER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_REWRITER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ai/ai_rewriter.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_rewriter.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_rewriter.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_common.mojom.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class AIRewriterProxy;

template <typename ImplRefTraits>
class AIRewriterStub;

class AIRewriterRequestValidator;
class AIRewriterResponseValidator;


class BLINK_COMMON_EXPORT AIRewriter
    : public AIRewriterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AIRewriter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AIRewriterInterfaceBase;
  using Proxy_ = AIRewriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = AIRewriterStub<ImplRefTraits>;

  using RequestValidator_ = AIRewriterRequestValidator;
  using ResponseValidator_ = AIRewriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRewriteMinVersion = 0,
    kMeasureUsageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Rewrite_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MeasureUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AIRewriter() = default;

  virtual void Rewrite(const std::string& input, const std::optional<std::string>& context, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) = 0;

  using MeasureUsageCallback = base::OnceCallback<void(std::optional<uint32_t>)>;
  using MeasureUsageMojoCallback = base::OnceCallback<void(std::optional<uint32_t>)>;

  virtual void MeasureUsage(const std::string& input, const std::string& context, MeasureUsageCallback callback) = 0;
};



class BLINK_COMMON_EXPORT AIRewriterProxy
    : public AIRewriter {
 public:
  using InterfaceType = AIRewriter;

  explicit AIRewriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Rewrite(const std::string& input, const std::optional<std::string>& context, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) final;
  
  void MeasureUsage(const std::string& input, const std::string& context, MeasureUsageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT AIRewriterStubDispatch {
 public:
  static bool Accept(AIRewriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AIRewriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AIRewriter>>
class AIRewriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AIRewriterStub() = default;
  ~AIRewriterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIRewriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIRewriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT AIRewriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT AIRewriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT AIRewriterCreateOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIRewriterCreateOptions, T>::value>;
  using DataView = AIRewriterCreateOptionsDataView;
  using Data_ = internal::AIRewriterCreateOptions_Data;

  template <typename... Args>
  static AIRewriterCreateOptionsPtr New(Args&&... args) {
    return AIRewriterCreateOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIRewriterCreateOptionsPtr From(const U& u) {
    return mojo::TypeConverter<AIRewriterCreateOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIRewriterCreateOptions>::Convert(*this);
  }


  AIRewriterCreateOptions();

  AIRewriterCreateOptions(
      const std::optional<std::string>& shared_context,
      AIRewriterTone tone,
      AIRewriterFormat format,
      AIRewriterLength length,
      std::vector<::blink::mojom::AILanguageCodePtr> expected_input_languages,
      std::vector<::blink::mojom::AILanguageCodePtr> expected_context_languages,
      ::blink::mojom::AILanguageCodePtr output_language);

AIRewriterCreateOptions(const AIRewriterCreateOptions&) = delete;
AIRewriterCreateOptions& operator=(const AIRewriterCreateOptions&) = delete;

  ~AIRewriterCreateOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIRewriterCreateOptionsPtr>
  AIRewriterCreateOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIRewriterCreateOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIRewriterCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIRewriterCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIRewriterCreateOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIRewriterCreateOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIRewriterCreateOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIRewriterCreateOptions_UnserializedMessageContext<
            UserType, AIRewriterCreateOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIRewriterCreateOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIRewriterCreateOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIRewriterCreateOptions_UnserializedMessageContext<
            UserType, AIRewriterCreateOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIRewriterCreateOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> shared_context;
  
  AIRewriterTone tone;
  
  AIRewriterFormat format;
  
  AIRewriterLength length;
  
  std::vector<::blink::mojom::AILanguageCodePtr> expected_input_languages;
  
  std::vector<::blink::mojom::AILanguageCodePtr> expected_context_languages;
  
  ::blink::mojom::AILanguageCodePtr output_language;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIRewriterCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIRewriterCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIRewriterCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIRewriterCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AIRewriterCreateOptionsPtr AIRewriterCreateOptions::Clone() const {
  return New(
      mojo::Clone(shared_context),
      mojo::Clone(tone),
      mojo::Clone(format),
      mojo::Clone(length),
      mojo::Clone(expected_input_languages),
      mojo::Clone(expected_context_languages),
      mojo::Clone(output_language)
  );
}

template <typename T, AIRewriterCreateOptions::EnableIfSame<T>*>
bool AIRewriterCreateOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_context, other_struct.shared_context))
    return false;
  if (!mojo::Equals(this->tone, other_struct.tone))
    return false;
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->expected_input_languages, other_struct.expected_input_languages))
    return false;
  if (!mojo::Equals(this->expected_context_languages, other_struct.expected_context_languages))
    return false;
  if (!mojo::Equals(this->output_language, other_struct.output_language))
    return false;
  return true;
}

template <typename T, AIRewriterCreateOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.shared_context < rhs.shared_context)
    return true;
  if (rhs.shared_context < lhs.shared_context)
    return false;
  if (lhs.tone < rhs.tone)
    return true;
  if (rhs.tone < lhs.tone)
    return false;
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.expected_input_languages < rhs.expected_input_languages)
    return true;
  if (rhs.expected_input_languages < lhs.expected_input_languages)
    return false;
  if (lhs.expected_context_languages < rhs.expected_context_languages)
    return true;
  if (rhs.expected_context_languages < lhs.expected_context_languages)
    return false;
  if (lhs.output_language < rhs.output_language)
    return true;
  if (rhs.output_language < lhs.output_language)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AIRewriterCreateOptions::DataView,
                                         ::blink::mojom::AIRewriterCreateOptionsPtr> {
  static bool IsNull(const ::blink::mojom::AIRewriterCreateOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AIRewriterCreateOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AIRewriterCreateOptions::shared_context)& shared_context(
      const ::blink::mojom::AIRewriterCreateOptionsPtr& input) {
    return input->shared_context;
  }

  static decltype(::blink::mojom::AIRewriterCreateOptions::tone) tone(
      const ::blink::mojom::AIRewriterCreateOptionsPtr& input) {
    return input->tone;
  }

  static decltype(::blink::mojom::AIRewriterCreateOptions::format) format(
      const ::blink::mojom::AIRewriterCreateOptionsPtr& input) {
    return input->format;
  }

  static decltype(::blink::mojom::AIRewriterCreateOptions::length) length(
      const ::blink::mojom::AIRewriterCreateOptionsPtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::AIRewriterCreateOptions::expected_input_languages)& expected_input_languages(
      const ::blink::mojom::AIRewriterCreateOptionsPtr& input) {
    return input->expected_input_languages;
  }

  static const decltype(::blink::mojom::AIRewriterCreateOptions::expected_context_languages)& expected_context_languages(
      const ::blink::mojom::AIRewriterCreateOptionsPtr& input) {
    return input->expected_context_languages;
  }

  static const decltype(::blink::mojom::AIRewriterCreateOptions::output_language)& output_language(
      const ::blink::mojom::AIRewriterCreateOptionsPtr& input) {
    return input->output_language;
  }

  static bool Read(::blink::mojom::AIRewriterCreateOptions::DataView input, ::blink::mojom::AIRewriterCreateOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_REWRITER_MOJOM_H_