// third_party/blink/public/mojom/ai/ai_proofreader.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/ai_proofreader.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ai_common$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_common.mojom', 'ai_common.mojom.js');
  }
  var model_streaming_responder$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_streaming_responder.mojom', 'model_streaming_responder.mojom.js');
  }



  function AIProofreaderCreateOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIProofreaderCreateOptions.prototype.initDefaults_ = function() {
    this.includeCorrectionTypes = false;
    this.includeCorrectionExplanations = false;
    this.correctionExplanationLanguage = null;
    this.expectedInputLanguages = null;
  };
  AIProofreaderCreateOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIProofreaderCreateOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AIProofreaderCreateOptions.correctionExplanationLanguage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_common$.AILanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIProofreaderCreateOptions.expectedInputLanguages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(ai_common$.AILanguageCode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIProofreaderCreateOptions.encodedSize = codec.kStructHeaderSize + 24;

  AIProofreaderCreateOptions.decode = function(decoder) {
    var packed;
    var val = new AIProofreaderCreateOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.includeCorrectionTypes = (packed >> 0) & 1 ? true : false;
    val.includeCorrectionExplanations = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.correctionExplanationLanguage =
        decoder.decodeStructPointer(ai_common$.AILanguageCode);
    val.expectedInputLanguages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    return val;
  };

  AIProofreaderCreateOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIProofreaderCreateOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.includeCorrectionTypes & 1) << 0
    packed |= (val.includeCorrectionExplanations & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ai_common$.AILanguageCode, val.correctionExplanationLanguage);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.expectedInputLanguages);
  };
  function AIProofreader_Proofread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIProofreader_Proofread_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  AIProofreader_Proofread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIProofreader_Proofread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIProofreader_Proofread_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIProofreader_Proofread_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIProofreader_Proofread_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIProofreader_Proofread_Params.decode = function(decoder) {
    var packed;
    var val = new AIProofreader_Proofread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  AIProofreader_Proofread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIProofreader_Proofread_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  function AIProofreader_GetCorrectionType_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIProofreader_GetCorrectionType_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.correctedInput = null;
    this.correctionInstruction = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  AIProofreader_GetCorrectionType_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIProofreader_GetCorrectionType_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIProofreader_GetCorrectionType_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIProofreader_GetCorrectionType_Params.correctedInput
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIProofreader_GetCorrectionType_Params.correctionInstruction
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIProofreader_GetCorrectionType_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIProofreader_GetCorrectionType_Params.encodedSize = codec.kStructHeaderSize + 32;

  AIProofreader_GetCorrectionType_Params.decode = function(decoder) {
    var packed;
    var val = new AIProofreader_GetCorrectionType_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.correctedInput =
        decoder.decodeStruct(codec.String);
    val.correctionInstruction =
        decoder.decodeStruct(codec.String);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  AIProofreader_GetCorrectionType_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIProofreader_GetCorrectionType_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.correctedInput);
    encoder.encodeStruct(codec.String, val.correctionInstruction);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  var kAIProofreader_Proofread_Name = 0;
  var kAIProofreader_GetCorrectionType_Name = 1;

  function AIProofreaderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIProofreader,
                                                   handleOrPtrInfo);
  }

  function AIProofreaderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIProofreader, associatedInterfacePtrInfo);
  }

  AIProofreaderAssociatedPtr.prototype =
      Object.create(AIProofreaderPtr.prototype);
  AIProofreaderAssociatedPtr.prototype.constructor =
      AIProofreaderAssociatedPtr;

  function AIProofreaderProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIProofreaderPtr.prototype.proofread = function() {
    return AIProofreaderProxy.prototype.proofread
        .apply(this.ptr.getProxy(), arguments);
  };

  AIProofreaderProxy.prototype.proofread = function(input, pendingResponder) {
    var params_ = new AIProofreader_Proofread_Params();
    params_.input = input;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kAIProofreader_Proofread_Name,
        codec.align(AIProofreader_Proofread_Params.encodedSize));
    builder.encodeStruct(AIProofreader_Proofread_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIProofreaderPtr.prototype.getCorrectionType = function() {
    return AIProofreaderProxy.prototype.getCorrectionType
        .apply(this.ptr.getProxy(), arguments);
  };

  AIProofreaderProxy.prototype.getCorrectionType = function(input, correctedInput, correctionInstruction, pendingResponder) {
    var params_ = new AIProofreader_GetCorrectionType_Params();
    params_.input = input;
    params_.correctedInput = correctedInput;
    params_.correctionInstruction = correctionInstruction;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kAIProofreader_GetCorrectionType_Name,
        codec.align(AIProofreader_GetCorrectionType_Params.encodedSize));
    builder.encodeStruct(AIProofreader_GetCorrectionType_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AIProofreaderStub(delegate) {
    this.delegate_ = delegate;
  }
  AIProofreaderStub.prototype.proofread = function(input, pendingResponder) {
    return this.delegate_ && this.delegate_.proofread && this.delegate_.proofread(input, pendingResponder);
  }
  AIProofreaderStub.prototype.getCorrectionType = function(input, correctedInput, correctionInstruction, pendingResponder) {
    return this.delegate_ && this.delegate_.getCorrectionType && this.delegate_.getCorrectionType(input, correctedInput, correctionInstruction, pendingResponder);
  }

  AIProofreaderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIProofreader_Proofread_Name:
      var params = reader.decodeStruct(AIProofreader_Proofread_Params);
      this.proofread(params.input, params.pendingResponder);
      return true;
    case kAIProofreader_GetCorrectionType_Name:
      var params = reader.decodeStruct(AIProofreader_GetCorrectionType_Params);
      this.getCorrectionType(params.input, params.correctedInput, params.correctionInstruction, params.pendingResponder);
      return true;
    default:
      return false;
    }
  };

  AIProofreaderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAIProofreaderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIProofreader_Proofread_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIProofreader_Proofread_Params;
      break;
      case kAIProofreader_GetCorrectionType_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIProofreader_GetCorrectionType_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIProofreaderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AIProofreader = {
    name: 'blink.mojom.AIProofreader',
    kVersion: 0,
    ptrClass: AIProofreaderPtr,
    proxyClass: AIProofreaderProxy,
    stubClass: AIProofreaderStub,
    validateRequest: validateAIProofreaderRequest,
    validateResponse: null,
  };
  AIProofreaderStub.prototype.validator = validateAIProofreaderRequest;
  AIProofreaderProxy.prototype.validator = null;
  exports.AIProofreaderCreateOptions = AIProofreaderCreateOptions;
  exports.AIProofreader = AIProofreader;
  exports.AIProofreaderPtr = AIProofreaderPtr;
  exports.AIProofreaderAssociatedPtr = AIProofreaderAssociatedPtr;
})();