// third_party/blink/public/mojom/ai/ai_proofreader.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.ModelStreamingResponder');
goog.require('blink.mojom.AILanguageCode');






goog.provide('blink.mojom.AIProofreader');
goog.provide('blink.mojom.AIProofreaderReceiver');
goog.provide('blink.mojom.AIProofreaderCallbackRouter');
goog.provide('blink.mojom.AIProofreaderInterface');
goog.provide('blink.mojom.AIProofreaderRemote');
goog.provide('blink.mojom.AIProofreaderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIProofreaderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIProofreader.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIProofreaderInterface = class {
  
  /**
   * @param { !string } input
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  proofread(input, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !string } correctedInput
   * @param { !string } correctionInstruction
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  getCorrectionType(input, correctedInput, correctionInstruction, pendingResponder) {}
};

/**
 * @export
 * @implements { blink.mojom.AIProofreaderInterface }
 */
blink.mojom.AIProofreaderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIProofreaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIProofreaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIProofreaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  proofread(
      input,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AIProofreader_Proofread_ParamsSpec.$,
        null,
        [
          input,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !string } correctedInput
   * @param { !string } correctionInstruction
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  getCorrectionType(
      input,
      correctedInput,
      correctionInstruction,
      pendingResponder) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AIProofreader_GetCorrectionType_ParamsSpec.$,
        null,
        [
          input,
          correctedInput,
          correctionInstruction,
          pendingResponder
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIProofreader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIProofreaderReceiver = class {
  /**
   * @param {!blink.mojom.AIProofreaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIProofreaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIProofreaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIProofreaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIProofreader_Proofread_ParamsSpec.$,
        null,
        impl.proofread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIProofreader_GetCorrectionType_ParamsSpec.$,
        null,
        impl.getCorrectionType.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIProofreader = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIProofreader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIProofreaderRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIProofreaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIProofreader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIProofreaderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIProofreaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIProofreaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.proofread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIProofreader_Proofread_ParamsSpec.$,
        null,
        this.proofread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCorrectionType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIProofreader_GetCorrectionType_ParamsSpec.$,
        null,
        this.getCorrectionType.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AIProofreaderCreateOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIProofreaderCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIProofreader_Proofread_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIProofreader_Proofread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIProofreader_GetCorrectionType_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIProofreader_GetCorrectionType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AIProofreaderCreateOptionsSpec.$,
    'AIProofreaderCreateOptions',
    [
      mojo.internal.StructField(
        'includeCorrectionTypes', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeCorrectionExplanations', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'correctionExplanationLanguage', 8,
        0,
        blink.mojom.AILanguageCodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedInputLanguages', 16,
        0,
        mojo.internal.Array(blink.mojom.AILanguageCodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIProofreaderCreateOptions');

/** @record */
blink.mojom.AIProofreaderCreateOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.includeCorrectionTypes;
    /** @export { !boolean } */
    this.includeCorrectionExplanations;
    /** @export { !blink.mojom.AILanguageCode } */
    this.correctionExplanationLanguage;
    /** @export { !Array<!blink.mojom.AILanguageCode> } */
    this.expectedInputLanguages;
  }
};



mojo.internal.Struct(
    blink.mojom.AIProofreader_Proofread_ParamsSpec.$,
    'AIProofreader_Proofread_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingResponder', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelStreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIProofreader_Proofread_Params');

/** @record */
blink.mojom.AIProofreader_Proofread_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
    /** @export { !blink.mojom.ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
};



mojo.internal.Struct(
    blink.mojom.AIProofreader_GetCorrectionType_ParamsSpec.$,
    'AIProofreader_GetCorrectionType_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'correctedInput', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'correctionInstruction', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingResponder', 24,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelStreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AIProofreader_GetCorrectionType_Params');

/** @record */
blink.mojom.AIProofreader_GetCorrectionType_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
    /** @export { !string } */
    this.correctedInput;
    /** @export { !string } */
    this.correctionInstruction;
    /** @export { !blink.mojom.ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
};

