// third_party/blink/public/mojom/ai/ai_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/ai_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ai_common$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_common.mojom', 'ai_common.mojom.js');
  }
  var ai_language_model$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_language_model.mojom', 'ai_language_model.mojom.js');
  }
  var ai_proofreader$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_proofreader.mojom', 'ai_proofreader.mojom.js');
  }
  var ai_rewriter$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_rewriter.mojom', 'ai_rewriter.mojom.js');
  }
  var ai_summarizer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_summarizer.mojom', 'ai_summarizer.mojom.js');
  }
  var ai_writer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_writer.mojom', 'ai_writer.mojom.js');
  }
  var model_download_progress_observer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_download_progress_observer.mojom', 'model_download_progress_observer.mojom.js');
  }


  var ModelAvailabilityCheckResult = {};
  ModelAvailabilityCheckResult.kAvailable = 0;
  ModelAvailabilityCheckResult.kDownloadable = 1;
  ModelAvailabilityCheckResult.kDownloading = 2;
  ModelAvailabilityCheckResult.kUnavailableServiceNotRunning = 3;
  ModelAvailabilityCheckResult.kUnavailableUnsupportedLanguage = 4;
  ModelAvailabilityCheckResult.kUnavailableUnknown = 5;
  ModelAvailabilityCheckResult.kUnavailableFeatureNotEnabled = 6;
  ModelAvailabilityCheckResult.kUnavailableConfigNotAvailableForFeature = 7;
  ModelAvailabilityCheckResult.kUnavailableGpuBlocked = 8;
  ModelAvailabilityCheckResult.kUnavailableTooManyRecentCrashes = 9;
  ModelAvailabilityCheckResult.kUnavailableSafetyModelNotAvailable = 10;
  ModelAvailabilityCheckResult.kUnavailableSafetyConfigNotAvailableForFeature = 11;
  ModelAvailabilityCheckResult.kUnavailableLanguageDetectionModelNotAvailable = 12;
  ModelAvailabilityCheckResult.kUnavailableFeatureExecutionNotEnabled = 13;
  ModelAvailabilityCheckResult.kUnavailableModelAdaptationNotAvailable = 14;
  ModelAvailabilityCheckResult.kUnavailableValidationPending = 15;
  ModelAvailabilityCheckResult.kUnavailableValidationFailed = 16;
  ModelAvailabilityCheckResult.kUnavailableModelNotEligible = 17;
  ModelAvailabilityCheckResult.kUnavailableInsufficientDiskSpace = 18;
  ModelAvailabilityCheckResult.kUnavailableTranslationNotEligible = 19;
  ModelAvailabilityCheckResult.kUnavailableEnterprisePolicyDisabled = 20;
  ModelAvailabilityCheckResult.MIN_VALUE = 0;
  ModelAvailabilityCheckResult.MAX_VALUE = 20;

  ModelAvailabilityCheckResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
      return true;
    }
    return false;
  };

  ModelAvailabilityCheckResult.toKnownEnumValue = function(value) {
    return value;
  };

  ModelAvailabilityCheckResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AIManagerCreateWriterClient_OnResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateWriterClient_OnResult_Params.prototype.initDefaults_ = function() {
    this.writer = new ai_writer$.AIWriterPtr();
  };
  AIManagerCreateWriterClient_OnResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateWriterClient_OnResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateWriterClient_OnResult_Params.writer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateWriterClient_OnResult_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManagerCreateWriterClient_OnResult_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateWriterClient_OnResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.writer =
        decoder.decodeStruct(new codec.Interface(ai_writer$.AIWriterPtr));
    return val;
  };

  AIManagerCreateWriterClient_OnResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateWriterClient_OnResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ai_writer$.AIWriterPtr), val.writer);
  };
  function AIManagerCreateWriterClient_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateWriterClient_OnError_Params.prototype.initDefaults_ = function() {
    this.error = 0;
    this.quotaErrorInfo = null;
  };
  AIManagerCreateWriterClient_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateWriterClient_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateWriterClient_OnError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ai_common$.AIManagerCreateClientError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateWriterClient_OnError_Params.quotaErrorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_common$.QuotaErrorInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateWriterClient_OnError_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManagerCreateWriterClient_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateWriterClient_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(ai_common$.AIManagerCreateClientError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.quotaErrorInfo =
        decoder.decodeStructPointer(ai_common$.QuotaErrorInfo);
    return val;
  };

  AIManagerCreateWriterClient_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateWriterClient_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ai_common$.QuotaErrorInfo, val.quotaErrorInfo);
  };
  function AIManagerCreateRewriterClient_OnResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateRewriterClient_OnResult_Params.prototype.initDefaults_ = function() {
    this.rewriter = new ai_rewriter$.AIRewriterPtr();
  };
  AIManagerCreateRewriterClient_OnResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateRewriterClient_OnResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateRewriterClient_OnResult_Params.rewriter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateRewriterClient_OnResult_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManagerCreateRewriterClient_OnResult_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateRewriterClient_OnResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rewriter =
        decoder.decodeStruct(new codec.Interface(ai_rewriter$.AIRewriterPtr));
    return val;
  };

  AIManagerCreateRewriterClient_OnResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateRewriterClient_OnResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ai_rewriter$.AIRewriterPtr), val.rewriter);
  };
  function AIManagerCreateRewriterClient_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateRewriterClient_OnError_Params.prototype.initDefaults_ = function() {
    this.error = 0;
    this.quotaErrorInfo = null;
  };
  AIManagerCreateRewriterClient_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateRewriterClient_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateRewriterClient_OnError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ai_common$.AIManagerCreateClientError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateRewriterClient_OnError_Params.quotaErrorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_common$.QuotaErrorInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateRewriterClient_OnError_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManagerCreateRewriterClient_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateRewriterClient_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(ai_common$.AIManagerCreateClientError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.quotaErrorInfo =
        decoder.decodeStructPointer(ai_common$.QuotaErrorInfo);
    return val;
  };

  AIManagerCreateRewriterClient_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateRewriterClient_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ai_common$.QuotaErrorInfo, val.quotaErrorInfo);
  };
  function AIManagerCreateSummarizerClient_OnResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateSummarizerClient_OnResult_Params.prototype.initDefaults_ = function() {
    this.summarizer = new ai_summarizer$.AISummarizerPtr();
  };
  AIManagerCreateSummarizerClient_OnResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateSummarizerClient_OnResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateSummarizerClient_OnResult_Params.summarizer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateSummarizerClient_OnResult_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManagerCreateSummarizerClient_OnResult_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateSummarizerClient_OnResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.summarizer =
        decoder.decodeStruct(new codec.Interface(ai_summarizer$.AISummarizerPtr));
    return val;
  };

  AIManagerCreateSummarizerClient_OnResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateSummarizerClient_OnResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ai_summarizer$.AISummarizerPtr), val.summarizer);
  };
  function AIManagerCreateSummarizerClient_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateSummarizerClient_OnError_Params.prototype.initDefaults_ = function() {
    this.error = 0;
    this.quotaErrorInfo = null;
  };
  AIManagerCreateSummarizerClient_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateSummarizerClient_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateSummarizerClient_OnError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ai_common$.AIManagerCreateClientError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateSummarizerClient_OnError_Params.quotaErrorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_common$.QuotaErrorInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateSummarizerClient_OnError_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManagerCreateSummarizerClient_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateSummarizerClient_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(ai_common$.AIManagerCreateClientError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.quotaErrorInfo =
        decoder.decodeStructPointer(ai_common$.QuotaErrorInfo);
    return val;
  };

  AIManagerCreateSummarizerClient_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateSummarizerClient_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ai_common$.QuotaErrorInfo, val.quotaErrorInfo);
  };
  function AIManagerCreateProofreaderClient_OnResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateProofreaderClient_OnResult_Params.prototype.initDefaults_ = function() {
    this.proofreader = new ai_proofreader$.AIProofreaderPtr();
  };
  AIManagerCreateProofreaderClient_OnResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateProofreaderClient_OnResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateProofreaderClient_OnResult_Params.proofreader
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateProofreaderClient_OnResult_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManagerCreateProofreaderClient_OnResult_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateProofreaderClient_OnResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proofreader =
        decoder.decodeStruct(new codec.Interface(ai_proofreader$.AIProofreaderPtr));
    return val;
  };

  AIManagerCreateProofreaderClient_OnResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateProofreaderClient_OnResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ai_proofreader$.AIProofreaderPtr), val.proofreader);
  };
  function AIManagerCreateProofreaderClient_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateProofreaderClient_OnError_Params.prototype.initDefaults_ = function() {
    this.error = 0;
    this.quotaErrorInfo = null;
  };
  AIManagerCreateProofreaderClient_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateProofreaderClient_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateProofreaderClient_OnError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ai_common$.AIManagerCreateClientError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateProofreaderClient_OnError_Params.quotaErrorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_common$.QuotaErrorInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateProofreaderClient_OnError_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManagerCreateProofreaderClient_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateProofreaderClient_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(ai_common$.AIManagerCreateClientError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.quotaErrorInfo =
        decoder.decodeStructPointer(ai_common$.QuotaErrorInfo);
    return val;
  };

  AIManagerCreateProofreaderClient_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateProofreaderClient_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ai_common$.QuotaErrorInfo, val.quotaErrorInfo);
  };
  function AIManager_CanCreateLanguageModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateLanguageModel_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  AIManager_CanCreateLanguageModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateLanguageModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateLanguageModel_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ai_language_model$.AILanguageModelCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateLanguageModel_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateLanguageModel_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateLanguageModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(ai_language_model$.AILanguageModelCreateOptions);
    return val;
  };

  AIManager_CanCreateLanguageModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateLanguageModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ai_language_model$.AILanguageModelCreateOptions, val.options);
  };
  function AIManager_CanCreateLanguageModel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateLanguageModel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  AIManager_CanCreateLanguageModel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateLanguageModel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateLanguageModel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ModelAvailabilityCheckResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateLanguageModel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateLanguageModel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateLanguageModel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(ModelAvailabilityCheckResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIManager_CanCreateLanguageModel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateLanguageModel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIManager_CreateLanguageModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CreateLanguageModel_Params.prototype.initDefaults_ = function() {
    this.client = new ai_language_model$.AIManagerCreateLanguageModelClientPtr();
    this.options = null;
  };
  AIManager_CreateLanguageModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CreateLanguageModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateLanguageModel_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateLanguageModel_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_language_model$.AILanguageModelCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CreateLanguageModel_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManager_CreateLanguageModel_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CreateLanguageModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(ai_language_model$.AIManagerCreateLanguageModelClientPtr));
    val.options =
        decoder.decodeStructPointer(ai_language_model$.AILanguageModelCreateOptions);
    return val;
  };

  AIManager_CreateLanguageModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CreateLanguageModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ai_language_model$.AIManagerCreateLanguageModelClientPtr), val.client);
    encoder.encodeStructPointer(ai_language_model$.AILanguageModelCreateOptions, val.options);
  };
  function AIManager_CanCreateSummarizer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateSummarizer_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  AIManager_CanCreateSummarizer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateSummarizer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateSummarizer_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ai_summarizer$.AISummarizerCreateOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateSummarizer_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateSummarizer_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateSummarizer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(ai_summarizer$.AISummarizerCreateOptions);
    return val;
  };

  AIManager_CanCreateSummarizer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateSummarizer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ai_summarizer$.AISummarizerCreateOptions, val.options);
  };
  function AIManager_CanCreateSummarizer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateSummarizer_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  AIManager_CanCreateSummarizer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateSummarizer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateSummarizer_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ModelAvailabilityCheckResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateSummarizer_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateSummarizer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateSummarizer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(ModelAvailabilityCheckResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIManager_CanCreateSummarizer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateSummarizer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIManager_CreateSummarizer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CreateSummarizer_Params.prototype.initDefaults_ = function() {
    this.client = new AIManagerCreateSummarizerClientPtr();
    this.options = null;
  };
  AIManager_CreateSummarizer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CreateSummarizer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateSummarizer_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateSummarizer_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_summarizer$.AISummarizerCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CreateSummarizer_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManager_CreateSummarizer_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CreateSummarizer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(AIManagerCreateSummarizerClientPtr));
    val.options =
        decoder.decodeStructPointer(ai_summarizer$.AISummarizerCreateOptions);
    return val;
  };

  AIManager_CreateSummarizer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CreateSummarizer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AIManagerCreateSummarizerClientPtr), val.client);
    encoder.encodeStructPointer(ai_summarizer$.AISummarizerCreateOptions, val.options);
  };
  function AIManager_GetLanguageModelParams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_GetLanguageModelParams_Params.prototype.initDefaults_ = function() {
  };
  AIManager_GetLanguageModelParams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_GetLanguageModelParams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_GetLanguageModelParams_Params.encodedSize = codec.kStructHeaderSize + 0;

  AIManager_GetLanguageModelParams_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_GetLanguageModelParams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AIManager_GetLanguageModelParams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_GetLanguageModelParams_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AIManager_GetLanguageModelParams_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_GetLanguageModelParams_ResponseParams.prototype.initDefaults_ = function() {
    this.languageModelParams = null;
  };
  AIManager_GetLanguageModelParams_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_GetLanguageModelParams_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_GetLanguageModelParams_ResponseParams.languageModelParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ai_language_model$.AILanguageModelParams, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_GetLanguageModelParams_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_GetLanguageModelParams_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIManager_GetLanguageModelParams_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.languageModelParams =
        decoder.decodeStructPointer(ai_language_model$.AILanguageModelParams);
    return val;
  };

  AIManager_GetLanguageModelParams_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_GetLanguageModelParams_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ai_language_model$.AILanguageModelParams, val.languageModelParams);
  };
  function AIManager_CanCreateWriter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateWriter_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  AIManager_CanCreateWriter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateWriter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateWriter_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ai_writer$.AIWriterCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateWriter_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateWriter_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateWriter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(ai_writer$.AIWriterCreateOptions);
    return val;
  };

  AIManager_CanCreateWriter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateWriter_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ai_writer$.AIWriterCreateOptions, val.options);
  };
  function AIManager_CanCreateWriter_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateWriter_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  AIManager_CanCreateWriter_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateWriter_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateWriter_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ModelAvailabilityCheckResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateWriter_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateWriter_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateWriter_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(ModelAvailabilityCheckResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIManager_CanCreateWriter_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateWriter_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIManager_CreateWriter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CreateWriter_Params.prototype.initDefaults_ = function() {
    this.client = new AIManagerCreateWriterClientPtr();
    this.options = null;
  };
  AIManager_CreateWriter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CreateWriter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateWriter_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateWriter_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_writer$.AIWriterCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CreateWriter_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManager_CreateWriter_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CreateWriter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(AIManagerCreateWriterClientPtr));
    val.options =
        decoder.decodeStructPointer(ai_writer$.AIWriterCreateOptions);
    return val;
  };

  AIManager_CreateWriter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CreateWriter_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AIManagerCreateWriterClientPtr), val.client);
    encoder.encodeStructPointer(ai_writer$.AIWriterCreateOptions, val.options);
  };
  function AIManager_CanCreateRewriter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateRewriter_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  AIManager_CanCreateRewriter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateRewriter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateRewriter_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ai_rewriter$.AIRewriterCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateRewriter_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateRewriter_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateRewriter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(ai_rewriter$.AIRewriterCreateOptions);
    return val;
  };

  AIManager_CanCreateRewriter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateRewriter_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ai_rewriter$.AIRewriterCreateOptions, val.options);
  };
  function AIManager_CanCreateRewriter_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateRewriter_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  AIManager_CanCreateRewriter_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateRewriter_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateRewriter_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ModelAvailabilityCheckResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateRewriter_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateRewriter_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateRewriter_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(ModelAvailabilityCheckResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIManager_CanCreateRewriter_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateRewriter_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIManager_CreateRewriter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CreateRewriter_Params.prototype.initDefaults_ = function() {
    this.client = new AIManagerCreateRewriterClientPtr();
    this.options = null;
  };
  AIManager_CreateRewriter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CreateRewriter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateRewriter_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateRewriter_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_rewriter$.AIRewriterCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CreateRewriter_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManager_CreateRewriter_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CreateRewriter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(AIManagerCreateRewriterClientPtr));
    val.options =
        decoder.decodeStructPointer(ai_rewriter$.AIRewriterCreateOptions);
    return val;
  };

  AIManager_CreateRewriter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CreateRewriter_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AIManagerCreateRewriterClientPtr), val.client);
    encoder.encodeStructPointer(ai_rewriter$.AIRewriterCreateOptions, val.options);
  };
  function AIManager_CanCreateProofreader_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateProofreader_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  AIManager_CanCreateProofreader_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateProofreader_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateProofreader_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ai_proofreader$.AIProofreaderCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateProofreader_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateProofreader_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateProofreader_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(ai_proofreader$.AIProofreaderCreateOptions);
    return val;
  };

  AIManager_CanCreateProofreader_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateProofreader_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ai_proofreader$.AIProofreaderCreateOptions, val.options);
  };
  function AIManager_CanCreateProofreader_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CanCreateProofreader_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  AIManager_CanCreateProofreader_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CanCreateProofreader_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CanCreateProofreader_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ModelAvailabilityCheckResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CanCreateProofreader_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_CanCreateProofreader_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIManager_CanCreateProofreader_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(ModelAvailabilityCheckResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIManager_CanCreateProofreader_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CanCreateProofreader_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIManager_CreateProofreader_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_CreateProofreader_Params.prototype.initDefaults_ = function() {
    this.client = new AIManagerCreateProofreaderClientPtr();
    this.options = null;
  };
  AIManager_CreateProofreader_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_CreateProofreader_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateProofreader_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_CreateProofreader_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_proofreader$.AIProofreaderCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_CreateProofreader_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManager_CreateProofreader_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_CreateProofreader_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(AIManagerCreateProofreaderClientPtr));
    val.options =
        decoder.decodeStructPointer(ai_proofreader$.AIProofreaderCreateOptions);
    return val;
  };

  AIManager_CreateProofreader_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_CreateProofreader_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AIManagerCreateProofreaderClientPtr), val.client);
    encoder.encodeStructPointer(ai_proofreader$.AIProofreaderCreateOptions, val.options);
  };
  function AIManager_AddModelDownloadProgressObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManager_AddModelDownloadProgressObserver_Params.prototype.initDefaults_ = function() {
    this.observerRemote = new model_download_progress_observer$.ModelDownloadProgressObserverPtr();
  };
  AIManager_AddModelDownloadProgressObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManager_AddModelDownloadProgressObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManager_AddModelDownloadProgressObserver_Params.observerRemote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManager_AddModelDownloadProgressObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIManager_AddModelDownloadProgressObserver_Params.decode = function(decoder) {
    var packed;
    var val = new AIManager_AddModelDownloadProgressObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observerRemote =
        decoder.decodeStruct(new codec.Interface(model_download_progress_observer$.ModelDownloadProgressObserverPtr));
    return val;
  };

  AIManager_AddModelDownloadProgressObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManager_AddModelDownloadProgressObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(model_download_progress_observer$.ModelDownloadProgressObserverPtr), val.observerRemote);
  };
  var kAIManagerCreateWriterClient_OnResult_Name = 0;
  var kAIManagerCreateWriterClient_OnError_Name = 1;

  function AIManagerCreateWriterClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIManagerCreateWriterClient,
                                                   handleOrPtrInfo);
  }

  function AIManagerCreateWriterClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIManagerCreateWriterClient, associatedInterfacePtrInfo);
  }

  AIManagerCreateWriterClientAssociatedPtr.prototype =
      Object.create(AIManagerCreateWriterClientPtr.prototype);
  AIManagerCreateWriterClientAssociatedPtr.prototype.constructor =
      AIManagerCreateWriterClientAssociatedPtr;

  function AIManagerCreateWriterClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIManagerCreateWriterClientPtr.prototype.onResult = function() {
    return AIManagerCreateWriterClientProxy.prototype.onResult
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateWriterClientProxy.prototype.onResult = function(writer) {
    var params_ = new AIManagerCreateWriterClient_OnResult_Params();
    params_.writer = writer;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateWriterClient_OnResult_Name,
        codec.align(AIManagerCreateWriterClient_OnResult_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateWriterClient_OnResult_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerCreateWriterClientPtr.prototype.onError = function() {
    return AIManagerCreateWriterClientProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateWriterClientProxy.prototype.onError = function(error, quotaErrorInfo) {
    var params_ = new AIManagerCreateWriterClient_OnError_Params();
    params_.error = error;
    params_.quotaErrorInfo = quotaErrorInfo;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateWriterClient_OnError_Name,
        codec.align(AIManagerCreateWriterClient_OnError_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateWriterClient_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AIManagerCreateWriterClientStub(delegate) {
    this.delegate_ = delegate;
  }
  AIManagerCreateWriterClientStub.prototype.onResult = function(writer) {
    return this.delegate_ && this.delegate_.onResult && this.delegate_.onResult(writer);
  }
  AIManagerCreateWriterClientStub.prototype.onError = function(error, quotaErrorInfo) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(error, quotaErrorInfo);
  }

  AIManagerCreateWriterClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIManagerCreateWriterClient_OnResult_Name:
      var params = reader.decodeStruct(AIManagerCreateWriterClient_OnResult_Params);
      this.onResult(params.writer);
      return true;
    case kAIManagerCreateWriterClient_OnError_Name:
      var params = reader.decodeStruct(AIManagerCreateWriterClient_OnError_Params);
      this.onError(params.error, params.quotaErrorInfo);
      return true;
    default:
      return false;
    }
  };

  AIManagerCreateWriterClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAIManagerCreateWriterClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIManagerCreateWriterClient_OnResult_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateWriterClient_OnResult_Params;
      break;
      case kAIManagerCreateWriterClient_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateWriterClient_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIManagerCreateWriterClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AIManagerCreateWriterClient = {
    name: 'blink.mojom.AIManagerCreateWriterClient',
    kVersion: 0,
    ptrClass: AIManagerCreateWriterClientPtr,
    proxyClass: AIManagerCreateWriterClientProxy,
    stubClass: AIManagerCreateWriterClientStub,
    validateRequest: validateAIManagerCreateWriterClientRequest,
    validateResponse: null,
  };
  AIManagerCreateWriterClientStub.prototype.validator = validateAIManagerCreateWriterClientRequest;
  AIManagerCreateWriterClientProxy.prototype.validator = null;
  var kAIManagerCreateRewriterClient_OnResult_Name = 0;
  var kAIManagerCreateRewriterClient_OnError_Name = 1;

  function AIManagerCreateRewriterClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIManagerCreateRewriterClient,
                                                   handleOrPtrInfo);
  }

  function AIManagerCreateRewriterClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIManagerCreateRewriterClient, associatedInterfacePtrInfo);
  }

  AIManagerCreateRewriterClientAssociatedPtr.prototype =
      Object.create(AIManagerCreateRewriterClientPtr.prototype);
  AIManagerCreateRewriterClientAssociatedPtr.prototype.constructor =
      AIManagerCreateRewriterClientAssociatedPtr;

  function AIManagerCreateRewriterClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIManagerCreateRewriterClientPtr.prototype.onResult = function() {
    return AIManagerCreateRewriterClientProxy.prototype.onResult
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateRewriterClientProxy.prototype.onResult = function(rewriter) {
    var params_ = new AIManagerCreateRewriterClient_OnResult_Params();
    params_.rewriter = rewriter;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateRewriterClient_OnResult_Name,
        codec.align(AIManagerCreateRewriterClient_OnResult_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateRewriterClient_OnResult_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerCreateRewriterClientPtr.prototype.onError = function() {
    return AIManagerCreateRewriterClientProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateRewriterClientProxy.prototype.onError = function(error, quotaErrorInfo) {
    var params_ = new AIManagerCreateRewriterClient_OnError_Params();
    params_.error = error;
    params_.quotaErrorInfo = quotaErrorInfo;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateRewriterClient_OnError_Name,
        codec.align(AIManagerCreateRewriterClient_OnError_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateRewriterClient_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AIManagerCreateRewriterClientStub(delegate) {
    this.delegate_ = delegate;
  }
  AIManagerCreateRewriterClientStub.prototype.onResult = function(rewriter) {
    return this.delegate_ && this.delegate_.onResult && this.delegate_.onResult(rewriter);
  }
  AIManagerCreateRewriterClientStub.prototype.onError = function(error, quotaErrorInfo) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(error, quotaErrorInfo);
  }

  AIManagerCreateRewriterClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIManagerCreateRewriterClient_OnResult_Name:
      var params = reader.decodeStruct(AIManagerCreateRewriterClient_OnResult_Params);
      this.onResult(params.rewriter);
      return true;
    case kAIManagerCreateRewriterClient_OnError_Name:
      var params = reader.decodeStruct(AIManagerCreateRewriterClient_OnError_Params);
      this.onError(params.error, params.quotaErrorInfo);
      return true;
    default:
      return false;
    }
  };

  AIManagerCreateRewriterClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAIManagerCreateRewriterClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIManagerCreateRewriterClient_OnResult_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateRewriterClient_OnResult_Params;
      break;
      case kAIManagerCreateRewriterClient_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateRewriterClient_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIManagerCreateRewriterClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AIManagerCreateRewriterClient = {
    name: 'blink.mojom.AIManagerCreateRewriterClient',
    kVersion: 0,
    ptrClass: AIManagerCreateRewriterClientPtr,
    proxyClass: AIManagerCreateRewriterClientProxy,
    stubClass: AIManagerCreateRewriterClientStub,
    validateRequest: validateAIManagerCreateRewriterClientRequest,
    validateResponse: null,
  };
  AIManagerCreateRewriterClientStub.prototype.validator = validateAIManagerCreateRewriterClientRequest;
  AIManagerCreateRewriterClientProxy.prototype.validator = null;
  var kAIManagerCreateSummarizerClient_OnResult_Name = 0;
  var kAIManagerCreateSummarizerClient_OnError_Name = 1;

  function AIManagerCreateSummarizerClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIManagerCreateSummarizerClient,
                                                   handleOrPtrInfo);
  }

  function AIManagerCreateSummarizerClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIManagerCreateSummarizerClient, associatedInterfacePtrInfo);
  }

  AIManagerCreateSummarizerClientAssociatedPtr.prototype =
      Object.create(AIManagerCreateSummarizerClientPtr.prototype);
  AIManagerCreateSummarizerClientAssociatedPtr.prototype.constructor =
      AIManagerCreateSummarizerClientAssociatedPtr;

  function AIManagerCreateSummarizerClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIManagerCreateSummarizerClientPtr.prototype.onResult = function() {
    return AIManagerCreateSummarizerClientProxy.prototype.onResult
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateSummarizerClientProxy.prototype.onResult = function(summarizer) {
    var params_ = new AIManagerCreateSummarizerClient_OnResult_Params();
    params_.summarizer = summarizer;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateSummarizerClient_OnResult_Name,
        codec.align(AIManagerCreateSummarizerClient_OnResult_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateSummarizerClient_OnResult_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerCreateSummarizerClientPtr.prototype.onError = function() {
    return AIManagerCreateSummarizerClientProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateSummarizerClientProxy.prototype.onError = function(error, quotaErrorInfo) {
    var params_ = new AIManagerCreateSummarizerClient_OnError_Params();
    params_.error = error;
    params_.quotaErrorInfo = quotaErrorInfo;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateSummarizerClient_OnError_Name,
        codec.align(AIManagerCreateSummarizerClient_OnError_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateSummarizerClient_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AIManagerCreateSummarizerClientStub(delegate) {
    this.delegate_ = delegate;
  }
  AIManagerCreateSummarizerClientStub.prototype.onResult = function(summarizer) {
    return this.delegate_ && this.delegate_.onResult && this.delegate_.onResult(summarizer);
  }
  AIManagerCreateSummarizerClientStub.prototype.onError = function(error, quotaErrorInfo) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(error, quotaErrorInfo);
  }

  AIManagerCreateSummarizerClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIManagerCreateSummarizerClient_OnResult_Name:
      var params = reader.decodeStruct(AIManagerCreateSummarizerClient_OnResult_Params);
      this.onResult(params.summarizer);
      return true;
    case kAIManagerCreateSummarizerClient_OnError_Name:
      var params = reader.decodeStruct(AIManagerCreateSummarizerClient_OnError_Params);
      this.onError(params.error, params.quotaErrorInfo);
      return true;
    default:
      return false;
    }
  };

  AIManagerCreateSummarizerClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAIManagerCreateSummarizerClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIManagerCreateSummarizerClient_OnResult_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateSummarizerClient_OnResult_Params;
      break;
      case kAIManagerCreateSummarizerClient_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateSummarizerClient_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIManagerCreateSummarizerClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AIManagerCreateSummarizerClient = {
    name: 'blink.mojom.AIManagerCreateSummarizerClient',
    kVersion: 0,
    ptrClass: AIManagerCreateSummarizerClientPtr,
    proxyClass: AIManagerCreateSummarizerClientProxy,
    stubClass: AIManagerCreateSummarizerClientStub,
    validateRequest: validateAIManagerCreateSummarizerClientRequest,
    validateResponse: null,
  };
  AIManagerCreateSummarizerClientStub.prototype.validator = validateAIManagerCreateSummarizerClientRequest;
  AIManagerCreateSummarizerClientProxy.prototype.validator = null;
  var kAIManagerCreateProofreaderClient_OnResult_Name = 0;
  var kAIManagerCreateProofreaderClient_OnError_Name = 1;

  function AIManagerCreateProofreaderClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIManagerCreateProofreaderClient,
                                                   handleOrPtrInfo);
  }

  function AIManagerCreateProofreaderClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIManagerCreateProofreaderClient, associatedInterfacePtrInfo);
  }

  AIManagerCreateProofreaderClientAssociatedPtr.prototype =
      Object.create(AIManagerCreateProofreaderClientPtr.prototype);
  AIManagerCreateProofreaderClientAssociatedPtr.prototype.constructor =
      AIManagerCreateProofreaderClientAssociatedPtr;

  function AIManagerCreateProofreaderClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIManagerCreateProofreaderClientPtr.prototype.onResult = function() {
    return AIManagerCreateProofreaderClientProxy.prototype.onResult
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateProofreaderClientProxy.prototype.onResult = function(proofreader) {
    var params_ = new AIManagerCreateProofreaderClient_OnResult_Params();
    params_.proofreader = proofreader;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateProofreaderClient_OnResult_Name,
        codec.align(AIManagerCreateProofreaderClient_OnResult_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateProofreaderClient_OnResult_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerCreateProofreaderClientPtr.prototype.onError = function() {
    return AIManagerCreateProofreaderClientProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateProofreaderClientProxy.prototype.onError = function(error, quotaErrorInfo) {
    var params_ = new AIManagerCreateProofreaderClient_OnError_Params();
    params_.error = error;
    params_.quotaErrorInfo = quotaErrorInfo;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateProofreaderClient_OnError_Name,
        codec.align(AIManagerCreateProofreaderClient_OnError_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateProofreaderClient_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AIManagerCreateProofreaderClientStub(delegate) {
    this.delegate_ = delegate;
  }
  AIManagerCreateProofreaderClientStub.prototype.onResult = function(proofreader) {
    return this.delegate_ && this.delegate_.onResult && this.delegate_.onResult(proofreader);
  }
  AIManagerCreateProofreaderClientStub.prototype.onError = function(error, quotaErrorInfo) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(error, quotaErrorInfo);
  }

  AIManagerCreateProofreaderClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIManagerCreateProofreaderClient_OnResult_Name:
      var params = reader.decodeStruct(AIManagerCreateProofreaderClient_OnResult_Params);
      this.onResult(params.proofreader);
      return true;
    case kAIManagerCreateProofreaderClient_OnError_Name:
      var params = reader.decodeStruct(AIManagerCreateProofreaderClient_OnError_Params);
      this.onError(params.error, params.quotaErrorInfo);
      return true;
    default:
      return false;
    }
  };

  AIManagerCreateProofreaderClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAIManagerCreateProofreaderClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIManagerCreateProofreaderClient_OnResult_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateProofreaderClient_OnResult_Params;
      break;
      case kAIManagerCreateProofreaderClient_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateProofreaderClient_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIManagerCreateProofreaderClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AIManagerCreateProofreaderClient = {
    name: 'blink.mojom.AIManagerCreateProofreaderClient',
    kVersion: 0,
    ptrClass: AIManagerCreateProofreaderClientPtr,
    proxyClass: AIManagerCreateProofreaderClientProxy,
    stubClass: AIManagerCreateProofreaderClientStub,
    validateRequest: validateAIManagerCreateProofreaderClientRequest,
    validateResponse: null,
  };
  AIManagerCreateProofreaderClientStub.prototype.validator = validateAIManagerCreateProofreaderClientRequest;
  AIManagerCreateProofreaderClientProxy.prototype.validator = null;
  var kAIManager_CanCreateLanguageModel_Name = 0;
  var kAIManager_CreateLanguageModel_Name = 1;
  var kAIManager_CanCreateSummarizer_Name = 2;
  var kAIManager_CreateSummarizer_Name = 3;
  var kAIManager_GetLanguageModelParams_Name = 4;
  var kAIManager_CanCreateWriter_Name = 5;
  var kAIManager_CreateWriter_Name = 6;
  var kAIManager_CanCreateRewriter_Name = 7;
  var kAIManager_CreateRewriter_Name = 8;
  var kAIManager_CanCreateProofreader_Name = 9;
  var kAIManager_CreateProofreader_Name = 10;
  var kAIManager_AddModelDownloadProgressObserver_Name = 11;

  function AIManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIManager,
                                                   handleOrPtrInfo);
  }

  function AIManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIManager, associatedInterfacePtrInfo);
  }

  AIManagerAssociatedPtr.prototype =
      Object.create(AIManagerPtr.prototype);
  AIManagerAssociatedPtr.prototype.constructor =
      AIManagerAssociatedPtr;

  function AIManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIManagerPtr.prototype.canCreateLanguageModel = function() {
    return AIManagerProxy.prototype.canCreateLanguageModel
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.canCreateLanguageModel = function(options) {
    var params_ = new AIManager_CanCreateLanguageModel_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIManager_CanCreateLanguageModel_Name,
          codec.align(AIManager_CanCreateLanguageModel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIManager_CanCreateLanguageModel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIManager_CanCreateLanguageModel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AIManagerPtr.prototype.createLanguageModel = function() {
    return AIManagerProxy.prototype.createLanguageModel
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.createLanguageModel = function(client, options) {
    var params_ = new AIManager_CreateLanguageModel_Params();
    params_.client = client;
    params_.options = options;
    var builder = new codec.MessageV0Builder(
        kAIManager_CreateLanguageModel_Name,
        codec.align(AIManager_CreateLanguageModel_Params.encodedSize));
    builder.encodeStruct(AIManager_CreateLanguageModel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerPtr.prototype.canCreateSummarizer = function() {
    return AIManagerProxy.prototype.canCreateSummarizer
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.canCreateSummarizer = function(options) {
    var params_ = new AIManager_CanCreateSummarizer_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIManager_CanCreateSummarizer_Name,
          codec.align(AIManager_CanCreateSummarizer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIManager_CanCreateSummarizer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIManager_CanCreateSummarizer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AIManagerPtr.prototype.createSummarizer = function() {
    return AIManagerProxy.prototype.createSummarizer
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.createSummarizer = function(client, options) {
    var params_ = new AIManager_CreateSummarizer_Params();
    params_.client = client;
    params_.options = options;
    var builder = new codec.MessageV0Builder(
        kAIManager_CreateSummarizer_Name,
        codec.align(AIManager_CreateSummarizer_Params.encodedSize));
    builder.encodeStruct(AIManager_CreateSummarizer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerPtr.prototype.getLanguageModelParams = function() {
    return AIManagerProxy.prototype.getLanguageModelParams
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.getLanguageModelParams = function() {
    var params_ = new AIManager_GetLanguageModelParams_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIManager_GetLanguageModelParams_Name,
          codec.align(AIManager_GetLanguageModelParams_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIManager_GetLanguageModelParams_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIManager_GetLanguageModelParams_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AIManagerPtr.prototype.canCreateWriter = function() {
    return AIManagerProxy.prototype.canCreateWriter
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.canCreateWriter = function(options) {
    var params_ = new AIManager_CanCreateWriter_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIManager_CanCreateWriter_Name,
          codec.align(AIManager_CanCreateWriter_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIManager_CanCreateWriter_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIManager_CanCreateWriter_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AIManagerPtr.prototype.createWriter = function() {
    return AIManagerProxy.prototype.createWriter
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.createWriter = function(client, options) {
    var params_ = new AIManager_CreateWriter_Params();
    params_.client = client;
    params_.options = options;
    var builder = new codec.MessageV0Builder(
        kAIManager_CreateWriter_Name,
        codec.align(AIManager_CreateWriter_Params.encodedSize));
    builder.encodeStruct(AIManager_CreateWriter_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerPtr.prototype.canCreateRewriter = function() {
    return AIManagerProxy.prototype.canCreateRewriter
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.canCreateRewriter = function(options) {
    var params_ = new AIManager_CanCreateRewriter_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIManager_CanCreateRewriter_Name,
          codec.align(AIManager_CanCreateRewriter_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIManager_CanCreateRewriter_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIManager_CanCreateRewriter_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AIManagerPtr.prototype.createRewriter = function() {
    return AIManagerProxy.prototype.createRewriter
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.createRewriter = function(client, options) {
    var params_ = new AIManager_CreateRewriter_Params();
    params_.client = client;
    params_.options = options;
    var builder = new codec.MessageV0Builder(
        kAIManager_CreateRewriter_Name,
        codec.align(AIManager_CreateRewriter_Params.encodedSize));
    builder.encodeStruct(AIManager_CreateRewriter_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerPtr.prototype.canCreateProofreader = function() {
    return AIManagerProxy.prototype.canCreateProofreader
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.canCreateProofreader = function(options) {
    var params_ = new AIManager_CanCreateProofreader_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIManager_CanCreateProofreader_Name,
          codec.align(AIManager_CanCreateProofreader_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIManager_CanCreateProofreader_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIManager_CanCreateProofreader_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AIManagerPtr.prototype.createProofreader = function() {
    return AIManagerProxy.prototype.createProofreader
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.createProofreader = function(client, options) {
    var params_ = new AIManager_CreateProofreader_Params();
    params_.client = client;
    params_.options = options;
    var builder = new codec.MessageV0Builder(
        kAIManager_CreateProofreader_Name,
        codec.align(AIManager_CreateProofreader_Params.encodedSize));
    builder.encodeStruct(AIManager_CreateProofreader_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerPtr.prototype.addModelDownloadProgressObserver = function() {
    return AIManagerProxy.prototype.addModelDownloadProgressObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerProxy.prototype.addModelDownloadProgressObserver = function(observerRemote) {
    var params_ = new AIManager_AddModelDownloadProgressObserver_Params();
    params_.observerRemote = observerRemote;
    var builder = new codec.MessageV0Builder(
        kAIManager_AddModelDownloadProgressObserver_Name,
        codec.align(AIManager_AddModelDownloadProgressObserver_Params.encodedSize));
    builder.encodeStruct(AIManager_AddModelDownloadProgressObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AIManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  AIManagerStub.prototype.canCreateLanguageModel = function(options) {
    return this.delegate_ && this.delegate_.canCreateLanguageModel && this.delegate_.canCreateLanguageModel(options);
  }
  AIManagerStub.prototype.createLanguageModel = function(client, options) {
    return this.delegate_ && this.delegate_.createLanguageModel && this.delegate_.createLanguageModel(client, options);
  }
  AIManagerStub.prototype.canCreateSummarizer = function(options) {
    return this.delegate_ && this.delegate_.canCreateSummarizer && this.delegate_.canCreateSummarizer(options);
  }
  AIManagerStub.prototype.createSummarizer = function(client, options) {
    return this.delegate_ && this.delegate_.createSummarizer && this.delegate_.createSummarizer(client, options);
  }
  AIManagerStub.prototype.getLanguageModelParams = function() {
    return this.delegate_ && this.delegate_.getLanguageModelParams && this.delegate_.getLanguageModelParams();
  }
  AIManagerStub.prototype.canCreateWriter = function(options) {
    return this.delegate_ && this.delegate_.canCreateWriter && this.delegate_.canCreateWriter(options);
  }
  AIManagerStub.prototype.createWriter = function(client, options) {
    return this.delegate_ && this.delegate_.createWriter && this.delegate_.createWriter(client, options);
  }
  AIManagerStub.prototype.canCreateRewriter = function(options) {
    return this.delegate_ && this.delegate_.canCreateRewriter && this.delegate_.canCreateRewriter(options);
  }
  AIManagerStub.prototype.createRewriter = function(client, options) {
    return this.delegate_ && this.delegate_.createRewriter && this.delegate_.createRewriter(client, options);
  }
  AIManagerStub.prototype.canCreateProofreader = function(options) {
    return this.delegate_ && this.delegate_.canCreateProofreader && this.delegate_.canCreateProofreader(options);
  }
  AIManagerStub.prototype.createProofreader = function(client, options) {
    return this.delegate_ && this.delegate_.createProofreader && this.delegate_.createProofreader(client, options);
  }
  AIManagerStub.prototype.addModelDownloadProgressObserver = function(observerRemote) {
    return this.delegate_ && this.delegate_.addModelDownloadProgressObserver && this.delegate_.addModelDownloadProgressObserver(observerRemote);
  }

  AIManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIManager_CreateLanguageModel_Name:
      var params = reader.decodeStruct(AIManager_CreateLanguageModel_Params);
      this.createLanguageModel(params.client, params.options);
      return true;
    case kAIManager_CreateSummarizer_Name:
      var params = reader.decodeStruct(AIManager_CreateSummarizer_Params);
      this.createSummarizer(params.client, params.options);
      return true;
    case kAIManager_CreateWriter_Name:
      var params = reader.decodeStruct(AIManager_CreateWriter_Params);
      this.createWriter(params.client, params.options);
      return true;
    case kAIManager_CreateRewriter_Name:
      var params = reader.decodeStruct(AIManager_CreateRewriter_Params);
      this.createRewriter(params.client, params.options);
      return true;
    case kAIManager_CreateProofreader_Name:
      var params = reader.decodeStruct(AIManager_CreateProofreader_Params);
      this.createProofreader(params.client, params.options);
      return true;
    case kAIManager_AddModelDownloadProgressObserver_Name:
      var params = reader.decodeStruct(AIManager_AddModelDownloadProgressObserver_Params);
      this.addModelDownloadProgressObserver(params.observerRemote);
      return true;
    default:
      return false;
    }
  };

  AIManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIManager_CanCreateLanguageModel_Name:
      var params = reader.decodeStruct(AIManager_CanCreateLanguageModel_Params);
      this.canCreateLanguageModel(params.options).then(function(response) {
        var responseParams =
            new AIManager_CanCreateLanguageModel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kAIManager_CanCreateLanguageModel_Name,
            codec.align(AIManager_CanCreateLanguageModel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIManager_CanCreateLanguageModel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAIManager_CanCreateSummarizer_Name:
      var params = reader.decodeStruct(AIManager_CanCreateSummarizer_Params);
      this.canCreateSummarizer(params.options).then(function(response) {
        var responseParams =
            new AIManager_CanCreateSummarizer_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kAIManager_CanCreateSummarizer_Name,
            codec.align(AIManager_CanCreateSummarizer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIManager_CanCreateSummarizer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAIManager_GetLanguageModelParams_Name:
      var params = reader.decodeStruct(AIManager_GetLanguageModelParams_Params);
      this.getLanguageModelParams().then(function(response) {
        var responseParams =
            new AIManager_GetLanguageModelParams_ResponseParams();
        responseParams.languageModelParams = response.languageModelParams;
        var builder = new codec.MessageV1Builder(
            kAIManager_GetLanguageModelParams_Name,
            codec.align(AIManager_GetLanguageModelParams_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIManager_GetLanguageModelParams_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAIManager_CanCreateWriter_Name:
      var params = reader.decodeStruct(AIManager_CanCreateWriter_Params);
      this.canCreateWriter(params.options).then(function(response) {
        var responseParams =
            new AIManager_CanCreateWriter_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kAIManager_CanCreateWriter_Name,
            codec.align(AIManager_CanCreateWriter_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIManager_CanCreateWriter_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAIManager_CanCreateRewriter_Name:
      var params = reader.decodeStruct(AIManager_CanCreateRewriter_Params);
      this.canCreateRewriter(params.options).then(function(response) {
        var responseParams =
            new AIManager_CanCreateRewriter_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kAIManager_CanCreateRewriter_Name,
            codec.align(AIManager_CanCreateRewriter_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIManager_CanCreateRewriter_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAIManager_CanCreateProofreader_Name:
      var params = reader.decodeStruct(AIManager_CanCreateProofreader_Params);
      this.canCreateProofreader(params.options).then(function(response) {
        var responseParams =
            new AIManager_CanCreateProofreader_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kAIManager_CanCreateProofreader_Name,
            codec.align(AIManager_CanCreateProofreader_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIManager_CanCreateProofreader_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAIManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIManager_CanCreateLanguageModel_Name:
        if (message.expectsResponse())
          paramsClass = AIManager_CanCreateLanguageModel_Params;
      break;
      case kAIManager_CreateLanguageModel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManager_CreateLanguageModel_Params;
      break;
      case kAIManager_CanCreateSummarizer_Name:
        if (message.expectsResponse())
          paramsClass = AIManager_CanCreateSummarizer_Params;
      break;
      case kAIManager_CreateSummarizer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManager_CreateSummarizer_Params;
      break;
      case kAIManager_GetLanguageModelParams_Name:
        if (message.expectsResponse())
          paramsClass = AIManager_GetLanguageModelParams_Params;
      break;
      case kAIManager_CanCreateWriter_Name:
        if (message.expectsResponse())
          paramsClass = AIManager_CanCreateWriter_Params;
      break;
      case kAIManager_CreateWriter_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManager_CreateWriter_Params;
      break;
      case kAIManager_CanCreateRewriter_Name:
        if (message.expectsResponse())
          paramsClass = AIManager_CanCreateRewriter_Params;
      break;
      case kAIManager_CreateRewriter_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManager_CreateRewriter_Params;
      break;
      case kAIManager_CanCreateProofreader_Name:
        if (message.expectsResponse())
          paramsClass = AIManager_CanCreateProofreader_Params;
      break;
      case kAIManager_CreateProofreader_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManager_CreateProofreader_Params;
      break;
      case kAIManager_AddModelDownloadProgressObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManager_AddModelDownloadProgressObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAIManager_CanCreateLanguageModel_Name:
        if (message.isResponse())
          paramsClass = AIManager_CanCreateLanguageModel_ResponseParams;
        break;
      case kAIManager_CanCreateSummarizer_Name:
        if (message.isResponse())
          paramsClass = AIManager_CanCreateSummarizer_ResponseParams;
        break;
      case kAIManager_GetLanguageModelParams_Name:
        if (message.isResponse())
          paramsClass = AIManager_GetLanguageModelParams_ResponseParams;
        break;
      case kAIManager_CanCreateWriter_Name:
        if (message.isResponse())
          paramsClass = AIManager_CanCreateWriter_ResponseParams;
        break;
      case kAIManager_CanCreateRewriter_Name:
        if (message.isResponse())
          paramsClass = AIManager_CanCreateRewriter_ResponseParams;
        break;
      case kAIManager_CanCreateProofreader_Name:
        if (message.isResponse())
          paramsClass = AIManager_CanCreateProofreader_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AIManager = {
    name: 'blink.mojom.AIManager',
    kVersion: 0,
    ptrClass: AIManagerPtr,
    proxyClass: AIManagerProxy,
    stubClass: AIManagerStub,
    validateRequest: validateAIManagerRequest,
    validateResponse: validateAIManagerResponse,
  };
  AIManagerStub.prototype.validator = validateAIManagerRequest;
  AIManagerProxy.prototype.validator = validateAIManagerResponse;
  exports.ModelAvailabilityCheckResult = ModelAvailabilityCheckResult;
  exports.AIManagerCreateWriterClient = AIManagerCreateWriterClient;
  exports.AIManagerCreateWriterClientPtr = AIManagerCreateWriterClientPtr;
  exports.AIManagerCreateWriterClientAssociatedPtr = AIManagerCreateWriterClientAssociatedPtr;
  exports.AIManagerCreateRewriterClient = AIManagerCreateRewriterClient;
  exports.AIManagerCreateRewriterClientPtr = AIManagerCreateRewriterClientPtr;
  exports.AIManagerCreateRewriterClientAssociatedPtr = AIManagerCreateRewriterClientAssociatedPtr;
  exports.AIManagerCreateSummarizerClient = AIManagerCreateSummarizerClient;
  exports.AIManagerCreateSummarizerClientPtr = AIManagerCreateSummarizerClientPtr;
  exports.AIManagerCreateSummarizerClientAssociatedPtr = AIManagerCreateSummarizerClientAssociatedPtr;
  exports.AIManagerCreateProofreaderClient = AIManagerCreateProofreaderClient;
  exports.AIManagerCreateProofreaderClientPtr = AIManagerCreateProofreaderClientPtr;
  exports.AIManagerCreateProofreaderClientAssociatedPtr = AIManagerCreateProofreaderClientAssociatedPtr;
  exports.AIManager = AIManager;
  exports.AIManagerPtr = AIManagerPtr;
  exports.AIManagerAssociatedPtr = AIManagerAssociatedPtr;
})();