// third_party/blink/public/mojom/ai/ai_language_model.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.AIManagerCreateClientError');
goog.require('blink.mojom.ModelStreamingResponder');
goog.require('blink.mojom.AILanguageCode');
goog.require('onDeviceModel.mojom.AudioData');
goog.require('skia.mojom.BitmapN32');
goog.require('blink.mojom.QuotaErrorInfo');
goog.require('onDeviceModel.mojom.ResponseConstraint');




goog.provide('blink.mojom.AILanguageModelPromptRole');
goog.provide('blink.mojom.AILanguageModelPromptRoleSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AILanguageModelPromptRoleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AILanguageModelPromptRole = {
  
  kSystem: 0,
  kUser: 1,
  kAssistant: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.AILanguageModelPromptType');
goog.provide('blink.mojom.AILanguageModelPromptTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AILanguageModelPromptTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AILanguageModelPromptType = {
  
  kText: 0,
  kImage: 1,
  kAudio: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('blink.mojom.AIManagerCreateLanguageModelClient');
goog.provide('blink.mojom.AIManagerCreateLanguageModelClientReceiver');
goog.provide('blink.mojom.AIManagerCreateLanguageModelClientCallbackRouter');
goog.provide('blink.mojom.AIManagerCreateLanguageModelClientInterface');
goog.provide('blink.mojom.AIManagerCreateLanguageModelClientRemote');
goog.provide('blink.mojom.AIManagerCreateLanguageModelClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIManagerCreateLanguageModelClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIManagerCreateLanguageModelClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIManagerCreateLanguageModelClientInterface = class {
  
  /**
   * @param { !blink.mojom.AILanguageModelRemote } languageModelRemote
   * @param { !blink.mojom.AILanguageModelInstanceInfo } info
   */

  onResult(languageModelRemote, info) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
};

/**
 * @export
 * @implements { blink.mojom.AIManagerCreateLanguageModelClientInterface }
 */
blink.mojom.AIManagerCreateLanguageModelClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIManagerCreateLanguageModelClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIManagerCreateLanguageModelClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIManagerCreateLanguageModelClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AILanguageModelRemote } languageModelRemote
   * @param { !blink.mojom.AILanguageModelInstanceInfo } info
   */

  onResult(
      languageModelRemote,
      info) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
        null,
        [
          languageModelRemote,
          info
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIManagerCreateLanguageModelClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIManagerCreateLanguageModelClientReceiver = class {
  /**
   * @param {!blink.mojom.AIManagerCreateLanguageModelClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIManagerCreateLanguageModelClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIManagerCreateLanguageModelClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateLanguageModelClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIManagerCreateLanguageModelClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateLanguageModelClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIManagerCreateLanguageModelClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIManagerCreateLanguageModelClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIManagerCreateLanguageModelClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIManagerCreateLanguageModelClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIManagerCreateLanguageModelClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateLanguageModelClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AILanguageModel');
goog.provide('blink.mojom.AILanguageModelReceiver');
goog.provide('blink.mojom.AILanguageModelCallbackRouter');
goog.provide('blink.mojom.AILanguageModelInterface');
goog.provide('blink.mojom.AILanguageModelRemote');
goog.provide('blink.mojom.AILanguageModelPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AILanguageModelPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AILanguageModel.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AILanguageModelInterface = class {
  
  /**
   * @param { !Array<!blink.mojom.AILanguageModelPrompt> } prompts
   * @param { ?onDeviceModel.mojom.ResponseConstraint } constraint
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  prompt(prompts, constraint, pendingResponder) {}
  
  /**
   * @param { !Array<!blink.mojom.AILanguageModelPrompt> } prompts
   * @param { !blink.mojom.ModelStreamingResponderRemote } client
   */

  append(prompts, client) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateLanguageModelClientRemote } client
   */

  fork(client) {}
  
  /**
   */

  destroy() {}
  
  /**
   * @param { !Array<!blink.mojom.AILanguageModelPrompt> } input
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureInputUsage(input) {}
};

/**
 * @export
 * @implements { blink.mojom.AILanguageModelInterface }
 */
blink.mojom.AILanguageModelRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AILanguageModelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AILanguageModelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AILanguageModelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink.mojom.AILanguageModelPrompt> } prompts
   * @param { ?onDeviceModel.mojom.ResponseConstraint } constraint
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  prompt(
      prompts,
      constraint,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AILanguageModel_Prompt_ParamsSpec.$,
        null,
        [
          prompts,
          constraint,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.AILanguageModelPrompt> } prompts
   * @param { !blink.mojom.ModelStreamingResponderRemote } client
   */

  append(
      prompts,
      client) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AILanguageModel_Append_ParamsSpec.$,
        null,
        [
          prompts,
          client
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateLanguageModelClientRemote } client
   */

  fork(
      client) {
    this.proxy.sendMessage(
        2,
        blink.mojom.AILanguageModel_Fork_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   */

  destroy() {
    this.proxy.sendMessage(
        3,
        blink.mojom.AILanguageModel_Destroy_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.AILanguageModelPrompt> } input
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureInputUsage(
      input) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.AILanguageModel_MeasureInputUsage_ParamsSpec.$,
        blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
        [
          input
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AILanguageModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AILanguageModelReceiver = class {
  /**
   * @param {!blink.mojom.AILanguageModelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AILanguageModelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AILanguageModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AILanguageModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AILanguageModel_Prompt_ParamsSpec.$,
        null,
        impl.prompt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AILanguageModel_Append_ParamsSpec.$,
        null,
        impl.append.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AILanguageModel_Fork_ParamsSpec.$,
        null,
        impl.fork.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AILanguageModel_Destroy_ParamsSpec.$,
        null,
        impl.destroy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AILanguageModel_MeasureInputUsage_ParamsSpec.$,
        blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
        impl.measureInputUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AILanguageModel = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AILanguageModel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AILanguageModelRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AILanguageModelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AILanguageModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AILanguageModelCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AILanguageModelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AILanguageModelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prompt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AILanguageModel_Prompt_ParamsSpec.$,
        null,
        this.prompt.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.append =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AILanguageModel_Append_ParamsSpec.$,
        null,
        this.append.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fork =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AILanguageModel_Fork_ParamsSpec.$,
        null,
        this.fork.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.destroy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AILanguageModel_Destroy_ParamsSpec.$,
        null,
        this.destroy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.measureInputUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AILanguageModel_MeasureInputUsage_ParamsSpec.$,
        blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
        this.measureInputUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AILanguageModelSamplingParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModelSamplingParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModelParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModelParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModelInstanceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModelInstanceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModelExpectedSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModelExpectedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModelPromptSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModelPromptSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModelCreateOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModelCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateLanguageModelClient_OnResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateLanguageModelClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateLanguageModelClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateLanguageModelClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModel_Prompt_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModel_Prompt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModel_Append_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModel_Append_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModel_Fork_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModel_Fork_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModel_Destroy_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModel_Destroy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModel_MeasureInputUsage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModel_MeasureInputUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AILanguageModelPromptContentSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AILanguageModelPromptContentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AILanguageModelSamplingParamsSpec.$,
    'AILanguageModelSamplingParams',
    [
      mojo.internal.StructField(
        'topK', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'temperature', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AILanguageModelSamplingParams');

/** @record */
blink.mojom.AILanguageModelSamplingParams = class {
  constructor() {
    /** @export { !number } */
    this.topK;
    /** @export { !number } */
    this.temperature;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModelParamsSpec.$,
    'AILanguageModelParams',
    [
      mojo.internal.StructField(
        'defaultSamplingParams', 0,
        0,
        blink.mojom.AILanguageModelSamplingParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxSamplingParams', 8,
        0,
        blink.mojom.AILanguageModelSamplingParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AILanguageModelParams');

/** @record */
blink.mojom.AILanguageModelParams = class {
  constructor() {
    /** @export { !blink.mojom.AILanguageModelSamplingParams } */
    this.defaultSamplingParams;
    /** @export { !blink.mojom.AILanguageModelSamplingParams } */
    this.maxSamplingParams;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModelInstanceInfoSpec.$,
    'AILanguageModelInstanceInfo',
    [
      mojo.internal.StructField(
        'inputQuota', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputUsage', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'samplingParams', 16,
        0,
        blink.mojom.AILanguageModelSamplingParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputTypes', 24,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelPromptTypeSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AILanguageModelInstanceInfo');

/** @record */
blink.mojom.AILanguageModelInstanceInfo = class {
  constructor() {
    /** @export { !bigint } */
    this.inputQuota;
    /** @export { !bigint } */
    this.inputUsage;
    /** @export { !blink.mojom.AILanguageModelSamplingParams } */
    this.samplingParams;
    /** @export { (Array<!blink.mojom.AILanguageModelPromptType>|undefined) } */
    this.inputTypes;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModelExpectedSpec.$,
    'AILanguageModelExpected',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.AILanguageModelPromptTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'languages', 8,
        0,
        mojo.internal.Array(blink.mojom.AILanguageCodeSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AILanguageModelExpected');

/** @record */
blink.mojom.AILanguageModelExpected = class {
  constructor() {
    /** @export { !blink.mojom.AILanguageModelPromptType } */
    this.type;
    /** @export { (Array<!blink.mojom.AILanguageCode>|undefined) } */
    this.languages;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModelPromptSpec.$,
    'AILanguageModelPrompt',
    [
      mojo.internal.StructField(
        'role', 0,
        0,
        blink.mojom.AILanguageModelPromptRoleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'content', 8,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelPromptContentSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPrefix', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AILanguageModelPrompt');

/** @record */
blink.mojom.AILanguageModelPrompt = class {
  constructor() {
    /** @export { !blink.mojom.AILanguageModelPromptRole } */
    this.role;
    /** @export { !Array<!blink.mojom.AILanguageModelPromptContent> } */
    this.content;
    /** @export { !boolean } */
    this.isPrefix;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModelCreateOptionsSpec.$,
    'AILanguageModelCreateOptions',
    [
      mojo.internal.StructField(
        'samplingParams', 0,
        0,
        blink.mojom.AILanguageModelSamplingParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialPrompts', 8,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelPromptSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedInputs', 16,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelExpectedSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedOutputs', 24,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelExpectedSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AILanguageModelCreateOptions');

/** @record */
blink.mojom.AILanguageModelCreateOptions = class {
  constructor() {
    /** @export { (blink.mojom.AILanguageModelSamplingParams|undefined) } */
    this.samplingParams;
    /** @export { !Array<!blink.mojom.AILanguageModelPrompt> } */
    this.initialPrompts;
    /** @export { (Array<!blink.mojom.AILanguageModelExpected>|undefined) } */
    this.expectedInputs;
    /** @export { (Array<!blink.mojom.AILanguageModelExpected>|undefined) } */
    this.expectedOutputs;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateLanguageModelClient_OnResult_ParamsSpec.$,
    'AIManagerCreateLanguageModelClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'languageModelRemote', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AILanguageModelRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'info', 8,
        0,
        blink.mojom.AILanguageModelInstanceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManagerCreateLanguageModelClient_OnResult_Params');

/** @record */
blink.mojom.AIManagerCreateLanguageModelClient_OnResult_Params = class {
  constructor() {
    /** @export { !blink.mojom.AILanguageModelRemote } */
    this.languageModelRemote;
    /** @export { !blink.mojom.AILanguageModelInstanceInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateLanguageModelClient_OnError_ParamsSpec.$,
    'AIManagerCreateLanguageModelClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.AIManagerCreateClientErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink.mojom.QuotaErrorInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManagerCreateLanguageModelClient_OnError_Params');

/** @record */
blink.mojom.AIManagerCreateLanguageModelClient_OnError_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateClientError } */
    this.error;
    /** @export { (blink.mojom.QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModel_Prompt_ParamsSpec.$,
    'AILanguageModel_Prompt_Params',
    [
      mojo.internal.StructField(
        'prompts', 0,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelPromptSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'constraint', 8,
        0,
        onDeviceModel.mojom.ResponseConstraintSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingResponder', 24,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelStreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AILanguageModel_Prompt_Params');

/** @record */
blink.mojom.AILanguageModel_Prompt_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AILanguageModelPrompt> } */
    this.prompts;
    /** @export { (onDeviceModel.mojom.ResponseConstraint|undefined) } */
    this.constraint;
    /** @export { !blink.mojom.ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModel_Append_ParamsSpec.$,
    'AILanguageModel_Append_Params',
    [
      mojo.internal.StructField(
        'prompts', 0,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelPromptSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelStreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AILanguageModel_Append_Params');

/** @record */
blink.mojom.AILanguageModel_Append_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AILanguageModelPrompt> } */
    this.prompts;
    /** @export { !blink.mojom.ModelStreamingResponderRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModel_Fork_ParamsSpec.$,
    'AILanguageModel_Fork_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIManagerCreateLanguageModelClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AILanguageModel_Fork_Params');

/** @record */
blink.mojom.AILanguageModel_Fork_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateLanguageModelClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModel_Destroy_ParamsSpec.$,
    'AILanguageModel_Destroy_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AILanguageModel_Destroy_Params');

/** @record */
blink.mojom.AILanguageModel_Destroy_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModel_MeasureInputUsage_ParamsSpec.$,
    'AILanguageModel_MeasureInputUsage_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.Array(blink.mojom.AILanguageModelPromptSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AILanguageModel_MeasureInputUsage_Params');

/** @record */
blink.mojom.AILanguageModel_MeasureInputUsage_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AILanguageModelPrompt> } */
    this.input;
  }
};



mojo.internal.Struct(
    blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParamsSpec.$,
    'AILanguageModel_MeasureInputUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'number_of_tokens_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "number_of_tokens_$value",
          originalFieldName: "numberOfTokens",
        }
      ),
      mojo.internal.StructField(
        'number_of_tokens_$value', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "numberOfTokens",
        }
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParams');

/** @record */
blink.mojom.AILanguageModel_MeasureInputUsage_ResponseParams = class {
  constructor() {
    /** @export { (number|undefined) } */
    this.numberOfTokens;
  }
};

goog.provide('blink.mojom.AILanguageModelPromptContent');


mojo.internal.Union(
    blink.mojom.AILanguageModelPromptContentSpec.$, 'AILanguageModelPromptContent',
    {
      'text': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'bitmap': {
        'ordinal': 1,
        'type': skia.mojom.BitmapN32Spec.$,
      },
      'audio': {
        'ordinal': 2,
        'type': onDeviceModel.mojom.AudioDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   text: (!string|undefined),
 *   bitmap: (!skia.mojom.BitmapN32|undefined),
 *   audio: (!onDeviceModel.mojom.AudioData|undefined),
 * } }
 */
blink.mojom.AILanguageModelPromptContent;
