// skia/public/mojom/skcolorspace.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_SHARED_H_
#define SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/skcolorspace.mojom-shared-internal.h"




#include "skia/public/mojom/skcolorspace.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::SkcmsMatrix3x3DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::SkcmsMatrix3x3DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::SkcmsMatrix3x3_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::vals(input)) in_vals = Traits::vals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vals)::BaseType>
        vals_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& vals_validate_params =
        mojo::internal::GetArrayValidator<9, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_vals,
      vals_fragment,
      &vals_validate_params);

    fragment->vals.Set(
        vals_fragment.is_null() ? nullptr : vals_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vals.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vals in SkcmsMatrix3x3 struct");
  }

  static bool Deserialize(::skia::mojom::internal::SkcmsMatrix3x3_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::SkcmsMatrix3x3DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::SkcmsTransferFunctionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::SkcmsTransferFunctionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::SkcmsTransferFunction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->g = Traits::g(input);

    fragment->a = Traits::a(input);

    fragment->b = Traits::b(input);

    fragment->c = Traits::c(input);

    fragment->d = Traits::d(input);

    fragment->e = Traits::e(input);

    fragment->f = Traits::f(input);
  }

  static bool Deserialize(::skia::mojom::internal::SkcmsTransferFunction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::SkcmsTransferFunctionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::SkColorSpaceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::SkColorSpaceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::SkColorSpace_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::to_linear(input)) in_to_linear = Traits::to_linear(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->to_linear)::BaseType> to_linear_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkcmsTransferFunctionDataView>(
      in_to_linear,
      to_linear_fragment);

    fragment->to_linear.Set(
        to_linear_fragment.is_null() ? nullptr : to_linear_fragment.data());

    decltype(Traits::to_xyzd50(input)) in_to_xyzd50 = Traits::to_xyzd50(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->to_xyzd50)::BaseType> to_xyzd50_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkcmsMatrix3x3DataView>(
      in_to_xyzd50,
      to_xyzd50_fragment);

    fragment->to_xyzd50.Set(
        to_xyzd50_fragment.is_null() ? nullptr : to_xyzd50_fragment.data());
  }

  static bool Deserialize(::skia::mojom::internal::SkColorSpace_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::SkColorSpaceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace skia::mojom {

inline void SkcmsMatrix3x3DataView::GetValsDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->vals.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}




inline void SkColorSpaceDataView::GetToLinearDataView(
    SkcmsTransferFunctionDataView* output) {
  auto pointer = data_->to_linear.Get();
  *output = SkcmsTransferFunctionDataView(pointer, message_);
}
inline void SkColorSpaceDataView::GetToXyzd50DataView(
    SkcmsMatrix3x3DataView* output) {
  auto pointer = data_->to_xyzd50.Get();
  *output = SkcmsMatrix3x3DataView(pointer, message_);
}



}  // skia::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_SHARED_H_