// services/webnn/public/mojom/webnn_graph_builder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-params-data.h"
namespace webnn {
namespace mojom {

namespace internal {
// static
bool WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data* object = static_cast<const WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebNNGraphBuilder_CreateGraph_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool CreateGraphSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateGraphSuccess_Data* object =
      static_cast<const CreateGraphSuccess_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->graph_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->graph_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::webnn::mojom::internal::Device_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

CreateGraphSuccess_Data::CreateGraphSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNGraphBuilder_CreatePendingConstant_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNGraphBuilder_CreatePendingConstant_Params_Data* object =
      static_cast<const WebNNGraphBuilder_CreatePendingConstant_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constant_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constant_handle, validation_context))
    return false;


  if (!::webnn::mojom::internal::DataType_Data
        ::Validate(object->data_type, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

WebNNGraphBuilder_CreatePendingConstant_Params_Data::WebNNGraphBuilder_CreatePendingConstant_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNGraphBuilder_CreateGraph_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNGraphBuilder_CreateGraph_Params_Data* object =
      static_cast<const WebNNGraphBuilder_CreateGraph_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->graph_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->graph_info, validation_context))
    return false;

  return true;
}

WebNNGraphBuilder_CreateGraph_Params_Data::WebNNGraphBuilder_CreateGraph_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNGraphBuilder_CreateGraph_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNGraphBuilder_CreateGraph_ResponseParams_Data* object =
      static_cast<const WebNNGraphBuilder_CreateGraph_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebNNGraphBuilder_CreateGraph_ResponseParams_Data::WebNNGraphBuilder_CreateGraph_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNGraphBuilder_IsValidGraphForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNGraphBuilder_IsValidGraphForTesting_Params_Data* object =
      static_cast<const WebNNGraphBuilder_IsValidGraphForTesting_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context_properties, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->graph_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->graph_info, validation_context))
    return false;

  return true;
}

WebNNGraphBuilder_IsValidGraphForTesting_Params_Data::WebNNGraphBuilder_IsValidGraphForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data* object =
      static_cast<const WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data*>(data);

  return true;
}

WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data::WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webnn