// services/webnn/public/mojom/webnn_graph_builder.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_SEND_VALIDATION_H_

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_device.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::CreateGraphSuccessDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateGraphSuccessDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateGraphSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::graph_remote(input)) in_graph_remote = Traits::graph_remote(input);

      
      mojo::internal::Serialize<::webnn::mojom::WebNNGraphAssociatedPtrInfoDataView>(
        in_graph_remote,
        &fragment->graph_remote,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->graph_remote)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid graph_remote in CreateGraphSuccess struct");

      decltype(Traits::devices(input)) in_devices = Traits::devices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->devices)::BaseType>
          devices_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::webnn::mojom::internal::Device_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::Device>, send_validation>(
        in_devices,
        devices_fragment,
        &devices_validate_params);

      fragment->devices.Set(
          devices_fragment.is_null() ? nullptr : devices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->devices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devices in CreateGraphSuccess struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::CreateGraphSuccessDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in WebNNGraphBuilder_CreateGraph_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in WebNNGraphBuilder_CreateGraph_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_SEND_VALIDATION_H_