// services/webnn/public/mojom/webnn_error.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_error.mojom-params-data.h"
namespace webnn {
namespace mojom {

NOINLINE static const char* Error_CodeToStringHelper(Error_Code value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Error_Code::kUnknownError:
      return "kUnknownError";
    case Error_Code::kNotSupportedError:
      return "kNotSupportedError";
    default:
      return nullptr;
  }
}

std::string Error_CodeToString(Error_Code value) {
  const char *str = Error_CodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Error_Code value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Error_Code value) {
  return os << Error_CodeToString(value);
}

namespace internal {


// static
bool Error_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Error_Data* object =
      static_cast<const Error_Data*>(data);


  if (!::webnn::mojom::internal::Error_Code_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

Error_Data::Error_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webnn

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::Error_Code>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::Error_Code value) {
  return std::move(context).WriteString(::webnn::mojom::Error_CodeToString(value));
}

} // namespace perfetto