// services/webnn/public/mojom/webnn_context_properties.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_BLINK_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_context_properties.mojom-features.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_context_properties.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/webnn/public/mojom/context_properties_mojom_traits.h"
#include "services/webnn/public/mojom/data_type_limits_mojom_traits.h"
#include "services/webnn/public/mojom/number_mojom_traits.h"
#include "services/webnn/public/mojom/operand_descriptor_mojom_traits.h"
#include "services/webnn/public/mojom/operand_id_mojom_traits.h"
#include "services/webnn/public/mojom/range_traits.h"
#include "services/webnn/public/mojom/supported_data_types_mojom_traits.h"
#include "services/webnn/public/mojom/supported_tensors_mojom_traits.h"
#include "services/webnn/public/mojom/tensor_usage_mojom_traits.h"
#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace webnn::mojom::blink {






class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) SupportedRanks {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupportedRanks, T>::value>;
  using DataView = SupportedRanksDataView;
  using Data_ = internal::SupportedRanks_Data;

  template <typename... Args>
  static SupportedRanksPtr New(Args&&... args) {
    return SupportedRanksPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupportedRanksPtr From(const U& u) {
    return mojo::TypeConverter<SupportedRanksPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupportedRanks>::Convert(*this);
  }


  SupportedRanks();

  SupportedRanks(
      uint32_t min,
      uint32_t max);


  ~SupportedRanks();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupportedRanksPtr>
  SupportedRanksPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupportedRanks::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupportedRanks::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupportedRanks::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedRanks::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedRanks::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupportedRanks::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupportedRanks_UnserializedMessageContext<
            UserType, SupportedRanks::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupportedRanks::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupportedRanks::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupportedRanks_UnserializedMessageContext<
            UserType, SupportedRanks::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupportedRanks::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t min;
  
  uint32_t max;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupportedRanks::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupportedRanks::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupportedRanks::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupportedRanks::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) SupportedDataTypes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupportedDataTypes, T>::value>;
  using DataView = SupportedDataTypesDataView;
  using Data_ = internal::SupportedDataTypes_Data;

  template <typename... Args>
  static SupportedDataTypesPtr New(Args&&... args) {
    return SupportedDataTypesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupportedDataTypesPtr From(const U& u) {
    return mojo::TypeConverter<SupportedDataTypesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupportedDataTypes>::Convert(*this);
  }


  SupportedDataTypes();

  SupportedDataTypes(
      bool float32,
      bool float16,
      bool int32,
      bool uint32,
      bool int64,
      bool uint64,
      bool int8,
      bool uint8,
      bool int4,
      bool uint4);


  ~SupportedDataTypes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupportedDataTypesPtr>
  SupportedDataTypesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupportedDataTypes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupportedDataTypes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupportedDataTypes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedDataTypes::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedDataTypes::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupportedDataTypes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupportedDataTypes_UnserializedMessageContext<
            UserType, SupportedDataTypes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupportedDataTypes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupportedDataTypes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupportedDataTypes_UnserializedMessageContext<
            UserType, SupportedDataTypes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupportedDataTypes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool float32;
  
  bool float16;
  
  bool int32;
  
  bool uint32;
  
  bool int64;
  
  bool uint64;
  
  bool int8;
  
  bool uint8;
  
  bool int4;
  
  bool uint4;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupportedDataTypes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupportedDataTypes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupportedDataTypes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupportedDataTypes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) SupportedTensors {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupportedTensors, T>::value>;
  using DataView = SupportedTensorsDataView;
  using Data_ = internal::SupportedTensors_Data;

  template <typename... Args>
  static SupportedTensorsPtr New(Args&&... args) {
    return SupportedTensorsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupportedTensorsPtr From(const U& u) {
    return mojo::TypeConverter<SupportedTensorsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupportedTensors>::Convert(*this);
  }


  SupportedTensors();

  SupportedTensors(
      const ::webnn::SupportedDataTypes& data_types,
      const ::webnn::SupportedRanks& ranks);


  ~SupportedTensors();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupportedTensorsPtr>
  SupportedTensorsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupportedTensors::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupportedTensors::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupportedTensors::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedTensors::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedTensors::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupportedTensors::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupportedTensors_UnserializedMessageContext<
            UserType, SupportedTensors::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupportedTensors::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupportedTensors::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupportedTensors_UnserializedMessageContext<
            UserType, SupportedTensors::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupportedTensors::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::SupportedDataTypes data_types;
  
  ::webnn::SupportedRanks ranks;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupportedTensors::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupportedTensors::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupportedTensors::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupportedTensors::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) DataTypeLimits {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataTypeLimits, T>::value>;
  using DataView = DataTypeLimitsDataView;
  using Data_ = internal::DataTypeLimits_Data;

  template <typename... Args>
  static DataTypeLimitsPtr New(Args&&... args) {
    return DataTypeLimitsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataTypeLimitsPtr From(const U& u) {
    return mojo::TypeConverter<DataTypeLimitsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataTypeLimits>::Convert(*this);
  }


  DataTypeLimits();

  DataTypeLimits(
      const ::webnn::SupportedTensors& input,
      const ::webnn::SupportedTensors& constant,
      const ::webnn::SupportedTensors& arg_min_max_input,
      const ::webnn::SupportedTensors& arg_min_max_output,
      const ::webnn::SupportedTensors& batch_normalization_input,
      const ::webnn::SupportedTensors& batch_normalization_mean,
      const ::webnn::SupportedTensors& cast_input,
      const ::webnn::SupportedTensors& clamp_input,
      const ::webnn::SupportedTensors& concat_inputs,
      const ::webnn::SupportedTensors& conv2d_input,
      const ::webnn::SupportedTensors& conv2d_bias,
      const ::webnn::SupportedTensors& conv_transpose2d_input,
      const ::webnn::SupportedTensors& conv_transpose2d_bias,
      const ::webnn::SupportedTensors& cumulative_sum_input,
      const ::webnn::SupportedTensors& dequantize_linear_input,
      const ::webnn::SupportedTensors& dequantize_linear_scale,
      const ::webnn::SupportedTensors& dequantize_linear_zero_point,
      const ::webnn::SupportedTensors& add_input,
      const ::webnn::SupportedTensors& sub_input,
      const ::webnn::SupportedTensors& mul_input,
      const ::webnn::SupportedTensors& div_input,
      const ::webnn::SupportedTensors& max_input,
      const ::webnn::SupportedTensors& min_input,
      const ::webnn::SupportedTensors& pow_input,
      const ::webnn::SupportedTensors& equal_input,
      const ::webnn::SupportedTensors& greater_input,
      const ::webnn::SupportedTensors& greater_or_equal_input,
      const ::webnn::SupportedTensors& lesser_input,
      const ::webnn::SupportedTensors& lesser_or_equal_input,
      const ::webnn::SupportedTensors& not_equal_input,
      const ::webnn::SupportedTensors& logical_and_input,
      const ::webnn::SupportedTensors& logical_or_input,
      const ::webnn::SupportedTensors& logical_xor_input,
      const ::webnn::SupportedTensors& logical_not_input,
      const ::webnn::SupportedTensors& is_nan_input,
      const ::webnn::SupportedTensors& is_infinite_input,
      const ::webnn::SupportedDataTypes& logical_output,
      const ::webnn::SupportedTensors& abs_input,
      const ::webnn::SupportedTensors& ceil_input,
      const ::webnn::SupportedTensors& cos_input,
      const ::webnn::SupportedTensors& erf_input,
      const ::webnn::SupportedTensors& exp_input,
      const ::webnn::SupportedTensors& floor_input,
      const ::webnn::SupportedTensors& identity_input,
      const ::webnn::SupportedTensors& log_input,
      const ::webnn::SupportedTensors& neg_input,
      const ::webnn::SupportedTensors& reciprocal_input,
      const ::webnn::SupportedTensors& round_even_input,
      const ::webnn::SupportedTensors& sign_input,
      const ::webnn::SupportedTensors& sin_input,
      const ::webnn::SupportedTensors& sqrt_input,
      const ::webnn::SupportedTensors& tan_input,
      const ::webnn::SupportedTensors& elu_input,
      const ::webnn::SupportedTensors& expand_input,
      const ::webnn::SupportedTensors& gather_input,
      const ::webnn::SupportedTensors& gather_indices,
      const ::webnn::SupportedTensors& gather_elements_input,
      const ::webnn::SupportedTensors& gather_elements_indices,
      const ::webnn::SupportedTensors& gather_nd_input,
      const ::webnn::SupportedTensors& gather_nd_indices,
      const ::webnn::SupportedTensors& gelu_input,
      const ::webnn::SupportedTensors& gemm_a,
      const ::webnn::SupportedTensors& gemm_c,
      const ::webnn::SupportedTensors& gru_input,
      const ::webnn::SupportedTensors& gru_bias,
      const ::webnn::SupportedTensors& gru_output_sequence,
      const ::webnn::SupportedTensors& gru_cell_input,
      const ::webnn::SupportedTensors& gru_cell_bias,
      const ::webnn::SupportedTensors& hard_sigmoid_input,
      const ::webnn::SupportedTensors& hard_swish_input,
      const ::webnn::SupportedTensors& instance_normalization_input,
      const ::webnn::SupportedTensors& instance_normalization_scale,
      const ::webnn::SupportedTensors& layer_normalization_input,
      const ::webnn::SupportedTensors& leaky_relu_input,
      const ::webnn::SupportedTensors& linear_input,
      const ::webnn::SupportedTensors& lstm_input,
      const ::webnn::SupportedTensors& lstm_bias,
      const ::webnn::SupportedTensors& lstm_output_sequence,
      const ::webnn::SupportedTensors& lstm_cell_input,
      const ::webnn::SupportedTensors& lstm_cell_bias,
      const ::webnn::SupportedTensors& matmul_input,
      const ::webnn::SupportedTensors& pad_input,
      const ::webnn::SupportedTensors& average_pool2d_input,
      const ::webnn::SupportedTensors& l2_pool2d_input,
      const ::webnn::SupportedTensors& max_pool2d_input,
      const ::webnn::SupportedTensors& prelu_input,
      const ::webnn::SupportedTensors& quantize_linear_input,
      const ::webnn::SupportedTensors& quantize_linear_zero_point,
      const ::webnn::SupportedTensors& reduce_l1_input,
      const ::webnn::SupportedTensors& reduce_l2_input,
      const ::webnn::SupportedTensors& reduce_log_sum_input,
      const ::webnn::SupportedTensors& reduce_log_sum_exp_input,
      const ::webnn::SupportedTensors& reduce_max_input,
      const ::webnn::SupportedTensors& reduce_mean_input,
      const ::webnn::SupportedTensors& reduce_min_input,
      const ::webnn::SupportedTensors& reduce_product_input,
      const ::webnn::SupportedTensors& reduce_sum_input,
      const ::webnn::SupportedTensors& reduce_sum_square_input,
      const ::webnn::SupportedTensors& relu_input,
      const ::webnn::SupportedTensors& resample2d_input,
      const ::webnn::SupportedTensors& reshape_input,
      const ::webnn::SupportedTensors& reverse_input,
      const ::webnn::SupportedTensors& scatter_elements_input,
      const ::webnn::SupportedTensors& scatter_elements_indices,
      const ::webnn::SupportedTensors& scatter_nd_input,
      const ::webnn::SupportedTensors& scatter_nd_indices,
      const ::webnn::SupportedTensors& scatter_nd_updates,
      const ::webnn::SupportedTensors& sigmoid_input,
      const ::webnn::SupportedTensors& slice_input,
      const ::webnn::SupportedTensors& softmax_input,
      const ::webnn::SupportedTensors& softplus_input,
      const ::webnn::SupportedTensors& softsign_input,
      const ::webnn::SupportedTensors& split_input,
      const ::webnn::SupportedTensors& tanh_input,
      const ::webnn::SupportedTensors& tile_input,
      const ::webnn::SupportedTensors& transpose_input,
      const ::webnn::SupportedTensors& triangular_input,
      const ::webnn::SupportedTensors& where_condition,
      const ::webnn::SupportedTensors& where_value);


  ~DataTypeLimits();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataTypeLimitsPtr>
  DataTypeLimitsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataTypeLimits::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataTypeLimits::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataTypeLimits::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataTypeLimits::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataTypeLimits::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataTypeLimits::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataTypeLimits_UnserializedMessageContext<
            UserType, DataTypeLimits::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataTypeLimits::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataTypeLimits::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataTypeLimits_UnserializedMessageContext<
            UserType, DataTypeLimits::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataTypeLimits::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::SupportedTensors input;
  
  ::webnn::SupportedTensors constant;
  
  ::webnn::SupportedTensors arg_min_max_input;
  
  ::webnn::SupportedTensors arg_min_max_output;
  
  ::webnn::SupportedTensors batch_normalization_input;
  
  ::webnn::SupportedTensors batch_normalization_mean;
  
  ::webnn::SupportedTensors cast_input;
  
  ::webnn::SupportedTensors clamp_input;
  
  ::webnn::SupportedTensors concat_inputs;
  
  ::webnn::SupportedTensors conv2d_input;
  
  ::webnn::SupportedTensors conv2d_bias;
  
  ::webnn::SupportedTensors conv_transpose2d_input;
  
  ::webnn::SupportedTensors conv_transpose2d_bias;
  
  ::webnn::SupportedTensors cumulative_sum_input;
  
  ::webnn::SupportedTensors dequantize_linear_input;
  
  ::webnn::SupportedTensors dequantize_linear_scale;
  
  ::webnn::SupportedTensors dequantize_linear_zero_point;
  
  ::webnn::SupportedTensors add_input;
  
  ::webnn::SupportedTensors sub_input;
  
  ::webnn::SupportedTensors mul_input;
  
  ::webnn::SupportedTensors div_input;
  
  ::webnn::SupportedTensors max_input;
  
  ::webnn::SupportedTensors min_input;
  
  ::webnn::SupportedTensors pow_input;
  
  ::webnn::SupportedTensors equal_input;
  
  ::webnn::SupportedTensors greater_input;
  
  ::webnn::SupportedTensors greater_or_equal_input;
  
  ::webnn::SupportedTensors lesser_input;
  
  ::webnn::SupportedTensors lesser_or_equal_input;
  
  ::webnn::SupportedTensors not_equal_input;
  
  ::webnn::SupportedTensors logical_and_input;
  
  ::webnn::SupportedTensors logical_or_input;
  
  ::webnn::SupportedTensors logical_xor_input;
  
  ::webnn::SupportedTensors logical_not_input;
  
  ::webnn::SupportedTensors is_nan_input;
  
  ::webnn::SupportedTensors is_infinite_input;
  
  ::webnn::SupportedDataTypes logical_output;
  
  ::webnn::SupportedTensors abs_input;
  
  ::webnn::SupportedTensors ceil_input;
  
  ::webnn::SupportedTensors cos_input;
  
  ::webnn::SupportedTensors erf_input;
  
  ::webnn::SupportedTensors exp_input;
  
  ::webnn::SupportedTensors floor_input;
  
  ::webnn::SupportedTensors identity_input;
  
  ::webnn::SupportedTensors log_input;
  
  ::webnn::SupportedTensors neg_input;
  
  ::webnn::SupportedTensors reciprocal_input;
  
  ::webnn::SupportedTensors round_even_input;
  
  ::webnn::SupportedTensors sign_input;
  
  ::webnn::SupportedTensors sin_input;
  
  ::webnn::SupportedTensors sqrt_input;
  
  ::webnn::SupportedTensors tan_input;
  
  ::webnn::SupportedTensors elu_input;
  
  ::webnn::SupportedTensors expand_input;
  
  ::webnn::SupportedTensors gather_input;
  
  ::webnn::SupportedTensors gather_indices;
  
  ::webnn::SupportedTensors gather_elements_input;
  
  ::webnn::SupportedTensors gather_elements_indices;
  
  ::webnn::SupportedTensors gather_nd_input;
  
  ::webnn::SupportedTensors gather_nd_indices;
  
  ::webnn::SupportedTensors gelu_input;
  
  ::webnn::SupportedTensors gemm_a;
  
  ::webnn::SupportedTensors gemm_c;
  
  ::webnn::SupportedTensors gru_input;
  
  ::webnn::SupportedTensors gru_bias;
  
  ::webnn::SupportedTensors gru_output_sequence;
  
  ::webnn::SupportedTensors gru_cell_input;
  
  ::webnn::SupportedTensors gru_cell_bias;
  
  ::webnn::SupportedTensors hard_sigmoid_input;
  
  ::webnn::SupportedTensors hard_swish_input;
  
  ::webnn::SupportedTensors instance_normalization_input;
  
  ::webnn::SupportedTensors instance_normalization_scale;
  
  ::webnn::SupportedTensors layer_normalization_input;
  
  ::webnn::SupportedTensors leaky_relu_input;
  
  ::webnn::SupportedTensors linear_input;
  
  ::webnn::SupportedTensors lstm_input;
  
  ::webnn::SupportedTensors lstm_bias;
  
  ::webnn::SupportedTensors lstm_output_sequence;
  
  ::webnn::SupportedTensors lstm_cell_input;
  
  ::webnn::SupportedTensors lstm_cell_bias;
  
  ::webnn::SupportedTensors matmul_input;
  
  ::webnn::SupportedTensors pad_input;
  
  ::webnn::SupportedTensors average_pool2d_input;
  
  ::webnn::SupportedTensors l2_pool2d_input;
  
  ::webnn::SupportedTensors max_pool2d_input;
  
  ::webnn::SupportedTensors prelu_input;
  
  ::webnn::SupportedTensors quantize_linear_input;
  
  ::webnn::SupportedTensors quantize_linear_zero_point;
  
  ::webnn::SupportedTensors reduce_l1_input;
  
  ::webnn::SupportedTensors reduce_l2_input;
  
  ::webnn::SupportedTensors reduce_log_sum_input;
  
  ::webnn::SupportedTensors reduce_log_sum_exp_input;
  
  ::webnn::SupportedTensors reduce_max_input;
  
  ::webnn::SupportedTensors reduce_mean_input;
  
  ::webnn::SupportedTensors reduce_min_input;
  
  ::webnn::SupportedTensors reduce_product_input;
  
  ::webnn::SupportedTensors reduce_sum_input;
  
  ::webnn::SupportedTensors reduce_sum_square_input;
  
  ::webnn::SupportedTensors relu_input;
  
  ::webnn::SupportedTensors resample2d_input;
  
  ::webnn::SupportedTensors reshape_input;
  
  ::webnn::SupportedTensors reverse_input;
  
  ::webnn::SupportedTensors scatter_elements_input;
  
  ::webnn::SupportedTensors scatter_elements_indices;
  
  ::webnn::SupportedTensors scatter_nd_input;
  
  ::webnn::SupportedTensors scatter_nd_indices;
  
  ::webnn::SupportedTensors scatter_nd_updates;
  
  ::webnn::SupportedTensors sigmoid_input;
  
  ::webnn::SupportedTensors slice_input;
  
  ::webnn::SupportedTensors softmax_input;
  
  ::webnn::SupportedTensors softplus_input;
  
  ::webnn::SupportedTensors softsign_input;
  
  ::webnn::SupportedTensors split_input;
  
  ::webnn::SupportedTensors tanh_input;
  
  ::webnn::SupportedTensors tile_input;
  
  ::webnn::SupportedTensors transpose_input;
  
  ::webnn::SupportedTensors triangular_input;
  
  ::webnn::SupportedTensors where_condition;
  
  ::webnn::SupportedTensors where_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataTypeLimits::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataTypeLimits::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataTypeLimits::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataTypeLimits::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) ContextProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContextProperties, T>::value>;
  using DataView = ContextPropertiesDataView;
  using Data_ = internal::ContextProperties_Data;

  template <typename... Args>
  static ContextPropertiesPtr New(Args&&... args) {
    return ContextPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContextPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<ContextPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContextProperties>::Convert(*this);
  }


  ContextProperties();

  ContextProperties(
      InputOperandLayout input_operand_layout,
      Resample2DAxes resample_2d_axes,
      BatchNormalizationAxis batch_normalization_axis,
      uint64_t tensor_byte_length_limit,
      const ::webnn::DataTypeLimits& data_type_limits);


  ~ContextProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContextPropertiesPtr>
  ContextPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContextProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContextProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContextProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContextProperties::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContextProperties::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContextProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContextProperties_UnserializedMessageContext<
            UserType, ContextProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContextProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContextProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContextProperties_UnserializedMessageContext<
            UserType, ContextProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContextProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  InputOperandLayout input_operand_layout;
  
  Resample2DAxes resample_2d_axes;
  
  BatchNormalizationAxis batch_normalization_axis;
  
  uint64_t tensor_byte_length_limit;
  
  ::webnn::DataTypeLimits data_type_limits;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContextProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContextProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContextProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContextProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SupportedDataTypesPtr SupportedDataTypes::Clone() const {
  return New(
      mojo::Clone(float32),
      mojo::Clone(float16),
      mojo::Clone(int32),
      mojo::Clone(uint32),
      mojo::Clone(int64),
      mojo::Clone(uint64),
      mojo::Clone(int8),
      mojo::Clone(uint8),
      mojo::Clone(int4),
      mojo::Clone(uint4)
  );
}

template <typename T, SupportedDataTypes::EnableIfSame<T>*>
bool SupportedDataTypes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->float32, other_struct.float32))
    return false;
  if (!mojo::Equals(this->float16, other_struct.float16))
    return false;
  if (!mojo::Equals(this->int32, other_struct.int32))
    return false;
  if (!mojo::Equals(this->uint32, other_struct.uint32))
    return false;
  if (!mojo::Equals(this->int64, other_struct.int64))
    return false;
  if (!mojo::Equals(this->uint64, other_struct.uint64))
    return false;
  if (!mojo::Equals(this->int8, other_struct.int8))
    return false;
  if (!mojo::Equals(this->uint8, other_struct.uint8))
    return false;
  if (!mojo::Equals(this->int4, other_struct.int4))
    return false;
  if (!mojo::Equals(this->uint4, other_struct.uint4))
    return false;
  return true;
}

template <typename T, SupportedDataTypes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.float32 < rhs.float32)
    return true;
  if (rhs.float32 < lhs.float32)
    return false;
  if (lhs.float16 < rhs.float16)
    return true;
  if (rhs.float16 < lhs.float16)
    return false;
  if (lhs.int32 < rhs.int32)
    return true;
  if (rhs.int32 < lhs.int32)
    return false;
  if (lhs.uint32 < rhs.uint32)
    return true;
  if (rhs.uint32 < lhs.uint32)
    return false;
  if (lhs.int64 < rhs.int64)
    return true;
  if (rhs.int64 < lhs.int64)
    return false;
  if (lhs.uint64 < rhs.uint64)
    return true;
  if (rhs.uint64 < lhs.uint64)
    return false;
  if (lhs.int8 < rhs.int8)
    return true;
  if (rhs.int8 < lhs.int8)
    return false;
  if (lhs.uint8 < rhs.uint8)
    return true;
  if (rhs.uint8 < lhs.uint8)
    return false;
  if (lhs.int4 < rhs.int4)
    return true;
  if (rhs.int4 < lhs.int4)
    return false;
  if (lhs.uint4 < rhs.uint4)
    return true;
  if (rhs.uint4 < lhs.uint4)
    return false;
  return false;
}
template <typename StructPtrType>
SupportedRanksPtr SupportedRanks::Clone() const {
  return New(
      mojo::Clone(min),
      mojo::Clone(max)
  );
}

template <typename T, SupportedRanks::EnableIfSame<T>*>
bool SupportedRanks::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->min, other_struct.min))
    return false;
  if (!mojo::Equals(this->max, other_struct.max))
    return false;
  return true;
}

template <typename T, SupportedRanks::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.min < rhs.min)
    return true;
  if (rhs.min < lhs.min)
    return false;
  if (lhs.max < rhs.max)
    return true;
  if (rhs.max < lhs.max)
    return false;
  return false;
}
template <typename StructPtrType>
SupportedTensorsPtr SupportedTensors::Clone() const {
  return New(
      mojo::Clone(data_types),
      mojo::Clone(ranks)
  );
}

template <typename T, SupportedTensors::EnableIfSame<T>*>
bool SupportedTensors::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_types, other_struct.data_types))
    return false;
  if (!mojo::Equals(this->ranks, other_struct.ranks))
    return false;
  return true;
}

template <typename T, SupportedTensors::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_types < rhs.data_types)
    return true;
  if (rhs.data_types < lhs.data_types)
    return false;
  if (lhs.ranks < rhs.ranks)
    return true;
  if (rhs.ranks < lhs.ranks)
    return false;
  return false;
}
template <typename StructPtrType>
DataTypeLimitsPtr DataTypeLimits::Clone() const {
  return New(
      mojo::Clone(input),
      mojo::Clone(constant),
      mojo::Clone(arg_min_max_input),
      mojo::Clone(arg_min_max_output),
      mojo::Clone(batch_normalization_input),
      mojo::Clone(batch_normalization_mean),
      mojo::Clone(cast_input),
      mojo::Clone(clamp_input),
      mojo::Clone(concat_inputs),
      mojo::Clone(conv2d_input),
      mojo::Clone(conv2d_bias),
      mojo::Clone(conv_transpose2d_input),
      mojo::Clone(conv_transpose2d_bias),
      mojo::Clone(cumulative_sum_input),
      mojo::Clone(dequantize_linear_input),
      mojo::Clone(dequantize_linear_scale),
      mojo::Clone(dequantize_linear_zero_point),
      mojo::Clone(add_input),
      mojo::Clone(sub_input),
      mojo::Clone(mul_input),
      mojo::Clone(div_input),
      mojo::Clone(max_input),
      mojo::Clone(min_input),
      mojo::Clone(pow_input),
      mojo::Clone(equal_input),
      mojo::Clone(greater_input),
      mojo::Clone(greater_or_equal_input),
      mojo::Clone(lesser_input),
      mojo::Clone(lesser_or_equal_input),
      mojo::Clone(not_equal_input),
      mojo::Clone(logical_and_input),
      mojo::Clone(logical_or_input),
      mojo::Clone(logical_xor_input),
      mojo::Clone(logical_not_input),
      mojo::Clone(is_nan_input),
      mojo::Clone(is_infinite_input),
      mojo::Clone(logical_output),
      mojo::Clone(abs_input),
      mojo::Clone(ceil_input),
      mojo::Clone(cos_input),
      mojo::Clone(erf_input),
      mojo::Clone(exp_input),
      mojo::Clone(floor_input),
      mojo::Clone(identity_input),
      mojo::Clone(log_input),
      mojo::Clone(neg_input),
      mojo::Clone(reciprocal_input),
      mojo::Clone(round_even_input),
      mojo::Clone(sign_input),
      mojo::Clone(sin_input),
      mojo::Clone(sqrt_input),
      mojo::Clone(tan_input),
      mojo::Clone(elu_input),
      mojo::Clone(expand_input),
      mojo::Clone(gather_input),
      mojo::Clone(gather_indices),
      mojo::Clone(gather_elements_input),
      mojo::Clone(gather_elements_indices),
      mojo::Clone(gather_nd_input),
      mojo::Clone(gather_nd_indices),
      mojo::Clone(gelu_input),
      mojo::Clone(gemm_a),
      mojo::Clone(gemm_c),
      mojo::Clone(gru_input),
      mojo::Clone(gru_bias),
      mojo::Clone(gru_output_sequence),
      mojo::Clone(gru_cell_input),
      mojo::Clone(gru_cell_bias),
      mojo::Clone(hard_sigmoid_input),
      mojo::Clone(hard_swish_input),
      mojo::Clone(instance_normalization_input),
      mojo::Clone(instance_normalization_scale),
      mojo::Clone(layer_normalization_input),
      mojo::Clone(leaky_relu_input),
      mojo::Clone(linear_input),
      mojo::Clone(lstm_input),
      mojo::Clone(lstm_bias),
      mojo::Clone(lstm_output_sequence),
      mojo::Clone(lstm_cell_input),
      mojo::Clone(lstm_cell_bias),
      mojo::Clone(matmul_input),
      mojo::Clone(pad_input),
      mojo::Clone(average_pool2d_input),
      mojo::Clone(l2_pool2d_input),
      mojo::Clone(max_pool2d_input),
      mojo::Clone(prelu_input),
      mojo::Clone(quantize_linear_input),
      mojo::Clone(quantize_linear_zero_point),
      mojo::Clone(reduce_l1_input),
      mojo::Clone(reduce_l2_input),
      mojo::Clone(reduce_log_sum_input),
      mojo::Clone(reduce_log_sum_exp_input),
      mojo::Clone(reduce_max_input),
      mojo::Clone(reduce_mean_input),
      mojo::Clone(reduce_min_input),
      mojo::Clone(reduce_product_input),
      mojo::Clone(reduce_sum_input),
      mojo::Clone(reduce_sum_square_input),
      mojo::Clone(relu_input),
      mojo::Clone(resample2d_input),
      mojo::Clone(reshape_input),
      mojo::Clone(reverse_input),
      mojo::Clone(scatter_elements_input),
      mojo::Clone(scatter_elements_indices),
      mojo::Clone(scatter_nd_input),
      mojo::Clone(scatter_nd_indices),
      mojo::Clone(scatter_nd_updates),
      mojo::Clone(sigmoid_input),
      mojo::Clone(slice_input),
      mojo::Clone(softmax_input),
      mojo::Clone(softplus_input),
      mojo::Clone(softsign_input),
      mojo::Clone(split_input),
      mojo::Clone(tanh_input),
      mojo::Clone(tile_input),
      mojo::Clone(transpose_input),
      mojo::Clone(triangular_input),
      mojo::Clone(where_condition),
      mojo::Clone(where_value)
  );
}

template <typename T, DataTypeLimits::EnableIfSame<T>*>
bool DataTypeLimits::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  if (!mojo::Equals(this->constant, other_struct.constant))
    return false;
  if (!mojo::Equals(this->arg_min_max_input, other_struct.arg_min_max_input))
    return false;
  if (!mojo::Equals(this->arg_min_max_output, other_struct.arg_min_max_output))
    return false;
  if (!mojo::Equals(this->batch_normalization_input, other_struct.batch_normalization_input))
    return false;
  if (!mojo::Equals(this->batch_normalization_mean, other_struct.batch_normalization_mean))
    return false;
  if (!mojo::Equals(this->cast_input, other_struct.cast_input))
    return false;
  if (!mojo::Equals(this->clamp_input, other_struct.clamp_input))
    return false;
  if (!mojo::Equals(this->concat_inputs, other_struct.concat_inputs))
    return false;
  if (!mojo::Equals(this->conv2d_input, other_struct.conv2d_input))
    return false;
  if (!mojo::Equals(this->conv2d_bias, other_struct.conv2d_bias))
    return false;
  if (!mojo::Equals(this->conv_transpose2d_input, other_struct.conv_transpose2d_input))
    return false;
  if (!mojo::Equals(this->conv_transpose2d_bias, other_struct.conv_transpose2d_bias))
    return false;
  if (!mojo::Equals(this->cumulative_sum_input, other_struct.cumulative_sum_input))
    return false;
  if (!mojo::Equals(this->dequantize_linear_input, other_struct.dequantize_linear_input))
    return false;
  if (!mojo::Equals(this->dequantize_linear_scale, other_struct.dequantize_linear_scale))
    return false;
  if (!mojo::Equals(this->dequantize_linear_zero_point, other_struct.dequantize_linear_zero_point))
    return false;
  if (!mojo::Equals(this->add_input, other_struct.add_input))
    return false;
  if (!mojo::Equals(this->sub_input, other_struct.sub_input))
    return false;
  if (!mojo::Equals(this->mul_input, other_struct.mul_input))
    return false;
  if (!mojo::Equals(this->div_input, other_struct.div_input))
    return false;
  if (!mojo::Equals(this->max_input, other_struct.max_input))
    return false;
  if (!mojo::Equals(this->min_input, other_struct.min_input))
    return false;
  if (!mojo::Equals(this->pow_input, other_struct.pow_input))
    return false;
  if (!mojo::Equals(this->equal_input, other_struct.equal_input))
    return false;
  if (!mojo::Equals(this->greater_input, other_struct.greater_input))
    return false;
  if (!mojo::Equals(this->greater_or_equal_input, other_struct.greater_or_equal_input))
    return false;
  if (!mojo::Equals(this->lesser_input, other_struct.lesser_input))
    return false;
  if (!mojo::Equals(this->lesser_or_equal_input, other_struct.lesser_or_equal_input))
    return false;
  if (!mojo::Equals(this->not_equal_input, other_struct.not_equal_input))
    return false;
  if (!mojo::Equals(this->logical_and_input, other_struct.logical_and_input))
    return false;
  if (!mojo::Equals(this->logical_or_input, other_struct.logical_or_input))
    return false;
  if (!mojo::Equals(this->logical_xor_input, other_struct.logical_xor_input))
    return false;
  if (!mojo::Equals(this->logical_not_input, other_struct.logical_not_input))
    return false;
  if (!mojo::Equals(this->is_nan_input, other_struct.is_nan_input))
    return false;
  if (!mojo::Equals(this->is_infinite_input, other_struct.is_infinite_input))
    return false;
  if (!mojo::Equals(this->logical_output, other_struct.logical_output))
    return false;
  if (!mojo::Equals(this->abs_input, other_struct.abs_input))
    return false;
  if (!mojo::Equals(this->ceil_input, other_struct.ceil_input))
    return false;
  if (!mojo::Equals(this->cos_input, other_struct.cos_input))
    return false;
  if (!mojo::Equals(this->erf_input, other_struct.erf_input))
    return false;
  if (!mojo::Equals(this->exp_input, other_struct.exp_input))
    return false;
  if (!mojo::Equals(this->floor_input, other_struct.floor_input))
    return false;
  if (!mojo::Equals(this->identity_input, other_struct.identity_input))
    return false;
  if (!mojo::Equals(this->log_input, other_struct.log_input))
    return false;
  if (!mojo::Equals(this->neg_input, other_struct.neg_input))
    return false;
  if (!mojo::Equals(this->reciprocal_input, other_struct.reciprocal_input))
    return false;
  if (!mojo::Equals(this->round_even_input, other_struct.round_even_input))
    return false;
  if (!mojo::Equals(this->sign_input, other_struct.sign_input))
    return false;
  if (!mojo::Equals(this->sin_input, other_struct.sin_input))
    return false;
  if (!mojo::Equals(this->sqrt_input, other_struct.sqrt_input))
    return false;
  if (!mojo::Equals(this->tan_input, other_struct.tan_input))
    return false;
  if (!mojo::Equals(this->elu_input, other_struct.elu_input))
    return false;
  if (!mojo::Equals(this->expand_input, other_struct.expand_input))
    return false;
  if (!mojo::Equals(this->gather_input, other_struct.gather_input))
    return false;
  if (!mojo::Equals(this->gather_indices, other_struct.gather_indices))
    return false;
  if (!mojo::Equals(this->gather_elements_input, other_struct.gather_elements_input))
    return false;
  if (!mojo::Equals(this->gather_elements_indices, other_struct.gather_elements_indices))
    return false;
  if (!mojo::Equals(this->gather_nd_input, other_struct.gather_nd_input))
    return false;
  if (!mojo::Equals(this->gather_nd_indices, other_struct.gather_nd_indices))
    return false;
  if (!mojo::Equals(this->gelu_input, other_struct.gelu_input))
    return false;
  if (!mojo::Equals(this->gemm_a, other_struct.gemm_a))
    return false;
  if (!mojo::Equals(this->gemm_c, other_struct.gemm_c))
    return false;
  if (!mojo::Equals(this->gru_input, other_struct.gru_input))
    return false;
  if (!mojo::Equals(this->gru_bias, other_struct.gru_bias))
    return false;
  if (!mojo::Equals(this->gru_output_sequence, other_struct.gru_output_sequence))
    return false;
  if (!mojo::Equals(this->gru_cell_input, other_struct.gru_cell_input))
    return false;
  if (!mojo::Equals(this->gru_cell_bias, other_struct.gru_cell_bias))
    return false;
  if (!mojo::Equals(this->hard_sigmoid_input, other_struct.hard_sigmoid_input))
    return false;
  if (!mojo::Equals(this->hard_swish_input, other_struct.hard_swish_input))
    return false;
  if (!mojo::Equals(this->instance_normalization_input, other_struct.instance_normalization_input))
    return false;
  if (!mojo::Equals(this->instance_normalization_scale, other_struct.instance_normalization_scale))
    return false;
  if (!mojo::Equals(this->layer_normalization_input, other_struct.layer_normalization_input))
    return false;
  if (!mojo::Equals(this->leaky_relu_input, other_struct.leaky_relu_input))
    return false;
  if (!mojo::Equals(this->linear_input, other_struct.linear_input))
    return false;
  if (!mojo::Equals(this->lstm_input, other_struct.lstm_input))
    return false;
  if (!mojo::Equals(this->lstm_bias, other_struct.lstm_bias))
    return false;
  if (!mojo::Equals(this->lstm_output_sequence, other_struct.lstm_output_sequence))
    return false;
  if (!mojo::Equals(this->lstm_cell_input, other_struct.lstm_cell_input))
    return false;
  if (!mojo::Equals(this->lstm_cell_bias, other_struct.lstm_cell_bias))
    return false;
  if (!mojo::Equals(this->matmul_input, other_struct.matmul_input))
    return false;
  if (!mojo::Equals(this->pad_input, other_struct.pad_input))
    return false;
  if (!mojo::Equals(this->average_pool2d_input, other_struct.average_pool2d_input))
    return false;
  if (!mojo::Equals(this->l2_pool2d_input, other_struct.l2_pool2d_input))
    return false;
  if (!mojo::Equals(this->max_pool2d_input, other_struct.max_pool2d_input))
    return false;
  if (!mojo::Equals(this->prelu_input, other_struct.prelu_input))
    return false;
  if (!mojo::Equals(this->quantize_linear_input, other_struct.quantize_linear_input))
    return false;
  if (!mojo::Equals(this->quantize_linear_zero_point, other_struct.quantize_linear_zero_point))
    return false;
  if (!mojo::Equals(this->reduce_l1_input, other_struct.reduce_l1_input))
    return false;
  if (!mojo::Equals(this->reduce_l2_input, other_struct.reduce_l2_input))
    return false;
  if (!mojo::Equals(this->reduce_log_sum_input, other_struct.reduce_log_sum_input))
    return false;
  if (!mojo::Equals(this->reduce_log_sum_exp_input, other_struct.reduce_log_sum_exp_input))
    return false;
  if (!mojo::Equals(this->reduce_max_input, other_struct.reduce_max_input))
    return false;
  if (!mojo::Equals(this->reduce_mean_input, other_struct.reduce_mean_input))
    return false;
  if (!mojo::Equals(this->reduce_min_input, other_struct.reduce_min_input))
    return false;
  if (!mojo::Equals(this->reduce_product_input, other_struct.reduce_product_input))
    return false;
  if (!mojo::Equals(this->reduce_sum_input, other_struct.reduce_sum_input))
    return false;
  if (!mojo::Equals(this->reduce_sum_square_input, other_struct.reduce_sum_square_input))
    return false;
  if (!mojo::Equals(this->relu_input, other_struct.relu_input))
    return false;
  if (!mojo::Equals(this->resample2d_input, other_struct.resample2d_input))
    return false;
  if (!mojo::Equals(this->reshape_input, other_struct.reshape_input))
    return false;
  if (!mojo::Equals(this->reverse_input, other_struct.reverse_input))
    return false;
  if (!mojo::Equals(this->scatter_elements_input, other_struct.scatter_elements_input))
    return false;
  if (!mojo::Equals(this->scatter_elements_indices, other_struct.scatter_elements_indices))
    return false;
  if (!mojo::Equals(this->scatter_nd_input, other_struct.scatter_nd_input))
    return false;
  if (!mojo::Equals(this->scatter_nd_indices, other_struct.scatter_nd_indices))
    return false;
  if (!mojo::Equals(this->scatter_nd_updates, other_struct.scatter_nd_updates))
    return false;
  if (!mojo::Equals(this->sigmoid_input, other_struct.sigmoid_input))
    return false;
  if (!mojo::Equals(this->slice_input, other_struct.slice_input))
    return false;
  if (!mojo::Equals(this->softmax_input, other_struct.softmax_input))
    return false;
  if (!mojo::Equals(this->softplus_input, other_struct.softplus_input))
    return false;
  if (!mojo::Equals(this->softsign_input, other_struct.softsign_input))
    return false;
  if (!mojo::Equals(this->split_input, other_struct.split_input))
    return false;
  if (!mojo::Equals(this->tanh_input, other_struct.tanh_input))
    return false;
  if (!mojo::Equals(this->tile_input, other_struct.tile_input))
    return false;
  if (!mojo::Equals(this->transpose_input, other_struct.transpose_input))
    return false;
  if (!mojo::Equals(this->triangular_input, other_struct.triangular_input))
    return false;
  if (!mojo::Equals(this->where_condition, other_struct.where_condition))
    return false;
  if (!mojo::Equals(this->where_value, other_struct.where_value))
    return false;
  return true;
}

template <typename T, DataTypeLimits::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input < rhs.input)
    return true;
  if (rhs.input < lhs.input)
    return false;
  if (lhs.constant < rhs.constant)
    return true;
  if (rhs.constant < lhs.constant)
    return false;
  if (lhs.arg_min_max_input < rhs.arg_min_max_input)
    return true;
  if (rhs.arg_min_max_input < lhs.arg_min_max_input)
    return false;
  if (lhs.arg_min_max_output < rhs.arg_min_max_output)
    return true;
  if (rhs.arg_min_max_output < lhs.arg_min_max_output)
    return false;
  if (lhs.batch_normalization_input < rhs.batch_normalization_input)
    return true;
  if (rhs.batch_normalization_input < lhs.batch_normalization_input)
    return false;
  if (lhs.batch_normalization_mean < rhs.batch_normalization_mean)
    return true;
  if (rhs.batch_normalization_mean < lhs.batch_normalization_mean)
    return false;
  if (lhs.cast_input < rhs.cast_input)
    return true;
  if (rhs.cast_input < lhs.cast_input)
    return false;
  if (lhs.clamp_input < rhs.clamp_input)
    return true;
  if (rhs.clamp_input < lhs.clamp_input)
    return false;
  if (lhs.concat_inputs < rhs.concat_inputs)
    return true;
  if (rhs.concat_inputs < lhs.concat_inputs)
    return false;
  if (lhs.conv2d_input < rhs.conv2d_input)
    return true;
  if (rhs.conv2d_input < lhs.conv2d_input)
    return false;
  if (lhs.conv2d_bias < rhs.conv2d_bias)
    return true;
  if (rhs.conv2d_bias < lhs.conv2d_bias)
    return false;
  if (lhs.conv_transpose2d_input < rhs.conv_transpose2d_input)
    return true;
  if (rhs.conv_transpose2d_input < lhs.conv_transpose2d_input)
    return false;
  if (lhs.conv_transpose2d_bias < rhs.conv_transpose2d_bias)
    return true;
  if (rhs.conv_transpose2d_bias < lhs.conv_transpose2d_bias)
    return false;
  if (lhs.cumulative_sum_input < rhs.cumulative_sum_input)
    return true;
  if (rhs.cumulative_sum_input < lhs.cumulative_sum_input)
    return false;
  if (lhs.dequantize_linear_input < rhs.dequantize_linear_input)
    return true;
  if (rhs.dequantize_linear_input < lhs.dequantize_linear_input)
    return false;
  if (lhs.dequantize_linear_scale < rhs.dequantize_linear_scale)
    return true;
  if (rhs.dequantize_linear_scale < lhs.dequantize_linear_scale)
    return false;
  if (lhs.dequantize_linear_zero_point < rhs.dequantize_linear_zero_point)
    return true;
  if (rhs.dequantize_linear_zero_point < lhs.dequantize_linear_zero_point)
    return false;
  if (lhs.add_input < rhs.add_input)
    return true;
  if (rhs.add_input < lhs.add_input)
    return false;
  if (lhs.sub_input < rhs.sub_input)
    return true;
  if (rhs.sub_input < lhs.sub_input)
    return false;
  if (lhs.mul_input < rhs.mul_input)
    return true;
  if (rhs.mul_input < lhs.mul_input)
    return false;
  if (lhs.div_input < rhs.div_input)
    return true;
  if (rhs.div_input < lhs.div_input)
    return false;
  if (lhs.max_input < rhs.max_input)
    return true;
  if (rhs.max_input < lhs.max_input)
    return false;
  if (lhs.min_input < rhs.min_input)
    return true;
  if (rhs.min_input < lhs.min_input)
    return false;
  if (lhs.pow_input < rhs.pow_input)
    return true;
  if (rhs.pow_input < lhs.pow_input)
    return false;
  if (lhs.equal_input < rhs.equal_input)
    return true;
  if (rhs.equal_input < lhs.equal_input)
    return false;
  if (lhs.greater_input < rhs.greater_input)
    return true;
  if (rhs.greater_input < lhs.greater_input)
    return false;
  if (lhs.greater_or_equal_input < rhs.greater_or_equal_input)
    return true;
  if (rhs.greater_or_equal_input < lhs.greater_or_equal_input)
    return false;
  if (lhs.lesser_input < rhs.lesser_input)
    return true;
  if (rhs.lesser_input < lhs.lesser_input)
    return false;
  if (lhs.lesser_or_equal_input < rhs.lesser_or_equal_input)
    return true;
  if (rhs.lesser_or_equal_input < lhs.lesser_or_equal_input)
    return false;
  if (lhs.not_equal_input < rhs.not_equal_input)
    return true;
  if (rhs.not_equal_input < lhs.not_equal_input)
    return false;
  if (lhs.logical_and_input < rhs.logical_and_input)
    return true;
  if (rhs.logical_and_input < lhs.logical_and_input)
    return false;
  if (lhs.logical_or_input < rhs.logical_or_input)
    return true;
  if (rhs.logical_or_input < lhs.logical_or_input)
    return false;
  if (lhs.logical_xor_input < rhs.logical_xor_input)
    return true;
  if (rhs.logical_xor_input < lhs.logical_xor_input)
    return false;
  if (lhs.logical_not_input < rhs.logical_not_input)
    return true;
  if (rhs.logical_not_input < lhs.logical_not_input)
    return false;
  if (lhs.is_nan_input < rhs.is_nan_input)
    return true;
  if (rhs.is_nan_input < lhs.is_nan_input)
    return false;
  if (lhs.is_infinite_input < rhs.is_infinite_input)
    return true;
  if (rhs.is_infinite_input < lhs.is_infinite_input)
    return false;
  if (lhs.logical_output < rhs.logical_output)
    return true;
  if (rhs.logical_output < lhs.logical_output)
    return false;
  if (lhs.abs_input < rhs.abs_input)
    return true;
  if (rhs.abs_input < lhs.abs_input)
    return false;
  if (lhs.ceil_input < rhs.ceil_input)
    return true;
  if (rhs.ceil_input < lhs.ceil_input)
    return false;
  if (lhs.cos_input < rhs.cos_input)
    return true;
  if (rhs.cos_input < lhs.cos_input)
    return false;
  if (lhs.erf_input < rhs.erf_input)
    return true;
  if (rhs.erf_input < lhs.erf_input)
    return false;
  if (lhs.exp_input < rhs.exp_input)
    return true;
  if (rhs.exp_input < lhs.exp_input)
    return false;
  if (lhs.floor_input < rhs.floor_input)
    return true;
  if (rhs.floor_input < lhs.floor_input)
    return false;
  if (lhs.identity_input < rhs.identity_input)
    return true;
  if (rhs.identity_input < lhs.identity_input)
    return false;
  if (lhs.log_input < rhs.log_input)
    return true;
  if (rhs.log_input < lhs.log_input)
    return false;
  if (lhs.neg_input < rhs.neg_input)
    return true;
  if (rhs.neg_input < lhs.neg_input)
    return false;
  if (lhs.reciprocal_input < rhs.reciprocal_input)
    return true;
  if (rhs.reciprocal_input < lhs.reciprocal_input)
    return false;
  if (lhs.round_even_input < rhs.round_even_input)
    return true;
  if (rhs.round_even_input < lhs.round_even_input)
    return false;
  if (lhs.sign_input < rhs.sign_input)
    return true;
  if (rhs.sign_input < lhs.sign_input)
    return false;
  if (lhs.sin_input < rhs.sin_input)
    return true;
  if (rhs.sin_input < lhs.sin_input)
    return false;
  if (lhs.sqrt_input < rhs.sqrt_input)
    return true;
  if (rhs.sqrt_input < lhs.sqrt_input)
    return false;
  if (lhs.tan_input < rhs.tan_input)
    return true;
  if (rhs.tan_input < lhs.tan_input)
    return false;
  if (lhs.elu_input < rhs.elu_input)
    return true;
  if (rhs.elu_input < lhs.elu_input)
    return false;
  if (lhs.expand_input < rhs.expand_input)
    return true;
  if (rhs.expand_input < lhs.expand_input)
    return false;
  if (lhs.gather_input < rhs.gather_input)
    return true;
  if (rhs.gather_input < lhs.gather_input)
    return false;
  if (lhs.gather_indices < rhs.gather_indices)
    return true;
  if (rhs.gather_indices < lhs.gather_indices)
    return false;
  if (lhs.gather_elements_input < rhs.gather_elements_input)
    return true;
  if (rhs.gather_elements_input < lhs.gather_elements_input)
    return false;
  if (lhs.gather_elements_indices < rhs.gather_elements_indices)
    return true;
  if (rhs.gather_elements_indices < lhs.gather_elements_indices)
    return false;
  if (lhs.gather_nd_input < rhs.gather_nd_input)
    return true;
  if (rhs.gather_nd_input < lhs.gather_nd_input)
    return false;
  if (lhs.gather_nd_indices < rhs.gather_nd_indices)
    return true;
  if (rhs.gather_nd_indices < lhs.gather_nd_indices)
    return false;
  if (lhs.gelu_input < rhs.gelu_input)
    return true;
  if (rhs.gelu_input < lhs.gelu_input)
    return false;
  if (lhs.gemm_a < rhs.gemm_a)
    return true;
  if (rhs.gemm_a < lhs.gemm_a)
    return false;
  if (lhs.gemm_c < rhs.gemm_c)
    return true;
  if (rhs.gemm_c < lhs.gemm_c)
    return false;
  if (lhs.gru_input < rhs.gru_input)
    return true;
  if (rhs.gru_input < lhs.gru_input)
    return false;
  if (lhs.gru_bias < rhs.gru_bias)
    return true;
  if (rhs.gru_bias < lhs.gru_bias)
    return false;
  if (lhs.gru_output_sequence < rhs.gru_output_sequence)
    return true;
  if (rhs.gru_output_sequence < lhs.gru_output_sequence)
    return false;
  if (lhs.gru_cell_input < rhs.gru_cell_input)
    return true;
  if (rhs.gru_cell_input < lhs.gru_cell_input)
    return false;
  if (lhs.gru_cell_bias < rhs.gru_cell_bias)
    return true;
  if (rhs.gru_cell_bias < lhs.gru_cell_bias)
    return false;
  if (lhs.hard_sigmoid_input < rhs.hard_sigmoid_input)
    return true;
  if (rhs.hard_sigmoid_input < lhs.hard_sigmoid_input)
    return false;
  if (lhs.hard_swish_input < rhs.hard_swish_input)
    return true;
  if (rhs.hard_swish_input < lhs.hard_swish_input)
    return false;
  if (lhs.instance_normalization_input < rhs.instance_normalization_input)
    return true;
  if (rhs.instance_normalization_input < lhs.instance_normalization_input)
    return false;
  if (lhs.instance_normalization_scale < rhs.instance_normalization_scale)
    return true;
  if (rhs.instance_normalization_scale < lhs.instance_normalization_scale)
    return false;
  if (lhs.layer_normalization_input < rhs.layer_normalization_input)
    return true;
  if (rhs.layer_normalization_input < lhs.layer_normalization_input)
    return false;
  if (lhs.leaky_relu_input < rhs.leaky_relu_input)
    return true;
  if (rhs.leaky_relu_input < lhs.leaky_relu_input)
    return false;
  if (lhs.linear_input < rhs.linear_input)
    return true;
  if (rhs.linear_input < lhs.linear_input)
    return false;
  if (lhs.lstm_input < rhs.lstm_input)
    return true;
  if (rhs.lstm_input < lhs.lstm_input)
    return false;
  if (lhs.lstm_bias < rhs.lstm_bias)
    return true;
  if (rhs.lstm_bias < lhs.lstm_bias)
    return false;
  if (lhs.lstm_output_sequence < rhs.lstm_output_sequence)
    return true;
  if (rhs.lstm_output_sequence < lhs.lstm_output_sequence)
    return false;
  if (lhs.lstm_cell_input < rhs.lstm_cell_input)
    return true;
  if (rhs.lstm_cell_input < lhs.lstm_cell_input)
    return false;
  if (lhs.lstm_cell_bias < rhs.lstm_cell_bias)
    return true;
  if (rhs.lstm_cell_bias < lhs.lstm_cell_bias)
    return false;
  if (lhs.matmul_input < rhs.matmul_input)
    return true;
  if (rhs.matmul_input < lhs.matmul_input)
    return false;
  if (lhs.pad_input < rhs.pad_input)
    return true;
  if (rhs.pad_input < lhs.pad_input)
    return false;
  if (lhs.average_pool2d_input < rhs.average_pool2d_input)
    return true;
  if (rhs.average_pool2d_input < lhs.average_pool2d_input)
    return false;
  if (lhs.l2_pool2d_input < rhs.l2_pool2d_input)
    return true;
  if (rhs.l2_pool2d_input < lhs.l2_pool2d_input)
    return false;
  if (lhs.max_pool2d_input < rhs.max_pool2d_input)
    return true;
  if (rhs.max_pool2d_input < lhs.max_pool2d_input)
    return false;
  if (lhs.prelu_input < rhs.prelu_input)
    return true;
  if (rhs.prelu_input < lhs.prelu_input)
    return false;
  if (lhs.quantize_linear_input < rhs.quantize_linear_input)
    return true;
  if (rhs.quantize_linear_input < lhs.quantize_linear_input)
    return false;
  if (lhs.quantize_linear_zero_point < rhs.quantize_linear_zero_point)
    return true;
  if (rhs.quantize_linear_zero_point < lhs.quantize_linear_zero_point)
    return false;
  if (lhs.reduce_l1_input < rhs.reduce_l1_input)
    return true;
  if (rhs.reduce_l1_input < lhs.reduce_l1_input)
    return false;
  if (lhs.reduce_l2_input < rhs.reduce_l2_input)
    return true;
  if (rhs.reduce_l2_input < lhs.reduce_l2_input)
    return false;
  if (lhs.reduce_log_sum_input < rhs.reduce_log_sum_input)
    return true;
  if (rhs.reduce_log_sum_input < lhs.reduce_log_sum_input)
    return false;
  if (lhs.reduce_log_sum_exp_input < rhs.reduce_log_sum_exp_input)
    return true;
  if (rhs.reduce_log_sum_exp_input < lhs.reduce_log_sum_exp_input)
    return false;
  if (lhs.reduce_max_input < rhs.reduce_max_input)
    return true;
  if (rhs.reduce_max_input < lhs.reduce_max_input)
    return false;
  if (lhs.reduce_mean_input < rhs.reduce_mean_input)
    return true;
  if (rhs.reduce_mean_input < lhs.reduce_mean_input)
    return false;
  if (lhs.reduce_min_input < rhs.reduce_min_input)
    return true;
  if (rhs.reduce_min_input < lhs.reduce_min_input)
    return false;
  if (lhs.reduce_product_input < rhs.reduce_product_input)
    return true;
  if (rhs.reduce_product_input < lhs.reduce_product_input)
    return false;
  if (lhs.reduce_sum_input < rhs.reduce_sum_input)
    return true;
  if (rhs.reduce_sum_input < lhs.reduce_sum_input)
    return false;
  if (lhs.reduce_sum_square_input < rhs.reduce_sum_square_input)
    return true;
  if (rhs.reduce_sum_square_input < lhs.reduce_sum_square_input)
    return false;
  if (lhs.relu_input < rhs.relu_input)
    return true;
  if (rhs.relu_input < lhs.relu_input)
    return false;
  if (lhs.resample2d_input < rhs.resample2d_input)
    return true;
  if (rhs.resample2d_input < lhs.resample2d_input)
    return false;
  if (lhs.reshape_input < rhs.reshape_input)
    return true;
  if (rhs.reshape_input < lhs.reshape_input)
    return false;
  if (lhs.reverse_input < rhs.reverse_input)
    return true;
  if (rhs.reverse_input < lhs.reverse_input)
    return false;
  if (lhs.scatter_elements_input < rhs.scatter_elements_input)
    return true;
  if (rhs.scatter_elements_input < lhs.scatter_elements_input)
    return false;
  if (lhs.scatter_elements_indices < rhs.scatter_elements_indices)
    return true;
  if (rhs.scatter_elements_indices < lhs.scatter_elements_indices)
    return false;
  if (lhs.scatter_nd_input < rhs.scatter_nd_input)
    return true;
  if (rhs.scatter_nd_input < lhs.scatter_nd_input)
    return false;
  if (lhs.scatter_nd_indices < rhs.scatter_nd_indices)
    return true;
  if (rhs.scatter_nd_indices < lhs.scatter_nd_indices)
    return false;
  if (lhs.scatter_nd_updates < rhs.scatter_nd_updates)
    return true;
  if (rhs.scatter_nd_updates < lhs.scatter_nd_updates)
    return false;
  if (lhs.sigmoid_input < rhs.sigmoid_input)
    return true;
  if (rhs.sigmoid_input < lhs.sigmoid_input)
    return false;
  if (lhs.slice_input < rhs.slice_input)
    return true;
  if (rhs.slice_input < lhs.slice_input)
    return false;
  if (lhs.softmax_input < rhs.softmax_input)
    return true;
  if (rhs.softmax_input < lhs.softmax_input)
    return false;
  if (lhs.softplus_input < rhs.softplus_input)
    return true;
  if (rhs.softplus_input < lhs.softplus_input)
    return false;
  if (lhs.softsign_input < rhs.softsign_input)
    return true;
  if (rhs.softsign_input < lhs.softsign_input)
    return false;
  if (lhs.split_input < rhs.split_input)
    return true;
  if (rhs.split_input < lhs.split_input)
    return false;
  if (lhs.tanh_input < rhs.tanh_input)
    return true;
  if (rhs.tanh_input < lhs.tanh_input)
    return false;
  if (lhs.tile_input < rhs.tile_input)
    return true;
  if (rhs.tile_input < lhs.tile_input)
    return false;
  if (lhs.transpose_input < rhs.transpose_input)
    return true;
  if (rhs.transpose_input < lhs.transpose_input)
    return false;
  if (lhs.triangular_input < rhs.triangular_input)
    return true;
  if (rhs.triangular_input < lhs.triangular_input)
    return false;
  if (lhs.where_condition < rhs.where_condition)
    return true;
  if (rhs.where_condition < lhs.where_condition)
    return false;
  if (lhs.where_value < rhs.where_value)
    return true;
  if (rhs.where_value < lhs.where_value)
    return false;
  return false;
}
template <typename StructPtrType>
ContextPropertiesPtr ContextProperties::Clone() const {
  return New(
      mojo::Clone(input_operand_layout),
      mojo::Clone(resample_2d_axes),
      mojo::Clone(batch_normalization_axis),
      mojo::Clone(tensor_byte_length_limit),
      mojo::Clone(data_type_limits)
  );
}

template <typename T, ContextProperties::EnableIfSame<T>*>
bool ContextProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_layout, other_struct.input_operand_layout))
    return false;
  if (!mojo::Equals(this->resample_2d_axes, other_struct.resample_2d_axes))
    return false;
  if (!mojo::Equals(this->batch_normalization_axis, other_struct.batch_normalization_axis))
    return false;
  if (!mojo::Equals(this->tensor_byte_length_limit, other_struct.tensor_byte_length_limit))
    return false;
  if (!mojo::Equals(this->data_type_limits, other_struct.data_type_limits))
    return false;
  return true;
}

template <typename T, ContextProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_layout < rhs.input_operand_layout)
    return true;
  if (rhs.input_operand_layout < lhs.input_operand_layout)
    return false;
  if (lhs.resample_2d_axes < rhs.resample_2d_axes)
    return true;
  if (rhs.resample_2d_axes < lhs.resample_2d_axes)
    return false;
  if (lhs.batch_normalization_axis < rhs.batch_normalization_axis)
    return true;
  if (rhs.batch_normalization_axis < lhs.batch_normalization_axis)
    return false;
  if (lhs.tensor_byte_length_limit < rhs.tensor_byte_length_limit)
    return true;
  if (rhs.tensor_byte_length_limit < lhs.tensor_byte_length_limit)
    return false;
  if (lhs.data_type_limits < rhs.data_type_limits)
    return true;
  if (rhs.data_type_limits < lhs.data_type_limits)
    return false;
  return false;
}


}  // webnn::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) StructTraits<::webnn::mojom::blink::SupportedDataTypes::DataView,
                                         ::webnn::mojom::blink::SupportedDataTypesPtr> {
  static bool IsNull(const ::webnn::mojom::blink::SupportedDataTypesPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::SupportedDataTypesPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::float32) float32(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->float32;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::float16) float16(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->float16;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::int32) int32(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->int32;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::uint32) uint32(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->uint32;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::int64) int64(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->int64;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::uint64) uint64(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->uint64;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::int8) int8(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->int8;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::uint8) uint8(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->uint8;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::int4) int4(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->int4;
  }

  static decltype(::webnn::mojom::blink::SupportedDataTypes::uint4) uint4(
      const ::webnn::mojom::blink::SupportedDataTypesPtr& input) {
    return input->uint4;
  }

  static bool Read(::webnn::mojom::blink::SupportedDataTypes::DataView input, ::webnn::mojom::blink::SupportedDataTypesPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) StructTraits<::webnn::mojom::blink::SupportedRanks::DataView,
                                         ::webnn::mojom::blink::SupportedRanksPtr> {
  static bool IsNull(const ::webnn::mojom::blink::SupportedRanksPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::SupportedRanksPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::blink::SupportedRanks::min) min(
      const ::webnn::mojom::blink::SupportedRanksPtr& input) {
    return input->min;
  }

  static decltype(::webnn::mojom::blink::SupportedRanks::max) max(
      const ::webnn::mojom::blink::SupportedRanksPtr& input) {
    return input->max;
  }

  static bool Read(::webnn::mojom::blink::SupportedRanks::DataView input, ::webnn::mojom::blink::SupportedRanksPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) StructTraits<::webnn::mojom::blink::SupportedTensors::DataView,
                                         ::webnn::mojom::blink::SupportedTensorsPtr> {
  static bool IsNull(const ::webnn::mojom::blink::SupportedTensorsPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::SupportedTensorsPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::blink::SupportedTensors::data_types)& data_types(
      const ::webnn::mojom::blink::SupportedTensorsPtr& input) {
    return input->data_types;
  }

  static const decltype(::webnn::mojom::blink::SupportedTensors::ranks)& ranks(
      const ::webnn::mojom::blink::SupportedTensorsPtr& input) {
    return input->ranks;
  }

  static bool Read(::webnn::mojom::blink::SupportedTensors::DataView input, ::webnn::mojom::blink::SupportedTensorsPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) StructTraits<::webnn::mojom::blink::DataTypeLimits::DataView,
                                         ::webnn::mojom::blink::DataTypeLimitsPtr> {
  static bool IsNull(const ::webnn::mojom::blink::DataTypeLimitsPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::DataTypeLimitsPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::input)& input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::constant)& constant(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->constant;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::arg_min_max_input)& arg_min_max_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->arg_min_max_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::arg_min_max_output)& arg_min_max_output(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->arg_min_max_output;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::batch_normalization_input)& batch_normalization_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->batch_normalization_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::batch_normalization_mean)& batch_normalization_mean(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->batch_normalization_mean;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::cast_input)& cast_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->cast_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::clamp_input)& clamp_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->clamp_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::concat_inputs)& concat_inputs(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->concat_inputs;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::conv2d_input)& conv2d_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->conv2d_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::conv2d_bias)& conv2d_bias(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->conv2d_bias;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::conv_transpose2d_input)& conv_transpose2d_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->conv_transpose2d_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::conv_transpose2d_bias)& conv_transpose2d_bias(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->conv_transpose2d_bias;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::cumulative_sum_input)& cumulative_sum_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->cumulative_sum_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::dequantize_linear_input)& dequantize_linear_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->dequantize_linear_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::dequantize_linear_scale)& dequantize_linear_scale(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->dequantize_linear_scale;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::dequantize_linear_zero_point)& dequantize_linear_zero_point(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->dequantize_linear_zero_point;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::add_input)& add_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->add_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::sub_input)& sub_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->sub_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::mul_input)& mul_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->mul_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::div_input)& div_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->div_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::max_input)& max_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->max_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::min_input)& min_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->min_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::pow_input)& pow_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->pow_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::equal_input)& equal_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->equal_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::greater_input)& greater_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->greater_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::greater_or_equal_input)& greater_or_equal_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->greater_or_equal_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::lesser_input)& lesser_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->lesser_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::lesser_or_equal_input)& lesser_or_equal_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->lesser_or_equal_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::not_equal_input)& not_equal_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->not_equal_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::logical_and_input)& logical_and_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->logical_and_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::logical_or_input)& logical_or_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->logical_or_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::logical_xor_input)& logical_xor_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->logical_xor_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::logical_not_input)& logical_not_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->logical_not_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::is_nan_input)& is_nan_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->is_nan_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::is_infinite_input)& is_infinite_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->is_infinite_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::logical_output)& logical_output(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->logical_output;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::abs_input)& abs_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->abs_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::ceil_input)& ceil_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->ceil_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::cos_input)& cos_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->cos_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::erf_input)& erf_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->erf_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::exp_input)& exp_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->exp_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::floor_input)& floor_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->floor_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::identity_input)& identity_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->identity_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::log_input)& log_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->log_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::neg_input)& neg_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->neg_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reciprocal_input)& reciprocal_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reciprocal_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::round_even_input)& round_even_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->round_even_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::sign_input)& sign_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->sign_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::sin_input)& sin_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->sin_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::sqrt_input)& sqrt_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->sqrt_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::tan_input)& tan_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->tan_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::elu_input)& elu_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->elu_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::expand_input)& expand_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->expand_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gather_input)& gather_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gather_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gather_indices)& gather_indices(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gather_indices;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gather_elements_input)& gather_elements_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gather_elements_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gather_elements_indices)& gather_elements_indices(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gather_elements_indices;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gather_nd_input)& gather_nd_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gather_nd_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gather_nd_indices)& gather_nd_indices(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gather_nd_indices;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gelu_input)& gelu_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gelu_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gemm_a)& gemm_a(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gemm_a;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gemm_c)& gemm_c(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gemm_c;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gru_input)& gru_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gru_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gru_bias)& gru_bias(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gru_bias;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gru_output_sequence)& gru_output_sequence(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gru_output_sequence;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gru_cell_input)& gru_cell_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gru_cell_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::gru_cell_bias)& gru_cell_bias(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->gru_cell_bias;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::hard_sigmoid_input)& hard_sigmoid_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->hard_sigmoid_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::hard_swish_input)& hard_swish_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->hard_swish_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::instance_normalization_input)& instance_normalization_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->instance_normalization_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::instance_normalization_scale)& instance_normalization_scale(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->instance_normalization_scale;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::layer_normalization_input)& layer_normalization_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->layer_normalization_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::leaky_relu_input)& leaky_relu_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->leaky_relu_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::linear_input)& linear_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->linear_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::lstm_input)& lstm_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->lstm_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::lstm_bias)& lstm_bias(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->lstm_bias;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::lstm_output_sequence)& lstm_output_sequence(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->lstm_output_sequence;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::lstm_cell_input)& lstm_cell_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->lstm_cell_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::lstm_cell_bias)& lstm_cell_bias(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->lstm_cell_bias;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::matmul_input)& matmul_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->matmul_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::pad_input)& pad_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->pad_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::average_pool2d_input)& average_pool2d_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->average_pool2d_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::l2_pool2d_input)& l2_pool2d_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->l2_pool2d_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::max_pool2d_input)& max_pool2d_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->max_pool2d_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::prelu_input)& prelu_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->prelu_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::quantize_linear_input)& quantize_linear_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->quantize_linear_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::quantize_linear_zero_point)& quantize_linear_zero_point(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->quantize_linear_zero_point;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_l1_input)& reduce_l1_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_l1_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_l2_input)& reduce_l2_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_l2_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_log_sum_input)& reduce_log_sum_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_log_sum_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_log_sum_exp_input)& reduce_log_sum_exp_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_log_sum_exp_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_max_input)& reduce_max_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_max_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_mean_input)& reduce_mean_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_mean_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_min_input)& reduce_min_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_min_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_product_input)& reduce_product_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_product_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_sum_input)& reduce_sum_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_sum_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reduce_sum_square_input)& reduce_sum_square_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reduce_sum_square_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::relu_input)& relu_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->relu_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::resample2d_input)& resample2d_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->resample2d_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reshape_input)& reshape_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reshape_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::reverse_input)& reverse_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->reverse_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::scatter_elements_input)& scatter_elements_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->scatter_elements_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::scatter_elements_indices)& scatter_elements_indices(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->scatter_elements_indices;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::scatter_nd_input)& scatter_nd_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->scatter_nd_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::scatter_nd_indices)& scatter_nd_indices(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->scatter_nd_indices;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::scatter_nd_updates)& scatter_nd_updates(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->scatter_nd_updates;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::sigmoid_input)& sigmoid_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->sigmoid_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::slice_input)& slice_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->slice_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::softmax_input)& softmax_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->softmax_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::softplus_input)& softplus_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->softplus_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::softsign_input)& softsign_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->softsign_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::split_input)& split_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->split_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::tanh_input)& tanh_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->tanh_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::tile_input)& tile_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->tile_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::transpose_input)& transpose_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->transpose_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::triangular_input)& triangular_input(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->triangular_input;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::where_condition)& where_condition(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->where_condition;
  }

  static const decltype(::webnn::mojom::blink::DataTypeLimits::where_value)& where_value(
      const ::webnn::mojom::blink::DataTypeLimitsPtr& input) {
    return input->where_value;
  }

  static bool Read(::webnn::mojom::blink::DataTypeLimits::DataView input, ::webnn::mojom::blink::DataTypeLimitsPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) StructTraits<::webnn::mojom::blink::ContextProperties::DataView,
                                         ::webnn::mojom::blink::ContextPropertiesPtr> {
  static bool IsNull(const ::webnn::mojom::blink::ContextPropertiesPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::ContextPropertiesPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::blink::ContextProperties::input_operand_layout) input_operand_layout(
      const ::webnn::mojom::blink::ContextPropertiesPtr& input) {
    return input->input_operand_layout;
  }

  static decltype(::webnn::mojom::blink::ContextProperties::resample_2d_axes) resample_2d_axes(
      const ::webnn::mojom::blink::ContextPropertiesPtr& input) {
    return input->resample_2d_axes;
  }

  static decltype(::webnn::mojom::blink::ContextProperties::batch_normalization_axis) batch_normalization_axis(
      const ::webnn::mojom::blink::ContextPropertiesPtr& input) {
    return input->batch_normalization_axis;
  }

  static decltype(::webnn::mojom::blink::ContextProperties::tensor_byte_length_limit) tensor_byte_length_limit(
      const ::webnn::mojom::blink::ContextPropertiesPtr& input) {
    return input->tensor_byte_length_limit;
  }

  static const decltype(::webnn::mojom::blink::ContextProperties::data_type_limits)& data_type_limits(
      const ::webnn::mojom::blink::ContextPropertiesPtr& input) {
    return input->data_type_limits;
  }

  static bool Read(::webnn::mojom::blink::ContextProperties::DataView input, ::webnn::mojom::blink::ContextPropertiesPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_BLINK_H_