// services/webnn/public/mojom/webnn_context.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/webnn/public/mojom/webnn_context.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_context.mojom-params-data.h"
#include "services/webnn/public/mojom/webnn_context.mojom-shared-message-ids.h"

#include "services/webnn/public/mojom/webnn_context.mojom-blink-import-headers.h"
#include "services/webnn/public/mojom/webnn_context.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace webnn::mojom::blink {
CreateTensorSuccess::CreateTensorSuccess()
    : tensor_remote(),
      tensor_handle() {}

CreateTensorSuccess::CreateTensorSuccess(
    ::mojo::PendingAssociatedRemote<::webnn::mojom::blink::WebNNTensor> tensor_remote_in,
    const ::blink::WebNNTensorToken& tensor_handle_in)
    : tensor_remote(std::move(tensor_remote_in)),
      tensor_handle(std::move(tensor_handle_in)) {}

CreateTensorSuccess::~CreateTensorSuccess() = default;

void CreateTensorSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tensor_remote"), this->tensor_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::webnn::mojom::blink::WebNNTensor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tensor_handle"), this->tensor_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::WebNNTensorToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateTensorSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateTensorResultPtr
CreateTensorResult::NewSuccess(
    CreateTensorSuccessPtr value) {
  return CreateTensorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CreateTensorResultPtr
CreateTensorResult::NewError(
    ::webnn::mojom::blink::ErrorPtr value) {
  return CreateTensorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

CreateTensorResult::CreateTensorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreateTensorSuccessPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CreateTensorResult::CreateTensorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
CreateTensorResult::~CreateTensorResult() {
  DestroyActive();
}

void CreateTensorResult::set_success(CreateTensorSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) CreateTensorSuccessPtr(
        std::move(success));
  }
}

void CreateTensorResult::set_error(::webnn::mojom::blink::ErrorPtr error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) ::webnn::mojom::blink::ErrorPtr(
        std::move(error));
  }
}


CreateTensorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreateTensorSuccessPtr value)
    : success(std::move(value)) {}

CreateTensorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : error(std::move(value)) {}

void CreateTensorResult::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool CreateTensorResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebNNContext::IPCStableHashFunction WebNNContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebNNContext>(message.name())) {
    case messages::WebNNContext::kCreateGraphBuilder: {
      return &WebNNContext::CreateGraphBuilder_Sym::IPCStableHash;
    }
    case messages::WebNNContext::kCreateTensor: {
      return &WebNNContext::CreateTensor_Sym::IPCStableHash;
    }
    case messages::WebNNContext::kCreateTensorFromMailbox: {
      return &WebNNContext::CreateTensorFromMailbox_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebNNContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebNNContext>(message.name())) {
      case messages::WebNNContext::kCreateGraphBuilder:
            return "Receive webnn::mojom::WebNNContext::CreateGraphBuilder";
      case messages::WebNNContext::kCreateTensor:
            return "Receive webnn::mojom::WebNNContext::CreateTensor";
      case messages::WebNNContext::kCreateTensorFromMailbox:
            return "Receive webnn::mojom::WebNNContext::CreateTensorFromMailbox";
    }
  } else {
    switch (static_cast<messages::WebNNContext>(message.name())) {
      case messages::WebNNContext::kCreateGraphBuilder:
            return "Receive reply webnn::mojom::WebNNContext::CreateGraphBuilder";
      case messages::WebNNContext::kCreateTensor:
            return "Receive reply webnn::mojom::WebNNContext::CreateTensor";
      case messages::WebNNContext::kCreateTensorFromMailbox:
            return "Receive reply webnn::mojom::WebNNContext::CreateTensorFromMailbox";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebNNContext::CreateGraphBuilder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10af4511;  // IPCStableHash for webnn::mojom::WebNNContext::CreateGraphBuilder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebNNContext::CreateTensor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19596945;  // IPCStableHash for webnn::mojom::WebNNContext::CreateTensor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebNNContext::CreateTensorFromMailbox_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9c6fe77;  // IPCStableHash for webnn::mojom::WebNNContext::CreateTensorFromMailbox
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

// static
bool WebNNContext::RuntimeFeature_IsEnabled_(bool expected) {
  bool enabled = base::FeatureList::IsEnabled(::webnn::mojom::features::kWebMachineLearningNeuralNetwork);
#if DCHECK_IS_ON()
  if (expected) {
    DCHECK(enabled) << "RuntimeFeature ::webnn::mojom::features::kWebMachineLearningNeuralNetwork for WebNNContext is not enabled";
  }
#endif
  return enabled;
}

class WebNNContext_CreateTensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebNNContext_CreateTensor_ForwardToCallback(
      WebNNContext::CreateTensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebNNContext_CreateTensor_ForwardToCallback(const WebNNContext_CreateTensor_ForwardToCallback&) = delete;
  WebNNContext_CreateTensor_ForwardToCallback& operator=(const WebNNContext_CreateTensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebNNContext::CreateTensorCallback callback_;
};

class WebNNContext_CreateTensorFromMailbox_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebNNContext_CreateTensorFromMailbox_ForwardToCallback(
      WebNNContext::CreateTensorFromMailboxCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebNNContext_CreateTensorFromMailbox_ForwardToCallback(const WebNNContext_CreateTensorFromMailbox_ForwardToCallback&) = delete;
  WebNNContext_CreateTensorFromMailbox_ForwardToCallback& operator=(const WebNNContext_CreateTensorFromMailbox_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebNNContext::CreateTensorFromMailboxCallback callback_;
};

WebNNContextProxy::WebNNContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebNNContextProxy::CreateGraphBuilder(
    ::mojo::PendingAssociatedReceiver<::webnn::mojom::blink::WebNNGraphBuilder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNContext::CreateGraphBuilder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::webnn::mojom::blink::WebNNGraphBuilder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNContext::kCreateGraphBuilder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNContext_CreateGraphBuilder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::webnn::mojom::WebNNGraphBuilderAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in WebNNContext.CreateGraphBuilder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNContext::Name_);
  message.set_method_name("CreateGraphBuilder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebNNContextProxy::CreateTensor(
    ::webnn::mojom::blink::TensorInfoPtr in_tensor_info, ::mojo_base::BigBuffer in_tensor_data, CreateTensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNContext::CreateTensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tensor_info"), in_tensor_info,
                        "<value of type ::webnn::mojom::blink::TensorInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tensor_data"), in_tensor_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNContext::kCreateTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNContext_CreateTensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tensor_info)::BaseType> tensor_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::webnn::mojom::TensorInfoDataView>(
    in_tensor_info,
    tensor_info_fragment);

  params->tensor_info.Set(
      tensor_info_fragment.is_null() ? nullptr : tensor_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tensor_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tensor_info in WebNNContext.CreateTensor request");
  mojo::internal::MessageFragment<decltype(params->tensor_data)>
      tensor_data_fragment(params.message());
  tensor_data_fragment.Claim(&params->tensor_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_tensor_data,
    tensor_data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tensor_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tensor_data in WebNNContext.CreateTensor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNContext::Name_);
  message.set_method_name("CreateTensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebNNContext_CreateTensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebNNContextProxy::CreateTensorFromMailbox(
    ::webnn::mojom::blink::TensorInfoPtr in_tensor_info, const ::gpu::Mailbox& in_mailbox, const ::gpu::SyncToken& in_fence, CreateTensorFromMailboxCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNContext::CreateTensorFromMailbox", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tensor_info"), in_tensor_info,
                        "<value of type ::webnn::mojom::blink::TensorInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mailbox"), in_mailbox,
                        "<value of type const ::gpu::Mailbox&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fence"), in_fence,
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNContext::kCreateTensorFromMailbox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNContext_CreateTensorFromMailbox_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tensor_info)::BaseType> tensor_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::webnn::mojom::TensorInfoDataView>(
    in_tensor_info,
    tensor_info_fragment);

  params->tensor_info.Set(
      tensor_info_fragment.is_null() ? nullptr : tensor_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tensor_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tensor_info in WebNNContext.CreateTensorFromMailbox request");
  mojo::internal::MessageFragment<
      typename decltype(params->mailbox)::BaseType> mailbox_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
    in_mailbox,
    mailbox_fragment);

  params->mailbox.Set(
      mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mailbox.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mailbox in WebNNContext.CreateTensorFromMailbox request");
  mojo::internal::MessageFragment<
      typename decltype(params->fence)::BaseType> fence_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_fence,
    fence_fragment);

  params->fence.Set(
      fence_fragment.is_null() ? nullptr : fence_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->fence.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null fence in WebNNContext.CreateTensorFromMailbox request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNContext::Name_);
  message.set_method_name("CreateTensorFromMailbox");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebNNContext_CreateTensorFromMailbox_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebNNContext_CreateTensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebNNContext::CreateTensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebNNContext_CreateTensor_ProxyToResponder> proxy(
        new WebNNContext_CreateTensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebNNContext_CreateTensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebNNContext_CreateTensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebNNContext_CreateTensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebNNContext::CreateTensorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateTensorResultPtr in_result);
};

bool WebNNContext_CreateTensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebNNContext_CreateTensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebNNContext_CreateTensor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebNNContext.1
  bool success = true;
  CreateTensorResultPtr p_result{};
  WebNNContext_CreateTensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebNNContext::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebNNContext_CreateTensor_ProxyToResponder::Run(
    CreateTensorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webnn::mojom::WebNNContext::CreateTensor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateTensorResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNContext::kCreateTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNContext_CreateTensor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::webnn::mojom::CreateTensorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNContext::Name_);
  message.set_method_name("CreateTensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebNNContext_CreateTensorFromMailbox_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebNNContext::CreateTensorFromMailboxCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebNNContext_CreateTensorFromMailbox_ProxyToResponder> proxy(
        new WebNNContext_CreateTensorFromMailbox_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebNNContext_CreateTensorFromMailbox_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebNNContext_CreateTensorFromMailbox_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebNNContext_CreateTensorFromMailbox_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebNNContext::CreateTensorFromMailboxCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateTensorResultPtr in_result);
};

bool WebNNContext_CreateTensorFromMailbox_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebNNContext_CreateTensorFromMailbox_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebNNContext_CreateTensorFromMailbox_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebNNContext.2
  bool success = true;
  CreateTensorResultPtr p_result{};
  WebNNContext_CreateTensorFromMailbox_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebNNContext::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebNNContext_CreateTensorFromMailbox_ProxyToResponder::Run(
    CreateTensorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webnn::mojom::WebNNContext::CreateTensorFromMailbox", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateTensorResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNContext::kCreateTensorFromMailbox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNContext_CreateTensorFromMailbox_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::webnn::mojom::CreateTensorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNContext::Name_);
  message.set_method_name("CreateTensorFromMailbox");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebNNContextStubDispatch::Accept(
    WebNNContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebNNContext>(message->header()->name)) {
    case messages::WebNNContext::kCreateGraphBuilder: {
      DCHECK(message->is_serialized());
      internal::WebNNContext_CreateGraphBuilder_Params_Data* params =
          reinterpret_cast<internal::WebNNContext_CreateGraphBuilder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebNNContext.0
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::webnn::mojom::blink::WebNNGraphBuilder> p_receiver{};
      WebNNContext_CreateGraphBuilder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGraphBuilder(        
        std::move(p_receiver));
      return true;
    }
    case messages::WebNNContext::kCreateTensor: {
      break;
    }
    case messages::WebNNContext::kCreateTensorFromMailbox: {
      break;
    }
  }
  return false;
}

// static
bool WebNNContextStubDispatch::AcceptWithResponder(
    WebNNContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebNNContext>(message->header()->name)) {
    case messages::WebNNContext::kCreateGraphBuilder: {
      break;
    }
    case messages::WebNNContext::kCreateTensor: {
      internal::WebNNContext_CreateTensor_Params_Data* params =
          reinterpret_cast<
              internal::WebNNContext_CreateTensor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebNNContext.1
      bool success = true;
      ::webnn::mojom::blink::TensorInfoPtr p_tensor_info{};
      ::mojo_base::BigBuffer p_tensor_data{};
      WebNNContext_CreateTensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTensorInfo(&p_tensor_info))
        success = false;
      if (success && !input_data_view.ReadTensorData(&p_tensor_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNContext::Name_, 1, false);
        return false;
      }
      auto callback =
          WebNNContext_CreateTensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTensor(        
        std::move(p_tensor_info), 
        std::move(p_tensor_data), std::move(callback));
      return true;
    }
    case messages::WebNNContext::kCreateTensorFromMailbox: {
      internal::WebNNContext_CreateTensorFromMailbox_Params_Data* params =
          reinterpret_cast<
              internal::WebNNContext_CreateTensorFromMailbox_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebNNContext.2
      bool success = true;
      ::webnn::mojom::blink::TensorInfoPtr p_tensor_info{};
      ::gpu::Mailbox p_mailbox{};
      ::gpu::SyncToken p_fence{};
      WebNNContext_CreateTensorFromMailbox_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTensorInfo(&p_tensor_info))
        success = false;
      if (success && !input_data_view.ReadMailbox(&p_mailbox))
        success = false;
      if (success && !input_data_view.ReadFence(&p_fence))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNContext::Name_, 2, false);
        return false;
      }
      auto callback =
          WebNNContext_CreateTensorFromMailbox_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTensorFromMailbox(        
        std::move(p_tensor_info), 
        std::move(p_mailbox), 
        std::move(p_fence), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebNNContextValidationInfo[] = {
    { &internal::WebNNContext_CreateGraphBuilder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebNNContext_CreateTensor_Params_Data::Validate,
     &internal::WebNNContext_CreateTensor_ResponseParams_Data::Validate},
    { &internal::WebNNContext_CreateTensorFromMailbox_Params_Data::Validate,
     &internal::WebNNContext_CreateTensorFromMailbox_ResponseParams_Data::Validate},
};

bool WebNNContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webnn::mojom::blink::WebNNContext::Name_,
    kWebNNContextValidationInfo);
}

bool WebNNContextResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webnn::mojom::blink::WebNNContext::Name_,
    kWebNNContextValidationInfo);
}


}  // webnn::mojom::blink


namespace mojo {


// static
bool StructTraits<::webnn::mojom::blink::CreateTensorSuccess::DataView, ::webnn::mojom::blink::CreateTensorSuccessPtr>::Read(
    ::webnn::mojom::blink::CreateTensorSuccess::DataView input,
    ::webnn::mojom::blink::CreateTensorSuccessPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::CreateTensorSuccessPtr result(::webnn::mojom::blink::CreateTensorSuccess::New());
  
      if (success) {
        result->tensor_remote =
            input.TakeTensorRemote<decltype(result->tensor_remote)>();
      }
      if (success && !input.ReadTensorHandle(&result->tensor_handle))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::webnn::mojom::blink::CreateTensorResult::DataView, ::webnn::mojom::blink::CreateTensorResultPtr>::Read(
    ::webnn::mojom::blink::CreateTensorResult::DataView input,
    ::webnn::mojom::blink::CreateTensorResultPtr* output) {
  using UnionType = ::webnn::mojom::blink::CreateTensorResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::webnn::mojom::blink::CreateTensorSuccessPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kError: {
      ::webnn::mojom::blink::ErrorPtr result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webnn::mojom::blink {


void WebNNContextInterceptorForTesting::CreateGraphBuilder(::mojo::PendingAssociatedReceiver<::webnn::mojom::blink::WebNNGraphBuilder> receiver) {
  GetForwardingInterface()->CreateGraphBuilder(
    std::move(receiver)
    );
}
void WebNNContextInterceptorForTesting::CreateTensor(::webnn::mojom::blink::TensorInfoPtr tensor_info, ::mojo_base::BigBuffer tensor_data, CreateTensorCallback callback) {
  GetForwardingInterface()->CreateTensor(
    std::move(tensor_info)
    , 
    std::move(tensor_data)
    , std::move(callback));
}
void WebNNContextInterceptorForTesting::CreateTensorFromMailbox(::webnn::mojom::blink::TensorInfoPtr tensor_info, const ::gpu::Mailbox& mailbox, const ::gpu::SyncToken& fence, CreateTensorFromMailboxCallback callback) {
  GetForwardingInterface()->CreateTensorFromMailbox(
    std::move(tensor_info)
    , 
    std::move(mailbox)
    , 
    std::move(fence)
    , std::move(callback));
}
WebNNContextAsyncWaiter::WebNNContextAsyncWaiter(
    WebNNContext* proxy) : proxy_(proxy) {}

WebNNContextAsyncWaiter::~WebNNContextAsyncWaiter() = default;


void WebNNContextAsyncWaiter::CreateTensor(
    ::webnn::mojom::blink::TensorInfoPtr tensor_info, ::mojo_base::BigBuffer tensor_data, CreateTensorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CreateTensor(
      std::move(tensor_info),
      std::move(tensor_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateTensorResultPtr* out_result
,
             CreateTensorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CreateTensorResultPtr WebNNContextAsyncWaiter::CreateTensor(
    ::webnn::mojom::blink::TensorInfoPtr tensor_info, ::mojo_base::BigBuffer tensor_data) {
  CreateTensorResultPtr async_wait_result;
  CreateTensor(std::move(tensor_info),std::move(tensor_data),&async_wait_result);
  return async_wait_result;
}

void WebNNContextAsyncWaiter::CreateTensorFromMailbox(
    ::webnn::mojom::blink::TensorInfoPtr tensor_info, const ::gpu::Mailbox& mailbox, const ::gpu::SyncToken& fence, CreateTensorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CreateTensorFromMailbox(
      std::move(tensor_info),
      std::move(mailbox),
      std::move(fence),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateTensorResultPtr* out_result
,
             CreateTensorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CreateTensorResultPtr WebNNContextAsyncWaiter::CreateTensorFromMailbox(
    ::webnn::mojom::blink::TensorInfoPtr tensor_info, const ::gpu::Mailbox& mailbox, const ::gpu::SyncToken& fence) {
  CreateTensorResultPtr async_wait_result;
  CreateTensorFromMailbox(std::move(tensor_info),std::move(mailbox),std::move(fence),&async_wait_result);
  return async_wait_result;
}






}  // webnn::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif