// services/viz/public/mojom/compositing/transferable_resource.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/transferable_resource.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-test-utils.h"


namespace viz::mojom {
TransferableResource::TransferableResource()
    : id(),
      format(),
      size(),
      memory_buffer_id(),
      sync_token(),
      texture_target(),
      synchronization_type(),
      is_software(),
      is_overlay_candidate(),
      is_low_latency_rendering(),
      color_space(),
      hdr_metadata(),
      needs_detiling(),
      origin(),
      alpha_type(),
      resource_source() {}

TransferableResource::TransferableResource(
    const ::viz::ResourceId& id_in,
    const ::viz::SharedImageFormat& format_in,
    const ::gfx::Size& size_in,
    const ::gpu::Mailbox& memory_buffer_id_in,
    const ::gpu::SyncToken& sync_token_in,
    uint32_t texture_target_in,
    SynchronizationType synchronization_type_in,
    bool is_software_in,
    bool is_overlay_candidate_in,
    bool is_low_latency_rendering_in,
    const ::gfx::ColorSpace& color_space_in,
    const ::gfx::HDRMetadata& hdr_metadata_in,
    bool needs_detiling_in,
    ::GrSurfaceOrigin origin_in,
    ::SkAlphaType alpha_type_in,
    ResourceSource resource_source_in)
    : id(std::move(id_in)),
      format(std::move(format_in)),
      size(std::move(size_in)),
      memory_buffer_id(std::move(memory_buffer_id_in)),
      sync_token(std::move(sync_token_in)),
      texture_target(std::move(texture_target_in)),
      synchronization_type(std::move(synchronization_type_in)),
      is_software(std::move(is_software_in)),
      is_overlay_candidate(std::move(is_overlay_candidate_in)),
      is_low_latency_rendering(std::move(is_low_latency_rendering_in)),
      color_space(std::move(color_space_in)),
      hdr_metadata(std::move(hdr_metadata_in)),
      needs_detiling(std::move(needs_detiling_in)),
      origin(std::move(origin_in)),
      alpha_type(std::move(alpha_type_in)),
      resource_source(std::move(resource_source_in)) {}

TransferableResource::~TransferableResource() = default;

void TransferableResource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::ResourceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::SharedImageFormat&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "memory_buffer_id"), this->memory_buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token"), this->sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SyncToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_target"), this->texture_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "synchronization_type"), this->synchronization_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SynchronizationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_software"), this->is_software,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_overlay_candidate"), this->is_overlay_candidate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_low_latency_rendering"), this->is_low_latency_rendering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::HDRMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_detiling"), this->needs_detiling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::GrSurfaceOrigin>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_type"), this->alpha_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkAlphaType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_source"), this->resource_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResourceSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TransferableResource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::TransferableResource::DataView, ::viz::mojom::TransferableResourcePtr>::Read(
    ::viz::mojom::TransferableResource::DataView input,
    ::viz::mojom::TransferableResourcePtr* output) {
  bool success = true;
  ::viz::mojom::TransferableResourcePtr result(::viz::mojom::TransferableResource::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadMemoryBufferId(&result->memory_buffer_id))
        success = false;
      if (success && !input.ReadSyncToken(&result->sync_token))
        success = false;
      if (success)
        result->texture_target = input.texture_target();
      if (success && !input.ReadSynchronizationType(&result->synchronization_type))
        success = false;
      if (success)
        result->is_software = input.is_software();
      if (success)
        result->is_overlay_candidate = input.is_overlay_candidate();
      if (success)
        result->is_low_latency_rendering = input.is_low_latency_rendering();
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
      if (success)
        result->needs_detiling = input.needs_detiling();
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadAlphaType(&result->alpha_type))
        success = false;
      if (success && !input.ReadResourceSource(&result->resource_source))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif