// services/viz/public/mojom/compositing/tiling.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/tiling.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "cc/mojom/missing_tile_reason.mojom-shared.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TileResourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileResourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TileResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::resource(input)) in_resource = Traits::resource(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resource)::BaseType> resource_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::TransferableResourceDataView, send_validation>(
        in_resource,
        resource_fragment);

      fragment->resource.Set(
          resource_fragment.is_null() ? nullptr : resource_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resource.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resource in TileResource struct");

      fragment->is_checkered = Traits::is_checkered(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Tile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->column_index = Traits::column_index(input);

      fragment->row_index = Traits::row_index(input);

      decltype(Traits::contents(input)) in_contents = Traits::contents(input);
      mojo::internal::MessageFragment<decltype(fragment->contents)>
          contents_fragment(fragment.message());
      contents_fragment.Claim(&fragment->contents);
      
      mojo::internal::Serialize<::viz::mojom::TileContentsDataView, send_validation>(
        in_contents,
        contents_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->contents.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contents in Tile struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TilingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TilingDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Tiling_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->layer_id = Traits::layer_id(input);

      decltype(Traits::raster_translation(input)) in_raster_translation = Traits::raster_translation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->raster_translation)::BaseType> raster_translation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_raster_translation,
        raster_translation_fragment);

      fragment->raster_translation.Set(
          raster_translation_fragment.is_null() ? nullptr : raster_translation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->raster_translation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raster_translation in Tiling struct");

      decltype(Traits::raster_scale(input)) in_raster_scale = Traits::raster_scale(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->raster_scale)::BaseType> raster_scale_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_raster_scale,
        raster_scale_fragment);

      fragment->raster_scale.Set(
          raster_scale_fragment.is_null() ? nullptr : raster_scale_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->raster_scale.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raster_scale in Tiling struct");

      decltype(Traits::tile_size(input)) in_tile_size = Traits::tile_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tile_size)::BaseType> tile_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_tile_size,
        tile_size_fragment);

      fragment->tile_size.Set(
          tile_size_fragment.is_null() ? nullptr : tile_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tile_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tile_size in Tiling struct");

      decltype(Traits::tiling_rect(input)) in_tiling_rect = Traits::tiling_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tiling_rect)::BaseType> tiling_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_tiling_rect,
        tiling_rect_fragment);

      fragment->tiling_rect.Set(
          tiling_rect_fragment.is_null() ? nullptr : tiling_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tiling_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tiling_rect in Tiling struct");

      decltype(Traits::tiles(input)) in_tiles = Traits::tiles(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tiles)::BaseType>
          tiles_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& tiles_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TileDataView>, send_validation>(
        in_tiles,
        tiles_fragment,
        &tiles_validate_params);

      fragment->tiles.Set(
          tiles_fragment.is_null() ? nullptr : tiles_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tiles.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tiles in Tiling struct");

      fragment->scale_key = Traits::scale_key(input);

      fragment->is_deleted = Traits::is_deleted(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TileContentsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::TileContentsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::TileContents_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::TileContentsDataView::Tag::kMissingReason: {
    decltype(Traits::missing_reason(input))
    in_missing_reason = Traits::missing_reason(input);
        
mojo::internal::Serialize<::cc::mojom::MissingTileReason, send_validation>(
  in_missing_reason,
  &fragment->data.f_missing_reason);
    break;
  }
  case ::viz::mojom::TileContentsDataView::Tag::kResource: {
    decltype(Traits::resource(input))
    in_resource = Traits::resource(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_resource)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::TileResourceDataView, send_validation>(
  in_resource,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null resource in TileContents union");
    fragment->data.f_resource.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TileContentsDataView::Tag::kSolidColor: {
    decltype(Traits::solid_color(input))
    in_solid_color = Traits::solid_color(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_solid_color)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::SkColor4fDataView, send_validation>(
  in_solid_color,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null solid_color in TileContents union");
    fragment->data.f_solid_color.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SEND_VALIDATION_H_