// services/viz/public/mojom/compositing/thread.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/thread.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/thread.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* ThreadTypeToStringHelper(ThreadType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ThreadType::kMain:
      return "kMain";
    case ThreadType::kIO:
      return "kIO";
    case ThreadType::kCompositor:
      return "kCompositor";
    case ThreadType::kVideo:
      return "kVideo";
    case ThreadType::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string ThreadTypeToString(ThreadType value) {
  const char *str = ThreadTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ThreadType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ThreadType value) {
  return os << ThreadTypeToString(value);
}

namespace internal {


// static
bool Thread_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Thread_Data* object =
      static_cast<const Thread_Data*>(data);


  if (!::viz::mojom::internal::ThreadType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

Thread_Data::Thread_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ThreadType>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::ThreadType value) {
  return std::move(context).WriteString(::viz::mojom::ThreadTypeToString(value));
}

} // namespace perfetto