// services/viz/public/mojom/compositing/subtree_capture_id.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/token.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/viz/public/cpp/compositing/subtree_capture_id_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT SubtreeCaptureId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubtreeCaptureId, T>::value>;
  using DataView = SubtreeCaptureIdDataView;
  using Data_ = internal::SubtreeCaptureId_Data;

  template <typename... Args>
  static SubtreeCaptureIdPtr New(Args&&... args) {
    return SubtreeCaptureIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubtreeCaptureIdPtr From(const U& u) {
    return mojo::TypeConverter<SubtreeCaptureIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubtreeCaptureId>::Convert(*this);
  }


  SubtreeCaptureId();

  explicit SubtreeCaptureId(
      const ::base::Token& subtree_id);


  ~SubtreeCaptureId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubtreeCaptureIdPtr>
  SubtreeCaptureIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubtreeCaptureId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubtreeCaptureId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubtreeCaptureId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubtreeCaptureId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubtreeCaptureId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubtreeCaptureId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubtreeCaptureId_UnserializedMessageContext<
            UserType, SubtreeCaptureId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubtreeCaptureId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubtreeCaptureId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubtreeCaptureId_UnserializedMessageContext<
            UserType, SubtreeCaptureId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubtreeCaptureId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Token subtree_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubtreeCaptureId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubtreeCaptureId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubtreeCaptureId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubtreeCaptureId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SubtreeCaptureIdPtr SubtreeCaptureId::Clone() const {
  return New(
      mojo::Clone(subtree_id)
  );
}

template <typename T, SubtreeCaptureId::EnableIfSame<T>*>
bool SubtreeCaptureId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subtree_id, other_struct.subtree_id))
    return false;
  return true;
}

template <typename T, SubtreeCaptureId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subtree_id < rhs.subtree_id)
    return true;
  if (rhs.subtree_id < lhs.subtree_id)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::SubtreeCaptureId::DataView,
                                         ::viz::mojom::blink::SubtreeCaptureIdPtr> {
  static bool IsNull(const ::viz::mojom::blink::SubtreeCaptureIdPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::SubtreeCaptureIdPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::SubtreeCaptureId::subtree_id)& subtree_id(
      const ::viz::mojom::blink::SubtreeCaptureIdPtr& input) {
    return input->subtree_id;
  }

  static bool Read(::viz::mojom::blink::SubtreeCaptureId::DataView input, ::viz::mojom::blink::SubtreeCaptureIdPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_BLINK_H_