// services/viz/public/mojom/compositing/offset_tag.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/offset_tag.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/token.mojom', '../../../../../mojo/public/mojom/base/token.mojom.js');
  }
  var surface_range$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/surface_range.mojom', 'surface_range.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function OffsetTag(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OffsetTag.prototype.initDefaults_ = function() {
    this.token = null;
  };
  OffsetTag.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OffsetTag.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OffsetTag.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, token$.Token, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OffsetTag.encodedSize = codec.kStructHeaderSize + 8;

  OffsetTag.decode = function(decoder) {
    var packed;
    var val = new OffsetTag();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(token$.Token);
    return val;
  };

  OffsetTag.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OffsetTag.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(token$.Token, val.token);
  };
  function OffsetTagValue(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OffsetTagValue.prototype.initDefaults_ = function() {
    this.tag = null;
    this.offset = null;
  };
  OffsetTagValue.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OffsetTagValue.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OffsetTagValue.tag
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OffsetTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OffsetTagValue.offset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OffsetTagValue.encodedSize = codec.kStructHeaderSize + 16;

  OffsetTagValue.decode = function(decoder) {
    var packed;
    var val = new OffsetTagValue();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tag =
        decoder.decodeStructPointer(OffsetTag);
    val.offset =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    return val;
  };

  OffsetTagValue.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OffsetTagValue.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OffsetTag, val.tag);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.offset);
  };
  function OffsetTagDefinition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OffsetTagDefinition.prototype.initDefaults_ = function() {
    this.tag = null;
    this.provider = null;
    this.minOffset = null;
    this.maxOffset = null;
  };
  OffsetTagDefinition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OffsetTagDefinition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OffsetTagDefinition.tag
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OffsetTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OffsetTagDefinition.provider
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, surface_range$.SurfaceRange, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OffsetTagDefinition.minOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OffsetTagDefinition.maxOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OffsetTagDefinition.encodedSize = codec.kStructHeaderSize + 32;

  OffsetTagDefinition.decode = function(decoder) {
    var packed;
    var val = new OffsetTagDefinition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tag =
        decoder.decodeStructPointer(OffsetTag);
    val.provider =
        decoder.decodeStructPointer(surface_range$.SurfaceRange);
    val.minOffset =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.maxOffset =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    return val;
  };

  OffsetTagDefinition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OffsetTagDefinition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OffsetTag, val.tag);
    encoder.encodeStructPointer(surface_range$.SurfaceRange, val.provider);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.minOffset);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.maxOffset);
  };
  exports.OffsetTag = OffsetTag;
  exports.OffsetTagValue = OffsetTagValue;
  exports.OffsetTagDefinition = OffsetTagDefinition;
})();