// services/viz/public/mojom/compositing/layer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/layer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var element_id$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/element_id.mojom', '../../../../../cc/mojom/element_id.mojom.js');
  }
  var hit_test_opaqueness$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/hit_test_opaqueness.mojom', '../../../../../cc/mojom/hit_test_opaqueness.mojom.js');
  }
  var layer_type$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/layer_type.mojom', '../../../../../cc/mojom/layer_type.mojom.js');
  }
  var paint_flags$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/paint_flags.mojom', '../../../../../cc/mojom/paint_flags.mojom.js');
  }
  var render_surface_reason$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/render_surface_reason.mojom', '../../../../../cc/mojom/render_surface_reason.mojom.js');
  }
  var synced_scroll_offset$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/synced_scroll_offset.mojom', '../../../../../cc/mojom/synced_scroll_offset.mojom.js');
  }
  var ui_resource_id$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/ui_resource_id.mojom', '../../../../../cc/mojom/ui_resource_id.mojom.js');
  }
  var skcolor4f$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor4f.mojom', '../../../../../skia/public/mojom/skcolor4f.mojom.js');
  }
  var skpath$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skpath.mojom', '../../../../../skia/public/mojom/skpath.mojom.js');
  }
  var surface_range$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/surface_range.mojom', 'surface_range.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var mask_filter_info$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/mask_filter_info.mojom', '../../../../../ui/gfx/mojom/mask_filter_info.mojom.js');
  }
  var rrect_f$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/rrect_f.mojom', '../../../../../ui/gfx/mojom/rrect_f.mojom.js');
  }
  var copy_output_request$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/copy_output_request.mojom', 'copy_output_request.mojom.js');
  }
  var filter_operations$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/filter_operations.mojom', 'filter_operations.mojom.js');
  }
  var region_capture_bounds$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/region_capture_bounds.mojom', 'region_capture_bounds.mojom.js');
  }
  var resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/resource_id.mojom', 'resource_id.mojom.js');
  }
  var subtree_capture_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/subtree_capture_id.mojom', 'subtree_capture_id.mojom.js');
  }
  var transferable_resource$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/transferable_resource.mojom', 'transferable_resource.mojom.js');
  }
  var view_transition_element_resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom', 'view_transition_element_resource_id.mojom.js');
  }
  var display_color_spaces$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/display_color_spaces.mojom', '../../../../../ui/gfx/mojom/display_color_spaces.mojom.js');
  }
  var transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/transform.mojom', '../../../../../ui/gfx/mojom/transform.mojom.js');
  }



  function RareProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RareProperties.prototype.initDefaults_ = function() {
    this.filterQuality = paint_flags$.FilterQuality.kLow;
    this.dynamicRangeLimit = null;
    this.captureBounds = null;
  };
  RareProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RareProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RareProperties.filterQuality
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, paint_flags$.FilterQuality);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RareProperties.dynamicRangeLimit
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, paint_flags$.DynamicRangeLimit, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RareProperties.captureBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, region_capture_bounds$.RegionCaptureBounds, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RareProperties.encodedSize = codec.kStructHeaderSize + 24;

  RareProperties.decode = function(decoder) {
    var packed;
    var val = new RareProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filterQuality =
        decoder.decodeStruct(new codec.Enum(paint_flags$.FilterQuality));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dynamicRangeLimit =
        decoder.decodeStructPointer(paint_flags$.DynamicRangeLimit);
    val.captureBounds =
        decoder.decodeStructPointer(region_capture_bounds$.RegionCaptureBounds);
    return val;
  };

  RareProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RareProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.filterQuality);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(paint_flags$.DynamicRangeLimit, val.dynamicRangeLimit);
    encoder.encodeStructPointer(region_capture_bounds$.RegionCaptureBounds, val.captureBounds);
  };
  function MirrorLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MirrorLayerExtra.prototype.initDefaults_ = function() {
    this.mirroredLayerId = 0;
  };
  MirrorLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MirrorLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MirrorLayerExtra.encodedSize = codec.kStructHeaderSize + 8;

  MirrorLayerExtra.decode = function(decoder) {
    var packed;
    var val = new MirrorLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mirroredLayerId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MirrorLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MirrorLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mirroredLayerId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SurfaceLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SurfaceLayerExtra.prototype.initDefaults_ = function() {
    this.surfaceRange = null;
    this.deadline_in_frames_$flag = false;
    this.stretchContentToFillBounds = false;
    this.surfaceHitTestable = false;
    this.hasPointerEventsNone = false;
    this.isReflection = false;
    this.willDrawNeedsReset = false;
    this.overrideChildPaintFlags = false;
    this.deadline_in_frames_$value = 0;
  };
  SurfaceLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SurfaceLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SurfaceLayerExtra.surfaceRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, surface_range$.SurfaceRange, false);
    if (err !== validator.validationError.NONE)
        return err;









    return validator.validationError.NONE;
  };

  SurfaceLayerExtra.encodedSize = codec.kStructHeaderSize + 16;

  SurfaceLayerExtra.decode = function(decoder) {
    var packed;
    var val = new SurfaceLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.surfaceRange =
        decoder.decodeStructPointer(surface_range$.SurfaceRange);
    packed = decoder.readUint8();
    val.deadline_in_frames_$flag = (packed >> 0) & 1 ? true : false;
    val.stretchContentToFillBounds = (packed >> 1) & 1 ? true : false;
    val.surfaceHitTestable = (packed >> 2) & 1 ? true : false;
    val.hasPointerEventsNone = (packed >> 3) & 1 ? true : false;
    val.isReflection = (packed >> 4) & 1 ? true : false;
    val.willDrawNeedsReset = (packed >> 5) & 1 ? true : false;
    val.overrideChildPaintFlags = (packed >> 6) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.deadline_in_frames_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  SurfaceLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SurfaceLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(surface_range$.SurfaceRange, val.surfaceRange);
    packed = 0;
    packed |= (val.deadline_in_frames_$flag & 1) << 0
    packed |= (val.stretchContentToFillBounds & 1) << 1
    packed |= (val.surfaceHitTestable & 1) << 2
    packed |= (val.hasPointerEventsNone & 1) << 3
    packed |= (val.isReflection & 1) << 4
    packed |= (val.willDrawNeedsReset & 1) << 5
    packed |= (val.overrideChildPaintFlags & 1) << 6
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.deadline_in_frames_$value);
  };
  function TextureLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextureLayerExtra.prototype.initDefaults_ = function() {
    this.blendBackgroundColor = false;
    this.forceTextureToOpaque = false;
    this.uvTopLeft = null;
    this.uvBottomRight = null;
    this.transferableResource = null;
  };
  TextureLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextureLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate TextureLayerExtra.uvTopLeft
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureLayerExtra.uvBottomRight
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureLayerExtra.transferableResource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, transferable_resource$.TransferableResource, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextureLayerExtra.encodedSize = codec.kStructHeaderSize + 32;

  TextureLayerExtra.decode = function(decoder) {
    var packed;
    var val = new TextureLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.blendBackgroundColor = (packed >> 0) & 1 ? true : false;
    val.forceTextureToOpaque = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.uvTopLeft =
        decoder.decodeStructPointer(geometry$.PointF);
    val.uvBottomRight =
        decoder.decodeStructPointer(geometry$.PointF);
    val.transferableResource =
        decoder.decodeStructPointer(transferable_resource$.TransferableResource);
    return val;
  };

  TextureLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextureLayerExtra.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.blendBackgroundColor & 1) << 0
    packed |= (val.forceTextureToOpaque & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.PointF, val.uvTopLeft);
    encoder.encodeStructPointer(geometry$.PointF, val.uvBottomRight);
    encoder.encodeStructPointer(transferable_resource$.TransferableResource, val.transferableResource);
  };
  function UIResourceLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UIResourceLayerExtra.prototype.initDefaults_ = function() {
    this.uiResourceId = null;
    this.imageBounds = null;
    this.uvTopLeft = null;
    this.uvBottomRight = null;
  };
  UIResourceLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UIResourceLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UIResourceLayerExtra.uiResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ui_resource_id$.UIResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UIResourceLayerExtra.imageBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UIResourceLayerExtra.uvTopLeft
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UIResourceLayerExtra.uvBottomRight
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UIResourceLayerExtra.encodedSize = codec.kStructHeaderSize + 32;

  UIResourceLayerExtra.decode = function(decoder) {
    var packed;
    var val = new UIResourceLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.uiResourceId =
        decoder.decodeStructPointer(ui_resource_id$.UIResourceId);
    val.imageBounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.uvTopLeft =
        decoder.decodeStructPointer(geometry$.PointF);
    val.uvBottomRight =
        decoder.decodeStructPointer(geometry$.PointF);
    return val;
  };

  UIResourceLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UIResourceLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ui_resource_id$.UIResourceId, val.uiResourceId);
    encoder.encodeStructPointer(geometry$.Size, val.imageBounds);
    encoder.encodeStructPointer(geometry$.PointF, val.uvTopLeft);
    encoder.encodeStructPointer(geometry$.PointF, val.uvBottomRight);
  };
  function TileDisplayLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TileDisplayLayerExtra.prototype.initDefaults_ = function() {
    this.solidColor = null;
    this.isBackdropFilterMask = false;
    this.isDirectlyCompositedImage = false;
    this.nearestNeighbor = false;
    this.contentColorUsage = 0;
    this.recordedBounds = null;
  };
  TileDisplayLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TileDisplayLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TileDisplayLayerExtra.solidColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, skcolor4f$.SkColor4f, true);
    if (err !== validator.validationError.NONE)
        return err;





    // validate TileDisplayLayerExtra.contentColorUsage
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, display_color_spaces$.ContentColorUsage);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TileDisplayLayerExtra.recordedBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TileDisplayLayerExtra.encodedSize = codec.kStructHeaderSize + 24;

  TileDisplayLayerExtra.decode = function(decoder) {
    var packed;
    var val = new TileDisplayLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.solidColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    packed = decoder.readUint8();
    val.isBackdropFilterMask = (packed >> 0) & 1 ? true : false;
    val.isDirectlyCompositedImage = (packed >> 1) & 1 ? true : false;
    val.nearestNeighbor = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.contentColorUsage =
        decoder.decodeStruct(new codec.Enum(display_color_spaces$.ContentColorUsage));
    val.recordedBounds =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  TileDisplayLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TileDisplayLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.solidColor);
    packed = 0;
    packed |= (val.isBackdropFilterMask & 1) << 0
    packed |= (val.isDirectlyCompositedImage & 1) << 1
    packed |= (val.nearestNeighbor & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.contentColorUsage);
    encoder.encodeStructPointer(geometry$.Rect, val.recordedBounds);
  };
  function ScrollbarLayerBaseExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScrollbarLayerBaseExtra.prototype.initDefaults_ = function() {
    this.scrollElementId = null;
    this.isOverlayScrollbar = false;
    this.isWebTest = false;
    this.isHorizontalOrientation = false;
    this.isLeftSideVerticalScrollbar = false;
    this.hasFindInPageTickmarks = false;
    this.thumbThicknessScaleFactor = 0;
    this.currentPos = 0;
    this.clipLayerLength = 0;
    this.scrollLayerLength = 0;
    this.verticalAdjust = 0;
  };
  ScrollbarLayerBaseExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScrollbarLayerBaseExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScrollbarLayerBaseExtra.scrollElementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;











    return validator.validationError.NONE;
  };

  ScrollbarLayerBaseExtra.encodedSize = codec.kStructHeaderSize + 32;

  ScrollbarLayerBaseExtra.decode = function(decoder) {
    var packed;
    var val = new ScrollbarLayerBaseExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollElementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    packed = decoder.readUint8();
    val.isOverlayScrollbar = (packed >> 0) & 1 ? true : false;
    val.isWebTest = (packed >> 1) & 1 ? true : false;
    val.isHorizontalOrientation = (packed >> 2) & 1 ? true : false;
    val.isLeftSideVerticalScrollbar = (packed >> 3) & 1 ? true : false;
    val.hasFindInPageTickmarks = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.thumbThicknessScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.currentPos =
        decoder.decodeStruct(codec.Float);
    val.clipLayerLength =
        decoder.decodeStruct(codec.Float);
    val.scrollLayerLength =
        decoder.decodeStruct(codec.Float);
    val.verticalAdjust =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  ScrollbarLayerBaseExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScrollbarLayerBaseExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(element_id$.ElementId, val.scrollElementId);
    packed = 0;
    packed |= (val.isOverlayScrollbar & 1) << 0
    packed |= (val.isWebTest & 1) << 1
    packed |= (val.isHorizontalOrientation & 1) << 2
    packed |= (val.isLeftSideVerticalScrollbar & 1) << 3
    packed |= (val.hasFindInPageTickmarks & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.thumbThicknessScaleFactor);
    encoder.encodeStruct(codec.Float, val.currentPos);
    encoder.encodeStruct(codec.Float, val.clipLayerLength);
    encoder.encodeStruct(codec.Float, val.scrollLayerLength);
    encoder.encodeStruct(codec.Float, val.verticalAdjust);
  };
  function NinePatchThumbScrollbarLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NinePatchThumbScrollbarLayerExtra.prototype.initDefaults_ = function() {
    this.scrollbarBaseExtra = null;
    this.thumbThickness = 0;
    this.thumbLength = 0;
    this.trackStart = 0;
    this.trackLength = 0;
    this.imageBounds = null;
    this.aperture = null;
    this.thumbUiResourceId = null;
    this.trackAndButtonsUiResourceId = null;
  };
  NinePatchThumbScrollbarLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NinePatchThumbScrollbarLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchThumbScrollbarLayerExtra.scrollbarBaseExtra
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ScrollbarLayerBaseExtra, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate NinePatchThumbScrollbarLayerExtra.imageBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchThumbScrollbarLayerExtra.aperture
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchThumbScrollbarLayerExtra.thumbUiResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, ui_resource_id$.UIResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchThumbScrollbarLayerExtra.trackAndButtonsUiResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, ui_resource_id$.UIResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NinePatchThumbScrollbarLayerExtra.encodedSize = codec.kStructHeaderSize + 56;

  NinePatchThumbScrollbarLayerExtra.decode = function(decoder) {
    var packed;
    var val = new NinePatchThumbScrollbarLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollbarBaseExtra =
        decoder.decodeStructPointer(ScrollbarLayerBaseExtra);
    val.thumbThickness =
        decoder.decodeStruct(codec.Int32);
    val.thumbLength =
        decoder.decodeStruct(codec.Int32);
    val.trackStart =
        decoder.decodeStruct(codec.Int32);
    val.trackLength =
        decoder.decodeStruct(codec.Int32);
    val.imageBounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.aperture =
        decoder.decodeStructPointer(geometry$.Rect);
    val.thumbUiResourceId =
        decoder.decodeStructPointer(ui_resource_id$.UIResourceId);
    val.trackAndButtonsUiResourceId =
        decoder.decodeStructPointer(ui_resource_id$.UIResourceId);
    return val;
  };

  NinePatchThumbScrollbarLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NinePatchThumbScrollbarLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ScrollbarLayerBaseExtra, val.scrollbarBaseExtra);
    encoder.encodeStruct(codec.Int32, val.thumbThickness);
    encoder.encodeStruct(codec.Int32, val.thumbLength);
    encoder.encodeStruct(codec.Int32, val.trackStart);
    encoder.encodeStruct(codec.Int32, val.trackLength);
    encoder.encodeStructPointer(geometry$.Size, val.imageBounds);
    encoder.encodeStructPointer(geometry$.Rect, val.aperture);
    encoder.encodeStructPointer(ui_resource_id$.UIResourceId, val.thumbUiResourceId);
    encoder.encodeStructPointer(ui_resource_id$.UIResourceId, val.trackAndButtonsUiResourceId);
  };
  function PaintedScrollbarLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PaintedScrollbarLayerExtra.prototype.initDefaults_ = function() {
    this.scrollbarBaseExtra = null;
    this.internalContentsScale = 0;
    this.jumpOnTrackClick = false;
    this.supportsDragSnapBack = false;
    this.usesNinePatchTrackAndButtons = false;
    this.internalContentBounds = null;
    this.thumbThickness = 0;
    this.thumbLength = 0;
    this.backButtonRect = null;
    this.forwardButtonRect = null;
    this.trackRect = null;
    this.thumbColor = null;
    this.trackAndButtonsImageBounds = null;
    this.trackAndButtonsAperture = null;
    this.paintedOpacity = 0;
    this.trackAndButtonsUiResourceId = null;
    this.thumbUiResourceId = null;
  };
  PaintedScrollbarLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PaintedScrollbarLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 112}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaintedScrollbarLayerExtra.scrollbarBaseExtra
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ScrollbarLayerBaseExtra, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PaintedScrollbarLayerExtra.internalContentBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate PaintedScrollbarLayerExtra.backButtonRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaintedScrollbarLayerExtra.forwardButtonRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaintedScrollbarLayerExtra.trackRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaintedScrollbarLayerExtra.thumbColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, skcolor4f$.SkColor4f, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PaintedScrollbarLayerExtra.trackAndButtonsImageBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaintedScrollbarLayerExtra.trackAndButtonsAperture
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PaintedScrollbarLayerExtra.trackAndButtonsUiResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, ui_resource_id$.UIResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaintedScrollbarLayerExtra.thumbUiResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, ui_resource_id$.UIResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PaintedScrollbarLayerExtra.encodedSize = codec.kStructHeaderSize + 104;

  PaintedScrollbarLayerExtra.decode = function(decoder) {
    var packed;
    var val = new PaintedScrollbarLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollbarBaseExtra =
        decoder.decodeStructPointer(ScrollbarLayerBaseExtra);
    val.internalContentsScale =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.jumpOnTrackClick = (packed >> 0) & 1 ? true : false;
    val.supportsDragSnapBack = (packed >> 1) & 1 ? true : false;
    val.usesNinePatchTrackAndButtons = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.internalContentBounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.thumbThickness =
        decoder.decodeStruct(codec.Int32);
    val.thumbLength =
        decoder.decodeStruct(codec.Int32);
    val.backButtonRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.forwardButtonRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.trackRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.thumbColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    val.trackAndButtonsImageBounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.trackAndButtonsAperture =
        decoder.decodeStructPointer(geometry$.Rect);
    val.paintedOpacity =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.trackAndButtonsUiResourceId =
        decoder.decodeStructPointer(ui_resource_id$.UIResourceId);
    val.thumbUiResourceId =
        decoder.decodeStructPointer(ui_resource_id$.UIResourceId);
    return val;
  };

  PaintedScrollbarLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PaintedScrollbarLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ScrollbarLayerBaseExtra, val.scrollbarBaseExtra);
    encoder.encodeStruct(codec.Float, val.internalContentsScale);
    packed = 0;
    packed |= (val.jumpOnTrackClick & 1) << 0
    packed |= (val.supportsDragSnapBack & 1) << 1
    packed |= (val.usesNinePatchTrackAndButtons & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.internalContentBounds);
    encoder.encodeStruct(codec.Int32, val.thumbThickness);
    encoder.encodeStruct(codec.Int32, val.thumbLength);
    encoder.encodeStructPointer(geometry$.Rect, val.backButtonRect);
    encoder.encodeStructPointer(geometry$.Rect, val.forwardButtonRect);
    encoder.encodeStructPointer(geometry$.Rect, val.trackRect);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.thumbColor);
    encoder.encodeStructPointer(geometry$.Size, val.trackAndButtonsImageBounds);
    encoder.encodeStructPointer(geometry$.Rect, val.trackAndButtonsAperture);
    encoder.encodeStruct(codec.Float, val.paintedOpacity);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ui_resource_id$.UIResourceId, val.trackAndButtonsUiResourceId);
    encoder.encodeStructPointer(ui_resource_id$.UIResourceId, val.thumbUiResourceId);
  };
  function SolidColorScrollbarLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SolidColorScrollbarLayerExtra.prototype.initDefaults_ = function() {
    this.scrollbarBaseExtra = null;
    this.thumbThickness = 0;
    this.trackStart = 0;
    this.color = null;
  };
  SolidColorScrollbarLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SolidColorScrollbarLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SolidColorScrollbarLayerExtra.scrollbarBaseExtra
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ScrollbarLayerBaseExtra, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate SolidColorScrollbarLayerExtra.color
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SolidColorScrollbarLayerExtra.encodedSize = codec.kStructHeaderSize + 24;

  SolidColorScrollbarLayerExtra.decode = function(decoder) {
    var packed;
    var val = new SolidColorScrollbarLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollbarBaseExtra =
        decoder.decodeStructPointer(ScrollbarLayerBaseExtra);
    val.thumbThickness =
        decoder.decodeStruct(codec.Int32);
    val.trackStart =
        decoder.decodeStruct(codec.Int32);
    val.color =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    return val;
  };

  SolidColorScrollbarLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SolidColorScrollbarLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ScrollbarLayerBaseExtra, val.scrollbarBaseExtra);
    encoder.encodeStruct(codec.Int32, val.thumbThickness);
    encoder.encodeStruct(codec.Int32, val.trackStart);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.color);
  };
  function ViewTransitionContentLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewTransitionContentLayerExtra.prototype.initDefaults_ = function() {
    this.resourceId = null;
    this.isLiveContentLayer = false;
    this.maxExtentsRect = null;
  };
  ViewTransitionContentLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewTransitionContentLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionContentLayerExtra.resourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, view_transition_element_resource_id$.ViewTransitionElementResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ViewTransitionContentLayerExtra.maxExtentsRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ViewTransitionContentLayerExtra.encodedSize = codec.kStructHeaderSize + 24;

  ViewTransitionContentLayerExtra.decode = function(decoder) {
    var packed;
    var val = new ViewTransitionContentLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resourceId =
        decoder.decodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId);
    packed = decoder.readUint8();
    val.isLiveContentLayer = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.maxExtentsRect =
        decoder.decodeStructPointer(geometry$.RectF);
    return val;
  };

  ViewTransitionContentLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewTransitionContentLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId, val.resourceId);
    packed = 0;
    packed |= (val.isLiveContentLayer & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.RectF, val.maxExtentsRect);
  };
  function NinePatchLayerExtra(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NinePatchLayerExtra.prototype.initDefaults_ = function() {
    this.imageAperture = null;
    this.border = null;
    this.layerOcclusion = null;
    this.fillCenter = false;
    this.uiResourceId = null;
    this.imageBounds = null;
    this.uvTopLeft = null;
    this.uvBottomRight = null;
  };
  NinePatchLayerExtra.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NinePatchLayerExtra.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchLayerExtra.imageAperture
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchLayerExtra.border
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchLayerExtra.layerOcclusion
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NinePatchLayerExtra.uiResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, ui_resource_id$.UIResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchLayerExtra.imageBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchLayerExtra.uvTopLeft
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NinePatchLayerExtra.uvBottomRight
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NinePatchLayerExtra.encodedSize = codec.kStructHeaderSize + 64;

  NinePatchLayerExtra.decode = function(decoder) {
    var packed;
    var val = new NinePatchLayerExtra();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imageAperture =
        decoder.decodeStructPointer(geometry$.Rect);
    val.border =
        decoder.decodeStructPointer(geometry$.Rect);
    val.layerOcclusion =
        decoder.decodeStructPointer(geometry$.Rect);
    packed = decoder.readUint8();
    val.fillCenter = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.uiResourceId =
        decoder.decodeStructPointer(ui_resource_id$.UIResourceId);
    val.imageBounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.uvTopLeft =
        decoder.decodeStructPointer(geometry$.PointF);
    val.uvBottomRight =
        decoder.decodeStructPointer(geometry$.PointF);
    return val;
  };

  NinePatchLayerExtra.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NinePatchLayerExtra.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.imageAperture);
    encoder.encodeStructPointer(geometry$.Rect, val.border);
    encoder.encodeStructPointer(geometry$.Rect, val.layerOcclusion);
    packed = 0;
    packed |= (val.fillCenter & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ui_resource_id$.UIResourceId, val.uiResourceId);
    encoder.encodeStructPointer(geometry$.Size, val.imageBounds);
    encoder.encodeStructPointer(geometry$.PointF, val.uvTopLeft);
    encoder.encodeStructPointer(geometry$.PointF, val.uvBottomRight);
  };
  function Layer(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Layer.prototype.initDefaults_ = function() {
    this.id = 0;
    this.type = 0;
    this.contentsOpaque = false;
    this.contentsOpaqueForText = false;
    this.isDrawable = false;
    this.layerPropertyChangedNotFromPropertyTrees = false;
    this.layerPropertyChangedFromPropertyTrees = false;
    this.shouldCheckBackfaceVisibility = false;
    this.bounds = null;
    this.hitTestOpaqueness = 0;
    this.transformTreeIndex = 0;
    this.backgroundColor = null;
    this.safeOpaqueBackgroundColor = null;
    this.elementId = null;
    this.updateRect = null;
    this.offsetToTransformParent = null;
    this.clipTreeIndex = 0;
    this.effectTreeIndex = 0;
    this.scrollTreeIndex = 0;
    this.rareProperties = null;
    this.layerExtra = null;
  };
  Layer.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Layer.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 120}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Layer.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, layer_type$.LayerType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Layer.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate Layer.hitTestOpaqueness
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, hit_test_opaqueness$.HitTestOpaqueness);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Layer.backgroundColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Layer.safeOpaqueBackgroundColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Layer.elementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Layer.updateRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Layer.offsetToTransformParent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate Layer.rareProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, RareProperties, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Layer.layerExtra
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 96, LayerExtra, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Layer.encodedSize = codec.kStructHeaderSize + 112;

  Layer.decode = function(decoder) {
    var packed;
    var val = new Layer();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int64);
    val.type =
        decoder.decodeStruct(new codec.Enum(layer_type$.LayerType));
    packed = decoder.readUint8();
    val.contentsOpaque = (packed >> 0) & 1 ? true : false;
    val.contentsOpaqueForText = (packed >> 1) & 1 ? true : false;
    val.isDrawable = (packed >> 2) & 1 ? true : false;
    val.layerPropertyChangedNotFromPropertyTrees = (packed >> 3) & 1 ? true : false;
    val.layerPropertyChangedFromPropertyTrees = (packed >> 4) & 1 ? true : false;
    val.shouldCheckBackfaceVisibility = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.bounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.hitTestOpaqueness =
        decoder.decodeStruct(new codec.Enum(hit_test_opaqueness$.HitTestOpaqueness));
    val.transformTreeIndex =
        decoder.decodeStruct(codec.Int32);
    val.backgroundColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    val.safeOpaqueBackgroundColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    val.elementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    val.updateRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.offsetToTransformParent =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.clipTreeIndex =
        decoder.decodeStruct(codec.Int32);
    val.effectTreeIndex =
        decoder.decodeStruct(codec.Int32);
    val.scrollTreeIndex =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.rareProperties =
        decoder.decodeStructPointer(RareProperties);
    val.layerExtra =
        decoder.decodeStruct(LayerExtra);
    return val;
  };

  Layer.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Layer.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.id);
    encoder.encodeStruct(codec.Int32, val.type);
    packed = 0;
    packed |= (val.contentsOpaque & 1) << 0
    packed |= (val.contentsOpaqueForText & 1) << 1
    packed |= (val.isDrawable & 1) << 2
    packed |= (val.layerPropertyChangedNotFromPropertyTrees & 1) << 3
    packed |= (val.layerPropertyChangedFromPropertyTrees & 1) << 4
    packed |= (val.shouldCheckBackfaceVisibility & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.bounds);
    encoder.encodeStruct(codec.Int32, val.hitTestOpaqueness);
    encoder.encodeStruct(codec.Int32, val.transformTreeIndex);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.backgroundColor);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.safeOpaqueBackgroundColor);
    encoder.encodeStructPointer(element_id$.ElementId, val.elementId);
    encoder.encodeStructPointer(geometry$.Rect, val.updateRect);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.offsetToTransformParent);
    encoder.encodeStruct(codec.Int32, val.clipTreeIndex);
    encoder.encodeStruct(codec.Int32, val.effectTreeIndex);
    encoder.encodeStruct(codec.Int32, val.scrollTreeIndex);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(RareProperties, val.rareProperties);
    encoder.encodeStruct(LayerExtra, val.layerExtra);
  };
  function AnchorPositionScrollData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorPositionScrollData.prototype.initDefaults_ = function() {
    this.adjustmentContainerIds = null;
    this.accumulatedScrollOrigin = null;
    this.needsScrollAdjustmentInX = false;
    this.needsScrollAdjustmentInY = false;
  };
  AnchorPositionScrollData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorPositionScrollData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorPositionScrollData.adjustmentContainerIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(element_id$.ElementId), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorPositionScrollData.accumulatedScrollOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Vector2d, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AnchorPositionScrollData.encodedSize = codec.kStructHeaderSize + 24;

  AnchorPositionScrollData.decode = function(decoder) {
    var packed;
    var val = new AnchorPositionScrollData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.adjustmentContainerIds =
        decoder.decodeArrayPointer(new codec.PointerTo(element_id$.ElementId));
    val.accumulatedScrollOrigin =
        decoder.decodeStructPointer(geometry$.Vector2d);
    packed = decoder.readUint8();
    val.needsScrollAdjustmentInX = (packed >> 0) & 1 ? true : false;
    val.needsScrollAdjustmentInY = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AnchorPositionScrollData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorPositionScrollData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(element_id$.ElementId), val.adjustmentContainerIds);
    encoder.encodeStructPointer(geometry$.Vector2d, val.accumulatedScrollOrigin);
    packed = 0;
    packed |= (val.needsScrollAdjustmentInX & 1) << 0
    packed |= (val.needsScrollAdjustmentInY & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StickyPositionNodeData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StickyPositionNodeData.prototype.initDefaults_ = function() {
    this.scrollAncestor = 0;
    this.isAnchoredLeft = false;
    this.isAnchoredRight = false;
    this.isAnchoredTop = false;
    this.isAnchoredBottom = false;
    this.leftOffset = 0;
    this.rightOffset = 0;
    this.topOffset = 0;
    this.bottomOffset = 0;
    this.constraintBoxRect = null;
    this.scrollContainerRelativeStickyBoxRect = null;
    this.scrollContainerRelativeContainingBlockRect = null;
    this.pixelSnapOffset = null;
    this.nearestNodeShiftingStickyBox = 0;
    this.nearestNodeShiftingContainingBlock = 0;
    this.totalStickyBoxStickyOffset = null;
    this.totalContainingBlockStickyOffset = null;
  };
  StickyPositionNodeData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StickyPositionNodeData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;











    // validate StickyPositionNodeData.constraintBoxRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StickyPositionNodeData.scrollContainerRelativeStickyBoxRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StickyPositionNodeData.scrollContainerRelativeContainingBlockRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StickyPositionNodeData.pixelSnapOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate StickyPositionNodeData.totalStickyBoxStickyOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StickyPositionNodeData.totalContainingBlockStickyOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StickyPositionNodeData.encodedSize = codec.kStructHeaderSize + 80;

  StickyPositionNodeData.decode = function(decoder) {
    var packed;
    var val = new StickyPositionNodeData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollAncestor =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.isAnchoredLeft = (packed >> 0) & 1 ? true : false;
    val.isAnchoredRight = (packed >> 1) & 1 ? true : false;
    val.isAnchoredTop = (packed >> 2) & 1 ? true : false;
    val.isAnchoredBottom = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.leftOffset =
        decoder.decodeStruct(codec.Float);
    val.rightOffset =
        decoder.decodeStruct(codec.Float);
    val.topOffset =
        decoder.decodeStruct(codec.Float);
    val.bottomOffset =
        decoder.decodeStruct(codec.Float);
    val.constraintBoxRect =
        decoder.decodeStructPointer(geometry$.RectF);
    val.scrollContainerRelativeStickyBoxRect =
        decoder.decodeStructPointer(geometry$.RectF);
    val.scrollContainerRelativeContainingBlockRect =
        decoder.decodeStructPointer(geometry$.RectF);
    val.pixelSnapOffset =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.nearestNodeShiftingStickyBox =
        decoder.decodeStruct(codec.Int32);
    val.nearestNodeShiftingContainingBlock =
        decoder.decodeStruct(codec.Int32);
    val.totalStickyBoxStickyOffset =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.totalContainingBlockStickyOffset =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    return val;
  };

  StickyPositionNodeData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StickyPositionNodeData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.scrollAncestor);
    packed = 0;
    packed |= (val.isAnchoredLeft & 1) << 0
    packed |= (val.isAnchoredRight & 1) << 1
    packed |= (val.isAnchoredTop & 1) << 2
    packed |= (val.isAnchoredBottom & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.leftOffset);
    encoder.encodeStruct(codec.Float, val.rightOffset);
    encoder.encodeStruct(codec.Float, val.topOffset);
    encoder.encodeStruct(codec.Float, val.bottomOffset);
    encoder.encodeStructPointer(geometry$.RectF, val.constraintBoxRect);
    encoder.encodeStructPointer(geometry$.RectF, val.scrollContainerRelativeStickyBoxRect);
    encoder.encodeStructPointer(geometry$.RectF, val.scrollContainerRelativeContainingBlockRect);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.pixelSnapOffset);
    encoder.encodeStruct(codec.Int32, val.nearestNodeShiftingStickyBox);
    encoder.encodeStruct(codec.Int32, val.nearestNodeShiftingContainingBlock);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.totalStickyBoxStickyOffset);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.totalContainingBlockStickyOffset);
  };
  function TransformTreeUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TransformTreeUpdate.prototype.initDefaults_ = function() {
    this.pageScaleFactor = 0;
    this.deviceScaleFactor = 0;
    this.deviceTransformScaleFactor = 0;
    this.nodesAffectedByOuterViewportBoundsDelta = null;
    this.nodesAffectedBySafeAreaBottom = null;
    this.stickyPositionData = null;
    this.anchorPositionScrollData = null;
  };
  TransformTreeUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TransformTreeUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate TransformTreeUpdate.nodesAffectedByOuterViewportBoundsDelta
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, codec.Int32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformTreeUpdate.nodesAffectedBySafeAreaBottom
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, codec.Int32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformTreeUpdate.stickyPositionData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(StickyPositionNodeData), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformTreeUpdate.anchorPositionScrollData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(AnchorPositionScrollData), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TransformTreeUpdate.encodedSize = codec.kStructHeaderSize + 48;

  TransformTreeUpdate.decode = function(decoder) {
    var packed;
    var val = new TransformTreeUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.deviceScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.deviceTransformScaleFactor =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.nodesAffectedByOuterViewportBoundsDelta =
        decoder.decodeArrayPointer(codec.Int32);
    val.nodesAffectedBySafeAreaBottom =
        decoder.decodeArrayPointer(codec.Int32);
    val.stickyPositionData =
        decoder.decodeArrayPointer(new codec.PointerTo(StickyPositionNodeData));
    val.anchorPositionScrollData =
        decoder.decodeArrayPointer(new codec.PointerTo(AnchorPositionScrollData));
    return val;
  };

  TransformTreeUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TransformTreeUpdate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.pageScaleFactor);
    encoder.encodeStruct(codec.Float, val.deviceScaleFactor);
    encoder.encodeStruct(codec.Float, val.deviceTransformScaleFactor);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Int32, val.nodesAffectedByOuterViewportBoundsDelta);
    encoder.encodeArrayPointer(codec.Int32, val.nodesAffectedBySafeAreaBottom);
    encoder.encodeArrayPointer(new codec.PointerTo(StickyPositionNodeData), val.stickyPositionData);
    encoder.encodeArrayPointer(new codec.PointerTo(AnchorPositionScrollData), val.anchorPositionScrollData);
  };
  function TransformNode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TransformNode.prototype.initDefaults_ = function() {
    this.id = 0;
    this.parentId = 0;
    this.parentFrameId = 0;
    this.sticky_position_constraint_id_$flag = false;
    this.anchor_position_scroll_data_id_$flag = false;
    this.hasPotentialAnimation = false;
    this.isCurrentlyAnimating = false;
    this.flattensInheritedTransform = false;
    this.scrolls = false;
    this.shouldUndoOverscroll = false;
    this.shouldBeSnapped = false;
    this.movedByOuterViewportBoundsDeltaY = false;
    this.inSubtreeOfPageScaleLayer = false;
    this.transformChanged = false;
    this.delegatesToParentForBackface = false;
    this.willChangeTransform = false;
    this.nodeAndAncestorsAreAnimatedOrInvertible = false;
    this.isInvertible = false;
    this.ancestorsAreInvertible = false;
    this.nodeAndAncestorsAreFlat = false;
    this.nodeOrAncestorsWillChangeTransform = false;
    this.movedBySafeAreaBottom = false;
    this.elementId = null;
    this.local = null;
    this.origin = null;
    this.postTranslation = null;
    this.toParent = null;
    this.scrollOffset = null;
    this.snapAmount = null;
    this.sticky_position_constraint_id_$value = 0;
    this.anchor_position_scroll_data_id_$value = 0;
    this.sortingContextId = 0;
    this.maximumAnimationScale = 0;
    this.visibleFrameElementId = null;
    this.damageReasonsBitMask = 0;
  };
  TransformNode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TransformNode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 112}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate TransformNode.elementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformNode.local
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, transform$.Transform, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformNode.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Point3F, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformNode.postTranslation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformNode.toParent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, transform$.Transform, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformNode.scrollOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransformNode.snapAmount
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;
























    // validate TransformNode.visibleFrameElementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  TransformNode.encodedSize = codec.kStructHeaderSize + 104;

  TransformNode.decode = function(decoder) {
    var packed;
    var val = new TransformNode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.parentId =
        decoder.decodeStruct(codec.Int32);
    val.parentFrameId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.sticky_position_constraint_id_$flag = (packed >> 0) & 1 ? true : false;
    val.anchor_position_scroll_data_id_$flag = (packed >> 1) & 1 ? true : false;
    val.hasPotentialAnimation = (packed >> 2) & 1 ? true : false;
    val.isCurrentlyAnimating = (packed >> 3) & 1 ? true : false;
    val.flattensInheritedTransform = (packed >> 4) & 1 ? true : false;
    val.scrolls = (packed >> 5) & 1 ? true : false;
    val.shouldUndoOverscroll = (packed >> 6) & 1 ? true : false;
    val.shouldBeSnapped = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.movedByOuterViewportBoundsDeltaY = (packed >> 0) & 1 ? true : false;
    val.inSubtreeOfPageScaleLayer = (packed >> 1) & 1 ? true : false;
    val.transformChanged = (packed >> 2) & 1 ? true : false;
    val.delegatesToParentForBackface = (packed >> 3) & 1 ? true : false;
    val.willChangeTransform = (packed >> 4) & 1 ? true : false;
    val.nodeAndAncestorsAreAnimatedOrInvertible = (packed >> 5) & 1 ? true : false;
    val.isInvertible = (packed >> 6) & 1 ? true : false;
    val.ancestorsAreInvertible = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.nodeAndAncestorsAreFlat = (packed >> 0) & 1 ? true : false;
    val.nodeOrAncestorsWillChangeTransform = (packed >> 1) & 1 ? true : false;
    val.movedBySafeAreaBottom = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    val.elementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    val.local =
        decoder.decodeStructPointer(transform$.Transform);
    val.origin =
        decoder.decodeStructPointer(geometry$.Point3F);
    val.postTranslation =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.toParent =
        decoder.decodeStructPointer(transform$.Transform);
    val.scrollOffset =
        decoder.decodeStructPointer(geometry$.PointF);
    val.snapAmount =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.sticky_position_constraint_id_$value =
        decoder.decodeStruct(codec.Uint32);
    val.anchor_position_scroll_data_id_$value =
        decoder.decodeStruct(codec.Uint32);
    val.sortingContextId =
        decoder.decodeStruct(codec.Int32);
    val.maximumAnimationScale =
        decoder.decodeStruct(codec.Float);
    val.visibleFrameElementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    val.damageReasonsBitMask =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  TransformNode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TransformNode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Int32, val.parentId);
    encoder.encodeStruct(codec.Int32, val.parentFrameId);
    packed = 0;
    packed |= (val.sticky_position_constraint_id_$flag & 1) << 0
    packed |= (val.anchor_position_scroll_data_id_$flag & 1) << 1
    packed |= (val.hasPotentialAnimation & 1) << 2
    packed |= (val.isCurrentlyAnimating & 1) << 3
    packed |= (val.flattensInheritedTransform & 1) << 4
    packed |= (val.scrolls & 1) << 5
    packed |= (val.shouldUndoOverscroll & 1) << 6
    packed |= (val.shouldBeSnapped & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.movedByOuterViewportBoundsDeltaY & 1) << 0
    packed |= (val.inSubtreeOfPageScaleLayer & 1) << 1
    packed |= (val.transformChanged & 1) << 2
    packed |= (val.delegatesToParentForBackface & 1) << 3
    packed |= (val.willChangeTransform & 1) << 4
    packed |= (val.nodeAndAncestorsAreAnimatedOrInvertible & 1) << 5
    packed |= (val.isInvertible & 1) << 6
    packed |= (val.ancestorsAreInvertible & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.nodeAndAncestorsAreFlat & 1) << 0
    packed |= (val.nodeOrAncestorsWillChangeTransform & 1) << 1
    packed |= (val.movedBySafeAreaBottom & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStructPointer(element_id$.ElementId, val.elementId);
    encoder.encodeStructPointer(transform$.Transform, val.local);
    encoder.encodeStructPointer(geometry$.Point3F, val.origin);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.postTranslation);
    encoder.encodeStructPointer(transform$.Transform, val.toParent);
    encoder.encodeStructPointer(geometry$.PointF, val.scrollOffset);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.snapAmount);
    encoder.encodeStruct(codec.Uint32, val.sticky_position_constraint_id_$value);
    encoder.encodeStruct(codec.Uint32, val.anchor_position_scroll_data_id_$value);
    encoder.encodeStruct(codec.Int32, val.sortingContextId);
    encoder.encodeStruct(codec.Float, val.maximumAnimationScale);
    encoder.encodeStructPointer(element_id$.ElementId, val.visibleFrameElementId);
    encoder.encodeStruct(codec.Uint64, val.damageReasonsBitMask);
  };
  function ClipNode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipNode.prototype.initDefaults_ = function() {
    this.id = 0;
    this.parentId = 0;
    this.transformId = 0;
    this.pixelMovingFilterId = 0;
    this.clip = null;
  };
  ClipNode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipNode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate ClipNode.clip
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipNode.encodedSize = codec.kStructHeaderSize + 24;

  ClipNode.decode = function(decoder) {
    var packed;
    var val = new ClipNode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.parentId =
        decoder.decodeStruct(codec.Int32);
    val.transformId =
        decoder.decodeStruct(codec.Int32);
    val.pixelMovingFilterId =
        decoder.decodeStruct(codec.Int32);
    val.clip =
        decoder.decodeStructPointer(geometry$.RectF);
    return val;
  };

  ClipNode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipNode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Int32, val.parentId);
    encoder.encodeStruct(codec.Int32, val.transformId);
    encoder.encodeStruct(codec.Int32, val.pixelMovingFilterId);
    encoder.encodeStructPointer(geometry$.RectF, val.clip);
  };
  function EffectNode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EffectNode.prototype.initDefaults_ = function() {
    this.id = 0;
    this.parentId = 0;
    this.transformId = 0;
    this.clipId = 0;
    this.elementId = null;
    this.opacity = 0;
    this.renderSurfaceReason = 0;
    this.surfaceContentsScale = null;
    this.subtreeCaptureId = null;
    this.subtreeSize = null;
    this.blendMode = 0;
    this.targetId = 0;
    this.viewTransitionTargetId = 0;
    this.closestAncestorWithCachedRenderSurfaceId = 0;
    this.closestAncestorWithCopyRequestId = 0;
    this.closestAncestorBeingCapturedId = 0;
    this.closestAncestorWithSharedElementId = 0;
    this.backdropFilterQuality = 0;
    this.viewTransitionElementResourceId = null;
    this.filters = null;
    this.backdropFilters = null;
    this.backdropFilterBounds = null;
    this.backdropMaskElementId = null;
    this.maskFilterInfo = null;
    this.cacheRenderSurface = false;
    this.doubleSided = false;
    this.trilinearFiltering = false;
    this.subtreeHidden = false;
    this.hasPotentialFilterAnimation = false;
    this.hasPotentialBackdropFilterAnimation = false;
    this.hasPotentialOpacityAnimation = false;
    this.subtreeHasCopyRequest = false;
    this.isFastRoundedCorner = false;
    this.mayHaveBackdropEffect = false;
    this.needsEffectFor2dScaleTransform = false;
    this.copyOutputRequests = null;
  };
  EffectNode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EffectNode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 160}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate EffectNode.elementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EffectNode.renderSurfaceReason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, render_surface_reason$.RenderSurfaceReason);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EffectNode.surfaceContentsScale
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EffectNode.subtreeCaptureId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, subtree_capture_id$.SubtreeCaptureId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EffectNode.subtreeSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;









    // validate EffectNode.viewTransitionElementResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, view_transition_element_resource_id$.ViewTransitionElementResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EffectNode.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, filter_operations$.FilterOperations, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EffectNode.backdropFilters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, filter_operations$.FilterOperations, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EffectNode.backdropFilterBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, skpath$.SkPath, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EffectNode.backdropMaskElementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EffectNode.maskFilterInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, mask_filter_info$.MaskFilterInfo, false);
    if (err !== validator.validationError.NONE)
        return err;













    // validate EffectNode.copyOutputRequests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 144, 8, new codec.PointerTo(copy_output_request$.CopyOutputRequest), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EffectNode.encodedSize = codec.kStructHeaderSize + 152;

  EffectNode.decode = function(decoder) {
    var packed;
    var val = new EffectNode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.parentId =
        decoder.decodeStruct(codec.Int32);
    val.transformId =
        decoder.decodeStruct(codec.Int32);
    val.clipId =
        decoder.decodeStruct(codec.Int32);
    val.elementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    val.opacity =
        decoder.decodeStruct(codec.Float);
    val.renderSurfaceReason =
        decoder.decodeStruct(new codec.Enum(render_surface_reason$.RenderSurfaceReason));
    val.surfaceContentsScale =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.subtreeCaptureId =
        decoder.decodeStructPointer(subtree_capture_id$.SubtreeCaptureId);
    val.subtreeSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.blendMode =
        decoder.decodeStruct(codec.Uint32);
    val.targetId =
        decoder.decodeStruct(codec.Int32);
    val.viewTransitionTargetId =
        decoder.decodeStruct(codec.Int32);
    val.closestAncestorWithCachedRenderSurfaceId =
        decoder.decodeStruct(codec.Int32);
    val.closestAncestorWithCopyRequestId =
        decoder.decodeStruct(codec.Int32);
    val.closestAncestorBeingCapturedId =
        decoder.decodeStruct(codec.Int32);
    val.closestAncestorWithSharedElementId =
        decoder.decodeStruct(codec.Int32);
    val.backdropFilterQuality =
        decoder.decodeStruct(codec.Float);
    val.viewTransitionElementResourceId =
        decoder.decodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId);
    val.filters =
        decoder.decodeStructPointer(filter_operations$.FilterOperations);
    val.backdropFilters =
        decoder.decodeStructPointer(filter_operations$.FilterOperations);
    val.backdropFilterBounds =
        decoder.decodeStructPointer(skpath$.SkPath);
    val.backdropMaskElementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    val.maskFilterInfo =
        decoder.decodeStructPointer(mask_filter_info$.MaskFilterInfo);
    packed = decoder.readUint8();
    val.cacheRenderSurface = (packed >> 0) & 1 ? true : false;
    val.doubleSided = (packed >> 1) & 1 ? true : false;
    val.trilinearFiltering = (packed >> 2) & 1 ? true : false;
    val.subtreeHidden = (packed >> 3) & 1 ? true : false;
    val.hasPotentialFilterAnimation = (packed >> 4) & 1 ? true : false;
    val.hasPotentialBackdropFilterAnimation = (packed >> 5) & 1 ? true : false;
    val.hasPotentialOpacityAnimation = (packed >> 6) & 1 ? true : false;
    val.subtreeHasCopyRequest = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.isFastRoundedCorner = (packed >> 0) & 1 ? true : false;
    val.mayHaveBackdropEffect = (packed >> 1) & 1 ? true : false;
    val.needsEffectFor2dScaleTransform = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.copyOutputRequests =
        decoder.decodeArrayPointer(new codec.PointerTo(copy_output_request$.CopyOutputRequest));
    return val;
  };

  EffectNode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EffectNode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Int32, val.parentId);
    encoder.encodeStruct(codec.Int32, val.transformId);
    encoder.encodeStruct(codec.Int32, val.clipId);
    encoder.encodeStructPointer(element_id$.ElementId, val.elementId);
    encoder.encodeStruct(codec.Float, val.opacity);
    encoder.encodeStruct(codec.Int32, val.renderSurfaceReason);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.surfaceContentsScale);
    encoder.encodeStructPointer(subtree_capture_id$.SubtreeCaptureId, val.subtreeCaptureId);
    encoder.encodeStructPointer(geometry$.Size, val.subtreeSize);
    encoder.encodeStruct(codec.Uint32, val.blendMode);
    encoder.encodeStruct(codec.Int32, val.targetId);
    encoder.encodeStruct(codec.Int32, val.viewTransitionTargetId);
    encoder.encodeStruct(codec.Int32, val.closestAncestorWithCachedRenderSurfaceId);
    encoder.encodeStruct(codec.Int32, val.closestAncestorWithCopyRequestId);
    encoder.encodeStruct(codec.Int32, val.closestAncestorBeingCapturedId);
    encoder.encodeStruct(codec.Int32, val.closestAncestorWithSharedElementId);
    encoder.encodeStruct(codec.Float, val.backdropFilterQuality);
    encoder.encodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId, val.viewTransitionElementResourceId);
    encoder.encodeStructPointer(filter_operations$.FilterOperations, val.filters);
    encoder.encodeStructPointer(filter_operations$.FilterOperations, val.backdropFilters);
    encoder.encodeStructPointer(skpath$.SkPath, val.backdropFilterBounds);
    encoder.encodeStructPointer(element_id$.ElementId, val.backdropMaskElementId);
    encoder.encodeStructPointer(mask_filter_info$.MaskFilterInfo, val.maskFilterInfo);
    packed = 0;
    packed |= (val.cacheRenderSurface & 1) << 0
    packed |= (val.doubleSided & 1) << 1
    packed |= (val.trilinearFiltering & 1) << 2
    packed |= (val.subtreeHidden & 1) << 3
    packed |= (val.hasPotentialFilterAnimation & 1) << 4
    packed |= (val.hasPotentialBackdropFilterAnimation & 1) << 5
    packed |= (val.hasPotentialOpacityAnimation & 1) << 6
    packed |= (val.subtreeHasCopyRequest & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.isFastRoundedCorner & 1) << 0
    packed |= (val.mayHaveBackdropEffect & 1) << 1
    packed |= (val.needsEffectFor2dScaleTransform & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(copy_output_request$.CopyOutputRequest), val.copyOutputRequests);
  };
  function ScrollTreeUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScrollTreeUpdate.prototype.initDefaults_ = function() {
    this.syncedScrollOffsets = null;
    this.scrollingContentsCullRects = null;
    this.elasticOverscroll = null;
  };
  ScrollTreeUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScrollTreeUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScrollTreeUpdate.syncedScrollOffsets
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(synced_scroll_offset$.SyncedScrollOffset), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScrollTreeUpdate.scrollingContentsCullRects
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(geometry$.Rect), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScrollTreeUpdate.elasticOverscroll
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(geometry$.Vector2dF), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ScrollTreeUpdate.encodedSize = codec.kStructHeaderSize + 24;

  ScrollTreeUpdate.decode = function(decoder) {
    var packed;
    var val = new ScrollTreeUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.syncedScrollOffsets =
        decoder.decodeMapPointer(new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(synced_scroll_offset$.SyncedScrollOffset));
    val.scrollingContentsCullRects =
        decoder.decodeMapPointer(new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(geometry$.Rect));
    val.elasticOverscroll =
        decoder.decodeMapPointer(new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(geometry$.Vector2dF));
    return val;
  };

  ScrollTreeUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScrollTreeUpdate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(synced_scroll_offset$.SyncedScrollOffset), val.syncedScrollOffsets);
    encoder.encodeMapPointer(new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(geometry$.Rect), val.scrollingContentsCullRects);
    encoder.encodeMapPointer(new codec.PointerTo(element_id$.ElementId), new codec.PointerTo(geometry$.Vector2dF), val.elasticOverscroll);
  };
  function ScrollNode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ScrollNode.prototype.initDefaults_ = function() {
    this.id = 0;
    this.parentId = 0;
    this.transformId = 0;
    this.maxScrollOffsetAffectedByPageScale = false;
    this.scrollsInnerViewport = false;
    this.scrollsOuterViewport = false;
    this.preventViewportScrollingFromInner = false;
    this.userScrollableHorizontal = false;
    this.userScrollableVertical = false;
    this.isComposited = false;
    this.containerBounds = null;
    this.bounds = null;
    this.elementId = null;
  };
  ScrollNode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ScrollNode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate ScrollNode.containerBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScrollNode.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ScrollNode.elementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;








    return validator.validationError.NONE;
  };

  ScrollNode.encodedSize = codec.kStructHeaderSize + 40;

  ScrollNode.decode = function(decoder) {
    var packed;
    var val = new ScrollNode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.parentId =
        decoder.decodeStruct(codec.Int32);
    val.transformId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.maxScrollOffsetAffectedByPageScale = (packed >> 0) & 1 ? true : false;
    val.scrollsInnerViewport = (packed >> 1) & 1 ? true : false;
    val.scrollsOuterViewport = (packed >> 2) & 1 ? true : false;
    val.preventViewportScrollingFromInner = (packed >> 3) & 1 ? true : false;
    val.userScrollableHorizontal = (packed >> 4) & 1 ? true : false;
    val.userScrollableVertical = (packed >> 5) & 1 ? true : false;
    val.isComposited = (packed >> 6) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.containerBounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.bounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.elementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    return val;
  };

  ScrollNode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ScrollNode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Int32, val.parentId);
    encoder.encodeStruct(codec.Int32, val.transformId);
    packed = 0;
    packed |= (val.maxScrollOffsetAffectedByPageScale & 1) << 0
    packed |= (val.scrollsInnerViewport & 1) << 1
    packed |= (val.scrollsOuterViewport & 1) << 2
    packed |= (val.preventViewportScrollingFromInner & 1) << 3
    packed |= (val.userScrollableHorizontal & 1) << 4
    packed |= (val.userScrollableVertical & 1) << 5
    packed |= (val.isComposited & 1) << 6
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.containerBounds);
    encoder.encodeStructPointer(geometry$.Size, val.bounds);
    encoder.encodeStructPointer(element_id$.ElementId, val.elementId);
  };

  function LayerExtra(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  LayerExtra.Tags = {
    mirrorLayerExtra: 0,
    ninePatchThumbScrollbarLayerExtra: 1,
    paintedScrollbarLayerExtra: 2,
    solidColorScrollbarLayerExtra: 3,
    surfaceLayerExtra: 4,
    textureLayerExtra: 5,
    uiResourceLayerExtra: 6,
    tileDisplayLayerExtra: 7,
    viewTransitionContentLayerExtra: 8,
    ninePatchLayerExtra: 9,
  };

  LayerExtra.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  LayerExtra.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "mirrorLayerExtra",
        "ninePatchThumbScrollbarLayerExtra",
        "paintedScrollbarLayerExtra",
        "solidColorScrollbarLayerExtra",
        "surfaceLayerExtra",
        "textureLayerExtra",
        "uiResourceLayerExtra",
        "tileDisplayLayerExtra",
        "viewTransitionContentLayerExtra",
        "ninePatchLayerExtra",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a LayerExtra member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(LayerExtra.prototype, "mirrorLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.mirrorLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.mirrorLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.mirrorLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "ninePatchThumbScrollbarLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.ninePatchThumbScrollbarLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.ninePatchThumbScrollbarLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.ninePatchThumbScrollbarLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "paintedScrollbarLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.paintedScrollbarLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.paintedScrollbarLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.paintedScrollbarLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "solidColorScrollbarLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.solidColorScrollbarLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.solidColorScrollbarLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.solidColorScrollbarLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "surfaceLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.surfaceLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.surfaceLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.surfaceLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "textureLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.textureLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.textureLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.textureLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "uiResourceLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.uiResourceLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.uiResourceLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.uiResourceLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "tileDisplayLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.tileDisplayLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.tileDisplayLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.tileDisplayLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "viewTransitionContentLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.viewTransitionContentLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.viewTransitionContentLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.viewTransitionContentLayerExtra;
      this.$data = value;
    }
  });
  Object.defineProperty(LayerExtra.prototype, "ninePatchLayerExtra", {
    get: function() {
      if (this.$tag != LayerExtra.Tags.ninePatchLayerExtra) {
        throw new ReferenceError(
            "LayerExtra.ninePatchLayerExtra is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = LayerExtra.Tags.ninePatchLayerExtra;
      this.$data = value;
    }
  });


    LayerExtra.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case LayerExtra.Tags.mirrorLayerExtra:
          encoder.encodeStructPointer(MirrorLayerExtra, val.mirrorLayerExtra);
          break;
        case LayerExtra.Tags.ninePatchThumbScrollbarLayerExtra:
          encoder.encodeStructPointer(NinePatchThumbScrollbarLayerExtra, val.ninePatchThumbScrollbarLayerExtra);
          break;
        case LayerExtra.Tags.paintedScrollbarLayerExtra:
          encoder.encodeStructPointer(PaintedScrollbarLayerExtra, val.paintedScrollbarLayerExtra);
          break;
        case LayerExtra.Tags.solidColorScrollbarLayerExtra:
          encoder.encodeStructPointer(SolidColorScrollbarLayerExtra, val.solidColorScrollbarLayerExtra);
          break;
        case LayerExtra.Tags.surfaceLayerExtra:
          encoder.encodeStructPointer(SurfaceLayerExtra, val.surfaceLayerExtra);
          break;
        case LayerExtra.Tags.textureLayerExtra:
          encoder.encodeStructPointer(TextureLayerExtra, val.textureLayerExtra);
          break;
        case LayerExtra.Tags.uiResourceLayerExtra:
          encoder.encodeStructPointer(UIResourceLayerExtra, val.uiResourceLayerExtra);
          break;
        case LayerExtra.Tags.tileDisplayLayerExtra:
          encoder.encodeStructPointer(TileDisplayLayerExtra, val.tileDisplayLayerExtra);
          break;
        case LayerExtra.Tags.viewTransitionContentLayerExtra:
          encoder.encodeStructPointer(ViewTransitionContentLayerExtra, val.viewTransitionContentLayerExtra);
          break;
        case LayerExtra.Tags.ninePatchLayerExtra:
          encoder.encodeStructPointer(NinePatchLayerExtra, val.ninePatchLayerExtra);
          break;
      }
      encoder.align();
    };


    LayerExtra.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new LayerExtra();
      var tag = decoder.readUint32();
      switch (tag) {
        case LayerExtra.Tags.mirrorLayerExtra:
          result.mirrorLayerExtra = decoder.decodeStructPointer(MirrorLayerExtra);
          break;
        case LayerExtra.Tags.ninePatchThumbScrollbarLayerExtra:
          result.ninePatchThumbScrollbarLayerExtra = decoder.decodeStructPointer(NinePatchThumbScrollbarLayerExtra);
          break;
        case LayerExtra.Tags.paintedScrollbarLayerExtra:
          result.paintedScrollbarLayerExtra = decoder.decodeStructPointer(PaintedScrollbarLayerExtra);
          break;
        case LayerExtra.Tags.solidColorScrollbarLayerExtra:
          result.solidColorScrollbarLayerExtra = decoder.decodeStructPointer(SolidColorScrollbarLayerExtra);
          break;
        case LayerExtra.Tags.surfaceLayerExtra:
          result.surfaceLayerExtra = decoder.decodeStructPointer(SurfaceLayerExtra);
          break;
        case LayerExtra.Tags.textureLayerExtra:
          result.textureLayerExtra = decoder.decodeStructPointer(TextureLayerExtra);
          break;
        case LayerExtra.Tags.uiResourceLayerExtra:
          result.uiResourceLayerExtra = decoder.decodeStructPointer(UIResourceLayerExtra);
          break;
        case LayerExtra.Tags.tileDisplayLayerExtra:
          result.tileDisplayLayerExtra = decoder.decodeStructPointer(TileDisplayLayerExtra);
          break;
        case LayerExtra.Tags.viewTransitionContentLayerExtra:
          result.viewTransitionContentLayerExtra = decoder.decodeStructPointer(ViewTransitionContentLayerExtra);
          break;
        case LayerExtra.Tags.ninePatchLayerExtra:
          result.ninePatchLayerExtra = decoder.decodeStructPointer(NinePatchLayerExtra);
          break;
      }
      decoder.align();

      return result;
    };


    LayerExtra.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case LayerExtra.Tags.mirrorLayerExtra:
          

    // validate LayerExtra.mirrorLayerExtra
    err = messageValidator.validateStructPointer(data_offset, MirrorLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.ninePatchThumbScrollbarLayerExtra:
          

    // validate LayerExtra.ninePatchThumbScrollbarLayerExtra
    err = messageValidator.validateStructPointer(data_offset, NinePatchThumbScrollbarLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.paintedScrollbarLayerExtra:
          

    // validate LayerExtra.paintedScrollbarLayerExtra
    err = messageValidator.validateStructPointer(data_offset, PaintedScrollbarLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.solidColorScrollbarLayerExtra:
          

    // validate LayerExtra.solidColorScrollbarLayerExtra
    err = messageValidator.validateStructPointer(data_offset, SolidColorScrollbarLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.surfaceLayerExtra:
          

    // validate LayerExtra.surfaceLayerExtra
    err = messageValidator.validateStructPointer(data_offset, SurfaceLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.textureLayerExtra:
          

    // validate LayerExtra.textureLayerExtra
    err = messageValidator.validateStructPointer(data_offset, TextureLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.uiResourceLayerExtra:
          

    // validate LayerExtra.uiResourceLayerExtra
    err = messageValidator.validateStructPointer(data_offset, UIResourceLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.tileDisplayLayerExtra:
          

    // validate LayerExtra.tileDisplayLayerExtra
    err = messageValidator.validateStructPointer(data_offset, TileDisplayLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.viewTransitionContentLayerExtra:
          

    // validate LayerExtra.viewTransitionContentLayerExtra
    err = messageValidator.validateStructPointer(data_offset, ViewTransitionContentLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case LayerExtra.Tags.ninePatchLayerExtra:
          

    // validate LayerExtra.ninePatchLayerExtra
    err = messageValidator.validateStructPointer(data_offset, NinePatchLayerExtra, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  LayerExtra.encodedSize = 16;
  exports.RareProperties = RareProperties;
  exports.MirrorLayerExtra = MirrorLayerExtra;
  exports.SurfaceLayerExtra = SurfaceLayerExtra;
  exports.TextureLayerExtra = TextureLayerExtra;
  exports.UIResourceLayerExtra = UIResourceLayerExtra;
  exports.TileDisplayLayerExtra = TileDisplayLayerExtra;
  exports.ScrollbarLayerBaseExtra = ScrollbarLayerBaseExtra;
  exports.NinePatchThumbScrollbarLayerExtra = NinePatchThumbScrollbarLayerExtra;
  exports.PaintedScrollbarLayerExtra = PaintedScrollbarLayerExtra;
  exports.SolidColorScrollbarLayerExtra = SolidColorScrollbarLayerExtra;
  exports.ViewTransitionContentLayerExtra = ViewTransitionContentLayerExtra;
  exports.NinePatchLayerExtra = NinePatchLayerExtra;
  exports.Layer = Layer;
  exports.AnchorPositionScrollData = AnchorPositionScrollData;
  exports.StickyPositionNodeData = StickyPositionNodeData;
  exports.TransformTreeUpdate = TransformTreeUpdate;
  exports.TransformNode = TransformNode;
  exports.ClipNode = ClipNode;
  exports.EffectNode = EffectNode;
  exports.ScrollTreeUpdate = ScrollTreeUpdate;
  exports.ScrollNode = ScrollNode;
  exports.LayerExtra = LayerExtra;
})();