// services/viz/public/mojom/compositing/frame_sink_bundle.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  HitTestRegionList as viz_mojom_HitTestRegionList,
  HitTestRegionListSpec as viz_mojom_HitTestRegionListSpec
} from '../hit_test/hit_test_region_list.mojom.m.js';

import {
  BeginFrameAck as viz_mojom_BeginFrameAck,
  BeginFrameAckSpec as viz_mojom_BeginFrameAckSpec,
  BeginFrameArgs as viz_mojom_BeginFrameArgs,
  BeginFrameArgsSpec as viz_mojom_BeginFrameArgsSpec
} from './begin_frame_args.mojom.m.js';

import {
  CompositorFrame as viz_mojom_CompositorFrame,
  CompositorFrameSpec as viz_mojom_CompositorFrameSpec
} from './compositor_frame.mojom.m.js';

import {
  FrameTimingDetails as viz_mojom_FrameTimingDetails,
  FrameTimingDetailsSpec as viz_mojom_FrameTimingDetailsSpec
} from './frame_timing_details.mojom.m.js';

import {
  LocalSurfaceId as viz_mojom_LocalSurfaceId,
  LocalSurfaceIdSpec as viz_mojom_LocalSurfaceIdSpec
} from './local_surface_id.mojom.m.js';

import {
  ReturnedResource as viz_mojom_ReturnedResource,
  ReturnedResourceSpec as viz_mojom_ReturnedResourceSpec
} from './returned_resource.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FrameSinkBundlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.FrameSinkBundle', scope);
  }
}

/** @interface */
export class FrameSinkBundleInterface {
  
  /**
   * @param { !number } sinkId
   * @param { !boolean } needsBeginFrame
   */

  setNeedsBeginFrame(sinkId, needsBeginFrame) {}
  
  /**
   * @param { !Array<!BundledFrameSubmission> } submissions
   */

  submit(submissions) {}
}

/**
 * @implements { FrameSinkBundleInterface }
 */
export class FrameSinkBundleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FrameSinkBundlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FrameSinkBundlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FrameSinkBundlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } sinkId
   * @param { !boolean } needsBeginFrame
   */

  setNeedsBeginFrame(
      sinkId,
      needsBeginFrame) {
    this.proxy.sendMessage(
        0,
        FrameSinkBundle_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        [
          sinkId,
          needsBeginFrame
        ],
        false);
  }

  
  /**
   * @param { !Array<!BundledFrameSubmission> } submissions
   */

  submit(
      submissions) {
    this.proxy.sendMessage(
        1,
        FrameSinkBundle_Submit_ParamsSpec.$,
        null,
        [
          submissions
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FrameSinkBundle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrameSinkBundleReceiver {
  /**
   * @param {!FrameSinkBundleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FrameSinkBundleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FrameSinkBundleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameSinkBundleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FrameSinkBundle_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        impl.setNeedsBeginFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FrameSinkBundle_Submit_ParamsSpec.$,
        null,
        impl.submit.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FrameSinkBundle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.FrameSinkBundle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FrameSinkBundleRemote}
   */
  static getRemote() {
    let remote = new FrameSinkBundleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FrameSinkBundle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrameSinkBundleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FrameSinkBundleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameSinkBundleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNeedsBeginFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FrameSinkBundle_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        this.setNeedsBeginFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FrameSinkBundle_Submit_ParamsSpec.$,
        null,
        this.submit.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FrameSinkBundleClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.FrameSinkBundleClient', scope);
  }
}

/** @interface */
export class FrameSinkBundleClientInterface {
  
  /**
   * @param { !Array<!BundledReturnedResources> } acks
   * @param { !Array<!BeginFrameInfo> } beginFrames
   * @param { !Array<!BundledReturnedResources> } reclaimedResources
   */

  flushNotifications(acks, beginFrames, reclaimedResources) {}
  
  /**
   * @param { !number } sinkId
   * @param { !boolean } paused
   */

  onBeginFramePausedChanged(sinkId, paused) {}
  
  /**
   * @param { !number } sinkId
   * @param { !number } sequenceId
   */

  onCompositorFrameTransitionDirectiveProcessed(sinkId, sequenceId) {}
}

/**
 * @implements { FrameSinkBundleClientInterface }
 */
export class FrameSinkBundleClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FrameSinkBundleClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FrameSinkBundleClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FrameSinkBundleClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!BundledReturnedResources> } acks
   * @param { !Array<!BeginFrameInfo> } beginFrames
   * @param { !Array<!BundledReturnedResources> } reclaimedResources
   */

  flushNotifications(
      acks,
      beginFrames,
      reclaimedResources) {
    this.proxy.sendMessage(
        0,
        FrameSinkBundleClient_FlushNotifications_ParamsSpec.$,
        null,
        [
          acks,
          beginFrames,
          reclaimedResources
        ],
        false);
  }

  
  /**
   * @param { !number } sinkId
   * @param { !boolean } paused
   */

  onBeginFramePausedChanged(
      sinkId,
      paused) {
    this.proxy.sendMessage(
        1,
        FrameSinkBundleClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        [
          sinkId,
          paused
        ],
        false);
  }

  
  /**
   * @param { !number } sinkId
   * @param { !number } sequenceId
   */

  onCompositorFrameTransitionDirectiveProcessed(
      sinkId,
      sequenceId) {
    this.proxy.sendMessage(
        2,
        FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        [
          sinkId,
          sequenceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FrameSinkBundleClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrameSinkBundleClientReceiver {
  /**
   * @param {!FrameSinkBundleClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FrameSinkBundleClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FrameSinkBundleClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameSinkBundleClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FrameSinkBundleClient_FlushNotifications_ParamsSpec.$,
        null,
        impl.flushNotifications.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FrameSinkBundleClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        impl.onBeginFramePausedChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        impl.onCompositorFrameTransitionDirectiveProcessed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FrameSinkBundleClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.FrameSinkBundleClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FrameSinkBundleClientRemote}
   */
  static getRemote() {
    let remote = new FrameSinkBundleClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FrameSinkBundleClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrameSinkBundleClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FrameSinkBundleClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FrameSinkBundleClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FrameSinkBundleClient_FlushNotifications_ParamsSpec.$,
        null,
        this.flushNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeginFramePausedChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FrameSinkBundleClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        this.onBeginFramePausedChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompositorFrameTransitionDirectiveProcessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        this.onCompositorFrameTransitionDirectiveProcessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BundledFrameSubmissionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BundledCompositorFrameSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BundledReturnedResourcesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BeginFrameInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameSinkBundle_SetNeedsBeginFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameSinkBundle_Submit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameSinkBundleClient_FlushNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameSinkBundleClient_OnBeginFramePausedChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const BundledFrameSubmissionDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BundledFrameSubmissionSpec.$,
    'BundledFrameSubmission',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        BundledFrameSubmissionDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BundledFrameSubmission {
  constructor() {
    /** @type { !number } */
    this.sinkId;
    /** @type { !BundledFrameSubmissionData } */
    this.data;
  }
}



mojo.internal.Struct(
    BundledCompositorFrameSpec.$,
    'BundledCompositorFrame',
    [
      mojo.internal.StructField(
        'localSurfaceId', 0,
        0,
        viz_mojom_LocalSurfaceIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frame', 8,
        0,
        viz_mojom_CompositorFrameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hitTestRegionList', 16,
        0,
        viz_mojom_HitTestRegionListSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'submitTime', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class BundledCompositorFrame {
  constructor() {
    /** @type { !viz_mojom_LocalSurfaceId } */
    this.localSurfaceId;
    /** @type { !viz_mojom_CompositorFrame } */
    this.frame;
    /** @type { (viz_mojom_HitTestRegionList|undefined) } */
    this.hitTestRegionList;
    /** @type { !bigint } */
    this.submitTime;
  }
}



mojo.internal.Struct(
    BundledReturnedResourcesSpec.$,
    'BundledReturnedResources',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resources', 8,
        0,
        mojo.internal.Array(viz_mojom_ReturnedResourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BundledReturnedResources {
  constructor() {
    /** @type { !number } */
    this.sinkId;
    /** @type { !Array<!viz_mojom_ReturnedResource> } */
    this.resources;
  }
}



mojo.internal.Struct(
    BeginFrameInfoSpec.$,
    'BeginFrameInfo',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'args', 8,
        0,
        viz_mojom_BeginFrameArgsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 16,
        0,
        mojo.internal.Map(mojo.internal.Uint32, viz_mojom_FrameTimingDetailsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resources', 24,
        0,
        mojo.internal.Array(viz_mojom_ReturnedResourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class BeginFrameInfo {
  constructor() {
    /** @type { !number } */
    this.sinkId;
    /** @type { !viz_mojom_BeginFrameArgs } */
    this.args;
    /** @type { !Object<!number, !viz_mojom_FrameTimingDetails> } */
    this.details;
    /** @type { !Array<!viz_mojom_ReturnedResource> } */
    this.resources;
  }
}



mojo.internal.Struct(
    FrameSinkBundle_SetNeedsBeginFrame_ParamsSpec.$,
    'FrameSinkBundle_SetNeedsBeginFrame_Params',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needsBeginFrame', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameSinkBundle_SetNeedsBeginFrame_Params {
  constructor() {
    /** @type { !number } */
    this.sinkId;
    /** @type { !boolean } */
    this.needsBeginFrame;
  }
}



mojo.internal.Struct(
    FrameSinkBundle_Submit_ParamsSpec.$,
    'FrameSinkBundle_Submit_Params',
    [
      mojo.internal.StructField(
        'submissions', 0,
        0,
        mojo.internal.Array(BundledFrameSubmissionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameSinkBundle_Submit_Params {
  constructor() {
    /** @type { !Array<!BundledFrameSubmission> } */
    this.submissions;
  }
}



mojo.internal.Struct(
    FrameSinkBundleClient_FlushNotifications_ParamsSpec.$,
    'FrameSinkBundleClient_FlushNotifications_Params',
    [
      mojo.internal.StructField(
        'acks', 0,
        0,
        mojo.internal.Array(BundledReturnedResourcesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'beginFrames', 8,
        0,
        mojo.internal.Array(BeginFrameInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reclaimedResources', 16,
        0,
        mojo.internal.Array(BundledReturnedResourcesSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FrameSinkBundleClient_FlushNotifications_Params {
  constructor() {
    /** @type { !Array<!BundledReturnedResources> } */
    this.acks;
    /** @type { !Array<!BeginFrameInfo> } */
    this.beginFrames;
    /** @type { !Array<!BundledReturnedResources> } */
    this.reclaimedResources;
  }
}



mojo.internal.Struct(
    FrameSinkBundleClient_OnBeginFramePausedChanged_ParamsSpec.$,
    'FrameSinkBundleClient_OnBeginFramePausedChanged_Params',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paused', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameSinkBundleClient_OnBeginFramePausedChanged_Params {
  constructor() {
    /** @type { !number } */
    this.sinkId;
    /** @type { !boolean } */
    this.paused;
  }
}



mojo.internal.Struct(
    FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
    'FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sequenceId', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params {
  constructor() {
    /** @type { !number } */
    this.sinkId;
    /** @type { !number } */
    this.sequenceId;
  }
}

mojo.internal.Union(
    BundledFrameSubmissionDataSpec.$, 'BundledFrameSubmissionData',
    {
      'frame': {
        'ordinal': 0,
        'type': BundledCompositorFrameSpec.$,
      },
      'didNotProduceFrame': {
        'ordinal': 1,
        'type': viz_mojom_BeginFrameAckSpec.$,
      },
    });

/**
 * @typedef { {
 *   frame: (!BundledCompositorFrame|undefined),
 *   didNotProduceFrame: (!viz_mojom_BeginFrameAck|undefined),
 * } }
 */
export const BundledFrameSubmissionData = {};
