// services/viz/public/mojom/compositing/copy_output_result.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom.h"
#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom.h"
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/viz/public/cpp/compositing/copy_output_result_mojom_traits.h"




namespace viz::mojom {








class  CopyOutputResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CopyOutputResult, T>::value>;
  using DataView = CopyOutputResultDataView;
  using Data_ = internal::CopyOutputResult_Data;

  template <typename... Args>
  static CopyOutputResultPtr New(Args&&... args) {
    return CopyOutputResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CopyOutputResultPtr From(const U& u) {
    return mojo::TypeConverter<CopyOutputResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CopyOutputResult>::Convert(*this);
  }


  CopyOutputResult();

  CopyOutputResult(
      CopyOutputResultFormat format,
      CopyOutputResultDestination destination,
      const ::gfx::Rect& rect,
      ::viz::mojom::BitmapInSharedMemoryPtr bitmap,
      const std::optional<::gpu::Mailbox>& mailbox,
      const std::optional<::gfx::ColorSpace>& color_space,
      ::mojo::PendingRemote<::viz::mojom::TextureReleaser> releaser);

CopyOutputResult(const CopyOutputResult&) = delete;
CopyOutputResult& operator=(const CopyOutputResult&) = delete;

  ~CopyOutputResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CopyOutputResultPtr>
  CopyOutputResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CopyOutputResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CopyOutputResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CopyOutputResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CopyOutputResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CopyOutputResult_UnserializedMessageContext<
            UserType, CopyOutputResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CopyOutputResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CopyOutputResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CopyOutputResult_UnserializedMessageContext<
            UserType, CopyOutputResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CopyOutputResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CopyOutputResultFormat format;
  
  CopyOutputResultDestination destination;
  
  ::gfx::Rect rect;
  
  ::viz::mojom::BitmapInSharedMemoryPtr bitmap;
  
  std::optional<::gpu::Mailbox> mailbox;
  
  std::optional<::gfx::ColorSpace> color_space;
  
  ::mojo::PendingRemote<::viz::mojom::TextureReleaser> releaser;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CopyOutputResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CopyOutputResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CopyOutputResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CopyOutputResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CopyOutputResultPtr CopyOutputResult::Clone() const {
  return New(
      mojo::Clone(format),
      mojo::Clone(destination),
      mojo::Clone(rect),
      mojo::Clone(bitmap),
      mojo::Clone(mailbox),
      mojo::Clone(color_space),
      mojo::Clone(releaser)
  );
}

template <typename T, CopyOutputResult::EnableIfSame<T>*>
bool CopyOutputResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->destination, other_struct.destination))
    return false;
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->bitmap, other_struct.bitmap))
    return false;
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->releaser, other_struct.releaser))
    return false;
  return true;
}

template <typename T, CopyOutputResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.destination < rhs.destination)
    return true;
  if (rhs.destination < lhs.destination)
    return false;
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  if (lhs.bitmap < rhs.bitmap)
    return true;
  if (rhs.bitmap < lhs.bitmap)
    return false;
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  if (lhs.color_space < rhs.color_space)
    return true;
  if (rhs.color_space < lhs.color_space)
    return false;
  if (lhs.releaser < rhs.releaser)
    return true;
  if (rhs.releaser < lhs.releaser)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::CopyOutputResult::DataView,
                                         ::viz::mojom::CopyOutputResultPtr> {
  static bool IsNull(const ::viz::mojom::CopyOutputResultPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CopyOutputResultPtr* output) { output->reset(); }

  static decltype(::viz::mojom::CopyOutputResult::format) format(
      const ::viz::mojom::CopyOutputResultPtr& input) {
    return input->format;
  }

  static decltype(::viz::mojom::CopyOutputResult::destination) destination(
      const ::viz::mojom::CopyOutputResultPtr& input) {
    return input->destination;
  }

  static const decltype(::viz::mojom::CopyOutputResult::rect)& rect(
      const ::viz::mojom::CopyOutputResultPtr& input) {
    return input->rect;
  }

  static  decltype(::viz::mojom::CopyOutputResult::bitmap)& bitmap(
       ::viz::mojom::CopyOutputResultPtr& input) {
    return input->bitmap;
  }

  static const decltype(::viz::mojom::CopyOutputResult::mailbox)& mailbox(
      const ::viz::mojom::CopyOutputResultPtr& input) {
    return input->mailbox;
  }

  static const decltype(::viz::mojom::CopyOutputResult::color_space)& color_space(
      const ::viz::mojom::CopyOutputResultPtr& input) {
    return input->color_space;
  }

  static  decltype(::viz::mojom::CopyOutputResult::releaser)& releaser(
       ::viz::mojom::CopyOutputResultPtr& input) {
    return input->releaser;
  }

  static bool Read(::viz::mojom::CopyOutputResult::DataView input, ::viz::mojom::CopyOutputResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_H_