// services/viz/public/mojom/compositing/copy_output_request.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/blit_request.mojom.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/viz/public/cpp/compositing/copy_output_request_mojom_traits.h"




namespace viz::mojom {

class CopyOutputResultSenderProxy;

template <typename ImplRefTraits>
class CopyOutputResultSenderStub;

class CopyOutputResultSenderRequestValidator;


class CopyOutputResultSender
    : public CopyOutputResultSenderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.CopyOutputResultSender";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CopyOutputResultSenderInterfaceBase;
  using Proxy_ = CopyOutputResultSenderProxy;

  template <typename ImplRefTraits>
  using Stub_ = CopyOutputResultSenderStub<ImplRefTraits>;

  using RequestValidator_ = CopyOutputResultSenderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CopyOutputResultSender() = default;

  virtual void SendResult(::std::unique_ptr<::viz::CopyOutputResult> result) = 0;
};



class  CopyOutputResultSenderProxy
    : public CopyOutputResultSender {
 public:
  using InterfaceType = CopyOutputResultSender;

  explicit CopyOutputResultSenderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendResult(::std::unique_ptr<::viz::CopyOutputResult> result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CopyOutputResultSenderStubDispatch {
 public:
  static bool Accept(CopyOutputResultSender* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CopyOutputResultSender* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CopyOutputResultSender>>
class CopyOutputResultSenderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CopyOutputResultSenderStub() = default;
  ~CopyOutputResultSenderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CopyOutputResultSenderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CopyOutputResultSenderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CopyOutputResultSenderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  CopyOutputRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CopyOutputRequest, T>::value>;
  using DataView = CopyOutputRequestDataView;
  using Data_ = internal::CopyOutputRequest_Data;

  template <typename... Args>
  static CopyOutputRequestPtr New(Args&&... args) {
    return CopyOutputRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CopyOutputRequestPtr From(const U& u) {
    return mojo::TypeConverter<CopyOutputRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CopyOutputRequest>::Convert(*this);
  }


  CopyOutputRequest();

  CopyOutputRequest(
      ::viz::mojom::CopyOutputResultFormat result_format,
      ::viz::mojom::CopyOutputResultDestination result_destination,
      ::base::TimeDelta send_result_delay,
      const ::gfx::Vector2d& scale_from,
      const ::gfx::Vector2d& scale_to,
      const std::optional<::base::UnguessableToken>& source,
      const std::optional<::gfx::Rect>& area,
      const std::optional<::gfx::Rect>& result_selection,
      std::optional<::viz::BlitRequest> blit_request,
      ::mojo::PendingRemote<CopyOutputResultSender> result_sender);

CopyOutputRequest(const CopyOutputRequest&) = delete;
CopyOutputRequest& operator=(const CopyOutputRequest&) = delete;

  ~CopyOutputRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CopyOutputRequestPtr>
  CopyOutputRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CopyOutputRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CopyOutputRequest_UnserializedMessageContext<
            UserType, CopyOutputRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CopyOutputRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CopyOutputRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CopyOutputRequest_UnserializedMessageContext<
            UserType, CopyOutputRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CopyOutputRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::CopyOutputResultFormat result_format;
  
  ::viz::mojom::CopyOutputResultDestination result_destination;
  
  ::base::TimeDelta send_result_delay;
  
  ::gfx::Vector2d scale_from;
  
  ::gfx::Vector2d scale_to;
  
  std::optional<::base::UnguessableToken> source;
  
  std::optional<::gfx::Rect> area;
  
  std::optional<::gfx::Rect> result_selection;
  
  std::optional<::viz::BlitRequest> blit_request;
  
  ::mojo::PendingRemote<CopyOutputResultSender> result_sender;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CopyOutputRequestPtr CopyOutputRequest::Clone() const {
  return New(
      mojo::Clone(result_format),
      mojo::Clone(result_destination),
      mojo::Clone(send_result_delay),
      mojo::Clone(scale_from),
      mojo::Clone(scale_to),
      mojo::Clone(source),
      mojo::Clone(area),
      mojo::Clone(result_selection),
      mojo::Clone(blit_request),
      mojo::Clone(result_sender)
  );
}

template <typename T, CopyOutputRequest::EnableIfSame<T>*>
bool CopyOutputRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result_format, other_struct.result_format))
    return false;
  if (!mojo::Equals(this->result_destination, other_struct.result_destination))
    return false;
  if (!mojo::Equals(this->send_result_delay, other_struct.send_result_delay))
    return false;
  if (!mojo::Equals(this->scale_from, other_struct.scale_from))
    return false;
  if (!mojo::Equals(this->scale_to, other_struct.scale_to))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->area, other_struct.area))
    return false;
  if (!mojo::Equals(this->result_selection, other_struct.result_selection))
    return false;
  if (!mojo::Equals(this->blit_request, other_struct.blit_request))
    return false;
  if (!mojo::Equals(this->result_sender, other_struct.result_sender))
    return false;
  return true;
}

template <typename T, CopyOutputRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.result_format < rhs.result_format)
    return true;
  if (rhs.result_format < lhs.result_format)
    return false;
  if (lhs.result_destination < rhs.result_destination)
    return true;
  if (rhs.result_destination < lhs.result_destination)
    return false;
  if (lhs.send_result_delay < rhs.send_result_delay)
    return true;
  if (rhs.send_result_delay < lhs.send_result_delay)
    return false;
  if (lhs.scale_from < rhs.scale_from)
    return true;
  if (rhs.scale_from < lhs.scale_from)
    return false;
  if (lhs.scale_to < rhs.scale_to)
    return true;
  if (rhs.scale_to < lhs.scale_to)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.area < rhs.area)
    return true;
  if (rhs.area < lhs.area)
    return false;
  if (lhs.result_selection < rhs.result_selection)
    return true;
  if (rhs.result_selection < lhs.result_selection)
    return false;
  if (lhs.blit_request < rhs.blit_request)
    return true;
  if (rhs.blit_request < lhs.blit_request)
    return false;
  if (lhs.result_sender < rhs.result_sender)
    return true;
  if (rhs.result_sender < lhs.result_sender)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::CopyOutputRequest::DataView,
                                         ::viz::mojom::CopyOutputRequestPtr> {
  static bool IsNull(const ::viz::mojom::CopyOutputRequestPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CopyOutputRequestPtr* output) { output->reset(); }

  static decltype(::viz::mojom::CopyOutputRequest::result_format) result_format(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->result_format;
  }

  static decltype(::viz::mojom::CopyOutputRequest::result_destination) result_destination(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->result_destination;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::send_result_delay)& send_result_delay(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->send_result_delay;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::scale_from)& scale_from(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->scale_from;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::scale_to)& scale_to(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->scale_to;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::source)& source(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->source;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::area)& area(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->area;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::result_selection)& result_selection(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->result_selection;
  }

  static  decltype(::viz::mojom::CopyOutputRequest::blit_request)& blit_request(
       ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->blit_request;
  }

  static  decltype(::viz::mojom::CopyOutputRequest::result_sender)& result_sender(
       ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->result_sender;
  }

  static bool Read(::viz::mojom::CopyOutputRequest::DataView input, ::viz::mojom::CopyOutputRequestPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_H_