// services/viz/public/mojom/compositing/copy_output_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/blit_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace viz::mojom {
class CopyOutputRequestDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CopyOutputRequestDataView> {
  using Data = ::viz::mojom::internal::CopyOutputRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class CopyOutputResultSenderInterfaceBase {};

using CopyOutputResultSenderPtrDataView =
    mojo::InterfacePtrDataView<CopyOutputResultSenderInterfaceBase>;
using CopyOutputResultSenderRequestDataView =
    mojo::InterfaceRequestDataView<CopyOutputResultSenderInterfaceBase>;
using CopyOutputResultSenderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CopyOutputResultSenderInterfaceBase>;
using CopyOutputResultSenderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CopyOutputResultSenderInterfaceBase>;


class CopyOutputRequestDataView {
 public:
  CopyOutputRequestDataView() = default;

  CopyOutputRequestDataView(
      internal::CopyOutputRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResultFormat(UserType* output) const {
    auto data_value = data_->result_format;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultFormat>(
        data_value, output);
  }
  ::viz::mojom::CopyOutputResultFormat result_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultFormat>(data_->result_format));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResultDestination(UserType* output) const {
    auto data_value = data_->result_destination;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultDestination>(
        data_value, output);
  }
  ::viz::mojom::CopyOutputResultDestination result_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultDestination>(data_->result_destination));
  }
  inline void GetSendResultDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSendResultDelay(UserType* output) {
    
    auto* pointer = data_->send_result_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetScaleFromDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleFrom(UserType* output) {
    
    auto* pointer = data_->scale_from.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  inline void GetScaleToDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleTo(UserType* output) {
    
    auto* pointer = data_->scale_to.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  inline void GetSourceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSource` instead "
    "of `ReadSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArea(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `area` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadArea` instead "
    "of `ReadArea if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetResultSelectionDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResultSelection(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `result_selection` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResultSelection` instead "
    "of `ReadResultSelection if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->result_selection.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetBlitRequestDataView(
      ::viz::mojom::BlitRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlitRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::BlitRequestDataView, UserType>(),
    "Attempting to read the optional `blit_request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlitRequest` instead "
    "of `ReadBlitRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blit_request.Get();
    return mojo::internal::Deserialize<::viz::mojom::BlitRequestDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeResultSender() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::CopyOutputResultSenderInterfaceBase>>(
            &data_->result_sender, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CopyOutputRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_DATA_VIEW_H_