// services/viz/public/mojom/compositing/compositor_frame_sink.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-forward.h"  // IWYU pragma: export
#include "cc/mojom/scrollbar_animator.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom-forward.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-forward.h"
#include "services/viz/public/mojom/compositing/layer_context.mojom-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom.h"
#include "services/viz/public/mojom/compositing/thread.mojom-forward.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"




namespace viz { class CompositorFrame; }


namespace viz::mojom {

class CompositorFrameSinkProxy;

template <typename ImplRefTraits>
class CompositorFrameSinkStub;

class CompositorFrameSinkRequestValidator;


class CompositorFrameSink
    : public CompositorFrameSinkInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.CompositorFrameSink";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr bool kSupportsDirectReceiver = true;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CompositorFrameSinkInterfaceBase;
  using Proxy_ = CompositorFrameSinkProxy;

  template <typename ImplRefTraits>
  using Stub_ = CompositorFrameSinkStub<ImplRefTraits>;

  using RequestValidator_ = CompositorFrameSinkRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetParamsMinVersion = 0,
    kSetNeedsBeginFrameMinVersion = 0,
    kSubmitCompositorFrameMinVersion = 0,
    kDidNotProduceFrameMinVersion = 0,
    kNotifyNewLocalSurfaceIdExpectedWhilePausedMinVersion = 0,
    kBindLayerContextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNeedsBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitCompositorFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidNotProduceFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyNewLocalSurfaceIdExpectedWhilePaused_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindLayerContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CompositorFrameSink() = default;

  virtual void SetParams(CompositorFrameSinkParamsPtr params) = 0;

  virtual void SetNeedsBeginFrame(bool needs_begin_frame) = 0;

  virtual void SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) = 0;

  virtual void DidNotProduceFrame(const ::viz::BeginFrameAck& ack) = 0;

  virtual void NotifyNewLocalSurfaceIdExpectedWhilePaused() = 0;

  virtual void BindLayerContext(::viz::mojom::PendingLayerContextPtr context, LayerContextSettingsPtr settings) = 0;
};

class CompositorFrameSinkClientProxy;

template <typename ImplRefTraits>
class CompositorFrameSinkClientStub;

class CompositorFrameSinkClientRequestValidator;


class CompositorFrameSinkClient
    : public CompositorFrameSinkClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.CompositorFrameSinkClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr bool kSupportsDirectReceiver = true;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CompositorFrameSinkClientInterfaceBase;
  using Proxy_ = CompositorFrameSinkClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CompositorFrameSinkClientStub<ImplRefTraits>;

  using RequestValidator_ = CompositorFrameSinkClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReceiveCompositorFrameAckMinVersion = 0,
    kOnBeginFrameMinVersion = 0,
    kOnBeginFramePausedChangedMinVersion = 0,
    kReclaimResourcesMinVersion = 0,
    kOnCompositorFrameTransitionDirectiveProcessedMinVersion = 0,
    kOnSurfaceEvictedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidReceiveCompositorFrameAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBeginFramePausedChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReclaimResources_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCompositorFrameTransitionDirectiveProcessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSurfaceEvicted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CompositorFrameSinkClient() = default;

  virtual void DidReceiveCompositorFrameAck(std::vector<::viz::ReturnedResource> resources) = 0;

  virtual void OnBeginFrame(const ::viz::BeginFrameArgs& args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details, std::vector<::viz::ReturnedResource> resources) = 0;

  virtual void OnBeginFramePausedChanged(bool paused) = 0;

  virtual void ReclaimResources(std::vector<::viz::ReturnedResource> resources) = 0;

  virtual void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) = 0;

  virtual void OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) = 0;
};



class  CompositorFrameSinkProxy
    : public CompositorFrameSink {
 public:
  using InterfaceType = CompositorFrameSink;

  explicit CompositorFrameSinkProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetParams(CompositorFrameSinkParamsPtr params) final;
  
  void SetNeedsBeginFrame(bool needs_begin_frame) final;
  
  void SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) final;
  
  void DidNotProduceFrame(const ::viz::BeginFrameAck& ack) final;
  
  void NotifyNewLocalSurfaceIdExpectedWhilePaused() final;
  
  void BindLayerContext(::viz::mojom::PendingLayerContextPtr context, LayerContextSettingsPtr settings) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
  mojo::internal::MessageSizeEstimator size_estimator_;
};



class  CompositorFrameSinkClientProxy
    : public CompositorFrameSinkClient {
 public:
  using InterfaceType = CompositorFrameSinkClient;

  explicit CompositorFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReceiveCompositorFrameAck(std::vector<::viz::ReturnedResource> resources) final;
  
  void OnBeginFrame(const ::viz::BeginFrameArgs& args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details, std::vector<::viz::ReturnedResource> resources) final;
  
  void OnBeginFramePausedChanged(bool paused) final;
  
  void ReclaimResources(std::vector<::viz::ReturnedResource> resources) final;
  
  void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) final;
  
  void OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CompositorFrameSinkStubDispatch {
 public:
  static bool Accept(CompositorFrameSink* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CompositorFrameSink* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CompositorFrameSink>>
class CompositorFrameSinkStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CompositorFrameSinkStub() = default;
  ~CompositorFrameSinkStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CompositorFrameSinkClientStubDispatch {
 public:
  static bool Accept(CompositorFrameSinkClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CompositorFrameSinkClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CompositorFrameSinkClient>>
class CompositorFrameSinkClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CompositorFrameSinkClientStub() = default;
  ~CompositorFrameSinkClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CompositorFrameSinkRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CompositorFrameSinkClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  CompositorFrameSinkParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorFrameSinkParams, T>::value>;
  using DataView = CompositorFrameSinkParamsDataView;
  using Data_ = internal::CompositorFrameSinkParams_Data;

  template <typename... Args>
  static CompositorFrameSinkParamsPtr New(Args&&... args) {
    return CompositorFrameSinkParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorFrameSinkParamsPtr From(const U& u) {
    return mojo::TypeConverter<CompositorFrameSinkParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorFrameSinkParams>::Convert(*this);
  }


  CompositorFrameSinkParams();

  CompositorFrameSinkParams(
      bool wants_animate_only_begin_frames,
      bool auto_needs_begin_frame,
      bool no_compositor_frame_acks);


  ~CompositorFrameSinkParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorFrameSinkParamsPtr>
  CompositorFrameSinkParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameSinkParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameSinkParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorFrameSinkParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorFrameSinkParams_UnserializedMessageContext<
            UserType, CompositorFrameSinkParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CompositorFrameSinkParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CompositorFrameSinkParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorFrameSinkParams_UnserializedMessageContext<
            UserType, CompositorFrameSinkParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorFrameSinkParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool wants_animate_only_begin_frames;
  
  bool auto_needs_begin_frame;
  
  bool no_compositor_frame_acks;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorFrameSinkParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  LayerContextSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerContextSettings, T>::value>;
  using DataView = LayerContextSettingsDataView;
  using Data_ = internal::LayerContextSettings_Data;

  template <typename... Args>
  static LayerContextSettingsPtr New(Args&&... args) {
    return LayerContextSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerContextSettingsPtr From(const U& u) {
    return mojo::TypeConverter<LayerContextSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerContextSettings>::Convert(*this);
  }


  LayerContextSettings();

  LayerContextSettings(
      bool draw_mode_is_gpu,
      bool enable_early_damage_check,
      int32_t damaged_frame_limit,
      ::cc::LayerTreeSettings::ScrollbarAnimator scrollbar_animator,
      ::base::TimeDelta scrollbar_fade_delay,
      ::base::TimeDelta scrollbar_fade_duration,
      ::base::TimeDelta scrollbar_thinning_duration,
      float idle_thickness_scale,
      float top_controls_show_threshold,
      float top_controls_hide_threshold,
      const ::gfx::Size& minimum_occlusion_tracking_size,
      bool enable_edge_anti_aliasing,
      bool enable_backface_visibility_interop,
      bool enable_fluent_scrollbar,
      bool enable_fluent_overlay_scrollbar);


  ~LayerContextSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerContextSettingsPtr>
  LayerContextSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerContextSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerContextSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerContextSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerContextSettings_UnserializedMessageContext<
            UserType, LayerContextSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerContextSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerContextSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerContextSettings_UnserializedMessageContext<
            UserType, LayerContextSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerContextSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool draw_mode_is_gpu;
  
  bool enable_early_damage_check;
  
  int32_t damaged_frame_limit;
  
  ::cc::LayerTreeSettings::ScrollbarAnimator scrollbar_animator;
  
  ::base::TimeDelta scrollbar_fade_delay;
  
  ::base::TimeDelta scrollbar_fade_duration;
  
  ::base::TimeDelta scrollbar_thinning_duration;
  
  float idle_thickness_scale;
  
  float top_controls_show_threshold;
  
  float top_controls_hide_threshold;
  
  ::gfx::Size minimum_occlusion_tracking_size;
  
  bool enable_edge_anti_aliasing;
  
  bool enable_backface_visibility_interop;
  
  bool enable_fluent_scrollbar;
  
  bool enable_fluent_overlay_scrollbar;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerContextSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
LayerContextSettingsPtr LayerContextSettings::Clone() const {
  return New(
      mojo::Clone(draw_mode_is_gpu),
      mojo::Clone(enable_early_damage_check),
      mojo::Clone(damaged_frame_limit),
      mojo::Clone(scrollbar_animator),
      mojo::Clone(scrollbar_fade_delay),
      mojo::Clone(scrollbar_fade_duration),
      mojo::Clone(scrollbar_thinning_duration),
      mojo::Clone(idle_thickness_scale),
      mojo::Clone(top_controls_show_threshold),
      mojo::Clone(top_controls_hide_threshold),
      mojo::Clone(minimum_occlusion_tracking_size),
      mojo::Clone(enable_edge_anti_aliasing),
      mojo::Clone(enable_backface_visibility_interop),
      mojo::Clone(enable_fluent_scrollbar),
      mojo::Clone(enable_fluent_overlay_scrollbar)
  );
}

template <typename T, LayerContextSettings::EnableIfSame<T>*>
bool LayerContextSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->draw_mode_is_gpu, other_struct.draw_mode_is_gpu))
    return false;
  if (!mojo::Equals(this->enable_early_damage_check, other_struct.enable_early_damage_check))
    return false;
  if (!mojo::Equals(this->damaged_frame_limit, other_struct.damaged_frame_limit))
    return false;
  if (!mojo::Equals(this->scrollbar_animator, other_struct.scrollbar_animator))
    return false;
  if (!mojo::Equals(this->scrollbar_fade_delay, other_struct.scrollbar_fade_delay))
    return false;
  if (!mojo::Equals(this->scrollbar_fade_duration, other_struct.scrollbar_fade_duration))
    return false;
  if (!mojo::Equals(this->scrollbar_thinning_duration, other_struct.scrollbar_thinning_duration))
    return false;
  if (!mojo::Equals(this->idle_thickness_scale, other_struct.idle_thickness_scale))
    return false;
  if (!mojo::Equals(this->top_controls_show_threshold, other_struct.top_controls_show_threshold))
    return false;
  if (!mojo::Equals(this->top_controls_hide_threshold, other_struct.top_controls_hide_threshold))
    return false;
  if (!mojo::Equals(this->minimum_occlusion_tracking_size, other_struct.minimum_occlusion_tracking_size))
    return false;
  if (!mojo::Equals(this->enable_edge_anti_aliasing, other_struct.enable_edge_anti_aliasing))
    return false;
  if (!mojo::Equals(this->enable_backface_visibility_interop, other_struct.enable_backface_visibility_interop))
    return false;
  if (!mojo::Equals(this->enable_fluent_scrollbar, other_struct.enable_fluent_scrollbar))
    return false;
  if (!mojo::Equals(this->enable_fluent_overlay_scrollbar, other_struct.enable_fluent_overlay_scrollbar))
    return false;
  return true;
}

template <typename T, LayerContextSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.draw_mode_is_gpu < rhs.draw_mode_is_gpu)
    return true;
  if (rhs.draw_mode_is_gpu < lhs.draw_mode_is_gpu)
    return false;
  if (lhs.enable_early_damage_check < rhs.enable_early_damage_check)
    return true;
  if (rhs.enable_early_damage_check < lhs.enable_early_damage_check)
    return false;
  if (lhs.damaged_frame_limit < rhs.damaged_frame_limit)
    return true;
  if (rhs.damaged_frame_limit < lhs.damaged_frame_limit)
    return false;
  if (lhs.scrollbar_animator < rhs.scrollbar_animator)
    return true;
  if (rhs.scrollbar_animator < lhs.scrollbar_animator)
    return false;
  if (lhs.scrollbar_fade_delay < rhs.scrollbar_fade_delay)
    return true;
  if (rhs.scrollbar_fade_delay < lhs.scrollbar_fade_delay)
    return false;
  if (lhs.scrollbar_fade_duration < rhs.scrollbar_fade_duration)
    return true;
  if (rhs.scrollbar_fade_duration < lhs.scrollbar_fade_duration)
    return false;
  if (lhs.scrollbar_thinning_duration < rhs.scrollbar_thinning_duration)
    return true;
  if (rhs.scrollbar_thinning_duration < lhs.scrollbar_thinning_duration)
    return false;
  if (lhs.idle_thickness_scale < rhs.idle_thickness_scale)
    return true;
  if (rhs.idle_thickness_scale < lhs.idle_thickness_scale)
    return false;
  if (lhs.top_controls_show_threshold < rhs.top_controls_show_threshold)
    return true;
  if (rhs.top_controls_show_threshold < lhs.top_controls_show_threshold)
    return false;
  if (lhs.top_controls_hide_threshold < rhs.top_controls_hide_threshold)
    return true;
  if (rhs.top_controls_hide_threshold < lhs.top_controls_hide_threshold)
    return false;
  if (lhs.minimum_occlusion_tracking_size < rhs.minimum_occlusion_tracking_size)
    return true;
  if (rhs.minimum_occlusion_tracking_size < lhs.minimum_occlusion_tracking_size)
    return false;
  if (lhs.enable_edge_anti_aliasing < rhs.enable_edge_anti_aliasing)
    return true;
  if (rhs.enable_edge_anti_aliasing < lhs.enable_edge_anti_aliasing)
    return false;
  if (lhs.enable_backface_visibility_interop < rhs.enable_backface_visibility_interop)
    return true;
  if (rhs.enable_backface_visibility_interop < lhs.enable_backface_visibility_interop)
    return false;
  if (lhs.enable_fluent_scrollbar < rhs.enable_fluent_scrollbar)
    return true;
  if (rhs.enable_fluent_scrollbar < lhs.enable_fluent_scrollbar)
    return false;
  if (lhs.enable_fluent_overlay_scrollbar < rhs.enable_fluent_overlay_scrollbar)
    return true;
  if (rhs.enable_fluent_overlay_scrollbar < lhs.enable_fluent_overlay_scrollbar)
    return false;
  return false;
}
template <typename StructPtrType>
CompositorFrameSinkParamsPtr CompositorFrameSinkParams::Clone() const {
  return New(
      mojo::Clone(wants_animate_only_begin_frames),
      mojo::Clone(auto_needs_begin_frame),
      mojo::Clone(no_compositor_frame_acks)
  );
}

template <typename T, CompositorFrameSinkParams::EnableIfSame<T>*>
bool CompositorFrameSinkParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->wants_animate_only_begin_frames, other_struct.wants_animate_only_begin_frames))
    return false;
  if (!mojo::Equals(this->auto_needs_begin_frame, other_struct.auto_needs_begin_frame))
    return false;
  if (!mojo::Equals(this->no_compositor_frame_acks, other_struct.no_compositor_frame_acks))
    return false;
  return true;
}

template <typename T, CompositorFrameSinkParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.wants_animate_only_begin_frames < rhs.wants_animate_only_begin_frames)
    return true;
  if (rhs.wants_animate_only_begin_frames < lhs.wants_animate_only_begin_frames)
    return false;
  if (lhs.auto_needs_begin_frame < rhs.auto_needs_begin_frame)
    return true;
  if (rhs.auto_needs_begin_frame < lhs.auto_needs_begin_frame)
    return false;
  if (lhs.no_compositor_frame_acks < rhs.no_compositor_frame_acks)
    return true;
  if (rhs.no_compositor_frame_acks < lhs.no_compositor_frame_acks)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::LayerContextSettings::DataView,
                                         ::viz::mojom::LayerContextSettingsPtr> {
  static bool IsNull(const ::viz::mojom::LayerContextSettingsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::LayerContextSettingsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::LayerContextSettings::draw_mode_is_gpu) draw_mode_is_gpu(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->draw_mode_is_gpu;
  }

  static decltype(::viz::mojom::LayerContextSettings::enable_early_damage_check) enable_early_damage_check(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->enable_early_damage_check;
  }

  static decltype(::viz::mojom::LayerContextSettings::damaged_frame_limit) damaged_frame_limit(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->damaged_frame_limit;
  }

  static decltype(::viz::mojom::LayerContextSettings::scrollbar_animator) scrollbar_animator(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->scrollbar_animator;
  }

  static const decltype(::viz::mojom::LayerContextSettings::scrollbar_fade_delay)& scrollbar_fade_delay(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->scrollbar_fade_delay;
  }

  static const decltype(::viz::mojom::LayerContextSettings::scrollbar_fade_duration)& scrollbar_fade_duration(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->scrollbar_fade_duration;
  }

  static const decltype(::viz::mojom::LayerContextSettings::scrollbar_thinning_duration)& scrollbar_thinning_duration(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->scrollbar_thinning_duration;
  }

  static decltype(::viz::mojom::LayerContextSettings::idle_thickness_scale) idle_thickness_scale(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->idle_thickness_scale;
  }

  static decltype(::viz::mojom::LayerContextSettings::top_controls_show_threshold) top_controls_show_threshold(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->top_controls_show_threshold;
  }

  static decltype(::viz::mojom::LayerContextSettings::top_controls_hide_threshold) top_controls_hide_threshold(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->top_controls_hide_threshold;
  }

  static const decltype(::viz::mojom::LayerContextSettings::minimum_occlusion_tracking_size)& minimum_occlusion_tracking_size(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->minimum_occlusion_tracking_size;
  }

  static decltype(::viz::mojom::LayerContextSettings::enable_edge_anti_aliasing) enable_edge_anti_aliasing(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->enable_edge_anti_aliasing;
  }

  static decltype(::viz::mojom::LayerContextSettings::enable_backface_visibility_interop) enable_backface_visibility_interop(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->enable_backface_visibility_interop;
  }

  static decltype(::viz::mojom::LayerContextSettings::enable_fluent_scrollbar) enable_fluent_scrollbar(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->enable_fluent_scrollbar;
  }

  static decltype(::viz::mojom::LayerContextSettings::enable_fluent_overlay_scrollbar) enable_fluent_overlay_scrollbar(
      const ::viz::mojom::LayerContextSettingsPtr& input) {
    return input->enable_fluent_overlay_scrollbar;
  }

  static bool Read(::viz::mojom::LayerContextSettings::DataView input, ::viz::mojom::LayerContextSettingsPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::CompositorFrameSinkParams::DataView,
                                         ::viz::mojom::CompositorFrameSinkParamsPtr> {
  static bool IsNull(const ::viz::mojom::CompositorFrameSinkParamsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CompositorFrameSinkParamsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::CompositorFrameSinkParams::wants_animate_only_begin_frames) wants_animate_only_begin_frames(
      const ::viz::mojom::CompositorFrameSinkParamsPtr& input) {
    return input->wants_animate_only_begin_frames;
  }

  static decltype(::viz::mojom::CompositorFrameSinkParams::auto_needs_begin_frame) auto_needs_begin_frame(
      const ::viz::mojom::CompositorFrameSinkParamsPtr& input) {
    return input->auto_needs_begin_frame;
  }

  static decltype(::viz::mojom::CompositorFrameSinkParams::no_compositor_frame_acks) no_compositor_frame_acks(
      const ::viz::mojom::CompositorFrameSinkParamsPtr& input) {
    return input->no_compositor_frame_acks;
  }

  static bool Read(::viz::mojom::CompositorFrameSinkParams::DataView input, ::viz::mojom::CompositorFrameSinkParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_H_