// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('viz.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.CompositorFrameSinkPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.CompositorFrameSink.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { viz.mojom.CompositorFrameSinkInterface }
 */
viz.mojom.CompositorFrameSinkRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.CompositorFrameSinkPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.CompositorFrameSinkPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.CompositorFrameSinkPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !viz.mojom.CompositorFrameSinkParams } params
   */

  setParams(
      params) {
    this.proxy.sendMessage(
        0,
        viz.mojom.CompositorFrameSink_SetParams_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !boolean } needsBeginFrame
   */

  setNeedsBeginFrame(
      needsBeginFrame) {
    this.proxy.sendMessage(
        1,
        viz.mojom.CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        [
          needsBeginFrame
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.LocalSurfaceId } localSurfaceId
   * @param { !viz.mojom.CompositorFrame } frame
   * @param { ?viz.mojom.HitTestRegionList } hitTestRegionList
   * @param { !bigint } submitTime
   */

  submitCompositorFrame(
      localSurfaceId,
      frame,
      hitTestRegionList,
      submitTime) {
    this.proxy.sendMessage(
        2,
        viz.mojom.CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
        null,
        [
          localSurfaceId,
          frame,
          hitTestRegionList,
          submitTime
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.BeginFrameAck } ack
   */

  didNotProduceFrame(
      ack) {
    this.proxy.sendMessage(
        3,
        viz.mojom.CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
        null,
        [
          ack
        ],
        false);
  }

  
  /**
   */

  notifyNewLocalSurfaceIdExpectedWhilePaused() {
    this.proxy.sendMessage(
        4,
        viz.mojom.CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.PendingLayerContext } context
   * @param { !viz.mojom.LayerContextSettings } settings
   */

  bindLayerContext(
      context,
      settings) {
    this.proxy.sendMessage(
        5,
        viz.mojom.CompositorFrameSink_BindLayerContext_ParamsSpec.$,
        null,
        [
          context,
          settings
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CompositorFrameSink
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.CompositorFrameSinkReceiver = class {
  /**
   * @param {!viz.mojom.CompositorFrameSinkInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.CompositorFrameSinkRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.CompositorFrameSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.CompositorFrameSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.CompositorFrameSink_SetParams_ParamsSpec.$,
        null,
        impl.setParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        viz.mojom.CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        impl.setNeedsBeginFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        viz.mojom.CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
        null,
        impl.submitCompositorFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        viz.mojom.CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
        null,
        impl.didNotProduceFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        viz.mojom.CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
        null,
        impl.notifyNewLocalSurfaceIdExpectedWhilePaused.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        viz.mojom.CompositorFrameSink_BindLayerContext_ParamsSpec.$,
        null,
        impl.bindLayerContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.CompositorFrameSink = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.CompositorFrameSink";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.CompositorFrameSinkRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.CompositorFrameSinkRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CompositorFrameSink
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.CompositorFrameSinkCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.CompositorFrameSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.CompositorFrameSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.CompositorFrameSink_SetParams_ParamsSpec.$,
        null,
        this.setParams.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNeedsBeginFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        viz.mojom.CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        this.setNeedsBeginFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitCompositorFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        viz.mojom.CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
        null,
        this.submitCompositorFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didNotProduceFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        viz.mojom.CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
        null,
        this.didNotProduceFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyNewLocalSurfaceIdExpectedWhilePaused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        viz.mojom.CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
        null,
        this.notifyNewLocalSurfaceIdExpectedWhilePaused.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindLayerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        viz.mojom.CompositorFrameSink_BindLayerContext_ParamsSpec.$,
        null,
        this.bindLayerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.CompositorFrameSinkClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.CompositorFrameSinkClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { viz.mojom.CompositorFrameSinkClientInterface }
 */
viz.mojom.CompositorFrameSinkClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.CompositorFrameSinkClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.CompositorFrameSinkClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.CompositorFrameSinkClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!viz.mojom.ReturnedResource> } resources
   */

  didReceiveCompositorFrameAck(
      resources) {
    this.proxy.sendMessage(
        0,
        viz.mojom.CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
        null,
        [
          resources
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.BeginFrameArgs } args
   * @param { !Object<!number, !viz.mojom.FrameTimingDetails> } details
   * @param { !Array<!viz.mojom.ReturnedResource> } resources
   */

  onBeginFrame(
      args,
      details,
      resources) {
    this.proxy.sendMessage(
        1,
        viz.mojom.CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
        null,
        [
          args,
          details,
          resources
        ],
        false);
  }

  
  /**
   * @param { !boolean } paused
   */

  onBeginFramePausedChanged(
      paused) {
    this.proxy.sendMessage(
        2,
        viz.mojom.CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        [
          paused
        ],
        false);
  }

  
  /**
   * @param { !Array<!viz.mojom.ReturnedResource> } resources
   */

  reclaimResources(
      resources) {
    this.proxy.sendMessage(
        3,
        viz.mojom.CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
        null,
        [
          resources
        ],
        false);
  }

  
  /**
   * @param { !number } sequenceId
   */

  onCompositorFrameTransitionDirectiveProcessed(
      sequenceId) {
    this.proxy.sendMessage(
        4,
        viz.mojom.CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        [
          sequenceId
        ],
        false);
  }

  
  /**
   * @param { !viz.mojom.LocalSurfaceId } localSurfaceId
   */

  onSurfaceEvicted(
      localSurfaceId) {
    this.proxy.sendMessage(
        5,
        viz.mojom.CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
        null,
        [
          localSurfaceId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CompositorFrameSinkClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.CompositorFrameSinkClientReceiver = class {
  /**
   * @param {!viz.mojom.CompositorFrameSinkClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.CompositorFrameSinkClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.CompositorFrameSinkClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.CompositorFrameSinkClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
        null,
        impl.didReceiveCompositorFrameAck.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        viz.mojom.CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
        null,
        impl.onBeginFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        viz.mojom.CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        impl.onBeginFramePausedChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        viz.mojom.CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
        null,
        impl.reclaimResources.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        viz.mojom.CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        impl.onCompositorFrameTransitionDirectiveProcessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        viz.mojom.CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
        null,
        impl.onSurfaceEvicted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.CompositorFrameSinkClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.CompositorFrameSinkClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.CompositorFrameSinkClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.CompositorFrameSinkClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CompositorFrameSinkClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.CompositorFrameSinkClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.CompositorFrameSinkClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.CompositorFrameSinkClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReceiveCompositorFrameAck =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
        null,
        this.didReceiveCompositorFrameAck.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeginFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        viz.mojom.CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
        null,
        this.onBeginFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeginFramePausedChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        viz.mojom.CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        this.onBeginFramePausedChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reclaimResources =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        viz.mojom.CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
        null,
        this.reclaimResources.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompositorFrameTransitionDirectiveProcessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        viz.mojom.CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        this.onCompositorFrameTransitionDirectiveProcessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSurfaceEvicted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        viz.mojom.CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
        null,
        this.onSurfaceEvicted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.LayerContextSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSinkParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSink_SetParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSink_SubmitCompositorFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSink_DidNotProduceFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSink_BindLayerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSinkClient_OnBeginFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSinkClient_ReclaimResources_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    viz.mojom.LayerContextSettingsSpec.$,
    'LayerContextSettings',
    [
      mojo.internal.StructField(
        'drawModeIsGpu', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableEarlyDamageCheck', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'damagedFrameLimit', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollbarAnimator', 8,
        0,
        cc.mojom.ScrollbarAnimatorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollbarFadeDelay', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollbarFadeDuration', 24,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollbarThinningDuration', 32,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'idleThicknessScale', 12,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topControlsShowThreshold', 40,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topControlsHideThreshold', 44,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minimumOcclusionTrackingSize', 48,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableEdgeAntiAliasing', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableBackfaceVisibilityInterop', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableFluentScrollbar', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableFluentOverlayScrollbar', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
viz.mojom.LayerContextSettings = class {
  constructor() {
    /** @export { !boolean } */
    this.drawModeIsGpu;
    /** @export { !boolean } */
    this.enableEarlyDamageCheck;
    /** @export { !number } */
    this.damagedFrameLimit;
    /** @export { !cc.mojom.ScrollbarAnimator } */
    this.scrollbarAnimator;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.scrollbarFadeDelay;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.scrollbarFadeDuration;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.scrollbarThinningDuration;
    /** @export { !number } */
    this.idleThicknessScale;
    /** @export { !number } */
    this.topControlsShowThreshold;
    /** @export { !number } */
    this.topControlsHideThreshold;
    /** @export { !gfx.mojom.Size } */
    this.minimumOcclusionTrackingSize;
    /** @export { !boolean } */
    this.enableEdgeAntiAliasing;
    /** @export { !boolean } */
    this.enableBackfaceVisibilityInterop;
    /** @export { !boolean } */
    this.enableFluentScrollbar;
    /** @export { !boolean } */
    this.enableFluentOverlayScrollbar;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSinkParamsSpec.$,
    'CompositorFrameSinkParams',
    [
      mojo.internal.StructField(
        'wantsAnimateOnlyBeginFrames', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'autoNeedsBeginFrame', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'noCompositorFrameAcks', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSinkParams = class {
  constructor() {
    /** @export { !boolean } */
    this.wantsAnimateOnlyBeginFrames;
    /** @export { !boolean } */
    this.autoNeedsBeginFrame;
    /** @export { !boolean } */
    this.noCompositorFrameAcks;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSink_SetParams_ParamsSpec.$,
    'CompositorFrameSink_SetParams_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        viz.mojom.CompositorFrameSinkParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSink_SetParams_Params = class {
  constructor() {
    /** @export { !viz.mojom.CompositorFrameSinkParams } */
    this.params;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
    'CompositorFrameSink_SetNeedsBeginFrame_Params',
    [
      mojo.internal.StructField(
        'needsBeginFrame', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSink_SetNeedsBeginFrame_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.needsBeginFrame;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
    'CompositorFrameSink_SubmitCompositorFrame_Params',
    [
      mojo.internal.StructField(
        'localSurfaceId', 0,
        0,
        viz.mojom.LocalSurfaceIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frame', 8,
        0,
        viz.mojom.CompositorFrameSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hitTestRegionList', 16,
        0,
        viz.mojom.HitTestRegionListSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'submitTime', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
viz.mojom.CompositorFrameSink_SubmitCompositorFrame_Params = class {
  constructor() {
    /** @export { !viz.mojom.LocalSurfaceId } */
    this.localSurfaceId;
    /** @export { !viz.mojom.CompositorFrame } */
    this.frame;
    /** @export { (viz.mojom.HitTestRegionList|undefined) } */
    this.hitTestRegionList;
    /** @export { !bigint } */
    this.submitTime;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
    'CompositorFrameSink_DidNotProduceFrame_Params',
    [
      mojo.internal.StructField(
        'ack', 0,
        0,
        viz.mojom.BeginFrameAckSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSink_DidNotProduceFrame_Params = class {
  constructor() {
    /** @export { !viz.mojom.BeginFrameAck } */
    this.ack;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
    'CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params',
    [
    ],
    [[0, 8],]);





/** @record */
viz.mojom.CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSink_BindLayerContext_ParamsSpec.$,
    'CompositorFrameSink_BindLayerContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        viz.mojom.PendingLayerContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        viz.mojom.LayerContextSettingsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
viz.mojom.CompositorFrameSink_BindLayerContext_Params = class {
  constructor() {
    /** @export { !viz.mojom.PendingLayerContext } */
    this.context;
    /** @export { !viz.mojom.LayerContextSettings } */
    this.settings;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
    'CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params',
    [
      mojo.internal.StructField(
        'resources', 0,
        0,
        mojo.internal.Array(viz.mojom.ReturnedResourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params = class {
  constructor() {
    /** @export { !Array<!viz.mojom.ReturnedResource> } */
    this.resources;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
    'CompositorFrameSinkClient_OnBeginFrame_Params',
    [
      mojo.internal.StructField(
        'args', 0,
        0,
        viz.mojom.BeginFrameArgsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        mojo.internal.Map(mojo.internal.Uint32, viz.mojom.FrameTimingDetailsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resources', 16,
        0,
        mojo.internal.Array(viz.mojom.ReturnedResourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
viz.mojom.CompositorFrameSinkClient_OnBeginFrame_Params = class {
  constructor() {
    /** @export { !viz.mojom.BeginFrameArgs } */
    this.args;
    /** @export { !Object<!number, !viz.mojom.FrameTimingDetails> } */
    this.details;
    /** @export { !Array<!viz.mojom.ReturnedResource> } */
    this.resources;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
    'CompositorFrameSinkClient_OnBeginFramePausedChanged_Params',
    [
      mojo.internal.StructField(
        'paused', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSinkClient_OnBeginFramePausedChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.paused;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
    'CompositorFrameSinkClient_ReclaimResources_Params',
    [
      mojo.internal.StructField(
        'resources', 0,
        0,
        mojo.internal.Array(viz.mojom.ReturnedResourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSinkClient_ReclaimResources_Params = class {
  constructor() {
    /** @export { !Array<!viz.mojom.ReturnedResource> } */
    this.resources;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
    'CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params',
    [
      mojo.internal.StructField(
        'sequenceId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params = class {
  constructor() {
    /** @export { !number } */
    this.sequenceId;
  }
};



mojo.internal.Struct(
    viz.mojom.CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
    'CompositorFrameSinkClient_OnSurfaceEvicted_Params',
    [
      mojo.internal.StructField(
        'localSurfaceId', 0,
        0,
        viz.mojom.LocalSurfaceIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.CompositorFrameSinkClient_OnSurfaceEvicted_Params = class {
  constructor() {
    /** @export { !viz.mojom.LocalSurfaceId } */
    this.localSurfaceId;
  }
};

