// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.h"
#include "ui/gfx/mojom/delegated_ink_metadata.mojom-shared.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_deadline.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared.h"
#include "services/viz/public/mojom/compositing/region_capture_bounds.mojom-shared.h"
#include "services/viz/public/mojom/compositing/trees_in_viz_timing.mojom-shared.h"
#include "services/viz/public/mojom/compositing/selection.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"
#include "ui/gfx/mojom/overlay_transform.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"


namespace viz::mojom {
class CompositorFrameMetadataDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CompositorFrameMetadataDataView> {
  using Data = ::viz::mojom::internal::CompositorFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class CompositorFrameMetadataDataView {
 public:
  CompositorFrameMetadataDataView() = default;

  CompositorFrameMetadataDataView(
      internal::CompositorFrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  inline void GetRootScrollOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootScrollOffset(UserType* output) {
    
    auto* pointer = data_->root_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  inline void GetScrollableViewportSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollableViewportSize(UserType* output) {
    
    auto* pointer = data_->scrollable_viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleViewportSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleViewportSize(UserType* output) {
    
    auto* pointer = data_->visible_viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContentColorUsage(UserType* output) const {
    auto data_value = data_->content_color_usage;
    return mojo::internal::Deserialize<::gfx::mojom::ContentColorUsage>(
        data_value, output);
  }
  ::gfx::mojom::ContentColorUsage content_color_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::ContentColorUsage>(data_->content_color_usage));
  }
  bool may_contain_video() const {
    return data_->may_contain_video;
  }
  bool may_throttle_if_undrawn_frames() const {
    return data_->may_throttle_if_undrawn_frames;
  }
  bool is_handling_interaction() const {
    return data_->is_handling_interaction;
  }
  bool is_handling_animation() const {
    return data_->is_handling_animation;
  }
  inline void GetRootBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootBackgroundColor(UserType* output) {
    
    auto* pointer = data_->root_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetLatencyInfoDataView(
      mojo::ArrayDataView<::ui::mojom::LatencyInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatencyInfo(UserType* output) {
    
    auto* pointer = data_->latency_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ui::mojom::LatencyInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetReferencedSurfacesDataView(
      mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferencedSurfaces(UserType* output) {
    
    auto* pointer = data_->referenced_surfaces.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>>(
        pointer, output, message_);
  }
  inline void GetDeadlineDataView(
      ::viz::mojom::FrameDeadlineDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeadline(UserType* output) {
    
    auto* pointer = data_->deadline.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameDeadlineDataView>(
        pointer, output, message_);
  }
  inline void GetActivationDependenciesDataView(
      mojo::ArrayDataView<::viz::mojom::SurfaceIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivationDependencies(UserType* output) {
    
    auto* pointer = data_->activation_dependencies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::SurfaceIdDataView>>(
        pointer, output, message_);
  }
  inline void GetBeginFrameAckDataView(
      ::viz::mojom::BeginFrameAckDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeginFrameAck(UserType* output) {
    
    auto* pointer = data_->begin_frame_ack.Get();
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameAckDataView>(
        pointer, output, message_);
  }
  uint32_t frame_token() const {
    return data_->frame_token;
  }
  bool send_frame_token_to_embedder() const {
    return data_->send_frame_token_to_embedder;
  }
  bool top_controls_visible_height_set() const {
    return data_->top_controls_visible_height_set;
  }
  float top_controls_visible_height() const {
    return data_->top_controls_visible_height;
  }
  float min_page_scale_factor() const {
    return data_->min_page_scale_factor;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisplayTransformHint(UserType* output) const {
    auto data_value = data_->display_transform_hint;
    return mojo::internal::Deserialize<::gfx::mojom::OverlayTransform>(
        data_value, output);
  }
  ::gfx::mojom::OverlayTransform display_transform_hint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::OverlayTransform>(data_->display_transform_hint));
  }
  bool is_mobile_optimized() const {
    return data_->is_mobile_optimized;
  }
  inline void GetDelegatedInkMetadataDataView(
      ::gfx::mojom::DelegatedInkMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDelegatedInkMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::DelegatedInkMetadataDataView, UserType>(),
    "Attempting to read the optional `delegated_ink_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDelegatedInkMetadata` instead "
    "of `ReadDelegatedInkMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->delegated_ink_metadata.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DelegatedInkMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetTransitionDirectivesDataView(
      mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransitionDirectives(UserType* output) {
    
    auto* pointer = data_->transition_directives.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveDataView>>(
        pointer, output, message_);
  }
  inline void GetCaptureBoundsDataView(
      ::viz::mojom::RegionCaptureBoundsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureBounds(UserType* output) {
    
    auto* pointer = data_->capture_bounds.Get();
    return mojo::internal::Deserialize<::viz::mojom::RegionCaptureBoundsDataView>(
        pointer, output, message_);
  }
  bool has_shared_element_resources() const {
    return data_->has_shared_element_resources;
  }
  inline void GetScreenshotDestinationDataView(
      ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenshotDestination(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView, UserType>(),
    "Attempting to read the optional `screenshot_destination` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScreenshotDestination` instead "
    "of `ReadScreenshotDestination if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->screenshot_destination.Get();
    return mojo::internal::Deserialize<::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView>(
        pointer, output, message_);
  }
  bool is_software() const {
    return data_->is_software;
  }
  inline void GetOffsetTagDefinitionsDataView(
      mojo::ArrayDataView<::viz::mojom::OffsetTagDefinitionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsetTagDefinitions(UserType* output) {
    
    auto* pointer = data_->offset_tag_definitions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::OffsetTagDefinitionDataView>>(
        pointer, output, message_);
  }
  inline void GetOffsetTagValuesDataView(
      mojo::ArrayDataView<::viz::mojom::OffsetTagValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsetTagValues(UserType* output) {
    
    auto* pointer = data_->offset_tag_values.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::OffsetTagValueDataView>>(
        pointer, output, message_);
  }
  inline void GetFrameIntervalInputsDataView(
      ::viz::mojom::FrameIntervalInputsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameIntervalInputs(UserType* output) {
    
    auto* pointer = data_->frame_interval_inputs.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameIntervalInputsDataView>(
        pointer, output, message_);
  }
  inline void GetTreesInVizTimingDataView(
      ::viz::mojom::TreesInVizTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTreesInVizTiming(UserType* output) {
    
    auto* pointer = data_->trees_in_viz_timing.Get();
    return mojo::internal::Deserialize<::viz::mojom::TreesInVizTimingDataView>(
        pointer, output, message_);
  }
 private:
  internal::CompositorFrameMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_DATA_VIEW_H_