// services/viz/privileged/mojom/compositing/renderer_settings.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared-internal.h"
#include "services/viz/privileged/mojom/compositing/overlay_strategy.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"


namespace viz::mojom {
class OcclusionCullerSettingsDataView;

class RendererSettingsDataView;

class DebugRendererSettingsDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::OcclusionCullerSettingsDataView> {
  using Data = ::viz::mojom::internal::OcclusionCullerSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::RendererSettingsDataView> {
  using Data = ::viz::mojom::internal::RendererSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::DebugRendererSettingsDataView> {
  using Data = ::viz::mojom::internal::DebugRendererSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class OcclusionCullerSettingsDataView {
 public:
  OcclusionCullerSettingsDataView() = default;

  OcclusionCullerSettingsDataView(
      internal::OcclusionCullerSettings_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t quad_split_limit() const {
    return data_->quad_split_limit;
  }
  uint16_t maximum_occluder_complexity() const {
    return data_->maximum_occluder_complexity;
  }
  uint16_t minimum_fragments_reduced() const {
    return data_->minimum_fragments_reduced;
  }
  bool generate_complex_occluder_for_rounded_corners() const {
    return data_->generate_complex_occluder_for_rounded_corners;
  }
 private:
  internal::OcclusionCullerSettings_Data* data_ = nullptr;
};


class RendererSettingsDataView {
 public:
  RendererSettingsDataView() = default;

  RendererSettingsDataView(
      internal::RendererSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool allow_antialiasing() const {
    return data_->allow_antialiasing;
  }
  bool force_antialiasing() const {
    return data_->force_antialiasing;
  }
  bool force_blending_with_shaders() const {
    return data_->force_blending_with_shaders;
  }
  int32_t highp_threshold_min() const {
    return data_->highp_threshold_min;
  }
  bool partial_swap_enabled() const {
    return data_->partial_swap_enabled;
  }
  bool release_overlay_resources_after_gpu_query() const {
    return data_->release_overlay_resources_after_gpu_query;
  }
  bool should_clear_root_render_pass() const {
    return data_->should_clear_root_render_pass;
  }
  int32_t slow_down_compositing_scale_factor() const {
    return data_->slow_down_compositing_scale_factor;
  }
  bool auto_resize_output_surface() const {
    return data_->auto_resize_output_surface;
  }
  bool requires_alpha_channel() const {
    return data_->requires_alpha_channel;
  }
  inline void GetOcclusionCullerSettingsDataView(
      OcclusionCullerSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOcclusionCullerSettings(UserType* output) {
    
    auto* pointer = data_->occlusion_culler_settings.Get();
    return mojo::internal::Deserialize<::viz::mojom::OcclusionCullerSettingsDataView>(
        pointer, output, message_);
  }
  int64_t display_id() const {
    return data_->display_id;
  }
 private:
  internal::RendererSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DebugRendererSettingsDataView {
 public:
  DebugRendererSettingsDataView() = default;

  DebugRendererSettingsDataView(
      internal::DebugRendererSettings_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool tint_composited_content() const {
    return data_->tint_composited_content;
  }
  bool tint_composited_content_modulate() const {
    return data_->tint_composited_content_modulate;
  }
  bool show_overdraw_feedback() const {
    return data_->show_overdraw_feedback;
  }
  bool show_dc_layer_debug_borders() const {
    return data_->show_dc_layer_debug_borders;
  }
  bool show_aggregated_damage() const {
    return data_->show_aggregated_damage;
  }
 private:
  internal::DebugRendererSettings_Data* data_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_DATA_VIEW_H_