// services/video_capture/public/mojom/video_frame_handler.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/video_capture/public/mojom/video_frame_handler.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_frame_handler.mojom-params-data.h"
namespace video_capture {
namespace mojom {

namespace internal {


// static
bool ReadyFrameInBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadyFrameInBuffer_Data* object =
      static_cast<const ReadyFrameInBuffer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_info, validation_context))
    return false;

  return true;
}

ReadyFrameInBuffer_Data::ReadyFrameInBuffer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data* object =
      static_cast<const VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data*>(data);

  return true;
}

VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data::VideoFrameAccessHandler_OnFinishedConsumingBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data* object =
      static_cast<const VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data*>(data);

  return true;
}

VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data::VideoFrameHandler_OnCaptureConfigurationChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnNewBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnNewBuffer_Params_Data* object =
      static_cast<const VideoFrameHandler_OnNewBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buffer_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buffer_handle, validation_context))
    return false;

  return true;
}

VideoFrameHandler_OnNewBuffer_Params_Data::VideoFrameHandler_OnNewBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data* object =
      static_cast<const VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_access_handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_access_handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data::VideoFrameHandler_OnFrameAccessHandlerReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnFrameReadyInBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnFrameReadyInBuffer_Params_Data* object =
      static_cast<const VideoFrameHandler_OnFrameReadyInBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

VideoFrameHandler_OnFrameReadyInBuffer_Params_Data::VideoFrameHandler_OnFrameReadyInBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnBufferRetired_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnBufferRetired_Params_Data* object =
      static_cast<const VideoFrameHandler_OnBufferRetired_Params_Data*>(data);

  return true;
}

VideoFrameHandler_OnBufferRetired_Params_Data::VideoFrameHandler_OnBufferRetired_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnError_Params_Data* object =
      static_cast<const VideoFrameHandler_OnError_Params_Data*>(data);


  if (!::media::mojom::internal::VideoCaptureError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

VideoFrameHandler_OnError_Params_Data::VideoFrameHandler_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnFrameDropped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnFrameDropped_Params_Data* object =
      static_cast<const VideoFrameHandler_OnFrameDropped_Params_Data*>(data);


  if (!::media::mojom::internal::VideoCaptureFrameDropReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

VideoFrameHandler_OnFrameDropped_Params_Data::VideoFrameHandler_OnFrameDropped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnNewCaptureVersion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnNewCaptureVersion_Params_Data* object =
      static_cast<const VideoFrameHandler_OnNewCaptureVersion_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capture_version, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capture_version, validation_context))
    return false;

  return true;
}

VideoFrameHandler_OnNewCaptureVersion_Params_Data::VideoFrameHandler_OnNewCaptureVersion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data* object =
      static_cast<const VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data*>(data);

  return true;
}

VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data::VideoFrameHandler_OnFrameWithEmptyRegionCapture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnLog_Params_Data* object =
      static_cast<const VideoFrameHandler_OnLog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

VideoFrameHandler_OnLog_Params_Data::VideoFrameHandler_OnLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnStarted_Params_Data* object =
      static_cast<const VideoFrameHandler_OnStarted_Params_Data*>(data);

  return true;
}

VideoFrameHandler_OnStarted_Params_Data::VideoFrameHandler_OnStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data* object =
      static_cast<const VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data*>(data);

  return true;
}

VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data::VideoFrameHandler_OnStartedUsingGpuDecode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandler_OnStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandler_OnStopped_Params_Data* object =
      static_cast<const VideoFrameHandler_OnStopped_Params_Data*>(data);

  return true;
}

VideoFrameHandler_OnStopped_Params_Data::VideoFrameHandler_OnStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace video_capture