// services/shape_detection/public/mojom/facedetection_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/shape_detection/public/mojom/facedetection_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/shape_detection/public/mojom/facedetection_provider.mojom-params-data.h"
#include "services/shape_detection/public/mojom/facedetection_provider.mojom-shared-message-ids.h"

#include "services/shape_detection/public/mojom/facedetection_provider.mojom-blink-import-headers.h"
#include "services/shape_detection/public/mojom/facedetection_provider.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace shape_detection::mojom::blink {
// The declaration includes the definition on other builds.

FaceDetectionProvider::IPCStableHashFunction FaceDetectionProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FaceDetectionProvider>(message.name())) {
    case messages::FaceDetectionProvider::kCreateFaceDetection: {
      return &FaceDetectionProvider::CreateFaceDetection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FaceDetectionProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FaceDetectionProvider>(message.name())) {
      case messages::FaceDetectionProvider::kCreateFaceDetection:
            return "Receive shape_detection::mojom::FaceDetectionProvider::CreateFaceDetection";
    }
  } else {
    switch (static_cast<messages::FaceDetectionProvider>(message.name())) {
      case messages::FaceDetectionProvider::kCreateFaceDetection:
            return "Receive reply shape_detection::mojom::FaceDetectionProvider::CreateFaceDetection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FaceDetectionProvider::CreateFaceDetection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf30af73;  // IPCStableHash for shape_detection::mojom::FaceDetectionProvider::CreateFaceDetection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FaceDetectionProviderProxy::FaceDetectionProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FaceDetectionProviderProxy::CreateFaceDetection(
    ::mojo::PendingReceiver<::shape_detection::mojom::blink::FaceDetection> in_receiver, ::shape_detection::mojom::blink::FaceDetectorOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shape_detection::mojom::FaceDetectionProvider::CreateFaceDetection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::shape_detection::mojom::blink::FaceDetection>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::shape_detection::mojom::blink::FaceDetectorOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FaceDetectionProvider::kCreateFaceDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::FaceDetectionProvider_CreateFaceDetection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::shape_detection::mojom::FaceDetectionInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FaceDetectionProvider.CreateFaceDetection request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::shape_detection::mojom::FaceDetectorOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in FaceDetectionProvider.CreateFaceDetection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FaceDetectionProvider::Name_);
  message.set_method_name("CreateFaceDetection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FaceDetectionProviderStubDispatch::Accept(
    FaceDetectionProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FaceDetectionProvider>(message->header()->name)) {
    case messages::FaceDetectionProvider::kCreateFaceDetection: {
      DCHECK(message->is_serialized());
      internal::FaceDetectionProvider_CreateFaceDetection_Params_Data* params =
          reinterpret_cast<internal::FaceDetectionProvider_CreateFaceDetection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FaceDetectionProvider.0
      bool success = true;
      ::mojo::PendingReceiver<::shape_detection::mojom::blink::FaceDetection> p_receiver{};
      ::shape_detection::mojom::blink::FaceDetectorOptionsPtr p_options{};
      FaceDetectionProvider_CreateFaceDetection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FaceDetectionProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFaceDetection(        
        std::move(p_receiver), 
        std::move(p_options));
      return true;
    }
  }
  return false;
}

// static
bool FaceDetectionProviderStubDispatch::AcceptWithResponder(
    FaceDetectionProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FaceDetectionProvider>(message->header()->name)) {
    case messages::FaceDetectionProvider::kCreateFaceDetection: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFaceDetectionProviderValidationInfo[] = {
    { &internal::FaceDetectionProvider_CreateFaceDetection_Params_Data::Validate,
     nullptr /* no response */},
};

bool FaceDetectionProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::shape_detection::mojom::blink::FaceDetectionProvider::Name_,
    kFaceDetectionProviderValidationInfo);
}



}  // shape_detection::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace shape_detection::mojom::blink {


void FaceDetectionProviderInterceptorForTesting::CreateFaceDetection(::mojo::PendingReceiver<::shape_detection::mojom::blink::FaceDetection> receiver, ::shape_detection::mojom::blink::FaceDetectorOptionsPtr options) {
  GetForwardingInterface()->CreateFaceDetection(
    std::move(receiver)
    , 
    std::move(options)
    );
}
FaceDetectionProviderAsyncWaiter::FaceDetectionProviderAsyncWaiter(
    FaceDetectionProvider* proxy) : proxy_(proxy) {}

FaceDetectionProviderAsyncWaiter::~FaceDetectionProviderAsyncWaiter() = default;







}  // shape_detection::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif