// services/service_manager/public/mojom/interface_provider_spec.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/service_manager/public/mojom/interface_provider_spec.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('serviceManager.mojom');


  var SERVICE_MANAGER_CONNECTOR_SPEC = "service_manager:connector";

  function InterfaceSet(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceSet.prototype.initDefaults_ = function() {
    this.interfaces = null;
  };
  InterfaceSet.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceSet.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterfaceSet.interfaces
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceSet.encodedSize = codec.kStructHeaderSize + 8;

  InterfaceSet.decode = function(decoder) {
    var packed;
    var val = new InterfaceSet();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.interfaces =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  InterfaceSet.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceSet.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.interfaces);
  };
  function CapabilitySet(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CapabilitySet.prototype.initDefaults_ = function() {
    this.capabilities = null;
  };
  CapabilitySet.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CapabilitySet.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CapabilitySet.capabilities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CapabilitySet.encodedSize = codec.kStructHeaderSize + 8;

  CapabilitySet.decode = function(decoder) {
    var packed;
    var val = new CapabilitySet();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.capabilities =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  CapabilitySet.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CapabilitySet.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.capabilities);
  };
  function InterfaceProviderSpec(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceProviderSpec.prototype.initDefaults_ = function() {
    this.provides = null;
    this.needs = null;
  };
  InterfaceProviderSpec.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceProviderSpec.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterfaceProviderSpec.provides
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(InterfaceSet), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterfaceProviderSpec.needs
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, new codec.PointerTo(CapabilitySet), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceProviderSpec.encodedSize = codec.kStructHeaderSize + 16;

  InterfaceProviderSpec.decode = function(decoder) {
    var packed;
    var val = new InterfaceProviderSpec();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.provides =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(InterfaceSet));
    val.needs =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(CapabilitySet));
    return val;
  };

  InterfaceProviderSpec.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceProviderSpec.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(InterfaceSet), val.provides);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(CapabilitySet), val.needs);
  };
  exports.SERVICE_MANAGER_CONNECTOR_SPEC = SERVICE_MANAGER_CONNECTOR_SPEC;
  exports.InterfaceSet = InterfaceSet;
  exports.CapabilitySet = CapabilitySet;
  exports.InterfaceProviderSpec = InterfaceProviderSpec;
})();