// services/screen_ai/public/mojom/screen_ai_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_TEST_UTILS_H_
#define SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_TEST_UTILS_H_

#include "services/screen_ai/public/mojom/screen_ai_service.mojom.h"


namespace screen_ai::mojom {


class  ScreenAIAnnotatorInterceptorForTesting : public ScreenAIAnnotator {
  virtual ScreenAIAnnotator* GetForwardingInterface() = 0;
  void PerformOcrAndReturnAnnotation(const ::SkBitmap& image, PerformOcrAndReturnAnnotationCallback callback) override;
  void SetClientType(OcrClientType client_type) override;
  void GetMaxImageDimension(GetMaxImageDimensionCallback callback) override;
  void SetOCRLightMode(bool enabled) override;
  void IsOCRBusy(IsOCRBusyCallback callback) override;
};
class  ScreenAIAnnotatorAsyncWaiter {
 public:
  explicit ScreenAIAnnotatorAsyncWaiter(ScreenAIAnnotator* proxy);

  ScreenAIAnnotatorAsyncWaiter(const ScreenAIAnnotatorAsyncWaiter&) = delete;
  ScreenAIAnnotatorAsyncWaiter& operator=(const ScreenAIAnnotatorAsyncWaiter&) = delete;

  ~ScreenAIAnnotatorAsyncWaiter();
  void PerformOcrAndReturnAnnotation(
      const ::SkBitmap& image, VisualAnnotationPtr* out_visual_annotation);
  VisualAnnotationPtr PerformOcrAndReturnAnnotation(const ::SkBitmap& image);
  void GetMaxImageDimension(
      uint32_t* out_max_dimension);
  uint32_t GetMaxImageDimension();
  void IsOCRBusy(
      bool* out_busy);
  bool IsOCRBusy();

 private:
  ScreenAIAnnotator* const proxy_;
};


class  Screen2xMainContentExtractorInterceptorForTesting : public Screen2xMainContentExtractor {
  virtual Screen2xMainContentExtractor* GetForwardingInterface() = 0;
  void ExtractMainContent(const ::ui::AXTreeUpdate& snapshot, ExtractMainContentCallback callback) override;
  void ExtractMainNode(const ::ui::AXTreeUpdate& snapshot, ExtractMainNodeCallback callback) override;
  void IdentifyMainNode(const ::ui::AXTreeUpdate& ax_tree, IdentifyMainNodeCallback callback) override;
  void SetClientType(MceClientType client_type) override;
};
class  Screen2xMainContentExtractorAsyncWaiter {
 public:
  explicit Screen2xMainContentExtractorAsyncWaiter(Screen2xMainContentExtractor* proxy);

  Screen2xMainContentExtractorAsyncWaiter(const Screen2xMainContentExtractorAsyncWaiter&) = delete;
  Screen2xMainContentExtractorAsyncWaiter& operator=(const Screen2xMainContentExtractorAsyncWaiter&) = delete;

  ~Screen2xMainContentExtractorAsyncWaiter();
  void ExtractMainContent(
      const ::ui::AXTreeUpdate& snapshot, std::vector<int32_t>* out_content_node_ids);
  std::vector<int32_t> ExtractMainContent(const ::ui::AXTreeUpdate& snapshot);
  void ExtractMainNode(
      const ::ui::AXTreeUpdate& snapshot, int32_t* out_main_node_id);
  int32_t ExtractMainNode(const ::ui::AXTreeUpdate& snapshot);
  void IdentifyMainNode(
      const ::ui::AXTreeUpdate& ax_tree, ::ui::AXTreeID* out_tree_id, int32_t* out_node_id);
  

 private:
  Screen2xMainContentExtractor* const proxy_;
};


class  OCRServiceInterceptorForTesting : public OCRService {
  virtual OCRService* GetForwardingInterface() = 0;
  void BindAnnotator(::mojo::PendingReceiver<ScreenAIAnnotator> annotator) override;
};
class  OCRServiceAsyncWaiter {
 public:
  explicit OCRServiceAsyncWaiter(OCRService* proxy);

  OCRServiceAsyncWaiter(const OCRServiceAsyncWaiter&) = delete;
  OCRServiceAsyncWaiter& operator=(const OCRServiceAsyncWaiter&) = delete;

  ~OCRServiceAsyncWaiter();

 private:
  OCRService* const proxy_;
};


class  MainContentExtractionServiceInterceptorForTesting : public MainContentExtractionService {
  virtual MainContentExtractionService* GetForwardingInterface() = 0;
  void BindMainContentExtractor(::mojo::PendingReceiver<Screen2xMainContentExtractor> main_content_extractor) override;
};
class  MainContentExtractionServiceAsyncWaiter {
 public:
  explicit MainContentExtractionServiceAsyncWaiter(MainContentExtractionService* proxy);

  MainContentExtractionServiceAsyncWaiter(const MainContentExtractionServiceAsyncWaiter&) = delete;
  MainContentExtractionServiceAsyncWaiter& operator=(const MainContentExtractionServiceAsyncWaiter&) = delete;

  ~MainContentExtractionServiceAsyncWaiter();

 private:
  MainContentExtractionService* const proxy_;
};




}  // screen_ai::mojom

#endif  // SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_TEST_UTILS_H_