// services/screen_ai/public/mojom/screen_ai_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_FACTORY_MOJOM_H_
#define SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/screen_ai/public/mojom/screen_ai_factory.mojom-features.h"  // IWYU pragma: export
#include "services/screen_ai/public/mojom/screen_ai_factory.mojom-shared.h"  // IWYU pragma: export
#include "services/screen_ai/public/mojom/screen_ai_factory.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "services/screen_ai/public/mojom/screen_ai_service.mojom-forward.h"
#include "ui/accessibility/ax_features.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace screen_ai::mojom {

class ScreenAIServiceShutdownHandlerProxy;

template <typename ImplRefTraits>
class ScreenAIServiceShutdownHandlerStub;

class ScreenAIServiceShutdownHandlerRequestValidator;


class ScreenAIServiceShutdownHandler
    : public ScreenAIServiceShutdownHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "screen_ai.mojom.ScreenAIServiceShutdownHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kScreenAI;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ScreenAIServiceShutdownHandlerInterfaceBase;
  using Proxy_ = ScreenAIServiceShutdownHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ScreenAIServiceShutdownHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ScreenAIServiceShutdownHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kShuttingDownOnIdleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShuttingDownOnIdle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ScreenAIServiceShutdownHandler() = default;

  virtual void ShuttingDownOnIdle() = 0;
};

class ScreenAIServiceFactoryProxy;

template <typename ImplRefTraits>
class ScreenAIServiceFactoryStub;

class ScreenAIServiceFactoryRequestValidator;
class ScreenAIServiceFactoryResponseValidator;


class ScreenAIServiceFactory
    : public ScreenAIServiceFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "screen_ai.mojom.ScreenAIServiceFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kScreenAI;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ScreenAIServiceFactoryInterfaceBase;
  using Proxy_ = ScreenAIServiceFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ScreenAIServiceFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ScreenAIServiceFactoryRequestValidator;
  using ResponseValidator_ = ScreenAIServiceFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeOCRMinVersion = 0,
    kInitializeMainContentExtractionMinVersion = 0,
    kBindShutdownHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InitializeOCR_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitializeMainContentExtraction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindShutdownHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ScreenAIServiceFactory() = default;

  using InitializeOCRCallback = base::OnceCallback<void(bool)>;
  using InitializeOCRMojoCallback = base::OnceCallback<void(bool)>;

  virtual void InitializeOCR(const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::OCRService> ocr_service_receiver, InitializeOCRCallback callback) = 0;

  using InitializeMainContentExtractionCallback = base::OnceCallback<void(bool)>;
  using InitializeMainContentExtractionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void InitializeMainContentExtraction(const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService> main_content_extractor_service, InitializeMainContentExtractionCallback callback) = 0;

  virtual void BindShutdownHandler(::mojo::PendingRemote<ScreenAIServiceShutdownHandler> shutdown_handler) = 0;
};



class  ScreenAIServiceShutdownHandlerProxy
    : public ScreenAIServiceShutdownHandler {
 public:
  using InterfaceType = ScreenAIServiceShutdownHandler;

  explicit ScreenAIServiceShutdownHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShuttingDownOnIdle() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ScreenAIServiceFactoryProxy
    : public ScreenAIServiceFactory {
 public:
  using InterfaceType = ScreenAIServiceFactory;

  explicit ScreenAIServiceFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitializeOCR(const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::OCRService> ocr_service_receiver, InitializeOCRCallback callback) final;
  
  void InitializeMainContentExtraction(const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService> main_content_extractor_service, InitializeMainContentExtractionCallback callback) final;
  
  void BindShutdownHandler(::mojo::PendingRemote<ScreenAIServiceShutdownHandler> shutdown_handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ScreenAIServiceShutdownHandlerStubDispatch {
 public:
  static bool Accept(ScreenAIServiceShutdownHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ScreenAIServiceShutdownHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ScreenAIServiceShutdownHandler>>
class ScreenAIServiceShutdownHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ScreenAIServiceShutdownHandlerStub() = default;
  ~ScreenAIServiceShutdownHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenAIServiceShutdownHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenAIServiceShutdownHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ScreenAIServiceFactoryStubDispatch {
 public:
  static bool Accept(ScreenAIServiceFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ScreenAIServiceFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ScreenAIServiceFactory>>
class ScreenAIServiceFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ScreenAIServiceFactoryStub() = default;
  ~ScreenAIServiceFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenAIServiceFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenAIServiceFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ScreenAIServiceShutdownHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ScreenAIServiceFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ScreenAIServiceFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // screen_ai::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_FACTORY_MOJOM_H_