// services/passage_embeddings/public/mojom/passage_embeddings.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_SEND_VALIDATION_H_

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::passage_embeddings::mojom::PassagePriority, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::passage_embeddings::mojom::PassageEmbeddingsResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::passage_embeddings::mojom::PassageEmbeddingsResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::passage_embeddings::mojom::internal::PassageEmbeddingsResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::embeddings(input)) in_embeddings = Traits::embeddings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->embeddings)::BaseType>
          embeddings_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& embeddings_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<float>, send_validation>(
        in_embeddings,
        embeddings_fragment,
        &embeddings_validate_params);

      fragment->embeddings.Set(
          embeddings_fragment.is_null() ? nullptr : embeddings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->embeddings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null embeddings in PassageEmbeddingsResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::passage_embeddings::mojom::internal::PassageEmbeddingsLoadModelsParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::embeddings_model(input)) in_embeddings_model = Traits::embeddings_model(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->embeddings_model)::BaseType> embeddings_model_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView, send_validation>(
        in_embeddings_model,
        embeddings_model_fragment);

      fragment->embeddings_model.Set(
          embeddings_model_fragment.is_null() ? nullptr : embeddings_model_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->embeddings_model.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null embeddings_model in PassageEmbeddingsLoadModelsParams struct");

      decltype(Traits::sp_model(input)) in_sp_model = Traits::sp_model(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sp_model)::BaseType> sp_model_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView, send_validation>(
        in_sp_model,
        sp_model_fragment);

      fragment->sp_model.Set(
          sp_model_fragment.is_null() ? nullptr : sp_model_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sp_model.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sp_model in PassageEmbeddingsLoadModelsParams struct");

      fragment->input_window_size = Traits::input_window_size(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::passage_embeddings::mojom::PassageEmbedderParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::passage_embeddings::mojom::PassageEmbedderParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::passage_embeddings::mojom::internal::PassageEmbedderParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->user_initiated_priority_num_threads = Traits::user_initiated_priority_num_threads(input);

      fragment->urgent_priority_num_threads = Traits::urgent_priority_num_threads(input);

      fragment->passive_priority_num_threads = Traits::passive_priority_num_threads(input);

      fragment->embedder_cache_size = Traits::embedder_cache_size(input);

      fragment->allow_gpu_execution = Traits::allow_gpu_execution(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_SEND_VALIDATION_H_