// services/on_device_model/public/mojom/on_device_model_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/on_device_model/public/mojom/on_device_model_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('onDeviceModel.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var uuid$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/uuid.mojom', '../../../../mojo/public/mojom/base/uuid.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../../sandbox/policy/mojom/context.mojom.js');
  }
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../../sandbox/policy/mojom/sandbox.mojom.js');
  }
  var on_device_model$ =
      mojo.internal.exposeNamespace('onDeviceModel.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/on_device_model/public/mojom/on_device_model.mojom', 'on_device_model.mojom.js');
  }


  var ModelBackendType = {};
  ModelBackendType.kGpu = 0;
  ModelBackendType.kApu = 1;
  ModelBackendType.kCpu = 2;
  ModelBackendType.MIN_VALUE = 0;
  ModelBackendType.MAX_VALUE = 2;

  ModelBackendType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ModelBackendType.toKnownEnumValue = function(value) {
    return value;
  };

  ModelBackendType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ModelPerformanceHint = {};
  ModelPerformanceHint.kHighestQuality = 0;
  ModelPerformanceHint.kFastestInference = 1;
  ModelPerformanceHint.MIN_VALUE = 0;
  ModelPerformanceHint.MAX_VALUE = 1;

  ModelPerformanceHint.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ModelPerformanceHint.toKnownEnumValue = function(value) {
    return value;
  };

  ModelPerformanceHint.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PlatformModelState = {};
  PlatformModelState.kUnknownState = 0;
  PlatformModelState.kInstalledOnDisk = 1;
  PlatformModelState.kInvalidUuid = 2;
  PlatformModelState.kInvalidDlcClient = 3;
  PlatformModelState.kInvalidDlcPackage = 4;
  PlatformModelState.kInvalidDlcVerifiedState = 5;
  PlatformModelState.kInvalidDlcInstall = 6;
  PlatformModelState.kInvalidModelFormat = 7;
  PlatformModelState.kInvalidModelDescriptor = 8;
  PlatformModelState.kInvalidBaseModelDescriptor = 9;
  PlatformModelState.MIN_VALUE = 0;
  PlatformModelState.MAX_VALUE = 9;
  PlatformModelState.DEFAULT_VALUE = 0;

  PlatformModelState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  PlatformModelState.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  PlatformModelState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FormatFeature = {};
  FormatFeature.kNone = 0;
  FormatFeature.kPrompt = 1;
  FormatFeature.kAudioSummary = 2;
  FormatFeature.kAudioTitle = 3;
  FormatFeature.MIN_VALUE = 0;
  FormatFeature.MAX_VALUE = 3;
  FormatFeature.DEFAULT_VALUE = 0;

  FormatFeature.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  FormatFeature.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  FormatFeature.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SafetyFeature = {};
  SafetyFeature.kGeneral = 0;
  SafetyFeature.kAudioSummaryRequest = 1;
  SafetyFeature.kAudioTitleRequest = 2;
  SafetyFeature.kAudioSummaryResponse = 3;
  SafetyFeature.kAudioTitleResponse = 4;
  SafetyFeature.kAudioSummaryResponseV2 = 5;
  SafetyFeature.kAudioTitleResponseV2 = 6;
  SafetyFeature.MIN_VALUE = 0;
  SafetyFeature.MAX_VALUE = 6;
  SafetyFeature.DEFAULT_VALUE = 0;

  SafetyFeature.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  SafetyFeature.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SafetyFeature.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ModelAssets(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModelAssets.prototype.initDefaults_ = function() {
    this.weights = null;
    this.spModelPath = null;
    this.cache = null;
    this.encoderCache = null;
    this.adapterCache = null;
  };
  ModelAssets.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModelAssets.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelAssets.weights
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ModelFile, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelAssets.spModelPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelAssets.cache
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, file$.File, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelAssets.encoderCache
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, file$.File, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelAssets.adapterCache
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, file$.File, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ModelAssets.encodedSize = codec.kStructHeaderSize + 48;

  ModelAssets.decode = function(decoder) {
    var packed;
    var val = new ModelAssets();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.weights =
        decoder.decodeStruct(ModelFile);
    val.spModelPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.cache =
        decoder.decodeStructPointer(file$.File);
    val.encoderCache =
        decoder.decodeStructPointer(file$.File);
    val.adapterCache =
        decoder.decodeStructPointer(file$.File);
    return val;
  };

  ModelAssets.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModelAssets.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ModelFile, val.weights);
    encoder.encodeStructPointer(file_path$.FilePath, val.spModelPath);
    encoder.encodeStructPointer(file$.File, val.cache);
    encoder.encodeStructPointer(file$.File, val.encoderCache);
    encoder.encodeStructPointer(file$.File, val.adapterCache);
  };
  function LoadModelParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoadModelParams.prototype.initDefaults_ = function() {
    this.backendType = 0;
    this.maxTokens = 0;
    this.assets = null;
    this.adaptationRanks = null;
    this.performanceHint = ModelPerformanceHint.kHighestQuality;
  };
  LoadModelParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoadModelParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadModelParams.backendType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ModelBackendType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadModelParams.assets
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ModelAssets, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate LoadModelParams.adaptationRanks
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadModelParams.performanceHint
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, ModelPerformanceHint);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LoadModelParams.encodedSize = codec.kStructHeaderSize + 32;

  LoadModelParams.decode = function(decoder) {
    var packed;
    var val = new LoadModelParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.backendType =
        decoder.decodeStruct(new codec.Enum(ModelBackendType));
    val.maxTokens =
        decoder.decodeStruct(codec.Uint32);
    val.assets =
        decoder.decodeStructPointer(ModelAssets);
    val.adaptationRanks =
        decoder.decodeArrayPointer(codec.Uint32);
    val.performanceHint =
        decoder.decodeStruct(new codec.Enum(ModelPerformanceHint));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LoadModelParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoadModelParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.backendType);
    encoder.encodeStruct(codec.Uint32, val.maxTokens);
    encoder.encodeStructPointer(ModelAssets, val.assets);
    encoder.encodeArrayPointer(codec.Uint32, val.adaptationRanks);
    encoder.encodeStruct(codec.Int32, val.performanceHint);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextSafetyModelAssets(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetyModelAssets.prototype.initDefaults_ = function() {
    this.data = null;
    this.spModel = null;
  };
  TextSafetyModelAssets.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetyModelAssets.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetyModelAssets.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.ReadOnlyFile, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetyModelAssets.spModel
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file$.ReadOnlyFile, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetyModelAssets.encodedSize = codec.kStructHeaderSize + 16;

  TextSafetyModelAssets.decode = function(decoder) {
    var packed;
    var val = new TextSafetyModelAssets();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(file$.ReadOnlyFile);
    val.spModel =
        decoder.decodeStructPointer(file$.ReadOnlyFile);
    return val;
  };

  TextSafetyModelAssets.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetyModelAssets.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.ReadOnlyFile, val.data);
    encoder.encodeStructPointer(file$.ReadOnlyFile, val.spModel);
  };
  function BertSafetyModelAssets(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BertSafetyModelAssets.prototype.initDefaults_ = function() {
    this.model = null;
  };
  BertSafetyModelAssets.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BertSafetyModelAssets.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BertSafetyModelAssets.model
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.ReadOnlyFile, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BertSafetyModelAssets.encodedSize = codec.kStructHeaderSize + 8;

  BertSafetyModelAssets.decode = function(decoder) {
    var packed;
    var val = new BertSafetyModelAssets();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.model =
        decoder.decodeStructPointer(file$.ReadOnlyFile);
    return val;
  };

  BertSafetyModelAssets.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BertSafetyModelAssets.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.ReadOnlyFile, val.model);
  };
  function LanguageModelAssets(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguageModelAssets.prototype.initDefaults_ = function() {
    this.model = null;
  };
  LanguageModelAssets.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguageModelAssets.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguageModelAssets.model
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.ReadOnlyFile, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguageModelAssets.encodedSize = codec.kStructHeaderSize + 8;

  LanguageModelAssets.decode = function(decoder) {
    var packed;
    var val = new LanguageModelAssets();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.model =
        decoder.decodeStructPointer(file$.ReadOnlyFile);
    return val;
  };

  LanguageModelAssets.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguageModelAssets.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.ReadOnlyFile, val.model);
  };
  function TextSafetyModelParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextSafetyModelParams.prototype.initDefaults_ = function() {
    this.safetyAssets = null;
    this.languageAssets = null;
  };
  TextSafetyModelParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextSafetyModelParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetyModelParams.safetyAssets
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SafetyModelAssets, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextSafetyModelParams.languageAssets
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, LanguageModelAssets, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextSafetyModelParams.encodedSize = codec.kStructHeaderSize + 24;

  TextSafetyModelParams.decode = function(decoder) {
    var packed;
    var val = new TextSafetyModelParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.safetyAssets =
        decoder.decodeStruct(SafetyModelAssets);
    val.languageAssets =
        decoder.decodeStructPointer(LanguageModelAssets);
    return val;
  };

  TextSafetyModelParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextSafetyModelParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SafetyModelAssets, val.safetyAssets);
    encoder.encodeStructPointer(LanguageModelAssets, val.languageAssets);
  };
  function PlatformModelProgressObserver_Progress_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlatformModelProgressObserver_Progress_Params.prototype.initDefaults_ = function() {
    this.progress = 0;
  };
  PlatformModelProgressObserver_Progress_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlatformModelProgressObserver_Progress_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PlatformModelProgressObserver_Progress_Params.encodedSize = codec.kStructHeaderSize + 8;

  PlatformModelProgressObserver_Progress_Params.decode = function(decoder) {
    var packed;
    var val = new PlatformModelProgressObserver_Progress_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.progress =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  PlatformModelProgressObserver_Progress_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlatformModelProgressObserver_Progress_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.progress);
  };
  function OnDeviceModelService_LoadModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelService_LoadModel_Params.prototype.initDefaults_ = function() {
    this.params = null;
    this.model = new bindings.InterfaceRequest();
  };
  OnDeviceModelService_LoadModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelService_LoadModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_LoadModel_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LoadModelParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_LoadModel_Params.model
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelService_LoadModel_Params.encodedSize = codec.kStructHeaderSize + 16;

  OnDeviceModelService_LoadModel_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelService_LoadModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(LoadModelParams);
    val.model =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelService_LoadModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelService_LoadModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LoadModelParams, val.params);
    encoder.encodeStruct(codec.InterfaceRequest, val.model);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModelService_LoadModel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelService_LoadModel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  OnDeviceModelService_LoadModel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelService_LoadModel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_LoadModel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, on_device_model$.LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelService_LoadModel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelService_LoadModel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelService_LoadModel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(on_device_model$.LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelService_LoadModel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelService_LoadModel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModelService_GetCapabilities_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelService_GetCapabilities_Params.prototype.initDefaults_ = function() {
    this.weights = null;
  };
  OnDeviceModelService_GetCapabilities_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelService_GetCapabilities_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_GetCapabilities_Params.weights
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ModelFile, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelService_GetCapabilities_Params.encodedSize = codec.kStructHeaderSize + 16;

  OnDeviceModelService_GetCapabilities_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelService_GetCapabilities_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.weights =
        decoder.decodeStruct(ModelFile);
    return val;
  };

  OnDeviceModelService_GetCapabilities_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelService_GetCapabilities_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ModelFile, val.weights);
  };
  function OnDeviceModelService_GetCapabilities_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelService_GetCapabilities_ResponseParams.prototype.initDefaults_ = function() {
    this.capabilities = null;
  };
  OnDeviceModelService_GetCapabilities_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelService_GetCapabilities_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_GetCapabilities_ResponseParams.capabilities
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, on_device_model$.Capabilities, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelService_GetCapabilities_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelService_GetCapabilities_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelService_GetCapabilities_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.capabilities =
        decoder.decodeStructPointer(on_device_model$.Capabilities);
    return val;
  };

  OnDeviceModelService_GetCapabilities_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelService_GetCapabilities_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(on_device_model$.Capabilities, val.capabilities);
  };
  function OnDeviceModelService_LoadTextSafetyModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelService_LoadTextSafetyModel_Params.prototype.initDefaults_ = function() {
    this.params = null;
    this.model = new bindings.InterfaceRequest();
  };
  OnDeviceModelService_LoadTextSafetyModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelService_LoadTextSafetyModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_LoadTextSafetyModel_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TextSafetyModelParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_LoadTextSafetyModel_Params.model
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelService_LoadTextSafetyModel_Params.encodedSize = codec.kStructHeaderSize + 16;

  OnDeviceModelService_LoadTextSafetyModel_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelService_LoadTextSafetyModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(TextSafetyModelParams);
    val.model =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelService_LoadTextSafetyModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelService_LoadTextSafetyModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TextSafetyModelParams, val.params);
    encoder.encodeStruct(codec.InterfaceRequest, val.model);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModelService_GetDeviceAndPerformanceInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.prototype.initDefaults_ = function() {
  };
  OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelService_GetDeviceAndPerformanceInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.performanceInfo = null;
    this.deviceInfo = null;
  };
  OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.performanceInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, on_device_model$.DevicePerformanceInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.deviceInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, on_device_model$.DeviceInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.performanceInfo =
        decoder.decodeStructPointer(on_device_model$.DevicePerformanceInfo);
    val.deviceInfo =
        decoder.decodeStructPointer(on_device_model$.DeviceInfo);
    return val;
  };

  OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(on_device_model$.DevicePerformanceInfo, val.performanceInfo);
    encoder.encodeStructPointer(on_device_model$.DeviceInfo, val.deviceInfo);
  };
  function OnDeviceModelPlatformService_LoadPlatformModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_LoadPlatformModel_Params.prototype.initDefaults_ = function() {
    this.uuid = null;
    this.model = new bindings.InterfaceRequest();
    this.progressObserver = new PlatformModelProgressObserverPtr();
  };
  OnDeviceModelPlatformService_LoadPlatformModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_LoadPlatformModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_LoadPlatformModel_Params.uuid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, uuid$.Uuid, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_LoadPlatformModel_Params.model
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_LoadPlatformModel_Params.progressObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_LoadPlatformModel_Params.encodedSize = codec.kStructHeaderSize + 24;

  OnDeviceModelPlatformService_LoadPlatformModel_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_LoadPlatformModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.uuid =
        decoder.decodeStructPointer(uuid$.Uuid);
    val.model =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.progressObserver =
        decoder.decodeStruct(new codec.NullableInterface(PlatformModelProgressObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelPlatformService_LoadPlatformModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_LoadPlatformModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(uuid$.Uuid, val.uuid);
    encoder.encodeStruct(codec.InterfaceRequest, val.model);
    encoder.encodeStruct(new codec.NullableInterface(PlatformModelProgressObserverPtr), val.progressObserver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, on_device_model$.LoadModelResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(on_device_model$.LoadModelResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModelPlatformService_GetPlatformModelState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_GetPlatformModelState_Params.prototype.initDefaults_ = function() {
    this.uuid = null;
  };
  OnDeviceModelPlatformService_GetPlatformModelState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_GetPlatformModelState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_GetPlatformModelState_Params.uuid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, uuid$.Uuid, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_GetPlatformModelState_Params.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelPlatformService_GetPlatformModelState_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_GetPlatformModelState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.uuid =
        decoder.decodeStructPointer(uuid$.Uuid);
    return val;
  };

  OnDeviceModelPlatformService_GetPlatformModelState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_GetPlatformModelState_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(uuid$.Uuid, val.uuid);
  };
  function OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PlatformModelState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(PlatformModelState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.prototype.initDefaults_ = function() {
  };
  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.encodedSize = codec.kStructHeaderSize + 0;

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.prototype.initDefaults_ = function() {
    this.performanceClass = 0;
  };
  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.performanceClass
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, on_device_model$.PerformanceClass);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.performanceClass =
        decoder.decodeStruct(new codec.Enum(on_device_model$.PerformanceClass));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.performanceClass);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceModelPlatformService_FormatInput_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_FormatInput_Params.prototype.initDefaults_ = function() {
    this.uuid = null;
    this.feature = 0;
    this.fields = null;
  };
  OnDeviceModelPlatformService_FormatInput_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_FormatInput_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_FormatInput_Params.uuid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, uuid$.Uuid, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_FormatInput_Params.feature
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, FormatFeature);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_FormatInput_Params.fields
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_FormatInput_Params.encodedSize = codec.kStructHeaderSize + 24;

  OnDeviceModelPlatformService_FormatInput_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_FormatInput_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.uuid =
        decoder.decodeStructPointer(uuid$.Uuid);
    val.feature =
        decoder.decodeStruct(new codec.Enum(FormatFeature));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.fields =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  OnDeviceModelPlatformService_FormatInput_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_FormatInput_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(uuid$.Uuid, val.uuid);
    encoder.encodeStruct(codec.Int32, val.feature);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeMapPointer(codec.String, codec.String, val.fields);
  };
  function OnDeviceModelPlatformService_FormatInput_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_FormatInput_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  OnDeviceModelPlatformService_FormatInput_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_FormatInput_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_FormatInput_ResponseParams.result
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_FormatInput_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelPlatformService_FormatInput_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_FormatInput_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.String);
    return val;
  };

  OnDeviceModelPlatformService_FormatInput_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_FormatInput_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.result);
  };
  function OnDeviceModelPlatformService_ValidateSafetyResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_ValidateSafetyResult_Params.prototype.initDefaults_ = function() {
    this.safetyFeature = 0;
    this.text = null;
    this.safetyInfo = null;
  };
  OnDeviceModelPlatformService_ValidateSafetyResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_ValidateSafetyResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_ValidateSafetyResult_Params.safetyFeature
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SafetyFeature);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_ValidateSafetyResult_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceModelPlatformService_ValidateSafetyResult_Params.safetyInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, on_device_model$.SafetyInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_ValidateSafetyResult_Params.encodedSize = codec.kStructHeaderSize + 24;

  OnDeviceModelPlatformService_ValidateSafetyResult_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_ValidateSafetyResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.safetyFeature =
        decoder.decodeStruct(new codec.Enum(SafetyFeature));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.text =
        decoder.decodeStruct(codec.String);
    val.safetyInfo =
        decoder.decodeStructPointer(on_device_model$.SafetyInfo);
    return val;
  };

  OnDeviceModelPlatformService_ValidateSafetyResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_ValidateSafetyResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.safetyFeature);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStructPointer(on_device_model$.SafetyInfo, val.safetyInfo);
  };
  function OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function ModelFile(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  ModelFile.Tags = {
    file: 0,
    path: 1,
  };

  ModelFile.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  ModelFile.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "file",
        "path",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a ModelFile member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(ModelFile.prototype, "file", {
    get: function() {
      if (this.$tag != ModelFile.Tags.file) {
        throw new ReferenceError(
            "ModelFile.file is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ModelFile.Tags.file;
      this.$data = value;
    }
  });
  Object.defineProperty(ModelFile.prototype, "path", {
    get: function() {
      if (this.$tag != ModelFile.Tags.path) {
        throw new ReferenceError(
            "ModelFile.path is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ModelFile.Tags.path;
      this.$data = value;
    }
  });


    ModelFile.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case ModelFile.Tags.file:
          encoder.encodeStructPointer(file$.File, val.file);
          break;
        case ModelFile.Tags.path:
          encoder.encodeStructPointer(file_path$.FilePath, val.path);
          break;
      }
      encoder.align();
    };


    ModelFile.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new ModelFile();
      var tag = decoder.readUint32();
      switch (tag) {
        case ModelFile.Tags.file:
          result.file = decoder.decodeStructPointer(file$.File);
          break;
        case ModelFile.Tags.path:
          result.path = decoder.decodeStructPointer(file_path$.FilePath);
          break;
      }
      decoder.align();

      return result;
    };


    ModelFile.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case ModelFile.Tags.file:
          

    // validate ModelFile.file
    err = messageValidator.validateStructPointer(data_offset, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ModelFile.Tags.path:
          

    // validate ModelFile.path
    err = messageValidator.validateStructPointer(data_offset, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  ModelFile.encodedSize = 16;

  function SafetyModelAssets(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SafetyModelAssets.Tags = {
    tsAssets: 0,
    bsAssets: 1,
  };

  SafetyModelAssets.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SafetyModelAssets.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "tsAssets",
        "bsAssets",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SafetyModelAssets member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SafetyModelAssets.prototype, "tsAssets", {
    get: function() {
      if (this.$tag != SafetyModelAssets.Tags.tsAssets) {
        throw new ReferenceError(
            "SafetyModelAssets.tsAssets is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SafetyModelAssets.Tags.tsAssets;
      this.$data = value;
    }
  });
  Object.defineProperty(SafetyModelAssets.prototype, "bsAssets", {
    get: function() {
      if (this.$tag != SafetyModelAssets.Tags.bsAssets) {
        throw new ReferenceError(
            "SafetyModelAssets.bsAssets is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SafetyModelAssets.Tags.bsAssets;
      this.$data = value;
    }
  });


    SafetyModelAssets.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SafetyModelAssets.Tags.tsAssets:
          encoder.encodeStructPointer(TextSafetyModelAssets, val.tsAssets);
          break;
        case SafetyModelAssets.Tags.bsAssets:
          encoder.encodeStructPointer(BertSafetyModelAssets, val.bsAssets);
          break;
      }
      encoder.align();
    };


    SafetyModelAssets.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SafetyModelAssets();
      var tag = decoder.readUint32();
      switch (tag) {
        case SafetyModelAssets.Tags.tsAssets:
          result.tsAssets = decoder.decodeStructPointer(TextSafetyModelAssets);
          break;
        case SafetyModelAssets.Tags.bsAssets:
          result.bsAssets = decoder.decodeStructPointer(BertSafetyModelAssets);
          break;
      }
      decoder.align();

      return result;
    };


    SafetyModelAssets.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SafetyModelAssets.Tags.tsAssets:
          

    // validate SafetyModelAssets.tsAssets
    err = messageValidator.validateStructPointer(data_offset, TextSafetyModelAssets, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SafetyModelAssets.Tags.bsAssets:
          

    // validate SafetyModelAssets.bsAssets
    err = messageValidator.validateStructPointer(data_offset, BertSafetyModelAssets, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SafetyModelAssets.encodedSize = 16;
  var kPlatformModelProgressObserver_Progress_Name = 0;

  function PlatformModelProgressObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PlatformModelProgressObserver,
                                                   handleOrPtrInfo);
  }

  function PlatformModelProgressObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PlatformModelProgressObserver, associatedInterfacePtrInfo);
  }

  PlatformModelProgressObserverAssociatedPtr.prototype =
      Object.create(PlatformModelProgressObserverPtr.prototype);
  PlatformModelProgressObserverAssociatedPtr.prototype.constructor =
      PlatformModelProgressObserverAssociatedPtr;

  function PlatformModelProgressObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  PlatformModelProgressObserverPtr.prototype.progress = function() {
    return PlatformModelProgressObserverProxy.prototype.progress
        .apply(this.ptr.getProxy(), arguments);
  };

  PlatformModelProgressObserverProxy.prototype.progress = function(progress) {
    var params_ = new PlatformModelProgressObserver_Progress_Params();
    params_.progress = progress;
    var builder = new codec.MessageV0Builder(
        kPlatformModelProgressObserver_Progress_Name,
        codec.align(PlatformModelProgressObserver_Progress_Params.encodedSize));
    builder.encodeStruct(PlatformModelProgressObserver_Progress_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PlatformModelProgressObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  PlatformModelProgressObserverStub.prototype.progress = function(progress) {
    return this.delegate_ && this.delegate_.progress && this.delegate_.progress(progress);
  }

  PlatformModelProgressObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPlatformModelProgressObserver_Progress_Name:
      var params = reader.decodeStruct(PlatformModelProgressObserver_Progress_Params);
      this.progress(params.progress);
      return true;
    default:
      return false;
    }
  };

  PlatformModelProgressObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePlatformModelProgressObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPlatformModelProgressObserver_Progress_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PlatformModelProgressObserver_Progress_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePlatformModelProgressObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PlatformModelProgressObserver = {
    name: 'on_device_model.mojom.PlatformModelProgressObserver',
    kVersion: 0,
    ptrClass: PlatformModelProgressObserverPtr,
    proxyClass: PlatformModelProgressObserverProxy,
    stubClass: PlatformModelProgressObserverStub,
    validateRequest: validatePlatformModelProgressObserverRequest,
    validateResponse: null,
  };
  PlatformModelProgressObserverStub.prototype.validator = validatePlatformModelProgressObserverRequest;
  PlatformModelProgressObserverProxy.prototype.validator = null;
  var kOnDeviceModelService_LoadModel_Name = 0;
  var kOnDeviceModelService_GetCapabilities_Name = 1;
  var kOnDeviceModelService_LoadTextSafetyModel_Name = 2;
  var kOnDeviceModelService_GetDeviceAndPerformanceInfo_Name = 3;

  function OnDeviceModelServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(OnDeviceModelService,
                                                   handleOrPtrInfo);
  }

  function OnDeviceModelServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        OnDeviceModelService, associatedInterfacePtrInfo);
  }

  OnDeviceModelServiceAssociatedPtr.prototype =
      Object.create(OnDeviceModelServicePtr.prototype);
  OnDeviceModelServiceAssociatedPtr.prototype.constructor =
      OnDeviceModelServiceAssociatedPtr;

  function OnDeviceModelServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  OnDeviceModelServicePtr.prototype.loadModel = function() {
    return OnDeviceModelServiceProxy.prototype.loadModel
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelServiceProxy.prototype.loadModel = function(params, model) {
    var params_ = new OnDeviceModelService_LoadModel_Params();
    params_.params = params;
    params_.model = model;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelService_LoadModel_Name,
          codec.align(OnDeviceModelService_LoadModel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelService_LoadModel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelService_LoadModel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelServicePtr.prototype.getCapabilities = function() {
    return OnDeviceModelServiceProxy.prototype.getCapabilities
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelServiceProxy.prototype.getCapabilities = function(weights) {
    var params_ = new OnDeviceModelService_GetCapabilities_Params();
    params_.weights = weights;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelService_GetCapabilities_Name,
          codec.align(OnDeviceModelService_GetCapabilities_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelService_GetCapabilities_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelService_GetCapabilities_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelServicePtr.prototype.loadTextSafetyModel = function() {
    return OnDeviceModelServiceProxy.prototype.loadTextSafetyModel
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelServiceProxy.prototype.loadTextSafetyModel = function(params, model) {
    var params_ = new OnDeviceModelService_LoadTextSafetyModel_Params();
    params_.params = params;
    params_.model = model;
    var builder = new codec.MessageV0Builder(
        kOnDeviceModelService_LoadTextSafetyModel_Name,
        codec.align(OnDeviceModelService_LoadTextSafetyModel_Params.encodedSize));
    builder.encodeStruct(OnDeviceModelService_LoadTextSafetyModel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  OnDeviceModelServicePtr.prototype.getDeviceAndPerformanceInfo = function() {
    return OnDeviceModelServiceProxy.prototype.getDeviceAndPerformanceInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelServiceProxy.prototype.getDeviceAndPerformanceInfo = function() {
    var params_ = new OnDeviceModelService_GetDeviceAndPerformanceInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelService_GetDeviceAndPerformanceInfo_Name,
          codec.align(OnDeviceModelService_GetDeviceAndPerformanceInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelService_GetDeviceAndPerformanceInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function OnDeviceModelServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  OnDeviceModelServiceStub.prototype.loadModel = function(params, model) {
    return this.delegate_ && this.delegate_.loadModel && this.delegate_.loadModel(params, model);
  }
  OnDeviceModelServiceStub.prototype.getCapabilities = function(weights) {
    return this.delegate_ && this.delegate_.getCapabilities && this.delegate_.getCapabilities(weights);
  }
  OnDeviceModelServiceStub.prototype.loadTextSafetyModel = function(params, model) {
    return this.delegate_ && this.delegate_.loadTextSafetyModel && this.delegate_.loadTextSafetyModel(params, model);
  }
  OnDeviceModelServiceStub.prototype.getDeviceAndPerformanceInfo = function() {
    return this.delegate_ && this.delegate_.getDeviceAndPerformanceInfo && this.delegate_.getDeviceAndPerformanceInfo();
  }

  OnDeviceModelServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOnDeviceModelService_LoadTextSafetyModel_Name:
      var params = reader.decodeStruct(OnDeviceModelService_LoadTextSafetyModel_Params);
      this.loadTextSafetyModel(params.params, params.model);
      return true;
    default:
      return false;
    }
  };

  OnDeviceModelServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOnDeviceModelService_LoadModel_Name:
      var params = reader.decodeStruct(OnDeviceModelService_LoadModel_Params);
      this.loadModel(params.params, params.model).then(function(response) {
        var responseParams =
            new OnDeviceModelService_LoadModel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelService_LoadModel_Name,
            codec.align(OnDeviceModelService_LoadModel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelService_LoadModel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModelService_GetCapabilities_Name:
      var params = reader.decodeStruct(OnDeviceModelService_GetCapabilities_Params);
      this.getCapabilities(params.weights).then(function(response) {
        var responseParams =
            new OnDeviceModelService_GetCapabilities_ResponseParams();
        responseParams.capabilities = response.capabilities;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelService_GetCapabilities_Name,
            codec.align(OnDeviceModelService_GetCapabilities_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelService_GetCapabilities_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModelService_GetDeviceAndPerformanceInfo_Name:
      var params = reader.decodeStruct(OnDeviceModelService_GetDeviceAndPerformanceInfo_Params);
      this.getDeviceAndPerformanceInfo().then(function(response) {
        var responseParams =
            new OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams();
        responseParams.performanceInfo = response.performanceInfo;
        responseParams.deviceInfo = response.deviceInfo;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelService_GetDeviceAndPerformanceInfo_Name,
            codec.align(OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateOnDeviceModelServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kOnDeviceModelService_LoadModel_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelService_LoadModel_Params;
      break;
      case kOnDeviceModelService_GetCapabilities_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelService_GetCapabilities_Params;
      break;
      case kOnDeviceModelService_LoadTextSafetyModel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = OnDeviceModelService_LoadTextSafetyModel_Params;
      break;
      case kOnDeviceModelService_GetDeviceAndPerformanceInfo_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelService_GetDeviceAndPerformanceInfo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateOnDeviceModelServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kOnDeviceModelService_LoadModel_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelService_LoadModel_ResponseParams;
        break;
      case kOnDeviceModelService_GetCapabilities_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelService_GetCapabilities_ResponseParams;
        break;
      case kOnDeviceModelService_GetDeviceAndPerformanceInfo_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var OnDeviceModelService = {
    name: 'on_device_model.mojom.OnDeviceModelService',
    kVersion: 0,
    ptrClass: OnDeviceModelServicePtr,
    proxyClass: OnDeviceModelServiceProxy,
    stubClass: OnDeviceModelServiceStub,
    validateRequest: validateOnDeviceModelServiceRequest,
    validateResponse: validateOnDeviceModelServiceResponse,
  };
  OnDeviceModelServiceStub.prototype.validator = validateOnDeviceModelServiceRequest;
  OnDeviceModelServiceProxy.prototype.validator = validateOnDeviceModelServiceResponse;
  var kOnDeviceModelPlatformService_LoadPlatformModel_Name = 0;
  var kOnDeviceModelPlatformService_GetPlatformModelState_Name = 1;
  var kOnDeviceModelPlatformService_GetEstimatedPerformanceClass_Name = 2;
  var kOnDeviceModelPlatformService_FormatInput_Name = 3;
  var kOnDeviceModelPlatformService_ValidateSafetyResult_Name = 4;

  function OnDeviceModelPlatformServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(OnDeviceModelPlatformService,
                                                   handleOrPtrInfo);
  }

  function OnDeviceModelPlatformServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        OnDeviceModelPlatformService, associatedInterfacePtrInfo);
  }

  OnDeviceModelPlatformServiceAssociatedPtr.prototype =
      Object.create(OnDeviceModelPlatformServicePtr.prototype);
  OnDeviceModelPlatformServiceAssociatedPtr.prototype.constructor =
      OnDeviceModelPlatformServiceAssociatedPtr;

  function OnDeviceModelPlatformServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  OnDeviceModelPlatformServicePtr.prototype.loadPlatformModel = function() {
    return OnDeviceModelPlatformServiceProxy.prototype.loadPlatformModel
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelPlatformServiceProxy.prototype.loadPlatformModel = function(uuid, model, progressObserver) {
    var params_ = new OnDeviceModelPlatformService_LoadPlatformModel_Params();
    params_.uuid = uuid;
    params_.model = model;
    params_.progressObserver = progressObserver;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelPlatformService_LoadPlatformModel_Name,
          codec.align(OnDeviceModelPlatformService_LoadPlatformModel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelPlatformService_LoadPlatformModel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelPlatformServicePtr.prototype.getPlatformModelState = function() {
    return OnDeviceModelPlatformServiceProxy.prototype.getPlatformModelState
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelPlatformServiceProxy.prototype.getPlatformModelState = function(uuid) {
    var params_ = new OnDeviceModelPlatformService_GetPlatformModelState_Params();
    params_.uuid = uuid;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelPlatformService_GetPlatformModelState_Name,
          codec.align(OnDeviceModelPlatformService_GetPlatformModelState_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelPlatformService_GetPlatformModelState_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelPlatformServicePtr.prototype.getEstimatedPerformanceClass = function() {
    return OnDeviceModelPlatformServiceProxy.prototype.getEstimatedPerformanceClass
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelPlatformServiceProxy.prototype.getEstimatedPerformanceClass = function() {
    var params_ = new OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelPlatformService_GetEstimatedPerformanceClass_Name,
          codec.align(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelPlatformServicePtr.prototype.formatInput = function() {
    return OnDeviceModelPlatformServiceProxy.prototype.formatInput
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelPlatformServiceProxy.prototype.formatInput = function(uuid, feature, fields) {
    var params_ = new OnDeviceModelPlatformService_FormatInput_Params();
    params_.uuid = uuid;
    params_.feature = feature;
    params_.fields = fields;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelPlatformService_FormatInput_Name,
          codec.align(OnDeviceModelPlatformService_FormatInput_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelPlatformService_FormatInput_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelPlatformService_FormatInput_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceModelPlatformServicePtr.prototype.validateSafetyResult = function() {
    return OnDeviceModelPlatformServiceProxy.prototype.validateSafetyResult
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceModelPlatformServiceProxy.prototype.validateSafetyResult = function(safetyFeature, text, safetyInfo) {
    var params_ = new OnDeviceModelPlatformService_ValidateSafetyResult_Params();
    params_.safetyFeature = safetyFeature;
    params_.text = text;
    params_.safetyInfo = safetyInfo;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceModelPlatformService_ValidateSafetyResult_Name,
          codec.align(OnDeviceModelPlatformService_ValidateSafetyResult_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceModelPlatformService_ValidateSafetyResult_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function OnDeviceModelPlatformServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  OnDeviceModelPlatformServiceStub.prototype.loadPlatformModel = function(uuid, model, progressObserver) {
    return this.delegate_ && this.delegate_.loadPlatformModel && this.delegate_.loadPlatformModel(uuid, model, progressObserver);
  }
  OnDeviceModelPlatformServiceStub.prototype.getPlatformModelState = function(uuid) {
    return this.delegate_ && this.delegate_.getPlatformModelState && this.delegate_.getPlatformModelState(uuid);
  }
  OnDeviceModelPlatformServiceStub.prototype.getEstimatedPerformanceClass = function() {
    return this.delegate_ && this.delegate_.getEstimatedPerformanceClass && this.delegate_.getEstimatedPerformanceClass();
  }
  OnDeviceModelPlatformServiceStub.prototype.formatInput = function(uuid, feature, fields) {
    return this.delegate_ && this.delegate_.formatInput && this.delegate_.formatInput(uuid, feature, fields);
  }
  OnDeviceModelPlatformServiceStub.prototype.validateSafetyResult = function(safetyFeature, text, safetyInfo) {
    return this.delegate_ && this.delegate_.validateSafetyResult && this.delegate_.validateSafetyResult(safetyFeature, text, safetyInfo);
  }

  OnDeviceModelPlatformServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  OnDeviceModelPlatformServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOnDeviceModelPlatformService_LoadPlatformModel_Name:
      var params = reader.decodeStruct(OnDeviceModelPlatformService_LoadPlatformModel_Params);
      this.loadPlatformModel(params.uuid, params.model, params.progressObserver).then(function(response) {
        var responseParams =
            new OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelPlatformService_LoadPlatformModel_Name,
            codec.align(OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModelPlatformService_GetPlatformModelState_Name:
      var params = reader.decodeStruct(OnDeviceModelPlatformService_GetPlatformModelState_Params);
      this.getPlatformModelState(params.uuid).then(function(response) {
        var responseParams =
            new OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelPlatformService_GetPlatformModelState_Name,
            codec.align(OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModelPlatformService_GetEstimatedPerformanceClass_Name:
      var params = reader.decodeStruct(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params);
      this.getEstimatedPerformanceClass().then(function(response) {
        var responseParams =
            new OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams();
        responseParams.performanceClass = response.performanceClass;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelPlatformService_GetEstimatedPerformanceClass_Name,
            codec.align(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModelPlatformService_FormatInput_Name:
      var params = reader.decodeStruct(OnDeviceModelPlatformService_FormatInput_Params);
      this.formatInput(params.uuid, params.feature, params.fields).then(function(response) {
        var responseParams =
            new OnDeviceModelPlatformService_FormatInput_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelPlatformService_FormatInput_Name,
            codec.align(OnDeviceModelPlatformService_FormatInput_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelPlatformService_FormatInput_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceModelPlatformService_ValidateSafetyResult_Name:
      var params = reader.decodeStruct(OnDeviceModelPlatformService_ValidateSafetyResult_Params);
      this.validateSafetyResult(params.safetyFeature, params.text, params.safetyInfo).then(function(response) {
        var responseParams =
            new OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kOnDeviceModelPlatformService_ValidateSafetyResult_Name,
            codec.align(OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateOnDeviceModelPlatformServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kOnDeviceModelPlatformService_LoadPlatformModel_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelPlatformService_LoadPlatformModel_Params;
      break;
      case kOnDeviceModelPlatformService_GetPlatformModelState_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelPlatformService_GetPlatformModelState_Params;
      break;
      case kOnDeviceModelPlatformService_GetEstimatedPerformanceClass_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params;
      break;
      case kOnDeviceModelPlatformService_FormatInput_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelPlatformService_FormatInput_Params;
      break;
      case kOnDeviceModelPlatformService_ValidateSafetyResult_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceModelPlatformService_ValidateSafetyResult_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateOnDeviceModelPlatformServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kOnDeviceModelPlatformService_LoadPlatformModel_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams;
        break;
      case kOnDeviceModelPlatformService_GetPlatformModelState_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams;
        break;
      case kOnDeviceModelPlatformService_GetEstimatedPerformanceClass_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams;
        break;
      case kOnDeviceModelPlatformService_FormatInput_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelPlatformService_FormatInput_ResponseParams;
        break;
      case kOnDeviceModelPlatformService_ValidateSafetyResult_Name:
        if (message.isResponse())
          paramsClass = OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var OnDeviceModelPlatformService = {
    name: 'on_device_model.mojom.OnDeviceModelPlatformService',
    kVersion: 0,
    ptrClass: OnDeviceModelPlatformServicePtr,
    proxyClass: OnDeviceModelPlatformServiceProxy,
    stubClass: OnDeviceModelPlatformServiceStub,
    validateRequest: validateOnDeviceModelPlatformServiceRequest,
    validateResponse: validateOnDeviceModelPlatformServiceResponse,
  };
  OnDeviceModelPlatformServiceStub.prototype.validator = validateOnDeviceModelPlatformServiceRequest;
  OnDeviceModelPlatformServiceProxy.prototype.validator = validateOnDeviceModelPlatformServiceResponse;
  exports.ModelBackendType = ModelBackendType;
  exports.ModelPerformanceHint = ModelPerformanceHint;
  exports.PlatformModelState = PlatformModelState;
  exports.FormatFeature = FormatFeature;
  exports.SafetyFeature = SafetyFeature;
  exports.ModelAssets = ModelAssets;
  exports.LoadModelParams = LoadModelParams;
  exports.TextSafetyModelAssets = TextSafetyModelAssets;
  exports.BertSafetyModelAssets = BertSafetyModelAssets;
  exports.LanguageModelAssets = LanguageModelAssets;
  exports.TextSafetyModelParams = TextSafetyModelParams;
  exports.ModelFile = ModelFile;
  exports.SafetyModelAssets = SafetyModelAssets;
  exports.PlatformModelProgressObserver = PlatformModelProgressObserver;
  exports.PlatformModelProgressObserverPtr = PlatformModelProgressObserverPtr;
  exports.PlatformModelProgressObserverAssociatedPtr = PlatformModelProgressObserverAssociatedPtr;
  exports.OnDeviceModelService = OnDeviceModelService;
  exports.OnDeviceModelServicePtr = OnDeviceModelServicePtr;
  exports.OnDeviceModelServiceAssociatedPtr = OnDeviceModelServiceAssociatedPtr;
  exports.OnDeviceModelPlatformService = OnDeviceModelPlatformService;
  exports.OnDeviceModelPlatformServicePtr = OnDeviceModelPlatformServicePtr;
  exports.OnDeviceModelPlatformServiceAssociatedPtr = OnDeviceModelPlatformServiceAssociatedPtr;
})();