// services/on_device_model/public/mojom/on_device_model.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_SEND_VALIDATION_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_SEND_VALIDATION_H_

#include "services/on_device_model/public/mojom/on_device_model.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"

#include "services/on_device_model/public/mojom/on_device_model.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::on_device_model::mojom::Token, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::on_device_model::mojom::Priority, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::on_device_model::mojom::PerformanceClass, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::on_device_model::mojom::LoadModelResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::AdaptationAssetsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AdaptationAssetsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AdaptationAssets_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::weights(input)) in_weights = Traits::weights(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->weights)::BaseType> weights_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FileDataView, send_validation>(
        in_weights,
        weights_fragment);

      fragment->weights.Set(
          weights_fragment.is_null() ? nullptr : weights_fragment.data());

      decltype(Traits::weights_path(input)) in_weights_path = Traits::weights_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->weights_path)::BaseType> weights_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_weights_path,
        weights_path_fragment);

      fragment->weights_path.Set(
          weights_path_fragment.is_null() ? nullptr : weights_path_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::LanguageDetectionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::LanguageDetectionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::LanguageDetectionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::code(input)) in_code = Traits::code(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->code)::BaseType> code_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_code,
        code_fragment);

      fragment->code.Set(
          code_fragment.is_null() ? nullptr : code_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->code.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null code in LanguageDetectionResult struct");

      fragment->reliability = Traits::reliability(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::SafetyInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::SafetyInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::SafetyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::class_scores(input)) in_class_scores = Traits::class_scores(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->class_scores)::BaseType>
          class_scores_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& class_scores_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<float>, send_validation>(
        in_class_scores,
        class_scores_fragment,
        &class_scores_validate_params);

      fragment->class_scores.Set(
          class_scores_fragment.is_null() ? nullptr : class_scores_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->class_scores.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null class_scores in SafetyInfo struct");

      decltype(Traits::language(input)) in_language = Traits::language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->language)::BaseType> language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::on_device_model::mojom::LanguageDetectionResultDataView, send_validation>(
        in_language,
        language_fragment);

      fragment->language.Set(
          language_fragment.is_null() ? nullptr : language_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::ResponseChunkDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::ResponseChunkDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::ResponseChunk_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in ResponseChunk struct");

      decltype(Traits::safety_info(input)) in_safety_info = Traits::safety_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->safety_info)::BaseType> safety_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::on_device_model::mojom::SafetyInfoDataView, send_validation>(
        in_safety_info,
        safety_info_fragment);

      fragment->safety_info.Set(
          safety_info_fragment.is_null() ? nullptr : safety_info_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::ResponseSummaryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::ResponseSummaryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::ResponseSummary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::safety_info(input)) in_safety_info = Traits::safety_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->safety_info)::BaseType> safety_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::on_device_model::mojom::SafetyInfoDataView, send_validation>(
        in_safety_info,
        safety_info_fragment);

      fragment->safety_info.Set(
          safety_info_fragment.is_null() ? nullptr : safety_info_fragment.data());

      fragment->output_token_count = Traits::output_token_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::LoadAdaptationParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::LoadAdaptationParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::LoadAdaptationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::assets(input)) in_assets = Traits::assets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->assets)::BaseType> assets_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::on_device_model::mojom::AdaptationAssetsDataView, send_validation>(
        in_assets,
        assets_fragment);

      fragment->assets.Set(
          assets_fragment.is_null() ? nullptr : assets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->assets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null assets in LoadAdaptationParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::CapabilitiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::CapabilitiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::Capabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->image_input = Traits::image_input(input);

      fragment->audio_input = Traits::audio_input(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::SessionParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::SessionParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::SessionParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->max_tokens = Traits::max_tokens(input);

      decltype(Traits::capabilities(input)) in_capabilities = Traits::capabilities(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capabilities)::BaseType> capabilities_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::on_device_model::mojom::CapabilitiesDataView, send_validation>(
        in_capabilities,
        capabilities_fragment);

      fragment->capabilities.Set(
          capabilities_fragment.is_null() ? nullptr : capabilities_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->capabilities.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null capabilities in SessionParams struct");

      fragment->top_k = Traits::top_k(input);

      fragment->temperature = Traits::temperature(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::InputDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::InputDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::Input_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::pieces(input)) in_pieces = Traits::pieces(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pieces)::BaseType>
          pieces_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& pieces_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::on_device_model::mojom::InputPieceDataView>, send_validation>(
        in_pieces,
        pieces_fragment,
        &pieces_validate_params);

      fragment->pieces.Set(
          pieces_fragment.is_null() ? nullptr : pieces_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pieces.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pieces in Input struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::AppendOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AppendOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AppendOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::input(input)) in_input = Traits::input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input)::BaseType> input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::on_device_model::mojom::InputDataView, send_validation>(
        in_input,
        input_fragment);

      fragment->input.Set(
          input_fragment.is_null() ? nullptr : input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in AppendOptions struct");

      fragment->max_tokens = Traits::max_tokens(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::GenerateOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::GenerateOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::GenerateOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->max_output_tokens = Traits::max_output_tokens(input);

      decltype(Traits::constraint(input)) in_constraint = Traits::constraint(input);
      mojo::internal::MessageFragment<decltype(fragment->constraint)>
          constraint_fragment(fragment.message());
      constraint_fragment.Claim(&fragment->constraint);
      
      mojo::internal::Serialize<::on_device_model::mojom::ResponseConstraintDataView, send_validation>(
        in_constraint,
        constraint_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::AudioDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AudioDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AudioData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->channel_count = Traits::channel_count(input);

      fragment->sample_rate = Traits::sample_rate(input);

      fragment->frame_count = Traits::frame_count(input);

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType>
          data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<float>, send_validation>(
        in_data,
        data_fragment,
        &data_validate_params);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in AudioData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::SpeechRecognitionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::SpeechRecognitionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::SpeechRecognitionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::transcript(input)) in_transcript = Traits::transcript(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transcript)::BaseType> transcript_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_transcript,
        transcript_fragment);

      fragment->transcript.Set(
          transcript_fragment.is_null() ? nullptr : transcript_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transcript.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transcript in SpeechRecognitionResult struct");

      fragment->is_final = Traits::is_final(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::AsrStreamOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::AsrStreamOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::AsrStreamOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->sample_rate_hz = Traits::sample_rate_hz(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::DevicePerformanceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::DevicePerformanceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::DevicePerformanceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::on_device_model::mojom::PerformanceClass>(
        Traits::performance_class(input),
        &fragment->performance_class);

      fragment->vram_mb = Traits::vram_mb(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::DeviceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_model::mojom::DeviceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_model::mojom::internal::DeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->vendor_id = Traits::vendor_id(input);

      fragment->device_id = Traits::device_id(input);

      decltype(Traits::driver_version(input)) in_driver_version = Traits::driver_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->driver_version)::BaseType> driver_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_driver_version,
        driver_version_fragment);

      fragment->driver_version.Set(
          driver_version_fragment.is_null() ? nullptr : driver_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->driver_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null driver_version in DeviceInfo struct");

      fragment->supports_fp16 = Traits::supports_fp16(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::InputPieceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::on_device_model::mojom::InputPieceDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::on_device_model::mojom::internal::InputPiece_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::on_device_model::mojom::InputPieceDataView::Tag::kToken: {
    decltype(Traits::token(input))
    in_token = Traits::token(input);
        
mojo::internal::Serialize<::on_device_model::mojom::Token, send_validation>(
  in_token,
  &fragment->data.f_token);
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kText: {
    decltype(Traits::text(input))
    in_text = Traits::text(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_text,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text in InputPiece union");
    fragment->data.f_text.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kBitmap: {
    decltype(Traits::bitmap(input))
    in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bitmap)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::BitmapWithArbitraryBppDataView, send_validation>(
  in_bitmap,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bitmap in InputPiece union");
    fragment->data.f_bitmap.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kUnknownType: {
    decltype(Traits::unknown_type(input))
    in_unknown_type = Traits::unknown_type(input);
    fragment->data.f_unknown_type = in_unknown_type;
    break;
  }
  case ::on_device_model::mojom::InputPieceDataView::Tag::kAudio: {
    decltype(Traits::audio(input))
    in_audio = Traits::audio(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_audio)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::on_device_model::mojom::AudioDataDataView, send_validation>(
  in_audio,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null audio in InputPiece union");
    fragment->data.f_audio.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::on_device_model::mojom::ResponseConstraintDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::on_device_model::mojom::ResponseConstraintDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::on_device_model::mojom::internal::ResponseConstraint_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::on_device_model::mojom::ResponseConstraintDataView::Tag::kJsonSchema: {
    decltype(Traits::json_schema(input))
    in_json_schema = Traits::json_schema(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_json_schema)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_json_schema,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null json_schema in ResponseConstraint union");
    fragment->data.f_json_schema.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::ResponseConstraintDataView::Tag::kRegex: {
    decltype(Traits::regex(input))
    in_regex = Traits::regex(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_regex)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_regex,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null regex in ResponseConstraint union");
    fragment->data.f_regex.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::on_device_model::mojom::ResponseConstraintDataView::Tag::kUnknownType: {
    decltype(Traits::unknown_type(input))
    in_unknown_type = Traits::unknown_type(input);
    fragment->data.f_unknown_type = in_unknown_type;
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_SEND_VALIDATION_H_