// services/network/public/mojom/websocket.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  AuthChallengeInfo as network_mojom_AuthChallengeInfo,
  AuthChallengeInfoSpec as network_mojom_AuthChallengeInfoSpec,
  AuthCredentials as network_mojom_AuthCredentials,
  AuthCredentialsSpec as network_mojom_AuthCredentialsSpec,
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec,
  HttpVersion as network_mojom_HttpVersion,
  HttpVersionSpec as network_mojom_HttpVersionSpec
} from './network_param.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebSocketMessageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebSocketMessageType = {
  
  CONTINUATION: 0,
  TEXT: 1,
  BINARY: 2,
  LAST: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebSocketAuthenticationHandlerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebSocketAuthenticationHandler', scope);
  }
}

/** @interface */
export class WebSocketAuthenticationHandlerInterface {
  
  /**
   * @param { !network_mojom_AuthChallengeInfo } info
   * @param { !network_mojom_HttpResponseHeaders } headers
   * @param { !network_mojom_IPEndPoint } remoteEndpoint
   * @return {!Promise<{
        credentials: ?network_mojom_AuthCredentials,
   *  }>}
   */

  onAuthRequired(info, headers, remoteEndpoint) {}
}

/**
 * @implements { WebSocketAuthenticationHandlerInterface }
 */
export class WebSocketAuthenticationHandlerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebSocketAuthenticationHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebSocketAuthenticationHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebSocketAuthenticationHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_AuthChallengeInfo } info
   * @param { !network_mojom_HttpResponseHeaders } headers
   * @param { !network_mojom_IPEndPoint } remoteEndpoint
   * @return {!Promise<{
        credentials: ?network_mojom_AuthCredentials,
   *  }>}
   */

  onAuthRequired(
      info,
      headers,
      remoteEndpoint) {
    return this.proxy.sendMessage(
        0,
        WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
        WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
        [
          info,
          headers,
          remoteEndpoint
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebSocketAuthenticationHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebSocketAuthenticationHandlerReceiver {
  /**
   * @param {!WebSocketAuthenticationHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebSocketAuthenticationHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebSocketAuthenticationHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketAuthenticationHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
        WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
        impl.onAuthRequired.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebSocketAuthenticationHandler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocketAuthenticationHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebSocketAuthenticationHandlerRemote}
   */
  static getRemote() {
    let remote = new WebSocketAuthenticationHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebSocketAuthenticationHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebSocketAuthenticationHandlerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebSocketAuthenticationHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketAuthenticationHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthRequired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
        WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
        this.onAuthRequired.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebSocketHandshakeClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebSocketHandshakeClient', scope);
  }
}

/** @interface */
export class WebSocketHandshakeClientInterface {
  
  /**
   * @param { !WebSocketHandshakeRequest } request
   */

  onOpeningHandshakeStarted(request) {}
  
  /**
   * @param { !string } message
   * @param { !number } netError
   * @param { !number } responseCode
   */

  onFailure(message, netError, responseCode) {}
  
  /**
   * @param { !WebSocketRemote } socket
   * @param { !WebSocketClientPendingReceiver } clientReceiver
   * @param { !WebSocketHandshakeResponse } response
   * @param { !MojoHandle } readable
   * @param { !MojoHandle } writable
   */

  onConnectionEstablished(socket, clientReceiver, response, readable, writable) {}
}

/**
 * @implements { WebSocketHandshakeClientInterface }
 */
export class WebSocketHandshakeClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebSocketHandshakeClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebSocketHandshakeClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebSocketHandshakeClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !WebSocketHandshakeRequest } request
   */

  onOpeningHandshakeStarted(
      request) {
    this.proxy.sendMessage(
        0,
        WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
        null,
        [
          request
        ],
        false);
  }

  
  /**
   * @param { !string } message
   * @param { !number } netError
   * @param { !number } responseCode
   */

  onFailure(
      message,
      netError,
      responseCode) {
    this.proxy.sendMessage(
        1,
        WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
        null,
        [
          message,
          netError,
          responseCode
        ],
        false);
  }

  
  /**
   * @param { !WebSocketRemote } socket
   * @param { !WebSocketClientPendingReceiver } clientReceiver
   * @param { !WebSocketHandshakeResponse } response
   * @param { !MojoHandle } readable
   * @param { !MojoHandle } writable
   */

  onConnectionEstablished(
      socket,
      clientReceiver,
      response,
      readable,
      writable) {
    this.proxy.sendMessage(
        2,
        WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        [
          socket,
          clientReceiver,
          response,
          readable,
          writable
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebSocketHandshakeClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebSocketHandshakeClientReceiver {
  /**
   * @param {!WebSocketHandshakeClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebSocketHandshakeClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebSocketHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
        null,
        impl.onOpeningHandshakeStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
        null,
        impl.onFailure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        impl.onConnectionEstablished.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebSocketHandshakeClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocketHandshakeClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebSocketHandshakeClientRemote}
   */
  static getRemote() {
    let remote = new WebSocketHandshakeClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebSocketHandshakeClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebSocketHandshakeClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebSocketHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOpeningHandshakeStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
        null,
        this.onOpeningHandshakeStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFailure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
        null,
        this.onFailure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionEstablished =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        this.onConnectionEstablished.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebSocketClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebSocketClient', scope);
  }
}

/** @interface */
export class WebSocketClientInterface {
  
  /**
   * @param { !boolean } fin
   * @param { !WebSocketMessageType } type
   * @param { !bigint } dataLength
   */

  onDataFrame(fin, type, dataLength) {}
  
  /**
   * @param { !boolean } wasClean
   * @param { !number } code
   * @param { !string } reason
   */

  onDropChannel(wasClean, code, reason) {}
  
  /**
   */

  onClosingHandshake() {}
}

/**
 * @implements { WebSocketClientInterface }
 */
export class WebSocketClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebSocketClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebSocketClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebSocketClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } fin
   * @param { !WebSocketMessageType } type
   * @param { !bigint } dataLength
   */

  onDataFrame(
      fin,
      type,
      dataLength) {
    this.proxy.sendMessage(
        0,
        WebSocketClient_OnDataFrame_ParamsSpec.$,
        null,
        [
          fin,
          type,
          dataLength
        ],
        false);
  }

  
  /**
   * @param { !boolean } wasClean
   * @param { !number } code
   * @param { !string } reason
   */

  onDropChannel(
      wasClean,
      code,
      reason) {
    this.proxy.sendMessage(
        1,
        WebSocketClient_OnDropChannel_ParamsSpec.$,
        null,
        [
          wasClean,
          code,
          reason
        ],
        false);
  }

  
  /**
   */

  onClosingHandshake() {
    this.proxy.sendMessage(
        2,
        WebSocketClient_OnClosingHandshake_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebSocketClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebSocketClientReceiver {
  /**
   * @param {!WebSocketClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebSocketClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebSocketClient_OnDataFrame_ParamsSpec.$,
        null,
        impl.onDataFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebSocketClient_OnDropChannel_ParamsSpec.$,
        null,
        impl.onDropChannel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebSocketClient_OnClosingHandshake_ParamsSpec.$,
        null,
        impl.onClosingHandshake.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebSocketClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocketClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebSocketClientRemote}
   */
  static getRemote() {
    let remote = new WebSocketClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebSocketClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebSocketClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDataFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebSocketClient_OnDataFrame_ParamsSpec.$,
        null,
        this.onDataFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDropChannel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebSocketClient_OnDropChannel_ParamsSpec.$,
        null,
        this.onDropChannel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClosingHandshake =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebSocketClient_OnClosingHandshake_ParamsSpec.$,
        null,
        this.onClosingHandshake.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebSocket', scope);
  }
}

/** @interface */
export class WebSocketInterface {
  
  /**
   * @param { !WebSocketMessageType } type
   * @param { !bigint } dataLength
   */

  sendMessage(type, dataLength) {}
  
  /**
   */

  startReceiving() {}
  
  /**
   * @param { !number } code
   * @param { !string } reason
   */

  startClosingHandshake(code, reason) {}
}

/**
 * @implements { WebSocketInterface }
 */
export class WebSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !WebSocketMessageType } type
   * @param { !bigint } dataLength
   */

  sendMessage(
      type,
      dataLength) {
    this.proxy.sendMessage(
        0,
        WebSocket_SendMessage_ParamsSpec.$,
        null,
        [
          type,
          dataLength
        ],
        false);
  }

  
  /**
   */

  startReceiving() {
    this.proxy.sendMessage(
        1,
        WebSocket_StartReceiving_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } code
   * @param { !string } reason
   */

  startClosingHandshake(
      code,
      reason) {
    this.proxy.sendMessage(
        2,
        WebSocket_StartClosingHandshake_ParamsSpec.$,
        null,
        [
          code,
          reason
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebSocketReceiver {
  /**
   * @param {!WebSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebSocket_SendMessage_ParamsSpec.$,
        null,
        impl.sendMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebSocket_StartReceiving_ParamsSpec.$,
        null,
        impl.startReceiving.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebSocket_StartClosingHandshake_ParamsSpec.$,
        null,
        impl.startClosingHandshake.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebSocketRemote}
   */
  static getRemote() {
    let remote = new WebSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebSocket_SendMessage_ParamsSpec.$,
        null,
        this.sendMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startReceiving =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebSocket_StartReceiving_ParamsSpec.$,
        null,
        this.startReceiving.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startClosingHandshake =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebSocket_StartClosingHandshake_ParamsSpec.$,
        null,
        this.startClosingHandshake.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpHeaderSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketHandshakeRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketHandshakeResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketHandshakeClient_OnFailure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketClient_OnDataFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketClient_OnDropChannel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocketClient_OnClosingHandshake_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocket_SendMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocket_StartReceiving_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebSocket_StartClosingHandshake_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    HttpHeaderSpec.$,
    'HttpHeader',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HttpHeader {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    WebSocketHandshakeRequestSpec.$,
    'WebSocketHandshakeRequest',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.Array(HttpHeaderSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headersText', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WebSocketHandshakeRequest {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!HttpHeader> } */
    this.headers;
    /** @type { !string } */
    this.headersText;
  }
}



mojo.internal.Struct(
    WebSocketHandshakeResponseSpec.$,
    'WebSocketHandshakeResponse',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpVersion', 8,
        0,
        network_mojom_HttpVersionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'statusCode', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'statusText', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 32,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 40,
        0,
        mojo.internal.Array(HttpHeaderSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headersText', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectedProtocol', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensions', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class WebSocketHandshakeResponse {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_HttpVersion } */
    this.httpVersion;
    /** @type { !number } */
    this.statusCode;
    /** @type { !string } */
    this.statusText;
    /** @type { !network_mojom_IPEndPoint } */
    this.remoteEndpoint;
    /** @type { !Array<!HttpHeader> } */
    this.headers;
    /** @type { !string } */
    this.headersText;
    /** @type { !string } */
    this.selectedProtocol;
    /** @type { !string } */
    this.extensions;
  }
}



mojo.internal.Struct(
    WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
    'WebSocketAuthenticationHandler_OnAuthRequired_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        network_mojom_AuthChallengeInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 16,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WebSocketAuthenticationHandler_OnAuthRequired_Params {
  constructor() {
    /** @type { !network_mojom_AuthChallengeInfo } */
    this.info;
    /** @type { !network_mojom_HttpResponseHeaders } */
    this.headers;
    /** @type { !network_mojom_IPEndPoint } */
    this.remoteEndpoint;
  }
}



mojo.internal.Struct(
    WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
    'WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams',
    [
      mojo.internal.StructField(
        'credentials', 0,
        0,
        network_mojom_AuthCredentialsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams {
  constructor() {
    /** @type { (network_mojom_AuthCredentials|undefined) } */
    this.credentials;
  }
}



mojo.internal.Struct(
    WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
    'WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        WebSocketHandshakeRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params {
  constructor() {
    /** @type { !WebSocketHandshakeRequest } */
    this.request;
  }
}



mojo.internal.Struct(
    WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
    'WebSocketHandshakeClient_OnFailure_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseCode', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebSocketHandshakeClient_OnFailure_Params {
  constructor() {
    /** @type { !string } */
    this.message;
    /** @type { !number } */
    this.netError;
    /** @type { !number } */
    this.responseCode;
  }
}



mojo.internal.Struct(
    WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
    'WebSocketHandshakeClient_OnConnectionEstablished_Params',
    [
      mojo.internal.StructField(
        'socket', 0,
        0,
        mojo.internal.InterfaceProxy(WebSocketRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(WebSocketClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 16,
        0,
        WebSocketHandshakeResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'readable', 12,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writable', 24,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WebSocketHandshakeClient_OnConnectionEstablished_Params {
  constructor() {
    /** @type { !WebSocketRemote } */
    this.socket;
    /** @type { !WebSocketClientPendingReceiver } */
    this.clientReceiver;
    /** @type { !WebSocketHandshakeResponse } */
    this.response;
    /** @type { !MojoHandle } */
    this.readable;
    /** @type { !MojoHandle } */
    this.writable;
  }
}



mojo.internal.Struct(
    WebSocketClient_OnDataFrame_ParamsSpec.$,
    'WebSocketClient_OnDataFrame_Params',
    [
      mojo.internal.StructField(
        'fin', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 4,
        0,
        WebSocketMessageTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebSocketClient_OnDataFrame_Params {
  constructor() {
    /** @type { !boolean } */
    this.fin;
    /** @type { !WebSocketMessageType } */
    this.type;
    /** @type { !bigint } */
    this.dataLength;
  }
}



mojo.internal.Struct(
    WebSocketClient_OnDropChannel_ParamsSpec.$,
    'WebSocketClient_OnDropChannel_Params',
    [
      mojo.internal.StructField(
        'wasClean', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'code', 2,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebSocketClient_OnDropChannel_Params {
  constructor() {
    /** @type { !boolean } */
    this.wasClean;
    /** @type { !number } */
    this.code;
    /** @type { !string } */
    this.reason;
  }
}



mojo.internal.Struct(
    WebSocketClient_OnClosingHandshake_ParamsSpec.$,
    'WebSocketClient_OnClosingHandshake_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebSocketClient_OnClosingHandshake_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebSocket_SendMessage_ParamsSpec.$,
    'WebSocket_SendMessage_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        WebSocketMessageTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebSocket_SendMessage_Params {
  constructor() {
    /** @type { !WebSocketMessageType } */
    this.type;
    /** @type { !bigint } */
    this.dataLength;
  }
}



mojo.internal.Struct(
    WebSocket_StartReceiving_ParamsSpec.$,
    'WebSocket_StartReceiving_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebSocket_StartReceiving_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebSocket_StartClosingHandshake_ParamsSpec.$,
    'WebSocket_StartClosingHandshake_Params',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebSocket_StartClosingHandshake_Params {
  constructor() {
    /** @type { !number } */
    this.code;
    /** @type { !string } */
    this.reason;
  }
}

