// services/network/public/mojom/websocket.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.WebSocketMessageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.WebSocketMessageType = {
  
  CONTINUATION: 0,
  TEXT: 1,
  BINARY: 2,
  LAST: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebSocketAuthenticationHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebSocketAuthenticationHandler.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.WebSocketAuthenticationHandlerInterface }
 */
network.mojom.WebSocketAuthenticationHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebSocketAuthenticationHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebSocketAuthenticationHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebSocketAuthenticationHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.AuthChallengeInfo } info
   * @param { !network.mojom.HttpResponseHeaders } headers
   * @param { !network.mojom.IPEndPoint } remoteEndpoint
   * @return {!Promise<{
        credentials: ?network.mojom.AuthCredentials,
   *  }>}
   */

  onAuthRequired(
      info,
      headers,
      remoteEndpoint) {
    return this.proxy.sendMessage(
        0,
        network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
        network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
        [
          info,
          headers,
          remoteEndpoint
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebSocketAuthenticationHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebSocketAuthenticationHandlerReceiver = class {
  /**
   * @param {!network.mojom.WebSocketAuthenticationHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebSocketAuthenticationHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebSocketAuthenticationHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketAuthenticationHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
        network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
        impl.onAuthRequired.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebSocketAuthenticationHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocketAuthenticationHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebSocketAuthenticationHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebSocketAuthenticationHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebSocketAuthenticationHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebSocketAuthenticationHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebSocketAuthenticationHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketAuthenticationHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthRequired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
        network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
        this.onAuthRequired.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebSocketHandshakeClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebSocketHandshakeClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.WebSocketHandshakeClientInterface }
 */
network.mojom.WebSocketHandshakeClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebSocketHandshakeClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebSocketHandshakeClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebSocketHandshakeClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.WebSocketHandshakeRequest } request
   */

  onOpeningHandshakeStarted(
      request) {
    this.proxy.sendMessage(
        0,
        network.mojom.WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
        null,
        [
          request
        ],
        false);
  }

  
  /**
   * @param { !string } message
   * @param { !number } netError
   * @param { !number } responseCode
   */

  onFailure(
      message,
      netError,
      responseCode) {
    this.proxy.sendMessage(
        1,
        network.mojom.WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
        null,
        [
          message,
          netError,
          responseCode
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.WebSocketRemote } socket
   * @param { !network.mojom.WebSocketClientPendingReceiver } clientReceiver
   * @param { !network.mojom.WebSocketHandshakeResponse } response
   * @param { !MojoHandle } readable
   * @param { !MojoHandle } writable
   */

  onConnectionEstablished(
      socket,
      clientReceiver,
      response,
      readable,
      writable) {
    this.proxy.sendMessage(
        2,
        network.mojom.WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        [
          socket,
          clientReceiver,
          response,
          readable,
          writable
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebSocketHandshakeClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebSocketHandshakeClientReceiver = class {
  /**
   * @param {!network.mojom.WebSocketHandshakeClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebSocketHandshakeClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebSocketHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
        null,
        impl.onOpeningHandshakeStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
        null,
        impl.onFailure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        impl.onConnectionEstablished.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebSocketHandshakeClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocketHandshakeClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebSocketHandshakeClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebSocketHandshakeClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebSocketHandshakeClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebSocketHandshakeClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebSocketHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOpeningHandshakeStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
        null,
        this.onOpeningHandshakeStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFailure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
        null,
        this.onFailure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionEstablished =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        this.onConnectionEstablished.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebSocketClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebSocketClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.WebSocketClientInterface }
 */
network.mojom.WebSocketClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebSocketClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebSocketClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebSocketClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } fin
   * @param { !network.mojom.WebSocketMessageType } type
   * @param { !bigint } dataLength
   */

  onDataFrame(
      fin,
      type,
      dataLength) {
    this.proxy.sendMessage(
        0,
        network.mojom.WebSocketClient_OnDataFrame_ParamsSpec.$,
        null,
        [
          fin,
          type,
          dataLength
        ],
        false);
  }

  
  /**
   * @param { !boolean } wasClean
   * @param { !number } code
   * @param { !string } reason
   */

  onDropChannel(
      wasClean,
      code,
      reason) {
    this.proxy.sendMessage(
        1,
        network.mojom.WebSocketClient_OnDropChannel_ParamsSpec.$,
        null,
        [
          wasClean,
          code,
          reason
        ],
        false);
  }

  
  /**
   */

  onClosingHandshake() {
    this.proxy.sendMessage(
        2,
        network.mojom.WebSocketClient_OnClosingHandshake_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebSocketClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebSocketClientReceiver = class {
  /**
   * @param {!network.mojom.WebSocketClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebSocketClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocketClient_OnDataFrame_ParamsSpec.$,
        null,
        impl.onDataFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebSocketClient_OnDropChannel_ParamsSpec.$,
        null,
        impl.onDropChannel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebSocketClient_OnClosingHandshake_ParamsSpec.$,
        null,
        impl.onClosingHandshake.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebSocketClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocketClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebSocketClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebSocketClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebSocketClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebSocketClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDataFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocketClient_OnDataFrame_ParamsSpec.$,
        null,
        this.onDataFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDropChannel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebSocketClient_OnDropChannel_ParamsSpec.$,
        null,
        this.onDropChannel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClosingHandshake =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebSocketClient_OnClosingHandshake_ParamsSpec.$,
        null,
        this.onClosingHandshake.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebSocket.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.WebSocketInterface }
 */
network.mojom.WebSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.WebSocketMessageType } type
   * @param { !bigint } dataLength
   */

  sendMessage(
      type,
      dataLength) {
    this.proxy.sendMessage(
        0,
        network.mojom.WebSocket_SendMessage_ParamsSpec.$,
        null,
        [
          type,
          dataLength
        ],
        false);
  }

  
  /**
   */

  startReceiving() {
    this.proxy.sendMessage(
        1,
        network.mojom.WebSocket_StartReceiving_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } code
   * @param { !string } reason
   */

  startClosingHandshake(
      code,
      reason) {
    this.proxy.sendMessage(
        2,
        network.mojom.WebSocket_StartClosingHandshake_ParamsSpec.$,
        null,
        [
          code,
          reason
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebSocketReceiver = class {
  /**
   * @param {!network.mojom.WebSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocket_SendMessage_ParamsSpec.$,
        null,
        impl.sendMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebSocket_StartReceiving_ParamsSpec.$,
        null,
        impl.startReceiving.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebSocket_StartClosingHandshake_ParamsSpec.$,
        null,
        impl.startClosingHandshake.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebSocket_SendMessage_ParamsSpec.$,
        null,
        this.sendMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startReceiving =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebSocket_StartReceiving_ParamsSpec.$,
        null,
        this.startReceiving.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startClosingHandshake =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebSocket_StartClosingHandshake_ParamsSpec.$,
        null,
        this.startClosingHandshake.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpHeaderSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketHandshakeRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketHandshakeResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketHandshakeClient_OnFailure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketClient_OnDataFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketClient_OnDropChannel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocketClient_OnClosingHandshake_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocket_SendMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocket_StartReceiving_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebSocket_StartClosingHandshake_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.HttpHeaderSpec.$,
    'HttpHeader',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.HttpHeader = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketHandshakeRequestSpec.$,
    'WebSocketHandshakeRequest',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.Array(network.mojom.HttpHeaderSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headersText', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.WebSocketHandshakeRequest = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Array<!network.mojom.HttpHeader> } */
    this.headers;
    /** @export { !string } */
    this.headersText;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketHandshakeResponseSpec.$,
    'WebSocketHandshakeResponse',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpVersion', 8,
        0,
        network.mojom.HttpVersionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'statusCode', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'statusText', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 32,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 40,
        0,
        mojo.internal.Array(network.mojom.HttpHeaderSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headersText', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectedProtocol', 56,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensions', 64,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);





/** @record */
network.mojom.WebSocketHandshakeResponse = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.HttpVersion } */
    this.httpVersion;
    /** @export { !number } */
    this.statusCode;
    /** @export { !string } */
    this.statusText;
    /** @export { !network.mojom.IPEndPoint } */
    this.remoteEndpoint;
    /** @export { !Array<!network.mojom.HttpHeader> } */
    this.headers;
    /** @export { !string } */
    this.headersText;
    /** @export { !string } */
    this.selectedProtocol;
    /** @export { !string } */
    this.extensions;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ParamsSpec.$,
    'WebSocketAuthenticationHandler_OnAuthRequired_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        network.mojom.AuthChallengeInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 16,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_Params = class {
  constructor() {
    /** @export { !network.mojom.AuthChallengeInfo } */
    this.info;
    /** @export { !network.mojom.HttpResponseHeaders } */
    this.headers;
    /** @export { !network.mojom.IPEndPoint } */
    this.remoteEndpoint;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsSpec.$,
    'WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams',
    [
      mojo.internal.StructField(
        'credentials', 0,
        0,
        network.mojom.AuthCredentialsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams = class {
  constructor() {
    /** @export { (network.mojom.AuthCredentials|undefined) } */
    this.credentials;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsSpec.$,
    'WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        network.mojom.WebSocketHandshakeRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params = class {
  constructor() {
    /** @export { !network.mojom.WebSocketHandshakeRequest } */
    this.request;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketHandshakeClient_OnFailure_ParamsSpec.$,
    'WebSocketHandshakeClient_OnFailure_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseCode', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebSocketHandshakeClient_OnFailure_Params = class {
  constructor() {
    /** @export { !string } */
    this.message;
    /** @export { !number } */
    this.netError;
    /** @export { !number } */
    this.responseCode;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
    'WebSocketHandshakeClient_OnConnectionEstablished_Params',
    [
      mojo.internal.StructField(
        'socket', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.WebSocketRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.WebSocketClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 16,
        0,
        network.mojom.WebSocketHandshakeResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'readable', 12,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'writable', 24,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.WebSocketHandshakeClient_OnConnectionEstablished_Params = class {
  constructor() {
    /** @export { !network.mojom.WebSocketRemote } */
    this.socket;
    /** @export { !network.mojom.WebSocketClientPendingReceiver } */
    this.clientReceiver;
    /** @export { !network.mojom.WebSocketHandshakeResponse } */
    this.response;
    /** @export { !MojoHandle } */
    this.readable;
    /** @export { !MojoHandle } */
    this.writable;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketClient_OnDataFrame_ParamsSpec.$,
    'WebSocketClient_OnDataFrame_Params',
    [
      mojo.internal.StructField(
        'fin', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 4,
        0,
        network.mojom.WebSocketMessageTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebSocketClient_OnDataFrame_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.fin;
    /** @export { !network.mojom.WebSocketMessageType } */
    this.type;
    /** @export { !bigint } */
    this.dataLength;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketClient_OnDropChannel_ParamsSpec.$,
    'WebSocketClient_OnDropChannel_Params',
    [
      mojo.internal.StructField(
        'wasClean', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'code', 2,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebSocketClient_OnDropChannel_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.wasClean;
    /** @export { !number } */
    this.code;
    /** @export { !string } */
    this.reason;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocketClient_OnClosingHandshake_ParamsSpec.$,
    'WebSocketClient_OnClosingHandshake_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.WebSocketClient_OnClosingHandshake_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.WebSocket_SendMessage_ParamsSpec.$,
    'WebSocket_SendMessage_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.WebSocketMessageTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebSocket_SendMessage_Params = class {
  constructor() {
    /** @export { !network.mojom.WebSocketMessageType } */
    this.type;
    /** @export { !bigint } */
    this.dataLength;
  }
};



mojo.internal.Struct(
    network.mojom.WebSocket_StartReceiving_ParamsSpec.$,
    'WebSocket_StartReceiving_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.WebSocket_StartReceiving_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.WebSocket_StartClosingHandshake_ParamsSpec.$,
    'WebSocket_StartClosingHandshake_Params',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.WebSocket_StartClosingHandshake_Params = class {
  constructor() {
    /** @export { !number } */
    this.code;
    /** @export { !string } */
    this.reason;
  }
};

