// services/network/public/mojom/web_transport.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer,
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec
} from '../../../../mojo/public/mojom/base/read_only_buffer.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec
} from './network_param.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebTransportPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebTransport', scope);
  }
}

/** @interface */
export class WebTransportInterface {
  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  sendDatagram(data) {}
  
  /**
   * @param { !MojoHandle } readable
   * @param { ?MojoHandle } writable
   * @return {!Promise<{
        succeeded: !boolean,
        streamId: !number,
   *  }>}
   */

  createStream(readable, writable) {}
  
  /**
   * @return {!Promise<{
        streamId: !number,
        readable: !MojoHandle,
        writable: !MojoHandle,
   *  }>}
   */

  acceptBidirectionalStream() {}
  
  /**
   * @return {!Promise<{
        streamId: !number,
        readable: !MojoHandle,
   *  }>}
   */

  acceptUnidirectionalStream() {}
  
  /**
   * @param { !number } streamId
   */

  sendFin(streamId) {}
  
  /**
   * @param { !number } streamId
   * @param { !number } code
   */

  abortStream(streamId, code) {}
  
  /**
   * @param { !number } streamId
   * @param { !number } code
   */

  stopSending(streamId, code) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } duration
   */

  setOutgoingDatagramExpirationDuration(duration) {}
  
  /**
   * @return {!Promise<{
        stats: ?WebTransportStats,
   *  }>}
   */

  getStats() {}
  
  /**
   * @param { ?WebTransportCloseInfo } closeInfo
   */

  close(closeInfo) {}
}

/**
 * @implements { WebTransportInterface }
 */
export class WebTransportRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebTransportPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebTransportPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebTransportPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  sendDatagram(
      data) {
    return this.proxy.sendMessage(
        0,
        WebTransport_SendDatagram_ParamsSpec.$,
        WebTransport_SendDatagram_ResponseParamsSpec.$,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } readable
   * @param { ?MojoHandle } writable
   * @return {!Promise<{
        succeeded: !boolean,
        streamId: !number,
   *  }>}
   */

  createStream(
      readable,
      writable) {
    return this.proxy.sendMessage(
        1,
        WebTransport_CreateStream_ParamsSpec.$,
        WebTransport_CreateStream_ResponseParamsSpec.$,
        [
          readable,
          writable
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        streamId: !number,
        readable: !MojoHandle,
        writable: !MojoHandle,
   *  }>}
   */

  acceptBidirectionalStream() {
    return this.proxy.sendMessage(
        2,
        WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
        WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        streamId: !number,
        readable: !MojoHandle,
   *  }>}
   */

  acceptUnidirectionalStream() {
    return this.proxy.sendMessage(
        3,
        WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
        WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   */

  sendFin(
      streamId) {
    this.proxy.sendMessage(
        4,
        WebTransport_SendFin_ParamsSpec.$,
        null,
        [
          streamId
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } code
   */

  abortStream(
      streamId,
      code) {
    this.proxy.sendMessage(
        5,
        WebTransport_AbortStream_ParamsSpec.$,
        null,
        [
          streamId,
          code
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } code
   */

  stopSending(
      streamId,
      code) {
    this.proxy.sendMessage(
        6,
        WebTransport_StopSending_ParamsSpec.$,
        null,
        [
          streamId,
          code
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } duration
   */

  setOutgoingDatagramExpirationDuration(
      duration) {
    this.proxy.sendMessage(
        7,
        WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
        null,
        [
          duration
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        stats: ?WebTransportStats,
   *  }>}
   */

  getStats() {
    return this.proxy.sendMessage(
        8,
        WebTransport_GetStats_ParamsSpec.$,
        WebTransport_GetStats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { ?WebTransportCloseInfo } closeInfo
   */

  close(
      closeInfo) {
    this.proxy.sendMessage(
        9,
        WebTransport_Close_ParamsSpec.$,
        null,
        [
          closeInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebTransport
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebTransportReceiver {
  /**
   * @param {!WebTransportInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebTransportRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebTransportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebTransport_SendDatagram_ParamsSpec.$,
        WebTransport_SendDatagram_ResponseParamsSpec.$,
        impl.sendDatagram.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebTransport_CreateStream_ParamsSpec.$,
        WebTransport_CreateStream_ResponseParamsSpec.$,
        impl.createStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
        WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
        impl.acceptBidirectionalStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
        WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
        impl.acceptUnidirectionalStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebTransport_SendFin_ParamsSpec.$,
        null,
        impl.sendFin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WebTransport_AbortStream_ParamsSpec.$,
        null,
        impl.abortStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WebTransport_StopSending_ParamsSpec.$,
        null,
        impl.stopSending.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
        null,
        impl.setOutgoingDatagramExpirationDuration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WebTransport_GetStats_ParamsSpec.$,
        WebTransport_GetStats_ResponseParamsSpec.$,
        impl.getStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WebTransport_Close_ParamsSpec.$,
        null,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebTransport {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebTransport";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebTransportRemote}
   */
  static getRemote() {
    let remote = new WebTransportRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebTransport
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebTransportCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebTransportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendDatagram =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebTransport_SendDatagram_ParamsSpec.$,
        WebTransport_SendDatagram_ResponseParamsSpec.$,
        this.sendDatagram.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebTransport_CreateStream_ParamsSpec.$,
        WebTransport_CreateStream_ResponseParamsSpec.$,
        this.createStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acceptBidirectionalStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
        WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
        this.acceptBidirectionalStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acceptUnidirectionalStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
        WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
        this.acceptUnidirectionalStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendFin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebTransport_SendFin_ParamsSpec.$,
        null,
        this.sendFin.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abortStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WebTransport_AbortStream_ParamsSpec.$,
        null,
        this.abortStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopSending =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WebTransport_StopSending_ParamsSpec.$,
        null,
        this.stopSending.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setOutgoingDatagramExpirationDuration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
        null,
        this.setOutgoingDatagramExpirationDuration.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WebTransport_GetStats_ParamsSpec.$,
        WebTransport_GetStats_ResponseParamsSpec.$,
        this.getStats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WebTransport_Close_ParamsSpec.$,
        null,
        this.close.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebTransportClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebTransportClient', scope);
  }
}

/** @interface */
export class WebTransportClientInterface {
  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   */

  onDatagramReceived(data) {}
  
  /**
   * @param { !number } streamId
   * @param { !boolean } finReceived
   */

  onIncomingStreamClosed(streamId, finReceived) {}
  
  /**
   * @param { !number } streamId
   */

  onOutgoingStreamClosed(streamId) {}
  
  /**
   * @param { !number } streamId
   * @param { !number } streamErrorCode
   */

  onReceivedStopSending(streamId, streamErrorCode) {}
  
  /**
   * @param { !number } streamId
   * @param { !number } streamErrorCode
   */

  onReceivedResetStream(streamId, streamErrorCode) {}
  
  /**
   * @param { ?WebTransportCloseInfo } closeInfo
   * @param { !WebTransportStats } finalStats
   */

  onClosed(closeInfo, finalStats) {}
}

/**
 * @implements { WebTransportClientInterface }
 */
export class WebTransportClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebTransportClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebTransportClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebTransportClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   */

  onDatagramReceived(
      data) {
    this.proxy.sendMessage(
        0,
        WebTransportClient_OnDatagramReceived_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !boolean } finReceived
   */

  onIncomingStreamClosed(
      streamId,
      finReceived) {
    this.proxy.sendMessage(
        1,
        WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
        null,
        [
          streamId,
          finReceived
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   */

  onOutgoingStreamClosed(
      streamId) {
    this.proxy.sendMessage(
        2,
        WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
        null,
        [
          streamId
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } streamErrorCode
   */

  onReceivedStopSending(
      streamId,
      streamErrorCode) {
    this.proxy.sendMessage(
        3,
        WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
        null,
        [
          streamId,
          streamErrorCode
        ],
        false);
  }

  
  /**
   * @param { !number } streamId
   * @param { !number } streamErrorCode
   */

  onReceivedResetStream(
      streamId,
      streamErrorCode) {
    this.proxy.sendMessage(
        4,
        WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
        null,
        [
          streamId,
          streamErrorCode
        ],
        false);
  }

  
  /**
   * @param { ?WebTransportCloseInfo } closeInfo
   * @param { !WebTransportStats } finalStats
   */

  onClosed(
      closeInfo,
      finalStats) {
    this.proxy.sendMessage(
        5,
        WebTransportClient_OnClosed_ParamsSpec.$,
        null,
        [
          closeInfo,
          finalStats
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebTransportClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebTransportClientReceiver {
  /**
   * @param {!WebTransportClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebTransportClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebTransportClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebTransportClient_OnDatagramReceived_ParamsSpec.$,
        null,
        impl.onDatagramReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
        null,
        impl.onIncomingStreamClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
        null,
        impl.onOutgoingStreamClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
        null,
        impl.onReceivedStopSending.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
        null,
        impl.onReceivedResetStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WebTransportClient_OnClosed_ParamsSpec.$,
        null,
        impl.onClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebTransportClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebTransportClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebTransportClientRemote}
   */
  static getRemote() {
    let remote = new WebTransportClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebTransportClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebTransportClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebTransportClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDatagramReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebTransportClient_OnDatagramReceived_ParamsSpec.$,
        null,
        this.onDatagramReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onIncomingStreamClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
        null,
        this.onIncomingStreamClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOutgoingStreamClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
        null,
        this.onOutgoingStreamClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedStopSending =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
        null,
        this.onReceivedStopSending.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedResetStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
        null,
        this.onReceivedResetStream.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WebTransportClient_OnClosed_ParamsSpec.$,
        null,
        this.onClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebTransportHandshakeClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.WebTransportHandshakeClient', scope);
  }
}

/** @interface */
export class WebTransportHandshakeClientInterface {
  
  /**
   * @param { !network_mojom_IPEndPoint } serverAddress
   */

  onBeforeConnect(serverAddress) {}
  
  /**
   * @param { !WebTransportRemote } transport
   * @param { !WebTransportClientPendingReceiver } client
   * @param { !network_mojom_HttpResponseHeaders } responseHeaders
   * @param { ?string } selectedApplicationProtocol
   * @param { !WebTransportStats } initialStats
   */

  onConnectionEstablished(transport, client, responseHeaders, selectedApplicationProtocol, initialStats) {}
  
  /**
   * @param { ?WebTransportError } error
   */

  onHandshakeFailed(error) {}
}

/**
 * @implements { WebTransportHandshakeClientInterface }
 */
export class WebTransportHandshakeClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebTransportHandshakeClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebTransportHandshakeClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebTransportHandshakeClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } serverAddress
   */

  onBeforeConnect(
      serverAddress) {
    this.proxy.sendMessage(
        0,
        WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
        null,
        [
          serverAddress
        ],
        false);
  }

  
  /**
   * @param { !WebTransportRemote } transport
   * @param { !WebTransportClientPendingReceiver } client
   * @param { !network_mojom_HttpResponseHeaders } responseHeaders
   * @param { ?string } selectedApplicationProtocol
   * @param { !WebTransportStats } initialStats
   */

  onConnectionEstablished(
      transport,
      client,
      responseHeaders,
      selectedApplicationProtocol,
      initialStats) {
    this.proxy.sendMessage(
        1,
        WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        [
          transport,
          client,
          responseHeaders,
          selectedApplicationProtocol,
          initialStats
        ],
        false);
  }

  
  /**
   * @param { ?WebTransportError } error
   */

  onHandshakeFailed(
      error) {
    this.proxy.sendMessage(
        2,
        WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebTransportHandshakeClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebTransportHandshakeClientReceiver {
  /**
   * @param {!WebTransportHandshakeClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebTransportHandshakeClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebTransportHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
        null,
        impl.onBeforeConnect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        impl.onConnectionEstablished.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
        null,
        impl.onHandshakeFailed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebTransportHandshakeClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebTransportHandshakeClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebTransportHandshakeClientRemote}
   */
  static getRemote() {
    let remote = new WebTransportHandshakeClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebTransportHandshakeClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebTransportHandshakeClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebTransportHandshakeClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportHandshakeClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeforeConnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
        null,
        this.onBeforeConnect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionEstablished =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
        null,
        this.onConnectionEstablished.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHandshakeFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
        null,
        this.onHandshakeFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportCertificateFingerprintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportCloseInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportStatsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_SendDatagram_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_SendDatagram_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_CreateStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_CreateStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_AcceptBidirectionalStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_AcceptBidirectionalStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_AcceptUnidirectionalStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_SendFin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_AbortStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_StopSending_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_GetStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_GetStats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransport_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportClient_OnDatagramReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportClient_OnIncomingStreamClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportClient_OnOutgoingStreamClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportClient_OnReceivedStopSending_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportClient_OnReceivedResetStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportClient_OnClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebTransportErrorSpec.$,
    'WebTransportError',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quicError', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'safeToReportDetails', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WebTransportError {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { !number } */
    this.quicError;
    /** @type { !string } */
    this.details;
    /** @type { !boolean } */
    this.safeToReportDetails;
  }
}



mojo.internal.Struct(
    WebTransportCertificateFingerprintSpec.$,
    'WebTransportCertificateFingerprint',
    [
      mojo.internal.StructField(
        'algorithm', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fingerprint', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTransportCertificateFingerprint {
  constructor() {
    /** @type { !string } */
    this.algorithm;
    /** @type { !string } */
    this.fingerprint;
  }
}



mojo.internal.Struct(
    WebTransportCloseInfoSpec.$,
    'WebTransportCloseInfo',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTransportCloseInfo {
  constructor() {
    /** @type { !number } */
    this.code;
    /** @type { !string } */
    this.reason;
  }
}



mojo.internal.Struct(
    WebTransportStatsSpec.$,
    'WebTransportStats',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minRtt', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'smoothedRtt', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rttVariation', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'estimatedSendRateBps', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'datagramsExpiredOutgoing', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'datagramsLostOutgoing', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class WebTransportStats {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.timestamp;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.minRtt;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.smoothedRtt;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.rttVariation;
    /** @type { !bigint } */
    this.estimatedSendRateBps;
    /** @type { !bigint } */
    this.datagramsExpiredOutgoing;
    /** @type { !bigint } */
    this.datagramsLostOutgoing;
  }
}



mojo.internal.Struct(
    WebTransport_SendDatagram_ParamsSpec.$,
    'WebTransport_SendDatagram_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_SendDatagram_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    WebTransport_SendDatagram_ResponseParamsSpec.$,
    'WebTransport_SendDatagram_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_SendDatagram_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    WebTransport_CreateStream_ParamsSpec.$,
    'WebTransport_CreateStream_Params',
    [
      mojo.internal.StructField(
        'readable', 0,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writable', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_CreateStream_Params {
  constructor() {
    /** @type { !MojoHandle } */
    this.readable;
    /** @type { (MojoHandle|undefined) } */
    this.writable;
  }
}



mojo.internal.Struct(
    WebTransport_CreateStream_ResponseParamsSpec.$,
    'WebTransport_CreateStream_ResponseParams',
    [
      mojo.internal.StructField(
        'succeeded', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamId', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_CreateStream_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.succeeded;
    /** @type { !number } */
    this.streamId;
  }
}



mojo.internal.Struct(
    WebTransport_AcceptBidirectionalStream_ParamsSpec.$,
    'WebTransport_AcceptBidirectionalStream_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTransport_AcceptBidirectionalStream_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTransport_AcceptBidirectionalStream_ResponseParamsSpec.$,
    'WebTransport_AcceptBidirectionalStream_ResponseParams',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'readable', 4,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writable', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTransport_AcceptBidirectionalStream_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.streamId;
    /** @type { !MojoHandle } */
    this.readable;
    /** @type { !MojoHandle } */
    this.writable;
  }
}



mojo.internal.Struct(
    WebTransport_AcceptUnidirectionalStream_ParamsSpec.$,
    'WebTransport_AcceptUnidirectionalStream_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTransport_AcceptUnidirectionalStream_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTransport_AcceptUnidirectionalStream_ResponseParamsSpec.$,
    'WebTransport_AcceptUnidirectionalStream_ResponseParams',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'readable', 4,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_AcceptUnidirectionalStream_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.streamId;
    /** @type { !MojoHandle } */
    this.readable;
  }
}



mojo.internal.Struct(
    WebTransport_SendFin_ParamsSpec.$,
    'WebTransport_SendFin_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_SendFin_Params {
  constructor() {
    /** @type { !number } */
    this.streamId;
  }
}



mojo.internal.Struct(
    WebTransport_AbortStream_ParamsSpec.$,
    'WebTransport_AbortStream_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'code', 4,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_AbortStream_Params {
  constructor() {
    /** @type { !number } */
    this.streamId;
    /** @type { !number } */
    this.code;
  }
}



mojo.internal.Struct(
    WebTransport_StopSending_ParamsSpec.$,
    'WebTransport_StopSending_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'code', 4,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_StopSending_Params {
  constructor() {
    /** @type { !number } */
    this.streamId;
    /** @type { !number } */
    this.code;
  }
}



mojo.internal.Struct(
    WebTransport_SetOutgoingDatagramExpirationDuration_ParamsSpec.$,
    'WebTransport_SetOutgoingDatagramExpirationDuration_Params',
    [
      mojo.internal.StructField(
        'duration', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_SetOutgoingDatagramExpirationDuration_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.duration;
  }
}



mojo.internal.Struct(
    WebTransport_GetStats_ParamsSpec.$,
    'WebTransport_GetStats_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WebTransport_GetStats_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WebTransport_GetStats_ResponseParamsSpec.$,
    'WebTransport_GetStats_ResponseParams',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        WebTransportStatsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_GetStats_ResponseParams {
  constructor() {
    /** @type { (WebTransportStats|undefined) } */
    this.stats;
  }
}



mojo.internal.Struct(
    WebTransport_Close_ParamsSpec.$,
    'WebTransport_Close_Params',
    [
      mojo.internal.StructField(
        'closeInfo', 0,
        0,
        WebTransportCloseInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransport_Close_Params {
  constructor() {
    /** @type { (WebTransportCloseInfo|undefined) } */
    this.closeInfo;
  }
}



mojo.internal.Struct(
    WebTransportClient_OnDatagramReceived_ParamsSpec.$,
    'WebTransportClient_OnDatagramReceived_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransportClient_OnDatagramReceived_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    WebTransportClient_OnIncomingStreamClosed_ParamsSpec.$,
    'WebTransportClient_OnIncomingStreamClosed_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'finReceived', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransportClient_OnIncomingStreamClosed_Params {
  constructor() {
    /** @type { !number } */
    this.streamId;
    /** @type { !boolean } */
    this.finReceived;
  }
}



mojo.internal.Struct(
    WebTransportClient_OnOutgoingStreamClosed_ParamsSpec.$,
    'WebTransportClient_OnOutgoingStreamClosed_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransportClient_OnOutgoingStreamClosed_Params {
  constructor() {
    /** @type { !number } */
    this.streamId;
  }
}



mojo.internal.Struct(
    WebTransportClient_OnReceivedStopSending_ParamsSpec.$,
    'WebTransportClient_OnReceivedStopSending_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamErrorCode', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransportClient_OnReceivedStopSending_Params {
  constructor() {
    /** @type { !number } */
    this.streamId;
    /** @type { !number } */
    this.streamErrorCode;
  }
}



mojo.internal.Struct(
    WebTransportClient_OnReceivedResetStream_ParamsSpec.$,
    'WebTransportClient_OnReceivedResetStream_Params',
    [
      mojo.internal.StructField(
        'streamId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamErrorCode', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransportClient_OnReceivedResetStream_Params {
  constructor() {
    /** @type { !number } */
    this.streamId;
    /** @type { !number } */
    this.streamErrorCode;
  }
}



mojo.internal.Struct(
    WebTransportClient_OnClosed_ParamsSpec.$,
    'WebTransportClient_OnClosed_Params',
    [
      mojo.internal.StructField(
        'closeInfo', 0,
        0,
        WebTransportCloseInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'finalStats', 8,
        0,
        WebTransportStatsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebTransportClient_OnClosed_Params {
  constructor() {
    /** @type { (WebTransportCloseInfo|undefined) } */
    this.closeInfo;
    /** @type { !WebTransportStats } */
    this.finalStats;
  }
}



mojo.internal.Struct(
    WebTransportHandshakeClient_OnBeforeConnect_ParamsSpec.$,
    'WebTransportHandshakeClient_OnBeforeConnect_Params',
    [
      mojo.internal.StructField(
        'serverAddress', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransportHandshakeClient_OnBeforeConnect_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.serverAddress;
  }
}



mojo.internal.Struct(
    WebTransportHandshakeClient_OnConnectionEstablished_ParamsSpec.$,
    'WebTransportHandshakeClient_OnConnectionEstablished_Params',
    [
      mojo.internal.StructField(
        'transport', 0,
        0,
        mojo.internal.InterfaceProxy(WebTransportRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceRequest(WebTransportClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseHeaders', 16,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectedApplicationProtocol', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialStats', 32,
        0,
        WebTransportStatsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class WebTransportHandshakeClient_OnConnectionEstablished_Params {
  constructor() {
    /** @type { !WebTransportRemote } */
    this.transport;
    /** @type { !WebTransportClientPendingReceiver } */
    this.client;
    /** @type { !network_mojom_HttpResponseHeaders } */
    this.responseHeaders;
    /** @type { (string|undefined) } */
    this.selectedApplicationProtocol;
    /** @type { !WebTransportStats } */
    this.initialStats;
  }
}



mojo.internal.Struct(
    WebTransportHandshakeClient_OnHandshakeFailed_ParamsSpec.$,
    'WebTransportHandshakeClient_OnHandshakeFailed_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        WebTransportErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebTransportHandshakeClient_OnHandshakeFailed_Params {
  constructor() {
    /** @type { (WebTransportError|undefined) } */
    this.error;
  }
}

