// services/network/public/mojom/web_transport.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/web_transport.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var read_only_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/read_only_buffer.mojom', '../../../../mojo/public/mojom/base/read_only_buffer.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }



  function WebTransportError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportError.prototype.initDefaults_ = function() {
    this.netError = 0;
    this.quicError = 0;
    this.details = null;
    this.safeToReportDetails = false;
  };
  WebTransportError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate WebTransportError.details
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTransportError.encodedSize = codec.kStructHeaderSize + 24;

  WebTransportError.decode = function(decoder) {
    var packed;
    var val = new WebTransportError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.netError =
        decoder.decodeStruct(codec.Int32);
    val.quicError =
        decoder.decodeStruct(codec.Int32);
    val.details =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.safeToReportDetails = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransportError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.netError);
    encoder.encodeStruct(codec.Int32, val.quicError);
    encoder.encodeStruct(codec.String, val.details);
    packed = 0;
    packed |= (val.safeToReportDetails & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransportCertificateFingerprint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportCertificateFingerprint.prototype.initDefaults_ = function() {
    this.algorithm = null;
    this.fingerprint = null;
  };
  WebTransportCertificateFingerprint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportCertificateFingerprint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportCertificateFingerprint.algorithm
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportCertificateFingerprint.fingerprint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransportCertificateFingerprint.encodedSize = codec.kStructHeaderSize + 16;

  WebTransportCertificateFingerprint.decode = function(decoder) {
    var packed;
    var val = new WebTransportCertificateFingerprint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.algorithm =
        decoder.decodeStruct(codec.String);
    val.fingerprint =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTransportCertificateFingerprint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportCertificateFingerprint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.algorithm);
    encoder.encodeStruct(codec.String, val.fingerprint);
  };
  function WebTransportCloseInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportCloseInfo.prototype.initDefaults_ = function() {
    this.code = 0;
    this.reason = null;
  };
  WebTransportCloseInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportCloseInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebTransportCloseInfo.reason
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransportCloseInfo.encodedSize = codec.kStructHeaderSize + 16;

  WebTransportCloseInfo.decode = function(decoder) {
    var packed;
    var val = new WebTransportCloseInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reason =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebTransportCloseInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportCloseInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.reason);
  };
  function WebTransportStats(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportStats.prototype.initDefaults_ = function() {
    this.timestamp = null;
    this.minRtt = null;
    this.smoothedRtt = null;
    this.rttVariation = null;
    this.estimatedSendRateBps = 0;
    this.datagramsExpiredOutgoing = 0;
    this.datagramsLostOutgoing = 0;
  };
  WebTransportStats.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportStats.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportStats.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportStats.minRtt
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportStats.smoothedRtt
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportStats.rttVariation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  WebTransportStats.encodedSize = codec.kStructHeaderSize + 56;

  WebTransportStats.decode = function(decoder) {
    var packed;
    var val = new WebTransportStats();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.timestamp =
        decoder.decodeStructPointer(time$.Time);
    val.minRtt =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.smoothedRtt =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.rttVariation =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.estimatedSendRateBps =
        decoder.decodeStruct(codec.Uint64);
    val.datagramsExpiredOutgoing =
        decoder.decodeStruct(codec.Uint64);
    val.datagramsLostOutgoing =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  WebTransportStats.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportStats.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.timestamp);
    encoder.encodeStructPointer(time$.TimeDelta, val.minRtt);
    encoder.encodeStructPointer(time$.TimeDelta, val.smoothedRtt);
    encoder.encodeStructPointer(time$.TimeDelta, val.rttVariation);
    encoder.encodeStruct(codec.Uint64, val.estimatedSendRateBps);
    encoder.encodeStruct(codec.Uint64, val.datagramsExpiredOutgoing);
    encoder.encodeStruct(codec.Uint64, val.datagramsLostOutgoing);
  };
  function WebTransport_SendDatagram_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_SendDatagram_Params.prototype.initDefaults_ = function() {
    this.data = null;
  };
  WebTransport_SendDatagram_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_SendDatagram_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransport_SendDatagram_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, read_only_buffer$.ReadOnlyBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_SendDatagram_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_SendDatagram_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_SendDatagram_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(read_only_buffer$.ReadOnlyBuffer);
    return val;
  };

  WebTransport_SendDatagram_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_SendDatagram_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(read_only_buffer$.ReadOnlyBuffer, val.data);
  };
  function WebTransport_SendDatagram_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_SendDatagram_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  WebTransport_SendDatagram_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_SendDatagram_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTransport_SendDatagram_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_SendDatagram_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTransport_SendDatagram_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransport_SendDatagram_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_SendDatagram_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransport_CreateStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_CreateStream_Params.prototype.initDefaults_ = function() {
    this.readable = null;
    this.writable = null;
  };
  WebTransport_CreateStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_CreateStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransport_CreateStream_Params.readable
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransport_CreateStream_Params.writable
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_CreateStream_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_CreateStream_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_CreateStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.readable =
        decoder.decodeStruct(codec.Handle);
    val.writable =
        decoder.decodeStruct(codec.Handle);
    return val;
  };

  WebTransport_CreateStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_CreateStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Handle, val.readable);
    encoder.encodeStruct(codec.Handle, val.writable);
  };
  function WebTransport_CreateStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_CreateStream_ResponseParams.prototype.initDefaults_ = function() {
    this.succeeded = false;
    this.streamId = 0;
  };
  WebTransport_CreateStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_CreateStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTransport_CreateStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_CreateStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTransport_CreateStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.succeeded = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  WebTransport_CreateStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_CreateStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.succeeded & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.streamId);
  };
  function WebTransport_AcceptBidirectionalStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_AcceptBidirectionalStream_Params.prototype.initDefaults_ = function() {
  };
  WebTransport_AcceptBidirectionalStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_AcceptBidirectionalStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_AcceptBidirectionalStream_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTransport_AcceptBidirectionalStream_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_AcceptBidirectionalStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTransport_AcceptBidirectionalStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_AcceptBidirectionalStream_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTransport_AcceptBidirectionalStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_AcceptBidirectionalStream_ResponseParams.prototype.initDefaults_ = function() {
    this.streamId = 0;
    this.readable = null;
    this.writable = null;
  };
  WebTransport_AcceptBidirectionalStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_AcceptBidirectionalStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebTransport_AcceptBidirectionalStream_ResponseParams.readable
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransport_AcceptBidirectionalStream_ResponseParams.writable
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_AcceptBidirectionalStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WebTransport_AcceptBidirectionalStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTransport_AcceptBidirectionalStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    val.readable =
        decoder.decodeStruct(codec.Handle);
    val.writable =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransport_AcceptBidirectionalStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_AcceptBidirectionalStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.encodeStruct(codec.Handle, val.readable);
    encoder.encodeStruct(codec.Handle, val.writable);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransport_AcceptUnidirectionalStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_AcceptUnidirectionalStream_Params.prototype.initDefaults_ = function() {
  };
  WebTransport_AcceptUnidirectionalStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_AcceptUnidirectionalStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_AcceptUnidirectionalStream_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTransport_AcceptUnidirectionalStream_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_AcceptUnidirectionalStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTransport_AcceptUnidirectionalStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_AcceptUnidirectionalStream_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTransport_AcceptUnidirectionalStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_AcceptUnidirectionalStream_ResponseParams.prototype.initDefaults_ = function() {
    this.streamId = 0;
    this.readable = null;
  };
  WebTransport_AcceptUnidirectionalStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_AcceptUnidirectionalStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebTransport_AcceptUnidirectionalStream_ResponseParams.readable
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_AcceptUnidirectionalStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_AcceptUnidirectionalStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTransport_AcceptUnidirectionalStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    val.readable =
        decoder.decodeStruct(codec.Handle);
    return val;
  };

  WebTransport_AcceptUnidirectionalStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_AcceptUnidirectionalStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.encodeStruct(codec.Handle, val.readable);
  };
  function WebTransport_SendFin_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_SendFin_Params.prototype.initDefaults_ = function() {
    this.streamId = 0;
  };
  WebTransport_SendFin_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_SendFin_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTransport_SendFin_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_SendFin_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_SendFin_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransport_SendFin_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_SendFin_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransport_AbortStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_AbortStream_Params.prototype.initDefaults_ = function() {
    this.streamId = 0;
    this.code = 0;
  };
  WebTransport_AbortStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_AbortStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTransport_AbortStream_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_AbortStream_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_AbortStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    val.code =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransport_AbortStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_AbortStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.encodeStruct(codec.Uint8, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransport_StopSending_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_StopSending_Params.prototype.initDefaults_ = function() {
    this.streamId = 0;
    this.code = 0;
  };
  WebTransport_StopSending_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_StopSending_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTransport_StopSending_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_StopSending_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_StopSending_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    val.code =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransport_StopSending_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_StopSending_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.encodeStruct(codec.Uint8, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransport_SetOutgoingDatagramExpirationDuration_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_SetOutgoingDatagramExpirationDuration_Params.prototype.initDefaults_ = function() {
    this.duration = null;
  };
  WebTransport_SetOutgoingDatagramExpirationDuration_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_SetOutgoingDatagramExpirationDuration_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransport_SetOutgoingDatagramExpirationDuration_Params.duration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_SetOutgoingDatagramExpirationDuration_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_SetOutgoingDatagramExpirationDuration_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_SetOutgoingDatagramExpirationDuration_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.duration =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  WebTransport_SetOutgoingDatagramExpirationDuration_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_SetOutgoingDatagramExpirationDuration_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.duration);
  };
  function WebTransport_GetStats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_GetStats_Params.prototype.initDefaults_ = function() {
  };
  WebTransport_GetStats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_GetStats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_GetStats_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebTransport_GetStats_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_GetStats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebTransport_GetStats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_GetStats_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebTransport_GetStats_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_GetStats_ResponseParams.prototype.initDefaults_ = function() {
    this.stats = null;
  };
  WebTransport_GetStats_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_GetStats_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransport_GetStats_ResponseParams.stats
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebTransportStats, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_GetStats_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_GetStats_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebTransport_GetStats_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stats =
        decoder.decodeStructPointer(WebTransportStats);
    return val;
  };

  WebTransport_GetStats_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_GetStats_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebTransportStats, val.stats);
  };
  function WebTransport_Close_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransport_Close_Params.prototype.initDefaults_ = function() {
    this.closeInfo = null;
  };
  WebTransport_Close_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransport_Close_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransport_Close_Params.closeInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebTransportCloseInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransport_Close_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransport_Close_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransport_Close_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.closeInfo =
        decoder.decodeStructPointer(WebTransportCloseInfo);
    return val;
  };

  WebTransport_Close_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransport_Close_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebTransportCloseInfo, val.closeInfo);
  };
  function WebTransportClient_OnDatagramReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportClient_OnDatagramReceived_Params.prototype.initDefaults_ = function() {
    this.data = null;
  };
  WebTransportClient_OnDatagramReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportClient_OnDatagramReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportClient_OnDatagramReceived_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, read_only_buffer$.ReadOnlyBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransportClient_OnDatagramReceived_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransportClient_OnDatagramReceived_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportClient_OnDatagramReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(read_only_buffer$.ReadOnlyBuffer);
    return val;
  };

  WebTransportClient_OnDatagramReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportClient_OnDatagramReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(read_only_buffer$.ReadOnlyBuffer, val.data);
  };
  function WebTransportClient_OnIncomingStreamClosed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportClient_OnIncomingStreamClosed_Params.prototype.initDefaults_ = function() {
    this.streamId = 0;
    this.finReceived = false;
  };
  WebTransportClient_OnIncomingStreamClosed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportClient_OnIncomingStreamClosed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTransportClient_OnIncomingStreamClosed_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransportClient_OnIncomingStreamClosed_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportClient_OnIncomingStreamClosed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.finReceived = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransportClient_OnIncomingStreamClosed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportClient_OnIncomingStreamClosed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    packed = 0;
    packed |= (val.finReceived & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransportClient_OnOutgoingStreamClosed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportClient_OnOutgoingStreamClosed_Params.prototype.initDefaults_ = function() {
    this.streamId = 0;
  };
  WebTransportClient_OnOutgoingStreamClosed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportClient_OnOutgoingStreamClosed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebTransportClient_OnOutgoingStreamClosed_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransportClient_OnOutgoingStreamClosed_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportClient_OnOutgoingStreamClosed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebTransportClient_OnOutgoingStreamClosed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportClient_OnOutgoingStreamClosed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebTransportClient_OnReceivedStopSending_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportClient_OnReceivedStopSending_Params.prototype.initDefaults_ = function() {
    this.streamId = 0;
    this.streamErrorCode = 0;
  };
  WebTransportClient_OnReceivedStopSending_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportClient_OnReceivedStopSending_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTransportClient_OnReceivedStopSending_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransportClient_OnReceivedStopSending_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportClient_OnReceivedStopSending_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    val.streamErrorCode =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  WebTransportClient_OnReceivedStopSending_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportClient_OnReceivedStopSending_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.encodeStruct(codec.Uint32, val.streamErrorCode);
  };
  function WebTransportClient_OnReceivedResetStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportClient_OnReceivedResetStream_Params.prototype.initDefaults_ = function() {
    this.streamId = 0;
    this.streamErrorCode = 0;
  };
  WebTransportClient_OnReceivedResetStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportClient_OnReceivedResetStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebTransportClient_OnReceivedResetStream_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransportClient_OnReceivedResetStream_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportClient_OnReceivedResetStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.streamId =
        decoder.decodeStruct(codec.Uint32);
    val.streamErrorCode =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  WebTransportClient_OnReceivedResetStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportClient_OnReceivedResetStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.streamId);
    encoder.encodeStruct(codec.Uint32, val.streamErrorCode);
  };
  function WebTransportClient_OnClosed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportClient_OnClosed_Params.prototype.initDefaults_ = function() {
    this.closeInfo = null;
    this.finalStats = null;
  };
  WebTransportClient_OnClosed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportClient_OnClosed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportClient_OnClosed_Params.closeInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebTransportCloseInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportClient_OnClosed_Params.finalStats
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, WebTransportStats, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransportClient_OnClosed_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebTransportClient_OnClosed_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportClient_OnClosed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.closeInfo =
        decoder.decodeStructPointer(WebTransportCloseInfo);
    val.finalStats =
        decoder.decodeStructPointer(WebTransportStats);
    return val;
  };

  WebTransportClient_OnClosed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportClient_OnClosed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebTransportCloseInfo, val.closeInfo);
    encoder.encodeStructPointer(WebTransportStats, val.finalStats);
  };
  function WebTransportHandshakeClient_OnBeforeConnect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportHandshakeClient_OnBeforeConnect_Params.prototype.initDefaults_ = function() {
    this.serverAddress = null;
  };
  WebTransportHandshakeClient_OnBeforeConnect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportHandshakeClient_OnBeforeConnect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportHandshakeClient_OnBeforeConnect_Params.serverAddress
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransportHandshakeClient_OnBeforeConnect_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransportHandshakeClient_OnBeforeConnect_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportHandshakeClient_OnBeforeConnect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serverAddress =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  WebTransportHandshakeClient_OnBeforeConnect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportHandshakeClient_OnBeforeConnect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.serverAddress);
  };
  function WebTransportHandshakeClient_OnConnectionEstablished_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportHandshakeClient_OnConnectionEstablished_Params.prototype.initDefaults_ = function() {
    this.transport = new WebTransportPtr();
    this.client = new bindings.InterfaceRequest();
    this.responseHeaders = null;
    this.selectedApplicationProtocol = null;
    this.initialStats = null;
  };
  WebTransportHandshakeClient_OnConnectionEstablished_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportHandshakeClient_OnConnectionEstablished_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportHandshakeClient_OnConnectionEstablished_Params.transport
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportHandshakeClient_OnConnectionEstablished_Params.client
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportHandshakeClient_OnConnectionEstablished_Params.responseHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, network_param$.HttpResponseHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportHandshakeClient_OnConnectionEstablished_Params.selectedApplicationProtocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportHandshakeClient_OnConnectionEstablished_Params.initialStats
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, WebTransportStats, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransportHandshakeClient_OnConnectionEstablished_Params.encodedSize = codec.kStructHeaderSize + 40;

  WebTransportHandshakeClient_OnConnectionEstablished_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportHandshakeClient_OnConnectionEstablished_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transport =
        decoder.decodeStruct(new codec.Interface(WebTransportPtr));
    val.client =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.responseHeaders =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    val.selectedApplicationProtocol =
        decoder.decodeStruct(codec.String);
    val.initialStats =
        decoder.decodeStructPointer(WebTransportStats);
    return val;
  };

  WebTransportHandshakeClient_OnConnectionEstablished_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportHandshakeClient_OnConnectionEstablished_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(WebTransportPtr), val.transport);
    encoder.encodeStruct(codec.InterfaceRequest, val.client);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.responseHeaders);
    encoder.encodeStruct(codec.String, val.selectedApplicationProtocol);
    encoder.encodeStructPointer(WebTransportStats, val.initialStats);
  };
  function WebTransportHandshakeClient_OnHandshakeFailed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebTransportHandshakeClient_OnHandshakeFailed_Params.prototype.initDefaults_ = function() {
    this.error = null;
  };
  WebTransportHandshakeClient_OnHandshakeFailed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebTransportHandshakeClient_OnHandshakeFailed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebTransportHandshakeClient_OnHandshakeFailed_Params.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebTransportError, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebTransportHandshakeClient_OnHandshakeFailed_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebTransportHandshakeClient_OnHandshakeFailed_Params.decode = function(decoder) {
    var packed;
    var val = new WebTransportHandshakeClient_OnHandshakeFailed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStructPointer(WebTransportError);
    return val;
  };

  WebTransportHandshakeClient_OnHandshakeFailed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebTransportHandshakeClient_OnHandshakeFailed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebTransportError, val.error);
  };
  var kWebTransport_SendDatagram_Name = 0;
  var kWebTransport_CreateStream_Name = 1;
  var kWebTransport_AcceptBidirectionalStream_Name = 2;
  var kWebTransport_AcceptUnidirectionalStream_Name = 3;
  var kWebTransport_SendFin_Name = 4;
  var kWebTransport_AbortStream_Name = 5;
  var kWebTransport_StopSending_Name = 6;
  var kWebTransport_SetOutgoingDatagramExpirationDuration_Name = 7;
  var kWebTransport_GetStats_Name = 8;
  var kWebTransport_Close_Name = 9;

  function WebTransportPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebTransport,
                                                   handleOrPtrInfo);
  }

  function WebTransportAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebTransport, associatedInterfacePtrInfo);
  }

  WebTransportAssociatedPtr.prototype =
      Object.create(WebTransportPtr.prototype);
  WebTransportAssociatedPtr.prototype.constructor =
      WebTransportAssociatedPtr;

  function WebTransportProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebTransportPtr.prototype.sendDatagram = function() {
    return WebTransportProxy.prototype.sendDatagram
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.sendDatagram = function(data) {
    var params_ = new WebTransport_SendDatagram_Params();
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTransport_SendDatagram_Name,
          codec.align(WebTransport_SendDatagram_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTransport_SendDatagram_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTransport_SendDatagram_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTransportPtr.prototype.createStream = function() {
    return WebTransportProxy.prototype.createStream
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.createStream = function(readable, writable) {
    var params_ = new WebTransport_CreateStream_Params();
    params_.readable = readable;
    params_.writable = writable;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTransport_CreateStream_Name,
          codec.align(WebTransport_CreateStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTransport_CreateStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTransport_CreateStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTransportPtr.prototype.acceptBidirectionalStream = function() {
    return WebTransportProxy.prototype.acceptBidirectionalStream
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.acceptBidirectionalStream = function() {
    var params_ = new WebTransport_AcceptBidirectionalStream_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTransport_AcceptBidirectionalStream_Name,
          codec.align(WebTransport_AcceptBidirectionalStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTransport_AcceptBidirectionalStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTransport_AcceptBidirectionalStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTransportPtr.prototype.acceptUnidirectionalStream = function() {
    return WebTransportProxy.prototype.acceptUnidirectionalStream
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.acceptUnidirectionalStream = function() {
    var params_ = new WebTransport_AcceptUnidirectionalStream_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTransport_AcceptUnidirectionalStream_Name,
          codec.align(WebTransport_AcceptUnidirectionalStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTransport_AcceptUnidirectionalStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTransport_AcceptUnidirectionalStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTransportPtr.prototype.sendFin = function() {
    return WebTransportProxy.prototype.sendFin
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.sendFin = function(streamId) {
    var params_ = new WebTransport_SendFin_Params();
    params_.streamId = streamId;
    var builder = new codec.MessageV0Builder(
        kWebTransport_SendFin_Name,
        codec.align(WebTransport_SendFin_Params.encodedSize));
    builder.encodeStruct(WebTransport_SendFin_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportPtr.prototype.abortStream = function() {
    return WebTransportProxy.prototype.abortStream
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.abortStream = function(streamId, code) {
    var params_ = new WebTransport_AbortStream_Params();
    params_.streamId = streamId;
    params_.code = code;
    var builder = new codec.MessageV0Builder(
        kWebTransport_AbortStream_Name,
        codec.align(WebTransport_AbortStream_Params.encodedSize));
    builder.encodeStruct(WebTransport_AbortStream_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportPtr.prototype.stopSending = function() {
    return WebTransportProxy.prototype.stopSending
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.stopSending = function(streamId, code) {
    var params_ = new WebTransport_StopSending_Params();
    params_.streamId = streamId;
    params_.code = code;
    var builder = new codec.MessageV0Builder(
        kWebTransport_StopSending_Name,
        codec.align(WebTransport_StopSending_Params.encodedSize));
    builder.encodeStruct(WebTransport_StopSending_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportPtr.prototype.setOutgoingDatagramExpirationDuration = function() {
    return WebTransportProxy.prototype.setOutgoingDatagramExpirationDuration
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.setOutgoingDatagramExpirationDuration = function(duration) {
    var params_ = new WebTransport_SetOutgoingDatagramExpirationDuration_Params();
    params_.duration = duration;
    var builder = new codec.MessageV0Builder(
        kWebTransport_SetOutgoingDatagramExpirationDuration_Name,
        codec.align(WebTransport_SetOutgoingDatagramExpirationDuration_Params.encodedSize));
    builder.encodeStruct(WebTransport_SetOutgoingDatagramExpirationDuration_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportPtr.prototype.getStats = function() {
    return WebTransportProxy.prototype.getStats
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.getStats = function() {
    var params_ = new WebTransport_GetStats_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebTransport_GetStats_Name,
          codec.align(WebTransport_GetStats_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebTransport_GetStats_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebTransport_GetStats_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebTransportPtr.prototype.close = function() {
    return WebTransportProxy.prototype.close
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportProxy.prototype.close = function(closeInfo) {
    var params_ = new WebTransport_Close_Params();
    params_.closeInfo = closeInfo;
    var builder = new codec.MessageV0Builder(
        kWebTransport_Close_Name,
        codec.align(WebTransport_Close_Params.encodedSize));
    builder.encodeStruct(WebTransport_Close_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebTransportStub(delegate) {
    this.delegate_ = delegate;
  }
  WebTransportStub.prototype.sendDatagram = function(data) {
    return this.delegate_ && this.delegate_.sendDatagram && this.delegate_.sendDatagram(data);
  }
  WebTransportStub.prototype.createStream = function(readable, writable) {
    return this.delegate_ && this.delegate_.createStream && this.delegate_.createStream(readable, writable);
  }
  WebTransportStub.prototype.acceptBidirectionalStream = function() {
    return this.delegate_ && this.delegate_.acceptBidirectionalStream && this.delegate_.acceptBidirectionalStream();
  }
  WebTransportStub.prototype.acceptUnidirectionalStream = function() {
    return this.delegate_ && this.delegate_.acceptUnidirectionalStream && this.delegate_.acceptUnidirectionalStream();
  }
  WebTransportStub.prototype.sendFin = function(streamId) {
    return this.delegate_ && this.delegate_.sendFin && this.delegate_.sendFin(streamId);
  }
  WebTransportStub.prototype.abortStream = function(streamId, code) {
    return this.delegate_ && this.delegate_.abortStream && this.delegate_.abortStream(streamId, code);
  }
  WebTransportStub.prototype.stopSending = function(streamId, code) {
    return this.delegate_ && this.delegate_.stopSending && this.delegate_.stopSending(streamId, code);
  }
  WebTransportStub.prototype.setOutgoingDatagramExpirationDuration = function(duration) {
    return this.delegate_ && this.delegate_.setOutgoingDatagramExpirationDuration && this.delegate_.setOutgoingDatagramExpirationDuration(duration);
  }
  WebTransportStub.prototype.getStats = function() {
    return this.delegate_ && this.delegate_.getStats && this.delegate_.getStats();
  }
  WebTransportStub.prototype.close = function(closeInfo) {
    return this.delegate_ && this.delegate_.close && this.delegate_.close(closeInfo);
  }

  WebTransportStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTransport_SendFin_Name:
      var params = reader.decodeStruct(WebTransport_SendFin_Params);
      this.sendFin(params.streamId);
      return true;
    case kWebTransport_AbortStream_Name:
      var params = reader.decodeStruct(WebTransport_AbortStream_Params);
      this.abortStream(params.streamId, params.code);
      return true;
    case kWebTransport_StopSending_Name:
      var params = reader.decodeStruct(WebTransport_StopSending_Params);
      this.stopSending(params.streamId, params.code);
      return true;
    case kWebTransport_SetOutgoingDatagramExpirationDuration_Name:
      var params = reader.decodeStruct(WebTransport_SetOutgoingDatagramExpirationDuration_Params);
      this.setOutgoingDatagramExpirationDuration(params.duration);
      return true;
    case kWebTransport_Close_Name:
      var params = reader.decodeStruct(WebTransport_Close_Params);
      this.close(params.closeInfo);
      return true;
    default:
      return false;
    }
  };

  WebTransportStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTransport_SendDatagram_Name:
      var params = reader.decodeStruct(WebTransport_SendDatagram_Params);
      this.sendDatagram(params.data).then(function(response) {
        var responseParams =
            new WebTransport_SendDatagram_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kWebTransport_SendDatagram_Name,
            codec.align(WebTransport_SendDatagram_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTransport_SendDatagram_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTransport_CreateStream_Name:
      var params = reader.decodeStruct(WebTransport_CreateStream_Params);
      this.createStream(params.readable, params.writable).then(function(response) {
        var responseParams =
            new WebTransport_CreateStream_ResponseParams();
        responseParams.succeeded = response.succeeded;
        responseParams.streamId = response.streamId;
        var builder = new codec.MessageV1Builder(
            kWebTransport_CreateStream_Name,
            codec.align(WebTransport_CreateStream_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTransport_CreateStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTransport_AcceptBidirectionalStream_Name:
      var params = reader.decodeStruct(WebTransport_AcceptBidirectionalStream_Params);
      this.acceptBidirectionalStream().then(function(response) {
        var responseParams =
            new WebTransport_AcceptBidirectionalStream_ResponseParams();
        responseParams.streamId = response.streamId;
        responseParams.readable = response.readable;
        responseParams.writable = response.writable;
        var builder = new codec.MessageV1Builder(
            kWebTransport_AcceptBidirectionalStream_Name,
            codec.align(WebTransport_AcceptBidirectionalStream_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTransport_AcceptBidirectionalStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTransport_AcceptUnidirectionalStream_Name:
      var params = reader.decodeStruct(WebTransport_AcceptUnidirectionalStream_Params);
      this.acceptUnidirectionalStream().then(function(response) {
        var responseParams =
            new WebTransport_AcceptUnidirectionalStream_ResponseParams();
        responseParams.streamId = response.streamId;
        responseParams.readable = response.readable;
        var builder = new codec.MessageV1Builder(
            kWebTransport_AcceptUnidirectionalStream_Name,
            codec.align(WebTransport_AcceptUnidirectionalStream_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTransport_AcceptUnidirectionalStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebTransport_GetStats_Name:
      var params = reader.decodeStruct(WebTransport_GetStats_Params);
      this.getStats().then(function(response) {
        var responseParams =
            new WebTransport_GetStats_ResponseParams();
        responseParams.stats = response.stats;
        var builder = new codec.MessageV1Builder(
            kWebTransport_GetStats_Name,
            codec.align(WebTransport_GetStats_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebTransport_GetStats_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebTransportRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebTransport_SendDatagram_Name:
        if (message.expectsResponse())
          paramsClass = WebTransport_SendDatagram_Params;
      break;
      case kWebTransport_CreateStream_Name:
        if (message.expectsResponse())
          paramsClass = WebTransport_CreateStream_Params;
      break;
      case kWebTransport_AcceptBidirectionalStream_Name:
        if (message.expectsResponse())
          paramsClass = WebTransport_AcceptBidirectionalStream_Params;
      break;
      case kWebTransport_AcceptUnidirectionalStream_Name:
        if (message.expectsResponse())
          paramsClass = WebTransport_AcceptUnidirectionalStream_Params;
      break;
      case kWebTransport_SendFin_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransport_SendFin_Params;
      break;
      case kWebTransport_AbortStream_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransport_AbortStream_Params;
      break;
      case kWebTransport_StopSending_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransport_StopSending_Params;
      break;
      case kWebTransport_SetOutgoingDatagramExpirationDuration_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransport_SetOutgoingDatagramExpirationDuration_Params;
      break;
      case kWebTransport_GetStats_Name:
        if (message.expectsResponse())
          paramsClass = WebTransport_GetStats_Params;
      break;
      case kWebTransport_Close_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransport_Close_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebTransportResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebTransport_SendDatagram_Name:
        if (message.isResponse())
          paramsClass = WebTransport_SendDatagram_ResponseParams;
        break;
      case kWebTransport_CreateStream_Name:
        if (message.isResponse())
          paramsClass = WebTransport_CreateStream_ResponseParams;
        break;
      case kWebTransport_AcceptBidirectionalStream_Name:
        if (message.isResponse())
          paramsClass = WebTransport_AcceptBidirectionalStream_ResponseParams;
        break;
      case kWebTransport_AcceptUnidirectionalStream_Name:
        if (message.isResponse())
          paramsClass = WebTransport_AcceptUnidirectionalStream_ResponseParams;
        break;
      case kWebTransport_GetStats_Name:
        if (message.isResponse())
          paramsClass = WebTransport_GetStats_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebTransport = {
    name: 'network.mojom.WebTransport',
    kVersion: 0,
    ptrClass: WebTransportPtr,
    proxyClass: WebTransportProxy,
    stubClass: WebTransportStub,
    validateRequest: validateWebTransportRequest,
    validateResponse: validateWebTransportResponse,
  };
  WebTransportStub.prototype.validator = validateWebTransportRequest;
  WebTransportProxy.prototype.validator = validateWebTransportResponse;
  var kWebTransportClient_OnDatagramReceived_Name = 0;
  var kWebTransportClient_OnIncomingStreamClosed_Name = 1;
  var kWebTransportClient_OnOutgoingStreamClosed_Name = 2;
  var kWebTransportClient_OnReceivedStopSending_Name = 3;
  var kWebTransportClient_OnReceivedResetStream_Name = 4;
  var kWebTransportClient_OnClosed_Name = 5;

  function WebTransportClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebTransportClient,
                                                   handleOrPtrInfo);
  }

  function WebTransportClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebTransportClient, associatedInterfacePtrInfo);
  }

  WebTransportClientAssociatedPtr.prototype =
      Object.create(WebTransportClientPtr.prototype);
  WebTransportClientAssociatedPtr.prototype.constructor =
      WebTransportClientAssociatedPtr;

  function WebTransportClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebTransportClientPtr.prototype.onDatagramReceived = function() {
    return WebTransportClientProxy.prototype.onDatagramReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportClientProxy.prototype.onDatagramReceived = function(data) {
    var params_ = new WebTransportClient_OnDatagramReceived_Params();
    params_.data = data;
    var builder = new codec.MessageV0Builder(
        kWebTransportClient_OnDatagramReceived_Name,
        codec.align(WebTransportClient_OnDatagramReceived_Params.encodedSize));
    builder.encodeStruct(WebTransportClient_OnDatagramReceived_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportClientPtr.prototype.onIncomingStreamClosed = function() {
    return WebTransportClientProxy.prototype.onIncomingStreamClosed
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportClientProxy.prototype.onIncomingStreamClosed = function(streamId, finReceived) {
    var params_ = new WebTransportClient_OnIncomingStreamClosed_Params();
    params_.streamId = streamId;
    params_.finReceived = finReceived;
    var builder = new codec.MessageV0Builder(
        kWebTransportClient_OnIncomingStreamClosed_Name,
        codec.align(WebTransportClient_OnIncomingStreamClosed_Params.encodedSize));
    builder.encodeStruct(WebTransportClient_OnIncomingStreamClosed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportClientPtr.prototype.onOutgoingStreamClosed = function() {
    return WebTransportClientProxy.prototype.onOutgoingStreamClosed
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportClientProxy.prototype.onOutgoingStreamClosed = function(streamId) {
    var params_ = new WebTransportClient_OnOutgoingStreamClosed_Params();
    params_.streamId = streamId;
    var builder = new codec.MessageV0Builder(
        kWebTransportClient_OnOutgoingStreamClosed_Name,
        codec.align(WebTransportClient_OnOutgoingStreamClosed_Params.encodedSize));
    builder.encodeStruct(WebTransportClient_OnOutgoingStreamClosed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportClientPtr.prototype.onReceivedStopSending = function() {
    return WebTransportClientProxy.prototype.onReceivedStopSending
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportClientProxy.prototype.onReceivedStopSending = function(streamId, streamErrorCode) {
    var params_ = new WebTransportClient_OnReceivedStopSending_Params();
    params_.streamId = streamId;
    params_.streamErrorCode = streamErrorCode;
    var builder = new codec.MessageV0Builder(
        kWebTransportClient_OnReceivedStopSending_Name,
        codec.align(WebTransportClient_OnReceivedStopSending_Params.encodedSize));
    builder.encodeStruct(WebTransportClient_OnReceivedStopSending_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportClientPtr.prototype.onReceivedResetStream = function() {
    return WebTransportClientProxy.prototype.onReceivedResetStream
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportClientProxy.prototype.onReceivedResetStream = function(streamId, streamErrorCode) {
    var params_ = new WebTransportClient_OnReceivedResetStream_Params();
    params_.streamId = streamId;
    params_.streamErrorCode = streamErrorCode;
    var builder = new codec.MessageV0Builder(
        kWebTransportClient_OnReceivedResetStream_Name,
        codec.align(WebTransportClient_OnReceivedResetStream_Params.encodedSize));
    builder.encodeStruct(WebTransportClient_OnReceivedResetStream_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportClientPtr.prototype.onClosed = function() {
    return WebTransportClientProxy.prototype.onClosed
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportClientProxy.prototype.onClosed = function(closeInfo, finalStats) {
    var params_ = new WebTransportClient_OnClosed_Params();
    params_.closeInfo = closeInfo;
    params_.finalStats = finalStats;
    var builder = new codec.MessageV0Builder(
        kWebTransportClient_OnClosed_Name,
        codec.align(WebTransportClient_OnClosed_Params.encodedSize));
    builder.encodeStruct(WebTransportClient_OnClosed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebTransportClientStub(delegate) {
    this.delegate_ = delegate;
  }
  WebTransportClientStub.prototype.onDatagramReceived = function(data) {
    return this.delegate_ && this.delegate_.onDatagramReceived && this.delegate_.onDatagramReceived(data);
  }
  WebTransportClientStub.prototype.onIncomingStreamClosed = function(streamId, finReceived) {
    return this.delegate_ && this.delegate_.onIncomingStreamClosed && this.delegate_.onIncomingStreamClosed(streamId, finReceived);
  }
  WebTransportClientStub.prototype.onOutgoingStreamClosed = function(streamId) {
    return this.delegate_ && this.delegate_.onOutgoingStreamClosed && this.delegate_.onOutgoingStreamClosed(streamId);
  }
  WebTransportClientStub.prototype.onReceivedStopSending = function(streamId, streamErrorCode) {
    return this.delegate_ && this.delegate_.onReceivedStopSending && this.delegate_.onReceivedStopSending(streamId, streamErrorCode);
  }
  WebTransportClientStub.prototype.onReceivedResetStream = function(streamId, streamErrorCode) {
    return this.delegate_ && this.delegate_.onReceivedResetStream && this.delegate_.onReceivedResetStream(streamId, streamErrorCode);
  }
  WebTransportClientStub.prototype.onClosed = function(closeInfo, finalStats) {
    return this.delegate_ && this.delegate_.onClosed && this.delegate_.onClosed(closeInfo, finalStats);
  }

  WebTransportClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTransportClient_OnDatagramReceived_Name:
      var params = reader.decodeStruct(WebTransportClient_OnDatagramReceived_Params);
      this.onDatagramReceived(params.data);
      return true;
    case kWebTransportClient_OnIncomingStreamClosed_Name:
      var params = reader.decodeStruct(WebTransportClient_OnIncomingStreamClosed_Params);
      this.onIncomingStreamClosed(params.streamId, params.finReceived);
      return true;
    case kWebTransportClient_OnOutgoingStreamClosed_Name:
      var params = reader.decodeStruct(WebTransportClient_OnOutgoingStreamClosed_Params);
      this.onOutgoingStreamClosed(params.streamId);
      return true;
    case kWebTransportClient_OnReceivedStopSending_Name:
      var params = reader.decodeStruct(WebTransportClient_OnReceivedStopSending_Params);
      this.onReceivedStopSending(params.streamId, params.streamErrorCode);
      return true;
    case kWebTransportClient_OnReceivedResetStream_Name:
      var params = reader.decodeStruct(WebTransportClient_OnReceivedResetStream_Params);
      this.onReceivedResetStream(params.streamId, params.streamErrorCode);
      return true;
    case kWebTransportClient_OnClosed_Name:
      var params = reader.decodeStruct(WebTransportClient_OnClosed_Params);
      this.onClosed(params.closeInfo, params.finalStats);
      return true;
    default:
      return false;
    }
  };

  WebTransportClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebTransportClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebTransportClient_OnDatagramReceived_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportClient_OnDatagramReceived_Params;
      break;
      case kWebTransportClient_OnIncomingStreamClosed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportClient_OnIncomingStreamClosed_Params;
      break;
      case kWebTransportClient_OnOutgoingStreamClosed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportClient_OnOutgoingStreamClosed_Params;
      break;
      case kWebTransportClient_OnReceivedStopSending_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportClient_OnReceivedStopSending_Params;
      break;
      case kWebTransportClient_OnReceivedResetStream_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportClient_OnReceivedResetStream_Params;
      break;
      case kWebTransportClient_OnClosed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportClient_OnClosed_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebTransportClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebTransportClient = {
    name: 'network.mojom.WebTransportClient',
    kVersion: 0,
    ptrClass: WebTransportClientPtr,
    proxyClass: WebTransportClientProxy,
    stubClass: WebTransportClientStub,
    validateRequest: validateWebTransportClientRequest,
    validateResponse: null,
  };
  WebTransportClientStub.prototype.validator = validateWebTransportClientRequest;
  WebTransportClientProxy.prototype.validator = null;
  var kWebTransportHandshakeClient_OnBeforeConnect_Name = 0;
  var kWebTransportHandshakeClient_OnConnectionEstablished_Name = 1;
  var kWebTransportHandshakeClient_OnHandshakeFailed_Name = 2;

  function WebTransportHandshakeClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebTransportHandshakeClient,
                                                   handleOrPtrInfo);
  }

  function WebTransportHandshakeClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebTransportHandshakeClient, associatedInterfacePtrInfo);
  }

  WebTransportHandshakeClientAssociatedPtr.prototype =
      Object.create(WebTransportHandshakeClientPtr.prototype);
  WebTransportHandshakeClientAssociatedPtr.prototype.constructor =
      WebTransportHandshakeClientAssociatedPtr;

  function WebTransportHandshakeClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebTransportHandshakeClientPtr.prototype.onBeforeConnect = function() {
    return WebTransportHandshakeClientProxy.prototype.onBeforeConnect
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportHandshakeClientProxy.prototype.onBeforeConnect = function(serverAddress) {
    var params_ = new WebTransportHandshakeClient_OnBeforeConnect_Params();
    params_.serverAddress = serverAddress;
    var builder = new codec.MessageV0Builder(
        kWebTransportHandshakeClient_OnBeforeConnect_Name,
        codec.align(WebTransportHandshakeClient_OnBeforeConnect_Params.encodedSize));
    builder.encodeStruct(WebTransportHandshakeClient_OnBeforeConnect_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportHandshakeClientPtr.prototype.onConnectionEstablished = function() {
    return WebTransportHandshakeClientProxy.prototype.onConnectionEstablished
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportHandshakeClientProxy.prototype.onConnectionEstablished = function(transport, client, responseHeaders, selectedApplicationProtocol, initialStats) {
    var params_ = new WebTransportHandshakeClient_OnConnectionEstablished_Params();
    params_.transport = transport;
    params_.client = client;
    params_.responseHeaders = responseHeaders;
    params_.selectedApplicationProtocol = selectedApplicationProtocol;
    params_.initialStats = initialStats;
    var builder = new codec.MessageV0Builder(
        kWebTransportHandshakeClient_OnConnectionEstablished_Name,
        codec.align(WebTransportHandshakeClient_OnConnectionEstablished_Params.encodedSize));
    builder.encodeStruct(WebTransportHandshakeClient_OnConnectionEstablished_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebTransportHandshakeClientPtr.prototype.onHandshakeFailed = function() {
    return WebTransportHandshakeClientProxy.prototype.onHandshakeFailed
        .apply(this.ptr.getProxy(), arguments);
  };

  WebTransportHandshakeClientProxy.prototype.onHandshakeFailed = function(error) {
    var params_ = new WebTransportHandshakeClient_OnHandshakeFailed_Params();
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kWebTransportHandshakeClient_OnHandshakeFailed_Name,
        codec.align(WebTransportHandshakeClient_OnHandshakeFailed_Params.encodedSize));
    builder.encodeStruct(WebTransportHandshakeClient_OnHandshakeFailed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebTransportHandshakeClientStub(delegate) {
    this.delegate_ = delegate;
  }
  WebTransportHandshakeClientStub.prototype.onBeforeConnect = function(serverAddress) {
    return this.delegate_ && this.delegate_.onBeforeConnect && this.delegate_.onBeforeConnect(serverAddress);
  }
  WebTransportHandshakeClientStub.prototype.onConnectionEstablished = function(transport, client, responseHeaders, selectedApplicationProtocol, initialStats) {
    return this.delegate_ && this.delegate_.onConnectionEstablished && this.delegate_.onConnectionEstablished(transport, client, responseHeaders, selectedApplicationProtocol, initialStats);
  }
  WebTransportHandshakeClientStub.prototype.onHandshakeFailed = function(error) {
    return this.delegate_ && this.delegate_.onHandshakeFailed && this.delegate_.onHandshakeFailed(error);
  }

  WebTransportHandshakeClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebTransportHandshakeClient_OnBeforeConnect_Name:
      var params = reader.decodeStruct(WebTransportHandshakeClient_OnBeforeConnect_Params);
      this.onBeforeConnect(params.serverAddress);
      return true;
    case kWebTransportHandshakeClient_OnConnectionEstablished_Name:
      var params = reader.decodeStruct(WebTransportHandshakeClient_OnConnectionEstablished_Params);
      this.onConnectionEstablished(params.transport, params.client, params.responseHeaders, params.selectedApplicationProtocol, params.initialStats);
      return true;
    case kWebTransportHandshakeClient_OnHandshakeFailed_Name:
      var params = reader.decodeStruct(WebTransportHandshakeClient_OnHandshakeFailed_Params);
      this.onHandshakeFailed(params.error);
      return true;
    default:
      return false;
    }
  };

  WebTransportHandshakeClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebTransportHandshakeClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebTransportHandshakeClient_OnBeforeConnect_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportHandshakeClient_OnBeforeConnect_Params;
      break;
      case kWebTransportHandshakeClient_OnConnectionEstablished_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportHandshakeClient_OnConnectionEstablished_Params;
      break;
      case kWebTransportHandshakeClient_OnHandshakeFailed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebTransportHandshakeClient_OnHandshakeFailed_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebTransportHandshakeClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebTransportHandshakeClient = {
    name: 'network.mojom.WebTransportHandshakeClient',
    kVersion: 0,
    ptrClass: WebTransportHandshakeClientPtr,
    proxyClass: WebTransportHandshakeClientProxy,
    stubClass: WebTransportHandshakeClientStub,
    validateRequest: validateWebTransportHandshakeClientRequest,
    validateResponse: null,
  };
  WebTransportHandshakeClientStub.prototype.validator = validateWebTransportHandshakeClientRequest;
  WebTransportHandshakeClientProxy.prototype.validator = null;
  exports.WebTransportError = WebTransportError;
  exports.WebTransportCertificateFingerprint = WebTransportCertificateFingerprint;
  exports.WebTransportCloseInfo = WebTransportCloseInfo;
  exports.WebTransportStats = WebTransportStats;
  exports.WebTransport = WebTransport;
  exports.WebTransportPtr = WebTransportPtr;
  exports.WebTransportAssociatedPtr = WebTransportAssociatedPtr;
  exports.WebTransportClient = WebTransportClient;
  exports.WebTransportClientPtr = WebTransportClientPtr;
  exports.WebTransportClientAssociatedPtr = WebTransportClientAssociatedPtr;
  exports.WebTransportHandshakeClient = WebTransportHandshakeClient;
  exports.WebTransportHandshakeClientPtr = WebTransportHandshakeClientPtr;
  exports.WebTransportHandshakeClientAssociatedPtr = WebTransportHandshakeClientAssociatedPtr;
})();