// services/network/public/mojom/url_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_request.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_request.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_request.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-blink-forward.h"
#include "services/network/public/mojom/attribution.mojom-blink-forward.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-blink-forward.h"
#include "services/network/public/mojom/client_security_state.mojom-blink.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-blink-forward.h"
#include "services/network/public/mojom/cookie_manager.mojom-blink-forward.h"
#include "services/network/public/mojom/cors.mojom-blink-forward.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-blink-forward.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-blink-forward.h"
#include "services/network/public/mojom/devtools_observer.mojom-blink-forward.h"
#include "services/network/public/mojom/fetch_api.mojom-blink-forward.h"
#include "services/network/public/mojom/fetch_retry_options.mojom-blink.h"
#include "services/network/public/mojom/http_raw_headers.mojom-blink-forward.h"
#include "services/network/public/mojom/http_request_headers.mojom-blink.h"
#include "services/network/public/mojom/ip_address_space.mojom-blink-forward.h"
#include "services/network/public/mojom/isolation_info.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink.h"
#include "services/network/public/mojom/referrer_policy.mojom-blink.h"
#include "services/network/public/mojom/request_priority.mojom-blink.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-blink-forward.h"
#include "services/network/public/mojom/site_for_cookies.mojom-blink.h"
#include "services/network/public/mojom/source_type.mojom-blink.h"
#include "services/network/public/mojom/storage_access_api.mojom-blink.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-blink-forward.h"
#include "services/network/public/mojom/trust_tokens.mojom-blink.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-blink-forward.h"
#include "services/network/public/mojom/url_response_head.mojom-blink-forward.h"
#include "services/network/public/mojom/web_bundle_handle.mojom-blink-forward.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/network_anonymization_key_mojom_traits.h"
#include "services/network/public/cpp/network_ipc_param_traits.h"
#include "services/network/public/cpp/network_isolation_key_mojom_traits.h"
#include "services/network/public/cpp/url_request_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {














class BLINK_PLATFORM_EXPORT SocketTag {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SocketTag, T>::value>;
  using DataView = SocketTagDataView;
  using Data_ = internal::SocketTag_Data;

  template <typename... Args>
  static SocketTagPtr New(Args&&... args) {
    return SocketTagPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SocketTagPtr From(const U& u) {
    return mojo::TypeConverter<SocketTagPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SocketTag>::Convert(*this);
  }


  SocketTag();


  ~SocketTag();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SocketTagPtr>
  SocketTagPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SocketTag::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SocketTag::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SocketTag::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SocketTag::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SocketTag::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SocketTag::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SocketTag_UnserializedMessageContext<
            UserType, SocketTag::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SocketTag::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SocketTag::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SocketTag_UnserializedMessageContext<
            UserType, SocketTag::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SocketTag::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SocketTag::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SocketTag::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SocketTag::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SocketTag::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DataElement {
 public:
  using DataView = DataElementDataView;
  using Data_ = internal::DataElement_Data;
  using Tag = Data_::DataElement_Tag;

  template <typename... Args>
  static DataElementPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |bytes|.
  static DataElementPtr NewBytes(
      ::network::DataElementBytes value);
  // Construct an instance holding |file|.
  static DataElementPtr NewFile(
      ::network::DataElementFile value);
  // Construct an instance holding |data_pipe|.
  static DataElementPtr NewDataPipe(
      ::network::DataElementDataPipe value);
  // Construct an instance holding |chunked_data_pipe|.
  static DataElementPtr NewChunkedDataPipe(
      ::network::DataElementChunkedDataPipe value);

  template <typename U>
  static DataElementPtr From(const U& u) {
    return mojo::TypeConverter<DataElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElement>::Convert(*this);
  }
  ~DataElement();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DataElement(const DataElement& other) = delete;
  DataElement& operator=(const DataElement& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DataElementPtr>
  DataElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DataElement>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DataElement>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_bytes() const { return tag_ == Tag::kBytes; }
  const ::network::DataElementBytes& get_bytes() const {
    CHECK(tag_ == Tag::kBytes);
    return data_.bytes;
  }
  ::network::DataElementBytes& get_bytes() {
    CHECK(tag_ == Tag::kBytes);
    return data_.bytes;
  }
  void set_bytes(::network::DataElementBytes bytes);

  bool is_file() const { return tag_ == Tag::kFile; }
  const ::network::DataElementFile& get_file() const {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  ::network::DataElementFile& get_file() {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  void set_file(::network::DataElementFile file);

  bool is_data_pipe() const { return tag_ == Tag::kDataPipe; }
  const ::network::DataElementDataPipe& get_data_pipe() const {
    CHECK(tag_ == Tag::kDataPipe);
    return data_.data_pipe;
  }
  ::network::DataElementDataPipe& get_data_pipe() {
    CHECK(tag_ == Tag::kDataPipe);
    return data_.data_pipe;
  }
  void set_data_pipe(::network::DataElementDataPipe data_pipe);

  bool is_chunked_data_pipe() const { return tag_ == Tag::kChunkedDataPipe; }
  const ::network::DataElementChunkedDataPipe& get_chunked_data_pipe() const {
    CHECK(tag_ == Tag::kChunkedDataPipe);
    return data_.chunked_data_pipe;
  }
  ::network::DataElementChunkedDataPipe& get_chunked_data_pipe() {
    CHECK(tag_ == Tag::kChunkedDataPipe);
    return data_.chunked_data_pipe;
  }
  void set_chunked_data_pipe(::network::DataElementChunkedDataPipe chunked_data_pipe);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElement::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DataElement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
        ::network::DataElementBytes value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
        ::network::DataElementFile value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDataPipe)>,
        ::network::DataElementDataPipe value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kChunkedDataPipe)>,
        ::network::DataElementChunkedDataPipe value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::network::DataElementBytes bytes;
    ::network::DataElementFile file;
    ::network::DataElementDataPipe data_pipe;
    ::network::DataElementChunkedDataPipe chunked_data_pipe;
  };

  DataElement(
      std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
      ::network::DataElementBytes value);
  DataElement(
      std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
      ::network::DataElementFile value);
  DataElement(
      std::in_place_index_t<static_cast<size_t>(Tag::kDataPipe)>,
      ::network::DataElementDataPipe value);
  DataElement(
      std::in_place_index_t<static_cast<size_t>(Tag::kChunkedDataPipe)>,
      ::network::DataElementChunkedDataPipe value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT EnabledClientHints {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EnabledClientHints, T>::value>;
  using DataView = EnabledClientHintsDataView;
  using Data_ = internal::EnabledClientHints_Data;

  template <typename... Args>
  static EnabledClientHintsPtr New(Args&&... args) {
    return EnabledClientHintsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EnabledClientHintsPtr From(const U& u) {
    return mojo::TypeConverter<EnabledClientHintsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EnabledClientHints>::Convert(*this);
  }


  EnabledClientHints();

  EnabledClientHints(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& origin,
      bool is_outermost_main_frame,
      ::blink::Vector<::network::mojom::blink::WebClientHintsType> hints,
      ::blink::Vector<::network::mojom::blink::WebClientHintsType> not_allowed_hints);


  ~EnabledClientHints();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EnabledClientHintsPtr>
  EnabledClientHintsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EnabledClientHints::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EnabledClientHints::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EnabledClientHints::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnabledClientHints::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnabledClientHints::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EnabledClientHints::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EnabledClientHints_UnserializedMessageContext<
            UserType, EnabledClientHints::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EnabledClientHints::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EnabledClientHints::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EnabledClientHints_UnserializedMessageContext<
            UserType, EnabledClientHints::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EnabledClientHints::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> origin;
  
  bool is_outermost_main_frame;
  
  ::blink::Vector<::network::mojom::blink::WebClientHintsType> hints;
  
  ::blink::Vector<::network::mojom::blink::WebClientHintsType> not_allowed_hints;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EnabledClientHints::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EnabledClientHints::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EnabledClientHints::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EnabledClientHints::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TrustedUrlRequestParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustedUrlRequestParams, T>::value>;
  using DataView = TrustedUrlRequestParamsDataView;
  using Data_ = internal::TrustedUrlRequestParams_Data;

  template <typename... Args>
  static TrustedUrlRequestParamsPtr New(Args&&... args) {
    return TrustedUrlRequestParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustedUrlRequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<TrustedUrlRequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustedUrlRequestParams>::Convert(*this);
  }


  TrustedUrlRequestParams();

  TrustedUrlRequestParams(
      const ::net::IsolationInfo& isolation_info,
      bool disable_secure_dns,
      bool has_user_activation,
      bool allow_cookies_from_browser,
      bool include_request_cookies_with_response,
      EnabledClientHintsPtr enabled_client_hints,
      ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer,
      ::mojo::PendingRemote<::network::mojom::blink::TrustTokenAccessObserver> trust_token_observer,
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderNetworkServiceObserver> url_loader_network_observer,
      ::mojo::PendingRemote<::network::mojom::blink::DevToolsObserver> devtools_observer,
      ::mojo::PendingRemote<::network::mojom::blink::DeviceBoundSessionAccessObserver> device_bound_session_observer,
      ::network::mojom::blink::ClientSecurityStatePtr client_security_state,
      ::mojo::PendingRemote<::network::mojom::blink::AcceptCHFrameObserver> accept_ch_frame_observer,
      ::mojo::PendingRemote<::network::mojom::blink::SharedDictionaryAccessObserver> shared_dictionary_observer);

TrustedUrlRequestParams(const TrustedUrlRequestParams&) = delete;
TrustedUrlRequestParams& operator=(const TrustedUrlRequestParams&) = delete;

  ~TrustedUrlRequestParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustedUrlRequestParamsPtr>
  TrustedUrlRequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustedUrlRequestParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustedUrlRequestParams_UnserializedMessageContext<
            UserType, TrustedUrlRequestParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustedUrlRequestParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustedUrlRequestParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustedUrlRequestParams_UnserializedMessageContext<
            UserType, TrustedUrlRequestParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustedUrlRequestParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::IsolationInfo isolation_info;
  
  bool disable_secure_dns;
  
  bool has_user_activation;
  
  bool allow_cookies_from_browser;
  
  bool include_request_cookies_with_response;
  
  EnabledClientHintsPtr enabled_client_hints;
  
  ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer;
  
  ::mojo::PendingRemote<::network::mojom::blink::TrustTokenAccessObserver> trust_token_observer;
  
  ::mojo::PendingRemote<::network::mojom::blink::URLLoaderNetworkServiceObserver> url_loader_network_observer;
  
  ::mojo::PendingRemote<::network::mojom::blink::DevToolsObserver> devtools_observer;
  
  ::mojo::PendingRemote<::network::mojom::blink::DeviceBoundSessionAccessObserver> device_bound_session_observer;
  
  ::network::mojom::blink::ClientSecurityStatePtr client_security_state;
  
  ::mojo::PendingRemote<::network::mojom::blink::AcceptCHFrameObserver> accept_ch_frame_observer;
  
  ::mojo::PendingRemote<::network::mojom::blink::SharedDictionaryAccessObserver> shared_dictionary_observer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebBundleTokenParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBundleTokenParams, T>::value>;
  using DataView = WebBundleTokenParamsDataView;
  using Data_ = internal::WebBundleTokenParams_Data;

  template <typename... Args>
  static WebBundleTokenParamsPtr New(Args&&... args) {
    return WebBundleTokenParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBundleTokenParamsPtr From(const U& u) {
    return mojo::TypeConverter<WebBundleTokenParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBundleTokenParams>::Convert(*this);
  }


  WebBundleTokenParams();

  WebBundleTokenParams(
      const ::blink::KURL& bundle_url,
      const ::base::UnguessableToken& token,
      ::mojo::PendingRemote<::network::mojom::blink::WebBundleHandle> web_bundle_handle,
      int32_t render_process_id);

WebBundleTokenParams(const WebBundleTokenParams&) = delete;
WebBundleTokenParams& operator=(const WebBundleTokenParams&) = delete;

  ~WebBundleTokenParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBundleTokenParamsPtr>
  WebBundleTokenParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBundleTokenParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBundleTokenParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBundleTokenParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBundleTokenParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBundleTokenParams_UnserializedMessageContext<
            UserType, WebBundleTokenParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBundleTokenParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBundleTokenParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBundleTokenParams_UnserializedMessageContext<
            UserType, WebBundleTokenParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBundleTokenParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL bundle_url;
  
  ::base::UnguessableToken token;
  
  ::mojo::PendingRemote<::network::mojom::blink::WebBundleHandle> web_bundle_handle;
  
  int32_t render_process_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBundleTokenParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBundleTokenParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBundleTokenParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBundleTokenParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT URLRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLRequest, T>::value>;
  using DataView = URLRequestDataView;
  using Data_ = internal::URLRequest_Data;

  template <typename... Args>
  static URLRequestPtr New(Args&&... args) {
    return URLRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLRequestPtr From(const U& u) {
    return mojo::TypeConverter<URLRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLRequest>::Convert(*this);
  }


  URLRequest();

  URLRequest(
      const ::blink::String& method,
      const ::blink::KURL& url,
      const ::net::SiteForCookies& site_for_cookies,
      bool update_first_party_url_on_redirect,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& request_initiator,
      ::blink::Vector<::blink::KURL> navigation_redirect_chain,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& isolated_world_origin,
      const ::blink::KURL& referrer,
      ::net::ReferrerPolicy referrer_policy,
      const ::net::HttpRequestHeaders& headers,
      const ::net::HttpRequestHeaders& cors_exempt_headers,
      int32_t load_flags,
      int32_t resource_type,
      ::net::RequestPriority priority,
      bool priority_incremental,
      ::network::mojom::blink::CorsPreflightPolicy cors_preflight_policy,
      bool originated_from_service_worker,
      bool skip_service_worker,
      ::network::mojom::blink::RequestMode mode,
      ::network::mojom::blink::CredentialsMode credentials_mode,
      ::network::mojom::blink::RedirectMode redirect_mode,
      const ::blink::String& fetch_integrity,
      ::blink::Vector<::blink::Vector<uint8_t>> expected_public_keys,
      ::network::mojom::blink::RequestDestination destination,
      ::scoped_refptr<::network::ResourceRequestBody> request_body,
      bool keepalive,
      bool browsing_topics,
      bool ad_auction_headers,
      bool shared_storage_writable_eligible,
      bool has_user_gesture,
      bool enable_load_timing,
      bool enable_upload_progress,
      bool do_not_prompt_for_login,
      bool is_outermost_main_frame,
      int32_t transition_type,
      int32_t previews_state,
      bool upgrade_if_insecure,
      bool is_revalidating,
      const std::optional<::base::UnguessableToken>& throttling_profile_id,
      const std::optional<::base::UnguessableToken>& fetch_window_id,
      const ::blink::String& devtools_request_id,
      const ::blink::String& devtools_stack_id,
      bool is_fetch_like_api,
      bool is_fetch_later_api,
      bool is_favicon,
      ::network::mojom::blink::RequestDestination original_destination,
      const std::optional<::network::ResourceRequest::TrustedParams>& trusted_params,
      const std::optional<::base::UnguessableToken>& recursive_prefetch_token,
      ::network::mojom::blink::TrustTokenParamsPtr trust_token_params,
      const std::optional<::network::ResourceRequest::WebBundleTokenParams>& web_bundle_token_params,
      std::optional<::blink::Vector<::net::SourceStreamType>> devtools_accepted_stream_types,
      const std::optional<::net::NetLogSource>& net_log_create_info,
      const std::optional<::net::NetLogSource>& net_log_reference_info,
      ::network::mojom::blink::IPAddressSpace target_ip_address_space,
      ::network::mojom::blink::IPAddressSpace required_ip_address_space,
      ::net::StorageAccessApiStatus storage_access_api_status,
      ::network::mojom::blink::AttributionSupport attribution_reporting_support,
      ::network::mojom::blink::AttributionReportingEligibility attribution_reporting_eligibility,
      const std::optional<::base::UnguessableToken>& attribution_reporting_src_token,
      const std::optional<::base::UnguessableToken>& keepalive_token,
      bool is_ad_tagged,
      bool shared_dictionary_writer_enabled,
      bool client_side_content_decoding_enabled,
      SocketTagPtr socket_tag,
      bool allows_device_bound_session_registration,
      std::optional<::network::PermissionsPolicy> permissions_policy,
      ::network::mojom::blink::FetchRetryOptionsPtr fetch_retry_options);

URLRequest(const URLRequest&) = delete;
URLRequest& operator=(const URLRequest&) = delete;

  ~URLRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLRequestPtr>
  URLRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLRequest_UnserializedMessageContext<
            UserType, URLRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLRequest_UnserializedMessageContext<
            UserType, URLRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String method;
  
  ::blink::KURL url;
  
  ::net::SiteForCookies site_for_cookies;
  
  bool update_first_party_url_on_redirect;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> request_initiator;
  
  ::blink::Vector<::blink::KURL> navigation_redirect_chain;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> isolated_world_origin;
  
  ::blink::KURL referrer;
  
  ::net::ReferrerPolicy referrer_policy;
  
  ::net::HttpRequestHeaders headers;
  
  ::net::HttpRequestHeaders cors_exempt_headers;
  
  int32_t load_flags;
  
  int32_t resource_type;
  
  ::net::RequestPriority priority;
  
  bool priority_incremental;
  
  ::network::mojom::blink::CorsPreflightPolicy cors_preflight_policy;
  
  bool originated_from_service_worker;
  
  bool skip_service_worker;
  
  ::network::mojom::blink::RequestMode mode;
  
  ::network::mojom::blink::CredentialsMode credentials_mode;
  
  ::network::mojom::blink::RedirectMode redirect_mode;
  
  ::blink::String fetch_integrity;
  
  ::blink::Vector<::blink::Vector<uint8_t>> expected_public_keys;
  
  ::network::mojom::blink::RequestDestination destination;
  
  ::scoped_refptr<::network::ResourceRequestBody> request_body;
  
  bool keepalive;
  
  bool browsing_topics;
  
  bool ad_auction_headers;
  
  bool shared_storage_writable_eligible;
  
  bool has_user_gesture;
  
  bool enable_load_timing;
  
  bool enable_upload_progress;
  
  bool do_not_prompt_for_login;
  
  bool is_outermost_main_frame;
  
  int32_t transition_type;
  
  int32_t previews_state;
  
  bool upgrade_if_insecure;
  
  bool is_revalidating;
  
  std::optional<::base::UnguessableToken> throttling_profile_id;
  
  std::optional<::base::UnguessableToken> fetch_window_id;
  
  ::blink::String devtools_request_id;
  
  ::blink::String devtools_stack_id;
  
  bool is_fetch_like_api;
  
  bool is_fetch_later_api;
  
  bool is_favicon;
  
  ::network::mojom::blink::RequestDestination original_destination;
  
  std::optional<::network::ResourceRequest::TrustedParams> trusted_params;
  
  std::optional<::base::UnguessableToken> recursive_prefetch_token;
  
  ::network::mojom::blink::TrustTokenParamsPtr trust_token_params;
  
  std::optional<::network::ResourceRequest::WebBundleTokenParams> web_bundle_token_params;
  
  std::optional<::blink::Vector<::net::SourceStreamType>> devtools_accepted_stream_types;
  
  std::optional<::net::NetLogSource> net_log_create_info;
  
  std::optional<::net::NetLogSource> net_log_reference_info;
  
  ::network::mojom::blink::IPAddressSpace target_ip_address_space;
  
  ::network::mojom::blink::IPAddressSpace required_ip_address_space;
  
  ::net::StorageAccessApiStatus storage_access_api_status;
  
  ::network::mojom::blink::AttributionSupport attribution_reporting_support;
  
  ::network::mojom::blink::AttributionReportingEligibility attribution_reporting_eligibility;
  
  std::optional<::base::UnguessableToken> attribution_reporting_src_token;
  
  std::optional<::base::UnguessableToken> keepalive_token;
  
  bool is_ad_tagged;
  
  bool shared_dictionary_writer_enabled;
  
  bool client_side_content_decoding_enabled;
  
  SocketTagPtr socket_tag;
  
  bool allows_device_bound_session_registration;
  
  std::optional<::network::PermissionsPolicy> permissions_policy;
  
  ::network::mojom::blink::FetchRetryOptionsPtr fetch_retry_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT URLRequestBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLRequestBody, T>::value>;
  using DataView = URLRequestBodyDataView;
  using Data_ = internal::URLRequestBody_Data;

  template <typename... Args>
  static URLRequestBodyPtr New(Args&&... args) {
    return URLRequestBodyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLRequestBodyPtr From(const U& u) {
    return mojo::TypeConverter<URLRequestBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLRequestBody>::Convert(*this);
  }


  URLRequestBody();

  URLRequestBody(
      ::blink::Vector<::network::DataElement> elements,
      uint64_t identifier,
      bool contains_sensitive_info,
      bool allow_http1_for_streaming_upload);

URLRequestBody(const URLRequestBody&) = delete;
URLRequestBody& operator=(const URLRequestBody&) = delete;

  ~URLRequestBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLRequestBodyPtr>
  URLRequestBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLRequestBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLRequestBody_UnserializedMessageContext<
            UserType, URLRequestBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLRequestBody::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLRequestBody::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLRequestBody_UnserializedMessageContext<
            UserType, URLRequestBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLRequestBody::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::network::DataElement> elements;
  
  uint64_t identifier;
  
  bool contains_sensitive_info;
  
  bool allow_http1_for_streaming_upload;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DataElementBytes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElementBytes, T>::value>;
  using DataView = DataElementBytesDataView;
  using Data_ = internal::DataElementBytes_Data;

  template <typename... Args>
  static DataElementBytesPtr New(Args&&... args) {
    return DataElementBytesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementBytesPtr From(const U& u) {
    return mojo::TypeConverter<DataElementBytesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElementBytes>::Convert(*this);
  }


  DataElementBytes();

  explicit DataElementBytes(
      ::mojo_base::BigBuffer data);

DataElementBytes(const DataElementBytes&) = delete;
DataElementBytes& operator=(const DataElementBytes&) = delete;

  ~DataElementBytes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementBytesPtr>
  DataElementBytesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElementBytes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElementBytes_UnserializedMessageContext<
            UserType, DataElementBytes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataElementBytes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataElementBytes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElementBytes_UnserializedMessageContext<
            UserType, DataElementBytes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElementBytes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElementBytes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DataElementFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElementFile, T>::value>;
  using DataView = DataElementFileDataView;
  using Data_ = internal::DataElementFile_Data;

  template <typename... Args>
  static DataElementFilePtr New(Args&&... args) {
    return DataElementFilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementFilePtr From(const U& u) {
    return mojo::TypeConverter<DataElementFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElementFile>::Convert(*this);
  }


  DataElementFile();

  DataElementFile(
      const ::base::FilePath& path,
      uint64_t offset,
      uint64_t length,
      ::base::Time expected_modification_time);


  ~DataElementFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementFilePtr>
  DataElementFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataElementFile::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataElementFile::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElementFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElementFile_UnserializedMessageContext<
            UserType, DataElementFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataElementFile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataElementFile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElementFile_UnserializedMessageContext<
            UserType, DataElementFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElementFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath path;
  
  uint64_t offset;
  
  uint64_t length;
  
  ::base::Time expected_modification_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElementFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DataElementDataPipe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElementDataPipe, T>::value>;
  using DataView = DataElementDataPipeDataView;
  using Data_ = internal::DataElementDataPipe_Data;

  template <typename... Args>
  static DataElementDataPipePtr New(Args&&... args) {
    return DataElementDataPipePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementDataPipePtr From(const U& u) {
    return mojo::TypeConverter<DataElementDataPipePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElementDataPipe>::Convert(*this);
  }


  DataElementDataPipe();

  explicit DataElementDataPipe(
      ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter);

DataElementDataPipe(const DataElementDataPipe&) = delete;
DataElementDataPipe& operator=(const DataElementDataPipe&) = delete;

  ~DataElementDataPipe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementDataPipePtr>
  DataElementDataPipePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElementDataPipe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataElementDataPipe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataElementDataPipe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElementDataPipe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElementDataPipe_UnserializedMessageContext<
            UserType, DataElementDataPipe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataElementDataPipe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataElementDataPipe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElementDataPipe_UnserializedMessageContext<
            UserType, DataElementDataPipe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElementDataPipe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElementDataPipe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElementDataPipe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElementDataPipe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElementDataPipe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DataElementChunkedDataPipe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElementChunkedDataPipe, T>::value>;
  using DataView = DataElementChunkedDataPipeDataView;
  using Data_ = internal::DataElementChunkedDataPipe_Data;

  template <typename... Args>
  static DataElementChunkedDataPipePtr New(Args&&... args) {
    return DataElementChunkedDataPipePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementChunkedDataPipePtr From(const U& u) {
    return mojo::TypeConverter<DataElementChunkedDataPipePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElementChunkedDataPipe>::Convert(*this);
  }


  DataElementChunkedDataPipe();

  DataElementChunkedDataPipe(
      ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> data_pipe_getter,
      bool read_only_once);

DataElementChunkedDataPipe(const DataElementChunkedDataPipe&) = delete;
DataElementChunkedDataPipe& operator=(const DataElementChunkedDataPipe&) = delete;

  ~DataElementChunkedDataPipe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementChunkedDataPipePtr>
  DataElementChunkedDataPipePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElementChunkedDataPipe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElementChunkedDataPipe_UnserializedMessageContext<
            UserType, DataElementChunkedDataPipe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataElementChunkedDataPipe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataElementChunkedDataPipe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElementChunkedDataPipe_UnserializedMessageContext<
            UserType, DataElementChunkedDataPipe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElementChunkedDataPipe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> data_pipe_getter;
  
  bool read_only_once;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
DataElementPtr DataElement::Clone() const {
  switch (tag_) {
    case Tag::kBytes:
      return NewBytes(
          mojo::Clone(data_.bytes));
    case Tag::kFile:
      return NewFile(
          mojo::Clone(data_.file));
    case Tag::kDataPipe:
      return NewDataPipe(
          mojo::Clone(data_.data_pipe));
    case Tag::kChunkedDataPipe:
      return NewChunkedDataPipe(
          mojo::Clone(data_.chunked_data_pipe));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DataElement>::value>::type*>
bool DataElement::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBytes:
      return mojo::Equals(data_.bytes, other.data_.bytes);
    case Tag::kFile:
      return mojo::Equals(data_.file, other.data_.file);
    case Tag::kDataPipe:
      return mojo::Equals(data_.data_pipe, other.data_.data_pipe);
    case Tag::kChunkedDataPipe:
      return mojo::Equals(data_.chunked_data_pipe, other.data_.chunked_data_pipe);
  }

  return false;
}
template <typename StructPtrType>
EnabledClientHintsPtr EnabledClientHints::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(is_outermost_main_frame),
      mojo::Clone(hints),
      mojo::Clone(not_allowed_hints)
  );
}

template <typename T, EnabledClientHints::EnableIfSame<T>*>
bool EnabledClientHints::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->is_outermost_main_frame, other_struct.is_outermost_main_frame))
    return false;
  if (!mojo::Equals(this->hints, other_struct.hints))
    return false;
  if (!mojo::Equals(this->not_allowed_hints, other_struct.not_allowed_hints))
    return false;
  return true;
}

template <typename T, EnabledClientHints::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.is_outermost_main_frame < rhs.is_outermost_main_frame)
    return true;
  if (rhs.is_outermost_main_frame < lhs.is_outermost_main_frame)
    return false;
  if (lhs.hints < rhs.hints)
    return true;
  if (rhs.hints < lhs.hints)
    return false;
  if (lhs.not_allowed_hints < rhs.not_allowed_hints)
    return true;
  if (rhs.not_allowed_hints < lhs.not_allowed_hints)
    return false;
  return false;
}
template <typename StructPtrType>
TrustedUrlRequestParamsPtr TrustedUrlRequestParams::Clone() const {
  return New(
      mojo::Clone(isolation_info),
      mojo::Clone(disable_secure_dns),
      mojo::Clone(has_user_activation),
      mojo::Clone(allow_cookies_from_browser),
      mojo::Clone(include_request_cookies_with_response),
      mojo::Clone(enabled_client_hints),
      mojo::Clone(cookie_observer),
      mojo::Clone(trust_token_observer),
      mojo::Clone(url_loader_network_observer),
      mojo::Clone(devtools_observer),
      mojo::Clone(device_bound_session_observer),
      mojo::Clone(client_security_state),
      mojo::Clone(accept_ch_frame_observer),
      mojo::Clone(shared_dictionary_observer)
  );
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>*>
bool TrustedUrlRequestParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->isolation_info, other_struct.isolation_info))
    return false;
  if (!mojo::Equals(this->disable_secure_dns, other_struct.disable_secure_dns))
    return false;
  if (!mojo::Equals(this->has_user_activation, other_struct.has_user_activation))
    return false;
  if (!mojo::Equals(this->allow_cookies_from_browser, other_struct.allow_cookies_from_browser))
    return false;
  if (!mojo::Equals(this->include_request_cookies_with_response, other_struct.include_request_cookies_with_response))
    return false;
  if (!mojo::Equals(this->enabled_client_hints, other_struct.enabled_client_hints))
    return false;
  if (!mojo::Equals(this->cookie_observer, other_struct.cookie_observer))
    return false;
  if (!mojo::Equals(this->trust_token_observer, other_struct.trust_token_observer))
    return false;
  if (!mojo::Equals(this->url_loader_network_observer, other_struct.url_loader_network_observer))
    return false;
  if (!mojo::Equals(this->devtools_observer, other_struct.devtools_observer))
    return false;
  if (!mojo::Equals(this->device_bound_session_observer, other_struct.device_bound_session_observer))
    return false;
  if (!mojo::Equals(this->client_security_state, other_struct.client_security_state))
    return false;
  if (!mojo::Equals(this->accept_ch_frame_observer, other_struct.accept_ch_frame_observer))
    return false;
  if (!mojo::Equals(this->shared_dictionary_observer, other_struct.shared_dictionary_observer))
    return false;
  return true;
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.isolation_info < rhs.isolation_info)
    return true;
  if (rhs.isolation_info < lhs.isolation_info)
    return false;
  if (lhs.disable_secure_dns < rhs.disable_secure_dns)
    return true;
  if (rhs.disable_secure_dns < lhs.disable_secure_dns)
    return false;
  if (lhs.has_user_activation < rhs.has_user_activation)
    return true;
  if (rhs.has_user_activation < lhs.has_user_activation)
    return false;
  if (lhs.allow_cookies_from_browser < rhs.allow_cookies_from_browser)
    return true;
  if (rhs.allow_cookies_from_browser < lhs.allow_cookies_from_browser)
    return false;
  if (lhs.include_request_cookies_with_response < rhs.include_request_cookies_with_response)
    return true;
  if (rhs.include_request_cookies_with_response < lhs.include_request_cookies_with_response)
    return false;
  if (lhs.enabled_client_hints < rhs.enabled_client_hints)
    return true;
  if (rhs.enabled_client_hints < lhs.enabled_client_hints)
    return false;
  if (lhs.cookie_observer < rhs.cookie_observer)
    return true;
  if (rhs.cookie_observer < lhs.cookie_observer)
    return false;
  if (lhs.trust_token_observer < rhs.trust_token_observer)
    return true;
  if (rhs.trust_token_observer < lhs.trust_token_observer)
    return false;
  if (lhs.url_loader_network_observer < rhs.url_loader_network_observer)
    return true;
  if (rhs.url_loader_network_observer < lhs.url_loader_network_observer)
    return false;
  if (lhs.devtools_observer < rhs.devtools_observer)
    return true;
  if (rhs.devtools_observer < lhs.devtools_observer)
    return false;
  if (lhs.device_bound_session_observer < rhs.device_bound_session_observer)
    return true;
  if (rhs.device_bound_session_observer < lhs.device_bound_session_observer)
    return false;
  if (lhs.client_security_state < rhs.client_security_state)
    return true;
  if (rhs.client_security_state < lhs.client_security_state)
    return false;
  if (lhs.accept_ch_frame_observer < rhs.accept_ch_frame_observer)
    return true;
  if (rhs.accept_ch_frame_observer < lhs.accept_ch_frame_observer)
    return false;
  if (lhs.shared_dictionary_observer < rhs.shared_dictionary_observer)
    return true;
  if (rhs.shared_dictionary_observer < lhs.shared_dictionary_observer)
    return false;
  return false;
}
template <typename StructPtrType>
WebBundleTokenParamsPtr WebBundleTokenParams::Clone() const {
  return New(
      mojo::Clone(bundle_url),
      mojo::Clone(token),
      mojo::Clone(web_bundle_handle),
      mojo::Clone(render_process_id)
  );
}

template <typename T, WebBundleTokenParams::EnableIfSame<T>*>
bool WebBundleTokenParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bundle_url, other_struct.bundle_url))
    return false;
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->web_bundle_handle, other_struct.web_bundle_handle))
    return false;
  if (!mojo::Equals(this->render_process_id, other_struct.render_process_id))
    return false;
  return true;
}

template <typename T, WebBundleTokenParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bundle_url < rhs.bundle_url)
    return true;
  if (rhs.bundle_url < lhs.bundle_url)
    return false;
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.web_bundle_handle < rhs.web_bundle_handle)
    return true;
  if (rhs.web_bundle_handle < lhs.web_bundle_handle)
    return false;
  if (lhs.render_process_id < rhs.render_process_id)
    return true;
  if (rhs.render_process_id < lhs.render_process_id)
    return false;
  return false;
}
template <typename StructPtrType>
URLRequestPtr URLRequest::Clone() const {
  return New(
      mojo::Clone(method),
      mojo::Clone(url),
      mojo::Clone(site_for_cookies),
      mojo::Clone(update_first_party_url_on_redirect),
      mojo::Clone(request_initiator),
      mojo::Clone(navigation_redirect_chain),
      mojo::Clone(isolated_world_origin),
      mojo::Clone(referrer),
      mojo::Clone(referrer_policy),
      mojo::Clone(headers),
      mojo::Clone(cors_exempt_headers),
      mojo::Clone(load_flags),
      mojo::Clone(resource_type),
      mojo::Clone(priority),
      mojo::Clone(priority_incremental),
      mojo::Clone(cors_preflight_policy),
      mojo::Clone(originated_from_service_worker),
      mojo::Clone(skip_service_worker),
      mojo::Clone(mode),
      mojo::Clone(credentials_mode),
      mojo::Clone(redirect_mode),
      mojo::Clone(fetch_integrity),
      mojo::Clone(expected_public_keys),
      mojo::Clone(destination),
      mojo::Clone(request_body),
      mojo::Clone(keepalive),
      mojo::Clone(browsing_topics),
      mojo::Clone(ad_auction_headers),
      mojo::Clone(shared_storage_writable_eligible),
      mojo::Clone(has_user_gesture),
      mojo::Clone(enable_load_timing),
      mojo::Clone(enable_upload_progress),
      mojo::Clone(do_not_prompt_for_login),
      mojo::Clone(is_outermost_main_frame),
      mojo::Clone(transition_type),
      mojo::Clone(previews_state),
      mojo::Clone(upgrade_if_insecure),
      mojo::Clone(is_revalidating),
      mojo::Clone(throttling_profile_id),
      mojo::Clone(fetch_window_id),
      mojo::Clone(devtools_request_id),
      mojo::Clone(devtools_stack_id),
      mojo::Clone(is_fetch_like_api),
      mojo::Clone(is_fetch_later_api),
      mojo::Clone(is_favicon),
      mojo::Clone(original_destination),
      mojo::Clone(trusted_params),
      mojo::Clone(recursive_prefetch_token),
      mojo::Clone(trust_token_params),
      mojo::Clone(web_bundle_token_params),
      mojo::Clone(devtools_accepted_stream_types),
      mojo::Clone(net_log_create_info),
      mojo::Clone(net_log_reference_info),
      mojo::Clone(target_ip_address_space),
      mojo::Clone(required_ip_address_space),
      mojo::Clone(storage_access_api_status),
      mojo::Clone(attribution_reporting_support),
      mojo::Clone(attribution_reporting_eligibility),
      mojo::Clone(attribution_reporting_src_token),
      mojo::Clone(keepalive_token),
      mojo::Clone(is_ad_tagged),
      mojo::Clone(shared_dictionary_writer_enabled),
      mojo::Clone(client_side_content_decoding_enabled),
      mojo::Clone(socket_tag),
      mojo::Clone(allows_device_bound_session_registration),
      mojo::Clone(permissions_policy),
      mojo::Clone(fetch_retry_options)
  );
}

template <typename T, URLRequest::EnableIfSame<T>*>
bool URLRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->update_first_party_url_on_redirect, other_struct.update_first_party_url_on_redirect))
    return false;
  if (!mojo::Equals(this->request_initiator, other_struct.request_initiator))
    return false;
  if (!mojo::Equals(this->navigation_redirect_chain, other_struct.navigation_redirect_chain))
    return false;
  if (!mojo::Equals(this->isolated_world_origin, other_struct.isolated_world_origin))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->cors_exempt_headers, other_struct.cors_exempt_headers))
    return false;
  if (!mojo::Equals(this->load_flags, other_struct.load_flags))
    return false;
  if (!mojo::Equals(this->resource_type, other_struct.resource_type))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->priority_incremental, other_struct.priority_incremental))
    return false;
  if (!mojo::Equals(this->cors_preflight_policy, other_struct.cors_preflight_policy))
    return false;
  if (!mojo::Equals(this->originated_from_service_worker, other_struct.originated_from_service_worker))
    return false;
  if (!mojo::Equals(this->skip_service_worker, other_struct.skip_service_worker))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->credentials_mode, other_struct.credentials_mode))
    return false;
  if (!mojo::Equals(this->redirect_mode, other_struct.redirect_mode))
    return false;
  if (!mojo::Equals(this->fetch_integrity, other_struct.fetch_integrity))
    return false;
  if (!mojo::Equals(this->expected_public_keys, other_struct.expected_public_keys))
    return false;
  if (!mojo::Equals(this->destination, other_struct.destination))
    return false;
  if (!mojo::Equals(this->request_body, other_struct.request_body))
    return false;
  if (!mojo::Equals(this->keepalive, other_struct.keepalive))
    return false;
  if (!mojo::Equals(this->browsing_topics, other_struct.browsing_topics))
    return false;
  if (!mojo::Equals(this->ad_auction_headers, other_struct.ad_auction_headers))
    return false;
  if (!mojo::Equals(this->shared_storage_writable_eligible, other_struct.shared_storage_writable_eligible))
    return false;
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  if (!mojo::Equals(this->enable_load_timing, other_struct.enable_load_timing))
    return false;
  if (!mojo::Equals(this->enable_upload_progress, other_struct.enable_upload_progress))
    return false;
  if (!mojo::Equals(this->do_not_prompt_for_login, other_struct.do_not_prompt_for_login))
    return false;
  if (!mojo::Equals(this->is_outermost_main_frame, other_struct.is_outermost_main_frame))
    return false;
  if (!mojo::Equals(this->transition_type, other_struct.transition_type))
    return false;
  if (!mojo::Equals(this->previews_state, other_struct.previews_state))
    return false;
  if (!mojo::Equals(this->upgrade_if_insecure, other_struct.upgrade_if_insecure))
    return false;
  if (!mojo::Equals(this->is_revalidating, other_struct.is_revalidating))
    return false;
  if (!mojo::Equals(this->throttling_profile_id, other_struct.throttling_profile_id))
    return false;
  if (!mojo::Equals(this->fetch_window_id, other_struct.fetch_window_id))
    return false;
  if (!mojo::Equals(this->devtools_request_id, other_struct.devtools_request_id))
    return false;
  if (!mojo::Equals(this->devtools_stack_id, other_struct.devtools_stack_id))
    return false;
  if (!mojo::Equals(this->is_fetch_like_api, other_struct.is_fetch_like_api))
    return false;
  if (!mojo::Equals(this->is_fetch_later_api, other_struct.is_fetch_later_api))
    return false;
  if (!mojo::Equals(this->is_favicon, other_struct.is_favicon))
    return false;
  if (!mojo::Equals(this->original_destination, other_struct.original_destination))
    return false;
  if (!mojo::Equals(this->trusted_params, other_struct.trusted_params))
    return false;
  if (!mojo::Equals(this->recursive_prefetch_token, other_struct.recursive_prefetch_token))
    return false;
  if (!mojo::Equals(this->trust_token_params, other_struct.trust_token_params))
    return false;
  if (!mojo::Equals(this->web_bundle_token_params, other_struct.web_bundle_token_params))
    return false;
  if (!mojo::Equals(this->devtools_accepted_stream_types, other_struct.devtools_accepted_stream_types))
    return false;
  if (!mojo::Equals(this->net_log_create_info, other_struct.net_log_create_info))
    return false;
  if (!mojo::Equals(this->net_log_reference_info, other_struct.net_log_reference_info))
    return false;
  if (!mojo::Equals(this->target_ip_address_space, other_struct.target_ip_address_space))
    return false;
  if (!mojo::Equals(this->required_ip_address_space, other_struct.required_ip_address_space))
    return false;
  if (!mojo::Equals(this->storage_access_api_status, other_struct.storage_access_api_status))
    return false;
  if (!mojo::Equals(this->attribution_reporting_support, other_struct.attribution_reporting_support))
    return false;
  if (!mojo::Equals(this->attribution_reporting_eligibility, other_struct.attribution_reporting_eligibility))
    return false;
  if (!mojo::Equals(this->attribution_reporting_src_token, other_struct.attribution_reporting_src_token))
    return false;
  if (!mojo::Equals(this->keepalive_token, other_struct.keepalive_token))
    return false;
  if (!mojo::Equals(this->is_ad_tagged, other_struct.is_ad_tagged))
    return false;
  if (!mojo::Equals(this->shared_dictionary_writer_enabled, other_struct.shared_dictionary_writer_enabled))
    return false;
  if (!mojo::Equals(this->client_side_content_decoding_enabled, other_struct.client_side_content_decoding_enabled))
    return false;
  if (!mojo::Equals(this->socket_tag, other_struct.socket_tag))
    return false;
  if (!mojo::Equals(this->allows_device_bound_session_registration, other_struct.allows_device_bound_session_registration))
    return false;
  if (!mojo::Equals(this->permissions_policy, other_struct.permissions_policy))
    return false;
  if (!mojo::Equals(this->fetch_retry_options, other_struct.fetch_retry_options))
    return false;
  return true;
}

template <typename T, URLRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.site_for_cookies < rhs.site_for_cookies)
    return true;
  if (rhs.site_for_cookies < lhs.site_for_cookies)
    return false;
  if (lhs.update_first_party_url_on_redirect < rhs.update_first_party_url_on_redirect)
    return true;
  if (rhs.update_first_party_url_on_redirect < lhs.update_first_party_url_on_redirect)
    return false;
  if (lhs.request_initiator < rhs.request_initiator)
    return true;
  if (rhs.request_initiator < lhs.request_initiator)
    return false;
  if (lhs.navigation_redirect_chain < rhs.navigation_redirect_chain)
    return true;
  if (rhs.navigation_redirect_chain < lhs.navigation_redirect_chain)
    return false;
  if (lhs.isolated_world_origin < rhs.isolated_world_origin)
    return true;
  if (rhs.isolated_world_origin < lhs.isolated_world_origin)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.cors_exempt_headers < rhs.cors_exempt_headers)
    return true;
  if (rhs.cors_exempt_headers < lhs.cors_exempt_headers)
    return false;
  if (lhs.load_flags < rhs.load_flags)
    return true;
  if (rhs.load_flags < lhs.load_flags)
    return false;
  if (lhs.resource_type < rhs.resource_type)
    return true;
  if (rhs.resource_type < lhs.resource_type)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.priority_incremental < rhs.priority_incremental)
    return true;
  if (rhs.priority_incremental < lhs.priority_incremental)
    return false;
  if (lhs.cors_preflight_policy < rhs.cors_preflight_policy)
    return true;
  if (rhs.cors_preflight_policy < lhs.cors_preflight_policy)
    return false;
  if (lhs.originated_from_service_worker < rhs.originated_from_service_worker)
    return true;
  if (rhs.originated_from_service_worker < lhs.originated_from_service_worker)
    return false;
  if (lhs.skip_service_worker < rhs.skip_service_worker)
    return true;
  if (rhs.skip_service_worker < lhs.skip_service_worker)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.credentials_mode < rhs.credentials_mode)
    return true;
  if (rhs.credentials_mode < lhs.credentials_mode)
    return false;
  if (lhs.redirect_mode < rhs.redirect_mode)
    return true;
  if (rhs.redirect_mode < lhs.redirect_mode)
    return false;
  if (lhs.fetch_integrity < rhs.fetch_integrity)
    return true;
  if (rhs.fetch_integrity < lhs.fetch_integrity)
    return false;
  if (lhs.expected_public_keys < rhs.expected_public_keys)
    return true;
  if (rhs.expected_public_keys < lhs.expected_public_keys)
    return false;
  if (lhs.destination < rhs.destination)
    return true;
  if (rhs.destination < lhs.destination)
    return false;
  if (lhs.request_body < rhs.request_body)
    return true;
  if (rhs.request_body < lhs.request_body)
    return false;
  if (lhs.keepalive < rhs.keepalive)
    return true;
  if (rhs.keepalive < lhs.keepalive)
    return false;
  if (lhs.browsing_topics < rhs.browsing_topics)
    return true;
  if (rhs.browsing_topics < lhs.browsing_topics)
    return false;
  if (lhs.ad_auction_headers < rhs.ad_auction_headers)
    return true;
  if (rhs.ad_auction_headers < lhs.ad_auction_headers)
    return false;
  if (lhs.shared_storage_writable_eligible < rhs.shared_storage_writable_eligible)
    return true;
  if (rhs.shared_storage_writable_eligible < lhs.shared_storage_writable_eligible)
    return false;
  if (lhs.has_user_gesture < rhs.has_user_gesture)
    return true;
  if (rhs.has_user_gesture < lhs.has_user_gesture)
    return false;
  if (lhs.enable_load_timing < rhs.enable_load_timing)
    return true;
  if (rhs.enable_load_timing < lhs.enable_load_timing)
    return false;
  if (lhs.enable_upload_progress < rhs.enable_upload_progress)
    return true;
  if (rhs.enable_upload_progress < lhs.enable_upload_progress)
    return false;
  if (lhs.do_not_prompt_for_login < rhs.do_not_prompt_for_login)
    return true;
  if (rhs.do_not_prompt_for_login < lhs.do_not_prompt_for_login)
    return false;
  if (lhs.is_outermost_main_frame < rhs.is_outermost_main_frame)
    return true;
  if (rhs.is_outermost_main_frame < lhs.is_outermost_main_frame)
    return false;
  if (lhs.transition_type < rhs.transition_type)
    return true;
  if (rhs.transition_type < lhs.transition_type)
    return false;
  if (lhs.previews_state < rhs.previews_state)
    return true;
  if (rhs.previews_state < lhs.previews_state)
    return false;
  if (lhs.upgrade_if_insecure < rhs.upgrade_if_insecure)
    return true;
  if (rhs.upgrade_if_insecure < lhs.upgrade_if_insecure)
    return false;
  if (lhs.is_revalidating < rhs.is_revalidating)
    return true;
  if (rhs.is_revalidating < lhs.is_revalidating)
    return false;
  if (lhs.throttling_profile_id < rhs.throttling_profile_id)
    return true;
  if (rhs.throttling_profile_id < lhs.throttling_profile_id)
    return false;
  if (lhs.fetch_window_id < rhs.fetch_window_id)
    return true;
  if (rhs.fetch_window_id < lhs.fetch_window_id)
    return false;
  if (lhs.devtools_request_id < rhs.devtools_request_id)
    return true;
  if (rhs.devtools_request_id < lhs.devtools_request_id)
    return false;
  if (lhs.devtools_stack_id < rhs.devtools_stack_id)
    return true;
  if (rhs.devtools_stack_id < lhs.devtools_stack_id)
    return false;
  if (lhs.is_fetch_like_api < rhs.is_fetch_like_api)
    return true;
  if (rhs.is_fetch_like_api < lhs.is_fetch_like_api)
    return false;
  if (lhs.is_fetch_later_api < rhs.is_fetch_later_api)
    return true;
  if (rhs.is_fetch_later_api < lhs.is_fetch_later_api)
    return false;
  if (lhs.is_favicon < rhs.is_favicon)
    return true;
  if (rhs.is_favicon < lhs.is_favicon)
    return false;
  if (lhs.original_destination < rhs.original_destination)
    return true;
  if (rhs.original_destination < lhs.original_destination)
    return false;
  if (lhs.trusted_params < rhs.trusted_params)
    return true;
  if (rhs.trusted_params < lhs.trusted_params)
    return false;
  if (lhs.recursive_prefetch_token < rhs.recursive_prefetch_token)
    return true;
  if (rhs.recursive_prefetch_token < lhs.recursive_prefetch_token)
    return false;
  if (lhs.trust_token_params < rhs.trust_token_params)
    return true;
  if (rhs.trust_token_params < lhs.trust_token_params)
    return false;
  if (lhs.web_bundle_token_params < rhs.web_bundle_token_params)
    return true;
  if (rhs.web_bundle_token_params < lhs.web_bundle_token_params)
    return false;
  if (lhs.devtools_accepted_stream_types < rhs.devtools_accepted_stream_types)
    return true;
  if (rhs.devtools_accepted_stream_types < lhs.devtools_accepted_stream_types)
    return false;
  if (lhs.net_log_create_info < rhs.net_log_create_info)
    return true;
  if (rhs.net_log_create_info < lhs.net_log_create_info)
    return false;
  if (lhs.net_log_reference_info < rhs.net_log_reference_info)
    return true;
  if (rhs.net_log_reference_info < lhs.net_log_reference_info)
    return false;
  if (lhs.target_ip_address_space < rhs.target_ip_address_space)
    return true;
  if (rhs.target_ip_address_space < lhs.target_ip_address_space)
    return false;
  if (lhs.required_ip_address_space < rhs.required_ip_address_space)
    return true;
  if (rhs.required_ip_address_space < lhs.required_ip_address_space)
    return false;
  if (lhs.storage_access_api_status < rhs.storage_access_api_status)
    return true;
  if (rhs.storage_access_api_status < lhs.storage_access_api_status)
    return false;
  if (lhs.attribution_reporting_support < rhs.attribution_reporting_support)
    return true;
  if (rhs.attribution_reporting_support < lhs.attribution_reporting_support)
    return false;
  if (lhs.attribution_reporting_eligibility < rhs.attribution_reporting_eligibility)
    return true;
  if (rhs.attribution_reporting_eligibility < lhs.attribution_reporting_eligibility)
    return false;
  if (lhs.attribution_reporting_src_token < rhs.attribution_reporting_src_token)
    return true;
  if (rhs.attribution_reporting_src_token < lhs.attribution_reporting_src_token)
    return false;
  if (lhs.keepalive_token < rhs.keepalive_token)
    return true;
  if (rhs.keepalive_token < lhs.keepalive_token)
    return false;
  if (lhs.is_ad_tagged < rhs.is_ad_tagged)
    return true;
  if (rhs.is_ad_tagged < lhs.is_ad_tagged)
    return false;
  if (lhs.shared_dictionary_writer_enabled < rhs.shared_dictionary_writer_enabled)
    return true;
  if (rhs.shared_dictionary_writer_enabled < lhs.shared_dictionary_writer_enabled)
    return false;
  if (lhs.client_side_content_decoding_enabled < rhs.client_side_content_decoding_enabled)
    return true;
  if (rhs.client_side_content_decoding_enabled < lhs.client_side_content_decoding_enabled)
    return false;
  if (lhs.socket_tag < rhs.socket_tag)
    return true;
  if (rhs.socket_tag < lhs.socket_tag)
    return false;
  if (lhs.allows_device_bound_session_registration < rhs.allows_device_bound_session_registration)
    return true;
  if (rhs.allows_device_bound_session_registration < lhs.allows_device_bound_session_registration)
    return false;
  if (lhs.permissions_policy < rhs.permissions_policy)
    return true;
  if (rhs.permissions_policy < lhs.permissions_policy)
    return false;
  if (lhs.fetch_retry_options < rhs.fetch_retry_options)
    return true;
  if (rhs.fetch_retry_options < lhs.fetch_retry_options)
    return false;
  return false;
}
template <typename StructPtrType>
URLRequestBodyPtr URLRequestBody::Clone() const {
  return New(
      mojo::Clone(elements),
      mojo::Clone(identifier),
      mojo::Clone(contains_sensitive_info),
      mojo::Clone(allow_http1_for_streaming_upload)
  );
}

template <typename T, URLRequestBody::EnableIfSame<T>*>
bool URLRequestBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->elements, other_struct.elements))
    return false;
  if (!mojo::Equals(this->identifier, other_struct.identifier))
    return false;
  if (!mojo::Equals(this->contains_sensitive_info, other_struct.contains_sensitive_info))
    return false;
  if (!mojo::Equals(this->allow_http1_for_streaming_upload, other_struct.allow_http1_for_streaming_upload))
    return false;
  return true;
}

template <typename T, URLRequestBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.elements < rhs.elements)
    return true;
  if (rhs.elements < lhs.elements)
    return false;
  if (lhs.identifier < rhs.identifier)
    return true;
  if (rhs.identifier < lhs.identifier)
    return false;
  if (lhs.contains_sensitive_info < rhs.contains_sensitive_info)
    return true;
  if (rhs.contains_sensitive_info < lhs.contains_sensitive_info)
    return false;
  if (lhs.allow_http1_for_streaming_upload < rhs.allow_http1_for_streaming_upload)
    return true;
  if (rhs.allow_http1_for_streaming_upload < lhs.allow_http1_for_streaming_upload)
    return false;
  return false;
}
template <typename StructPtrType>
DataElementBytesPtr DataElementBytes::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, DataElementBytes::EnableIfSame<T>*>
bool DataElementBytes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, DataElementBytes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
DataElementFilePtr DataElementFile::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(expected_modification_time)
  );
}

template <typename T, DataElementFile::EnableIfSame<T>*>
bool DataElementFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->expected_modification_time, other_struct.expected_modification_time))
    return false;
  return true;
}

template <typename T, DataElementFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.expected_modification_time < rhs.expected_modification_time)
    return true;
  if (rhs.expected_modification_time < lhs.expected_modification_time)
    return false;
  return false;
}
template <typename StructPtrType>
DataElementDataPipePtr DataElementDataPipe::Clone() const {
  return New(
      mojo::Clone(data_pipe_getter)
  );
}

template <typename T, DataElementDataPipe::EnableIfSame<T>*>
bool DataElementDataPipe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_pipe_getter, other_struct.data_pipe_getter))
    return false;
  return true;
}

template <typename T, DataElementDataPipe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_pipe_getter < rhs.data_pipe_getter)
    return true;
  if (rhs.data_pipe_getter < lhs.data_pipe_getter)
    return false;
  return false;
}
template <typename StructPtrType>
DataElementChunkedDataPipePtr DataElementChunkedDataPipe::Clone() const {
  return New(
      mojo::Clone(data_pipe_getter),
      mojo::Clone(read_only_once)
  );
}

template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>*>
bool DataElementChunkedDataPipe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_pipe_getter, other_struct.data_pipe_getter))
    return false;
  if (!mojo::Equals(this->read_only_once, other_struct.read_only_once))
    return false;
  return true;
}

template <typename T, DataElementChunkedDataPipe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_pipe_getter < rhs.data_pipe_getter)
    return true;
  if (rhs.data_pipe_getter < lhs.data_pipe_getter)
    return false;
  if (lhs.read_only_once < rhs.read_only_once)
    return true;
  if (rhs.read_only_once < lhs.read_only_once)
    return false;
  return false;
}
template <typename StructPtrType>
SocketTagPtr SocketTag::Clone() const {
  return New(
  );
}

template <typename T, SocketTag::EnableIfSame<T>*>
bool SocketTag::Equals(const T& other_struct) const {
  return true;
}

template <typename T, SocketTag::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::EnabledClientHints::DataView,
                                         ::network::mojom::blink::EnabledClientHintsPtr> {
  static bool IsNull(const ::network::mojom::blink::EnabledClientHintsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::EnabledClientHintsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::EnabledClientHints::origin)& origin(
      const ::network::mojom::blink::EnabledClientHintsPtr& input) {
    return input->origin;
  }

  static decltype(::network::mojom::blink::EnabledClientHints::is_outermost_main_frame) is_outermost_main_frame(
      const ::network::mojom::blink::EnabledClientHintsPtr& input) {
    return input->is_outermost_main_frame;
  }

  static const decltype(::network::mojom::blink::EnabledClientHints::hints)& hints(
      const ::network::mojom::blink::EnabledClientHintsPtr& input) {
    return input->hints;
  }

  static const decltype(::network::mojom::blink::EnabledClientHints::not_allowed_hints)& not_allowed_hints(
      const ::network::mojom::blink::EnabledClientHintsPtr& input) {
    return input->not_allowed_hints;
  }

  static bool Read(::network::mojom::blink::EnabledClientHints::DataView input, ::network::mojom::blink::EnabledClientHintsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::TrustedUrlRequestParams::DataView,
                                         ::network::mojom::blink::TrustedUrlRequestParamsPtr> {
  static bool IsNull(const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::TrustedUrlRequestParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::TrustedUrlRequestParams::isolation_info)& isolation_info(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->isolation_info;
  }

  static decltype(::network::mojom::blink::TrustedUrlRequestParams::disable_secure_dns) disable_secure_dns(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->disable_secure_dns;
  }

  static decltype(::network::mojom::blink::TrustedUrlRequestParams::has_user_activation) has_user_activation(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->has_user_activation;
  }

  static decltype(::network::mojom::blink::TrustedUrlRequestParams::allow_cookies_from_browser) allow_cookies_from_browser(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->allow_cookies_from_browser;
  }

  static decltype(::network::mojom::blink::TrustedUrlRequestParams::include_request_cookies_with_response) include_request_cookies_with_response(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->include_request_cookies_with_response;
  }

  static const decltype(::network::mojom::blink::TrustedUrlRequestParams::enabled_client_hints)& enabled_client_hints(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->enabled_client_hints;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::cookie_observer)& cookie_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->cookie_observer;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::trust_token_observer)& trust_token_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->trust_token_observer;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::url_loader_network_observer)& url_loader_network_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->url_loader_network_observer;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::devtools_observer)& devtools_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->devtools_observer;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::device_bound_session_observer)& device_bound_session_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->device_bound_session_observer;
  }

  static const decltype(::network::mojom::blink::TrustedUrlRequestParams::client_security_state)& client_security_state(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->client_security_state;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::accept_ch_frame_observer)& accept_ch_frame_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->accept_ch_frame_observer;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::shared_dictionary_observer)& shared_dictionary_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->shared_dictionary_observer;
  }

  static bool Read(::network::mojom::blink::TrustedUrlRequestParams::DataView input, ::network::mojom::blink::TrustedUrlRequestParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::WebBundleTokenParams::DataView,
                                         ::network::mojom::blink::WebBundleTokenParamsPtr> {
  static bool IsNull(const ::network::mojom::blink::WebBundleTokenParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::WebBundleTokenParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::WebBundleTokenParams::bundle_url)& bundle_url(
      const ::network::mojom::blink::WebBundleTokenParamsPtr& input) {
    return input->bundle_url;
  }

  static const decltype(::network::mojom::blink::WebBundleTokenParams::token)& token(
      const ::network::mojom::blink::WebBundleTokenParamsPtr& input) {
    return input->token;
  }

  static  decltype(::network::mojom::blink::WebBundleTokenParams::web_bundle_handle)& web_bundle_handle(
       ::network::mojom::blink::WebBundleTokenParamsPtr& input) {
    return input->web_bundle_handle;
  }

  static decltype(::network::mojom::blink::WebBundleTokenParams::render_process_id) render_process_id(
      const ::network::mojom::blink::WebBundleTokenParamsPtr& input) {
    return input->render_process_id;
  }

  static bool Read(::network::mojom::blink::WebBundleTokenParams::DataView input, ::network::mojom::blink::WebBundleTokenParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::URLRequest::DataView,
                                         ::network::mojom::blink::URLRequestPtr> {
  static bool IsNull(const ::network::mojom::blink::URLRequestPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::URLRequestPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::URLRequest::method)& method(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->method;
  }

  static const decltype(::network::mojom::blink::URLRequest::url)& url(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->url;
  }

  static const decltype(::network::mojom::blink::URLRequest::site_for_cookies)& site_for_cookies(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->site_for_cookies;
  }

  static decltype(::network::mojom::blink::URLRequest::update_first_party_url_on_redirect) update_first_party_url_on_redirect(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->update_first_party_url_on_redirect;
  }

  static const decltype(::network::mojom::blink::URLRequest::request_initiator)& request_initiator(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->request_initiator;
  }

  static const decltype(::network::mojom::blink::URLRequest::navigation_redirect_chain)& navigation_redirect_chain(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->navigation_redirect_chain;
  }

  static const decltype(::network::mojom::blink::URLRequest::isolated_world_origin)& isolated_world_origin(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->isolated_world_origin;
  }

  static const decltype(::network::mojom::blink::URLRequest::referrer)& referrer(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->referrer;
  }

  static decltype(::network::mojom::blink::URLRequest::referrer_policy) referrer_policy(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::network::mojom::blink::URLRequest::headers)& headers(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::blink::URLRequest::cors_exempt_headers)& cors_exempt_headers(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->cors_exempt_headers;
  }

  static decltype(::network::mojom::blink::URLRequest::load_flags) load_flags(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->load_flags;
  }

  static decltype(::network::mojom::blink::URLRequest::resource_type) resource_type(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->resource_type;
  }

  static decltype(::network::mojom::blink::URLRequest::priority) priority(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->priority;
  }

  static decltype(::network::mojom::blink::URLRequest::priority_incremental) priority_incremental(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->priority_incremental;
  }

  static decltype(::network::mojom::blink::URLRequest::cors_preflight_policy) cors_preflight_policy(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->cors_preflight_policy;
  }

  static decltype(::network::mojom::blink::URLRequest::originated_from_service_worker) originated_from_service_worker(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->originated_from_service_worker;
  }

  static decltype(::network::mojom::blink::URLRequest::skip_service_worker) skip_service_worker(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->skip_service_worker;
  }

  static decltype(::network::mojom::blink::URLRequest::mode) mode(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->mode;
  }

  static decltype(::network::mojom::blink::URLRequest::credentials_mode) credentials_mode(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->credentials_mode;
  }

  static decltype(::network::mojom::blink::URLRequest::redirect_mode) redirect_mode(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->redirect_mode;
  }

  static const decltype(::network::mojom::blink::URLRequest::fetch_integrity)& fetch_integrity(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->fetch_integrity;
  }

  static const decltype(::network::mojom::blink::URLRequest::expected_public_keys)& expected_public_keys(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->expected_public_keys;
  }

  static decltype(::network::mojom::blink::URLRequest::destination) destination(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->destination;
  }

  static  decltype(::network::mojom::blink::URLRequest::request_body)& request_body(
       ::network::mojom::blink::URLRequestPtr& input) {
    return input->request_body;
  }

  static decltype(::network::mojom::blink::URLRequest::keepalive) keepalive(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->keepalive;
  }

  static decltype(::network::mojom::blink::URLRequest::browsing_topics) browsing_topics(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->browsing_topics;
  }

  static decltype(::network::mojom::blink::URLRequest::ad_auction_headers) ad_auction_headers(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->ad_auction_headers;
  }

  static decltype(::network::mojom::blink::URLRequest::shared_storage_writable_eligible) shared_storage_writable_eligible(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->shared_storage_writable_eligible;
  }

  static decltype(::network::mojom::blink::URLRequest::has_user_gesture) has_user_gesture(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->has_user_gesture;
  }

  static decltype(::network::mojom::blink::URLRequest::enable_load_timing) enable_load_timing(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->enable_load_timing;
  }

  static decltype(::network::mojom::blink::URLRequest::enable_upload_progress) enable_upload_progress(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->enable_upload_progress;
  }

  static decltype(::network::mojom::blink::URLRequest::do_not_prompt_for_login) do_not_prompt_for_login(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->do_not_prompt_for_login;
  }

  static decltype(::network::mojom::blink::URLRequest::is_outermost_main_frame) is_outermost_main_frame(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_outermost_main_frame;
  }

  static decltype(::network::mojom::blink::URLRequest::transition_type) transition_type(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->transition_type;
  }

  static decltype(::network::mojom::blink::URLRequest::previews_state) previews_state(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->previews_state;
  }

  static decltype(::network::mojom::blink::URLRequest::upgrade_if_insecure) upgrade_if_insecure(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->upgrade_if_insecure;
  }

  static decltype(::network::mojom::blink::URLRequest::is_revalidating) is_revalidating(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_revalidating;
  }

  static const decltype(::network::mojom::blink::URLRequest::throttling_profile_id)& throttling_profile_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->throttling_profile_id;
  }

  static const decltype(::network::mojom::blink::URLRequest::fetch_window_id)& fetch_window_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->fetch_window_id;
  }

  static const decltype(::network::mojom::blink::URLRequest::devtools_request_id)& devtools_request_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->devtools_request_id;
  }

  static const decltype(::network::mojom::blink::URLRequest::devtools_stack_id)& devtools_stack_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->devtools_stack_id;
  }

  static decltype(::network::mojom::blink::URLRequest::is_fetch_like_api) is_fetch_like_api(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_fetch_like_api;
  }

  static decltype(::network::mojom::blink::URLRequest::is_fetch_later_api) is_fetch_later_api(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_fetch_later_api;
  }

  static decltype(::network::mojom::blink::URLRequest::is_favicon) is_favicon(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_favicon;
  }

  static decltype(::network::mojom::blink::URLRequest::original_destination) original_destination(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->original_destination;
  }

  static  decltype(::network::mojom::blink::URLRequest::trusted_params)& trusted_params(
       ::network::mojom::blink::URLRequestPtr& input) {
    return input->trusted_params;
  }

  static const decltype(::network::mojom::blink::URLRequest::recursive_prefetch_token)& recursive_prefetch_token(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->recursive_prefetch_token;
  }

  static const decltype(::network::mojom::blink::URLRequest::trust_token_params)& trust_token_params(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->trust_token_params;
  }

  static  decltype(::network::mojom::blink::URLRequest::web_bundle_token_params)& web_bundle_token_params(
       ::network::mojom::blink::URLRequestPtr& input) {
    return input->web_bundle_token_params;
  }

  static const decltype(::network::mojom::blink::URLRequest::devtools_accepted_stream_types)& devtools_accepted_stream_types(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->devtools_accepted_stream_types;
  }

  static const decltype(::network::mojom::blink::URLRequest::net_log_create_info)& net_log_create_info(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->net_log_create_info;
  }

  static const decltype(::network::mojom::blink::URLRequest::net_log_reference_info)& net_log_reference_info(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->net_log_reference_info;
  }

  static decltype(::network::mojom::blink::URLRequest::target_ip_address_space) target_ip_address_space(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->target_ip_address_space;
  }

  static decltype(::network::mojom::blink::URLRequest::required_ip_address_space) required_ip_address_space(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->required_ip_address_space;
  }

  static decltype(::network::mojom::blink::URLRequest::storage_access_api_status) storage_access_api_status(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->storage_access_api_status;
  }

  static decltype(::network::mojom::blink::URLRequest::attribution_reporting_support) attribution_reporting_support(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->attribution_reporting_support;
  }

  static decltype(::network::mojom::blink::URLRequest::attribution_reporting_eligibility) attribution_reporting_eligibility(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->attribution_reporting_eligibility;
  }

  static const decltype(::network::mojom::blink::URLRequest::attribution_reporting_src_token)& attribution_reporting_src_token(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->attribution_reporting_src_token;
  }

  static const decltype(::network::mojom::blink::URLRequest::keepalive_token)& keepalive_token(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->keepalive_token;
  }

  static decltype(::network::mojom::blink::URLRequest::is_ad_tagged) is_ad_tagged(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_ad_tagged;
  }

  static decltype(::network::mojom::blink::URLRequest::shared_dictionary_writer_enabled) shared_dictionary_writer_enabled(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->shared_dictionary_writer_enabled;
  }

  static decltype(::network::mojom::blink::URLRequest::client_side_content_decoding_enabled) client_side_content_decoding_enabled(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->client_side_content_decoding_enabled;
  }

  static const decltype(::network::mojom::blink::URLRequest::socket_tag)& socket_tag(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->socket_tag;
  }

  static decltype(::network::mojom::blink::URLRequest::allows_device_bound_session_registration) allows_device_bound_session_registration(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->allows_device_bound_session_registration;
  }

  static const decltype(::network::mojom::blink::URLRequest::permissions_policy)& permissions_policy(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->permissions_policy;
  }

  static const decltype(::network::mojom::blink::URLRequest::fetch_retry_options)& fetch_retry_options(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->fetch_retry_options;
  }

  static bool Read(::network::mojom::blink::URLRequest::DataView input, ::network::mojom::blink::URLRequestPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::URLRequestBody::DataView,
                                         ::network::mojom::blink::URLRequestBodyPtr> {
  static bool IsNull(const ::network::mojom::blink::URLRequestBodyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::URLRequestBodyPtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::URLRequestBody::elements)& elements(
       ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->elements;
  }

  static decltype(::network::mojom::blink::URLRequestBody::identifier) identifier(
      const ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->identifier;
  }

  static decltype(::network::mojom::blink::URLRequestBody::contains_sensitive_info) contains_sensitive_info(
      const ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->contains_sensitive_info;
  }

  static decltype(::network::mojom::blink::URLRequestBody::allow_http1_for_streaming_upload) allow_http1_for_streaming_upload(
      const ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->allow_http1_for_streaming_upload;
  }

  static bool Read(::network::mojom::blink::URLRequestBody::DataView input, ::network::mojom::blink::URLRequestBodyPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DataElementBytes::DataView,
                                         ::network::mojom::blink::DataElementBytesPtr> {
  static bool IsNull(const ::network::mojom::blink::DataElementBytesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DataElementBytesPtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::DataElementBytes::data)& data(
       ::network::mojom::blink::DataElementBytesPtr& input) {
    return input->data;
  }

  static bool Read(::network::mojom::blink::DataElementBytes::DataView input, ::network::mojom::blink::DataElementBytesPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DataElementFile::DataView,
                                         ::network::mojom::blink::DataElementFilePtr> {
  static bool IsNull(const ::network::mojom::blink::DataElementFilePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DataElementFilePtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::DataElementFile::path)& path(
      const ::network::mojom::blink::DataElementFilePtr& input) {
    return input->path;
  }

  static decltype(::network::mojom::blink::DataElementFile::offset) offset(
      const ::network::mojom::blink::DataElementFilePtr& input) {
    return input->offset;
  }

  static decltype(::network::mojom::blink::DataElementFile::length) length(
      const ::network::mojom::blink::DataElementFilePtr& input) {
    return input->length;
  }

  static const decltype(::network::mojom::blink::DataElementFile::expected_modification_time)& expected_modification_time(
      const ::network::mojom::blink::DataElementFilePtr& input) {
    return input->expected_modification_time;
  }

  static bool Read(::network::mojom::blink::DataElementFile::DataView input, ::network::mojom::blink::DataElementFilePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DataElementDataPipe::DataView,
                                         ::network::mojom::blink::DataElementDataPipePtr> {
  static bool IsNull(const ::network::mojom::blink::DataElementDataPipePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DataElementDataPipePtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::DataElementDataPipe::data_pipe_getter)& data_pipe_getter(
       ::network::mojom::blink::DataElementDataPipePtr& input) {
    return input->data_pipe_getter;
  }

  static bool Read(::network::mojom::blink::DataElementDataPipe::DataView input, ::network::mojom::blink::DataElementDataPipePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DataElementChunkedDataPipe::DataView,
                                         ::network::mojom::blink::DataElementChunkedDataPipePtr> {
  static bool IsNull(const ::network::mojom::blink::DataElementChunkedDataPipePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DataElementChunkedDataPipePtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::DataElementChunkedDataPipe::data_pipe_getter)& data_pipe_getter(
       ::network::mojom::blink::DataElementChunkedDataPipePtr& input) {
    return input->data_pipe_getter;
  }

  static decltype(::network::mojom::blink::DataElementChunkedDataPipe::read_only_once) read_only_once(
      const ::network::mojom::blink::DataElementChunkedDataPipePtr& input) {
    return input->read_only_once;
  }

  static bool Read(::network::mojom::blink::DataElementChunkedDataPipe::DataView input, ::network::mojom::blink::DataElementChunkedDataPipePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SocketTag::DataView,
                                         ::network::mojom::blink::SocketTagPtr> {
  static bool IsNull(const ::network::mojom::blink::SocketTagPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SocketTagPtr* output) { output->reset(); }

  static bool Read(::network::mojom::blink::SocketTag::DataView input, ::network::mojom::blink::SocketTagPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::network::mojom::blink::DataElement::DataView,
                                        ::network::mojom::blink::DataElementPtr> {
  static bool IsNull(const ::network::mojom::blink::DataElementPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DataElementPtr* output) { output->reset(); }

  static ::network::mojom::blink::DataElement::Tag GetTag(const ::network::mojom::blink::DataElementPtr& input) {
    return input->which();
  }

  static  ::network::DataElementBytes& bytes( ::network::mojom::blink::DataElementPtr& input) {
    return input->get_bytes();
  }

  static const ::network::DataElementFile& file(const ::network::mojom::blink::DataElementPtr& input) {
    return input->get_file();
  }

  static  ::network::DataElementDataPipe& data_pipe( ::network::mojom::blink::DataElementPtr& input) {
    return input->get_data_pipe();
  }

  static  ::network::DataElementChunkedDataPipe& chunked_data_pipe( ::network::mojom::blink::DataElementPtr& input) {
    return input->get_chunked_data_pipe();
  }

  static bool Read(::network::mojom::blink::DataElement::DataView input, ::network::mojom::blink::DataElementPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_BLINK_H_