// services/network/public/mojom/url_loader_network_service_observer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/ad_auction.mojom-shared.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/shared_storage.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class LoadInfoDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::LoadInfoDataView> {
  using Data = ::network::mojom::internal::LoadInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class ClientCertificateResponderInterfaceBase {};

using ClientCertificateResponderPtrDataView =
    mojo::InterfacePtrDataView<ClientCertificateResponderInterfaceBase>;
using ClientCertificateResponderRequestDataView =
    mojo::InterfaceRequestDataView<ClientCertificateResponderInterfaceBase>;
using ClientCertificateResponderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ClientCertificateResponderInterfaceBase>;
using ClientCertificateResponderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ClientCertificateResponderInterfaceBase>;
class SSLPrivateKeyInterfaceBase {};

using SSLPrivateKeyPtrDataView =
    mojo::InterfacePtrDataView<SSLPrivateKeyInterfaceBase>;
using SSLPrivateKeyRequestDataView =
    mojo::InterfaceRequestDataView<SSLPrivateKeyInterfaceBase>;
using SSLPrivateKeyAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SSLPrivateKeyInterfaceBase>;
using SSLPrivateKeyAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SSLPrivateKeyInterfaceBase>;
class AuthChallengeResponderInterfaceBase {};

using AuthChallengeResponderPtrDataView =
    mojo::InterfacePtrDataView<AuthChallengeResponderInterfaceBase>;
using AuthChallengeResponderRequestDataView =
    mojo::InterfaceRequestDataView<AuthChallengeResponderInterfaceBase>;
using AuthChallengeResponderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AuthChallengeResponderInterfaceBase>;
using AuthChallengeResponderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AuthChallengeResponderInterfaceBase>;
class URLLoaderNetworkServiceObserverInterfaceBase {};

using URLLoaderNetworkServiceObserverPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderNetworkServiceObserverInterfaceBase>;
using URLLoaderNetworkServiceObserverRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderNetworkServiceObserverInterfaceBase>;
using URLLoaderNetworkServiceObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderNetworkServiceObserverInterfaceBase>;
using URLLoaderNetworkServiceObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderNetworkServiceObserverInterfaceBase>;


class LoadInfoDataView {
 public:
  LoadInfoDataView() = default;

  LoadInfoDataView(
      internal::LoadInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t load_state() const {
    return data_->load_state;
  }
  inline void GetStateParamDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStateParam(UserType* output) {
    
    auto* pointer = data_->state_param.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  uint64_t upload_position() const {
    return data_->upload_position;
  }
  uint64_t upload_size() const {
    return data_->upload_size;
  }
 private:
  internal::LoadInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_DATA_VIEW_H_