// services/network/public/mojom/url_loader_factory.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.URLLoader');
goog.require('network.mojom.URLLoaderClient');
goog.require('network.mojom.MutableNetworkTrafficAnnotationTag');
goog.require('network.mojom.URLRequest');



goog.provide('network.mojom.URL_LOAD_OPTION_NONE');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_NONE = 0;
goog.provide('network.mojom.URL_LOAD_OPTION_SEND_SSL_INFO_WITH_RESPONSE');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_SEND_SSL_INFO_WITH_RESPONSE = 1;
goog.provide('network.mojom.URL_LOAD_OPTION_SNIFF_MIME_TYPE');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_SNIFF_MIME_TYPE = 2;
goog.provide('network.mojom.URL_LOAD_OPTION_SYNCHRONOUS');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_SYNCHRONOUS = 4;
goog.provide('network.mojom.URL_LOAD_OPTION_SEND_SSL_INFO_FOR_CERTIFICATE_ERROR');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_SEND_SSL_INFO_FOR_CERTIFICATE_ERROR = 8;
goog.provide('network.mojom.URL_LOAD_OPTION_USE_HEADER_CLIENT');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_USE_HEADER_CLIENT = 16;
goog.provide('network.mojom.URL_LOAD_OPTION_BLOCK_ALL_COOKIES');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_BLOCK_ALL_COOKIES = 32;
goog.provide('network.mojom.URL_LOAD_OPTION_BLOCK_THIRD_PARTY_COOKIES');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_BLOCK_THIRD_PARTY_COOKIES = 64;
goog.provide('network.mojom.URL_LOAD_OPTION_AS_CORS_PREFLIGHT');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_AS_CORS_PREFLIGHT = 128;
goog.provide('network.mojom.URL_LOAD_OPTION_BLOCK_LOCAL_REQUEST');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_BLOCK_LOCAL_REQUEST = 256;
goog.provide('network.mojom.URL_LOAD_OPTION_READ_AND_DISCARD_BODY');
/**
 * @const { !number }
 * @export
 */
network.mojom.URL_LOAD_OPTION_READ_AND_DISCARD_BODY = 512;



goog.provide('network.mojom.URLLoaderFactory');
goog.provide('network.mojom.URLLoaderFactoryReceiver');
goog.provide('network.mojom.URLLoaderFactoryCallbackRouter');
goog.provide('network.mojom.URLLoaderFactoryInterface');
goog.provide('network.mojom.URLLoaderFactoryRemote');
goog.provide('network.mojom.URLLoaderFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.URLLoaderFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.URLLoaderFactory.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.URLLoaderFactoryInterface = class {
  
  /**
   * @param { !network.mojom.URLLoaderPendingReceiver } loader
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network.mojom.URLRequest } request
   * @param { !network.mojom.URLLoaderClientRemote } client
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  createLoaderAndStart(loader, requestId, options, request, client, trafficAnnotation) {}
  
  /**
   * @param { !network.mojom.URLLoaderFactoryPendingReceiver } factory
   */

  clone(factory) {}
};

/**
 * @export
 * @implements { network.mojom.URLLoaderFactoryInterface }
 */
network.mojom.URLLoaderFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.URLLoaderFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.URLLoaderFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.URLLoaderFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.URLLoaderPendingReceiver } loader
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network.mojom.URLRequest } request
   * @param { !network.mojom.URLLoaderClientRemote } client
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  createLoaderAndStart(
      loader,
      requestId,
      options,
      request,
      client,
      trafficAnnotation) {
    this.proxy.sendMessage(
        0,
        network.mojom.URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
        null,
        [
          loader,
          requestId,
          options,
          request,
          client,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLLoaderFactoryPendingReceiver } factory
   */

  clone(
      factory) {
    this.proxy.sendMessage(
        1,
        network.mojom.URLLoaderFactory_Clone_ParamsSpec.$,
        null,
        [
          factory
        ],
        false);
  }
};

/**
 * An object which receives request messages for the URLLoaderFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.URLLoaderFactoryReceiver = class {
  /**
   * @param {!network.mojom.URLLoaderFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.URLLoaderFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.URLLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
        null,
        impl.createLoaderAndStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoaderFactory_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.URLLoaderFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoaderFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.URLLoaderFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.URLLoaderFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the URLLoaderFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.URLLoaderFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.URLLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createLoaderAndStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
        null,
        this.createLoaderAndStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoaderFactory_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.URLLoaderFactory_CreateLoaderAndStart_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderFactory_CreateLoaderAndStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.URLLoaderFactory_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderFactory_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.URLLoaderFactory_CreateLoaderAndStart_ParamsSpec.$,
    'URLLoaderFactory_CreateLoaderAndStart_Params',
    [
      mojo.internal.StructField(
        'loader', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 16,
        0,
        network.mojom.URLRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.URLLoaderFactory_CreateLoaderAndStart_Params');

/** @record */
network.mojom.URLLoaderFactory_CreateLoaderAndStart_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderPendingReceiver } */
    this.loader;
    /** @export { !number } */
    this.requestId;
    /** @export { !number } */
    this.options;
    /** @export { !network.mojom.URLRequest } */
    this.request;
    /** @export { !network.mojom.URLLoaderClientRemote } */
    this.client;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderFactory_Clone_ParamsSpec.$,
    'URLLoaderFactory_Clone_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.URLLoaderFactory_Clone_Params');

/** @record */
network.mojom.URLLoaderFactory_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderFactoryPendingReceiver } */
    this.factory;
  }
};

