// services/network/public/mojom/udp_socket.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/udp_socket.mojom.h"


namespace network::mojom {


class  UDPSocketInterceptorForTesting : public UDPSocket {
  virtual UDPSocket* GetForwardingInterface() = 0;
  void Bind(const ::net::IPEndPoint& local_addr, UDPSocketOptionsPtr socket_options, BindCallback callback) override;
  void Connect(const ::net::IPEndPoint& remote_addr, UDPSocketOptionsPtr socket_options, ConnectCallback callback) override;
  void SetBroadcast(bool broadcast, SetBroadcastCallback callback) override;
  void SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) override;
  void SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) override;
  void JoinGroup(const ::net::IPAddress& group_address, JoinGroupCallback callback) override;
  void LeaveGroup(const ::net::IPAddress& group_address, LeaveGroupCallback callback) override;
  void ReceiveMore(uint32_t num_additional_datagrams) override;
  void ReceiveMoreWithBufferSize(uint32_t num_additional_datagrams, uint32_t buffer_size) override;
  void SendTo(const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendToCallback callback) override;
  void Send(::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendCallback callback) override;
  void Close() override;
};
class  UDPSocketAsyncWaiter {
 public:
  explicit UDPSocketAsyncWaiter(UDPSocket* proxy);

  UDPSocketAsyncWaiter(const UDPSocketAsyncWaiter&) = delete;
  UDPSocketAsyncWaiter& operator=(const UDPSocketAsyncWaiter&) = delete;

  ~UDPSocketAsyncWaiter();
  void Bind(
      const ::net::IPEndPoint& local_addr, UDPSocketOptionsPtr socket_options, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out);
  
  void Connect(
      const ::net::IPEndPoint& remote_addr, UDPSocketOptionsPtr socket_options, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out);
  
  void SetBroadcast(
      bool broadcast, int32_t* out_result);
  int32_t SetBroadcast(bool broadcast);
  void SetSendBufferSize(
      int32_t send_buffer_size, int32_t* out_result);
  int32_t SetSendBufferSize(int32_t send_buffer_size);
  void SetReceiveBufferSize(
      int32_t receive_buffer_size, int32_t* out_result);
  int32_t SetReceiveBufferSize(int32_t receive_buffer_size);
  void JoinGroup(
      const ::net::IPAddress& group_address, int32_t* out_result);
  int32_t JoinGroup(const ::net::IPAddress& group_address);
  void LeaveGroup(
      const ::net::IPAddress& group_address, int32_t* out_result);
  int32_t LeaveGroup(const ::net::IPAddress& group_address);
  void SendTo(
      const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, int32_t* out_result);
  int32_t SendTo(const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation);
  void Send(
      ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, int32_t* out_result);
  int32_t Send(::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation);

 private:
  UDPSocket* const proxy_;
};


class  UDPSocketListenerInterceptorForTesting : public UDPSocketListener {
  virtual UDPSocketListener* GetForwardingInterface() = 0;
  void OnReceived(int32_t result, const std::optional<::net::IPEndPoint>& src_addr, std::optional<::base::span<const ::uint8_t>> data) override;
};
class  UDPSocketListenerAsyncWaiter {
 public:
  explicit UDPSocketListenerAsyncWaiter(UDPSocketListener* proxy);

  UDPSocketListenerAsyncWaiter(const UDPSocketListenerAsyncWaiter&) = delete;
  UDPSocketListenerAsyncWaiter& operator=(const UDPSocketListenerAsyncWaiter&) = delete;

  ~UDPSocketListenerAsyncWaiter();

 private:
  UDPSocketListener* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_TEST_UTILS_H_