// services/network/public/mojom/udp_socket.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.UDPSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.UDPSocket.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.UDPSocketInterface }
 */
network.mojom.UDPSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.UDPSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.UDPSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.UDPSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } localAddr
   * @param { ?network.mojom.UDPSocketOptions } socketOptions
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network.mojom.IPEndPoint,
   *  }>}
   */

  bind(
      localAddr,
      socketOptions) {
    return this.proxy.sendMessage(
        0,
        network.mojom.UDPSocket_Bind_ParamsSpec.$,
        network.mojom.UDPSocket_Bind_ResponseParamsSpec.$,
        [
          localAddr,
          socketOptions
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } remoteAddr
   * @param { ?network.mojom.UDPSocketOptions } socketOptions
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network.mojom.IPEndPoint,
   *  }>}
   */

  connect(
      remoteAddr,
      socketOptions) {
    return this.proxy.sendMessage(
        1,
        network.mojom.UDPSocket_Connect_ParamsSpec.$,
        network.mojom.UDPSocket_Connect_ResponseParamsSpec.$,
        [
          remoteAddr,
          socketOptions
        ],
        false);
  }

  
  /**
   * @param { !boolean } broadcast
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setBroadcast(
      broadcast) {
    return this.proxy.sendMessage(
        2,
        network.mojom.UDPSocket_SetBroadcast_ParamsSpec.$,
        network.mojom.UDPSocket_SetBroadcast_ResponseParamsSpec.$,
        [
          broadcast
        ],
        false);
  }

  
  /**
   * @param { !number } sendBufferSize
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setSendBufferSize(
      sendBufferSize) {
    return this.proxy.sendMessage(
        3,
        network.mojom.UDPSocket_SetSendBufferSize_ParamsSpec.$,
        network.mojom.UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
        [
          sendBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } receiveBufferSize
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  setReceiveBufferSize(
      receiveBufferSize) {
    return this.proxy.sendMessage(
        4,
        network.mojom.UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
        network.mojom.UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        [
          receiveBufferSize
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  joinGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        5,
        network.mojom.UDPSocket_JoinGroup_ParamsSpec.$,
        network.mojom.UDPSocket_JoinGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPAddress } groupAddress
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  leaveGroup(
      groupAddress) {
    return this.proxy.sendMessage(
        6,
        network.mojom.UDPSocket_LeaveGroup_ParamsSpec.$,
        network.mojom.UDPSocket_LeaveGroup_ResponseParamsSpec.$,
        [
          groupAddress
        ],
        false);
  }

  
  /**
   * @param { !number } numAdditionalDatagrams
   */

  receiveMore(
      numAdditionalDatagrams) {
    this.proxy.sendMessage(
        7,
        network.mojom.UDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        [
          numAdditionalDatagrams
        ],
        false);
  }

  
  /**
   * @param { !number } numAdditionalDatagrams
   * @param { !number } bufferSize
   */

  receiveMoreWithBufferSize(
      numAdditionalDatagrams,
      bufferSize) {
    this.proxy.sendMessage(
        8,
        network.mojom.UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
        null,
        [
          numAdditionalDatagrams,
          bufferSize
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } destAddr
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  sendTo(
      destAddr,
      data,
      trafficAnnotation) {
    return this.proxy.sendMessage(
        9,
        network.mojom.UDPSocket_SendTo_ParamsSpec.$,
        network.mojom.UDPSocket_SendTo_ResponseParamsSpec.$,
        [
          destAddr,
          data,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  send(
      data,
      trafficAnnotation) {
    return this.proxy.sendMessage(
        10,
        network.mojom.UDPSocket_Send_ParamsSpec.$,
        network.mojom.UDPSocket_Send_ResponseParamsSpec.$,
        [
          data,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   */

  close() {
    this.proxy.sendMessage(
        11,
        network.mojom.UDPSocket_Close_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UDPSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.UDPSocketReceiver = class {
  /**
   * @param {!network.mojom.UDPSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.UDPSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.UDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.UDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.UDPSocket_Bind_ParamsSpec.$,
        network.mojom.UDPSocket_Bind_ResponseParamsSpec.$,
        impl.bind.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.UDPSocket_Connect_ParamsSpec.$,
        network.mojom.UDPSocket_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.UDPSocket_SetBroadcast_ParamsSpec.$,
        network.mojom.UDPSocket_SetBroadcast_ResponseParamsSpec.$,
        impl.setBroadcast.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.UDPSocket_SetSendBufferSize_ParamsSpec.$,
        network.mojom.UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
        impl.setSendBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
        network.mojom.UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        impl.setReceiveBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.UDPSocket_JoinGroup_ParamsSpec.$,
        network.mojom.UDPSocket_JoinGroup_ResponseParamsSpec.$,
        impl.joinGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.UDPSocket_LeaveGroup_ParamsSpec.$,
        network.mojom.UDPSocket_LeaveGroup_ResponseParamsSpec.$,
        impl.leaveGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.UDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        impl.receiveMore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
        null,
        impl.receiveMoreWithBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.UDPSocket_SendTo_ParamsSpec.$,
        network.mojom.UDPSocket_SendTo_ResponseParamsSpec.$,
        impl.sendTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        network.mojom.UDPSocket_Send_ParamsSpec.$,
        network.mojom.UDPSocket_Send_ResponseParamsSpec.$,
        impl.send.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        network.mojom.UDPSocket_Close_ParamsSpec.$,
        null,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.UDPSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.UDPSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.UDPSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.UDPSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UDPSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.UDPSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.UDPSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.UDPSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bind =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.UDPSocket_Bind_ParamsSpec.$,
        network.mojom.UDPSocket_Bind_ResponseParamsSpec.$,
        this.bind.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.UDPSocket_Connect_ParamsSpec.$,
        network.mojom.UDPSocket_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBroadcast =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.UDPSocket_SetBroadcast_ParamsSpec.$,
        network.mojom.UDPSocket_SetBroadcast_ResponseParamsSpec.$,
        this.setBroadcast.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSendBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.UDPSocket_SetSendBufferSize_ParamsSpec.$,
        network.mojom.UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
        this.setSendBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReceiveBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
        network.mojom.UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        this.setReceiveBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.joinGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.UDPSocket_JoinGroup_ParamsSpec.$,
        network.mojom.UDPSocket_JoinGroup_ResponseParamsSpec.$,
        this.joinGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.UDPSocket_LeaveGroup_ParamsSpec.$,
        network.mojom.UDPSocket_LeaveGroup_ResponseParamsSpec.$,
        this.leaveGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveMore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.UDPSocket_ReceiveMore_ParamsSpec.$,
        null,
        this.receiveMore.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.receiveMoreWithBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
        null,
        this.receiveMoreWithBufferSize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.UDPSocket_SendTo_ParamsSpec.$,
        network.mojom.UDPSocket_SendTo_ResponseParamsSpec.$,
        this.sendTo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.send =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        network.mojom.UDPSocket_Send_ParamsSpec.$,
        network.mojom.UDPSocket_Send_ResponseParamsSpec.$,
        this.send.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        network.mojom.UDPSocket_Close_ParamsSpec.$,
        null,
        this.close.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.UDPSocketListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.UDPSocketListener.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.UDPSocketListenerInterface }
 */
network.mojom.UDPSocketListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.UDPSocketListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.UDPSocketListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.UDPSocketListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } result
   * @param { ?network.mojom.IPEndPoint } srcAddr
   * @param { ?mojoBase.mojom.ReadOnlyBuffer } data
   */

  onReceived(
      result,
      srcAddr,
      data) {
    this.proxy.sendMessage(
        0,
        network.mojom.UDPSocketListener_OnReceived_ParamsSpec.$,
        null,
        [
          result,
          srcAddr,
          data
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UDPSocketListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.UDPSocketListenerReceiver = class {
  /**
   * @param {!network.mojom.UDPSocketListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.UDPSocketListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.UDPSocketListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.UDPSocketListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.UDPSocketListener_OnReceived_ParamsSpec.$,
        null,
        impl.onReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.UDPSocketListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.UDPSocketListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.UDPSocketListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.UDPSocketListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UDPSocketListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.UDPSocketListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.UDPSocketListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.UDPSocketListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.UDPSocketListener_OnReceived_ParamsSpec.$,
        null,
        this.onReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_Bind_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_Bind_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SetBroadcast_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SetBroadcast_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SetSendBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SetSendBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SetReceiveBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SetReceiveBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_JoinGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_JoinGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_LeaveGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_LeaveGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_ReceiveMore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SendTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_SendTo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_Send_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_Send_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocket_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.UDPSocketListener_OnReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.UDPSocketOptionsSpec.$,
    'UDPSocketOptions',
    [
      mojo.internal.StructField(
        'allowAddressReuse', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowBroadcast', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowAddressSharingForMulticast', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multicastInterface', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multicastTimeToLive', 8,
        0,
        mojo.internal.Uint32,
        1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multicastLoopbackMode', 0,
        3,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendBufferSize', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveBufferSize', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.UDPSocketOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.allowAddressReuse;
    /** @export { !boolean } */
    this.allowBroadcast;
    /** @export { !boolean } */
    this.allowAddressSharingForMulticast;
    /** @export { !number } */
    this.multicastInterface;
    /** @export { !number } */
    this.multicastTimeToLive;
    /** @export { !boolean } */
    this.multicastLoopbackMode;
    /** @export { !number } */
    this.sendBufferSize;
    /** @export { !number } */
    this.receiveBufferSize;
    /** @export { (boolean|undefined) } */
    this.ipv6Only;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_Bind_ParamsSpec.$,
    'UDPSocket_Bind_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socketOptions', 8,
        0,
        network.mojom.UDPSocketOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.UDPSocket_Bind_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.localAddr;
    /** @export { (network.mojom.UDPSocketOptions|undefined) } */
    this.socketOptions;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_Bind_ResponseParamsSpec.$,
    'UDPSocket_Bind_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.UDPSocket_Bind_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddrOut;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_Connect_ParamsSpec.$,
    'UDPSocket_Connect_Params',
    [
      mojo.internal.StructField(
        'remoteAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socketOptions', 8,
        0,
        network.mojom.UDPSocketOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.UDPSocket_Connect_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.remoteAddr;
    /** @export { (network.mojom.UDPSocketOptions|undefined) } */
    this.socketOptions;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_Connect_ResponseParamsSpec.$,
    'UDPSocket_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.UDPSocket_Connect_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddrOut;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SetBroadcast_ParamsSpec.$,
    'UDPSocket_SetBroadcast_Params',
    [
      mojo.internal.StructField(
        'broadcast', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_SetBroadcast_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.broadcast;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SetBroadcast_ResponseParamsSpec.$,
    'UDPSocket_SetBroadcast_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_SetBroadcast_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SetSendBufferSize_ParamsSpec.$,
    'UDPSocket_SetSendBufferSize_Params',
    [
      mojo.internal.StructField(
        'sendBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_SetSendBufferSize_Params = class {
  constructor() {
    /** @export { !number } */
    this.sendBufferSize;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SetSendBufferSize_ResponseParamsSpec.$,
    'UDPSocket_SetSendBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_SetSendBufferSize_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SetReceiveBufferSize_ParamsSpec.$,
    'UDPSocket_SetReceiveBufferSize_Params',
    [
      mojo.internal.StructField(
        'receiveBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_SetReceiveBufferSize_Params = class {
  constructor() {
    /** @export { !number } */
    this.receiveBufferSize;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
    'UDPSocket_SetReceiveBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_SetReceiveBufferSize_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_JoinGroup_ParamsSpec.$,
    'UDPSocket_JoinGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_JoinGroup_Params = class {
  constructor() {
    /** @export { !network.mojom.IPAddress } */
    this.groupAddress;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_JoinGroup_ResponseParamsSpec.$,
    'UDPSocket_JoinGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_JoinGroup_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_LeaveGroup_ParamsSpec.$,
    'UDPSocket_LeaveGroup_Params',
    [
      mojo.internal.StructField(
        'groupAddress', 0,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_LeaveGroup_Params = class {
  constructor() {
    /** @export { !network.mojom.IPAddress } */
    this.groupAddress;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_LeaveGroup_ResponseParamsSpec.$,
    'UDPSocket_LeaveGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_LeaveGroup_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_ReceiveMore_ParamsSpec.$,
    'UDPSocket_ReceiveMore_Params',
    [
      mojo.internal.StructField(
        'numAdditionalDatagrams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_ReceiveMore_Params = class {
  constructor() {
    /** @export { !number } */
    this.numAdditionalDatagrams;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_ReceiveMoreWithBufferSize_ParamsSpec.$,
    'UDPSocket_ReceiveMoreWithBufferSize_Params',
    [
      mojo.internal.StructField(
        'numAdditionalDatagrams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bufferSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_ReceiveMoreWithBufferSize_Params = class {
  constructor() {
    /** @export { !number } */
    this.numAdditionalDatagrams;
    /** @export { !number } */
    this.bufferSize;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SendTo_ParamsSpec.$,
    'UDPSocket_SendTo_Params',
    [
      mojo.internal.StructField(
        'destAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.UDPSocket_SendTo_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.destAddr;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_SendTo_ResponseParamsSpec.$,
    'UDPSocket_SendTo_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_SendTo_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_Send_ParamsSpec.$,
    'UDPSocket_Send_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.UDPSocket_Send_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_Send_ResponseParamsSpec.$,
    'UDPSocket_Send_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.UDPSocket_Send_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocket_Close_ParamsSpec.$,
    'UDPSocket_Close_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.UDPSocket_Close_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.UDPSocketListener_OnReceived_ParamsSpec.$,
    'UDPSocketListener_OnReceived_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'srcAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.UDPSocketListener_OnReceived_Params = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.srcAddr;
    /** @export { (mojoBase.mojom.ReadOnlyBuffer|undefined) } */
    this.data;
  }
};

